/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.ldap;

import com.iplanet.services.ldap.DSConfigMgr;
import com.iplanet.services.util.Crypt;
import com.iplanet.services.util.GenericNode;
import com.iplanet.services.util.ParseOutput;
import java.util.Hashtable;
import java.util.Vector;

public class LDAPUser
implements ParseOutput {
    public static final String ANONYMOUS_USER = "";
    public static final String ANONYMOUS_PASSWD = "";
    private String userID;
    private String userName;
    private Type userType = Type.AUTH_ANONYMOUS;
    private String userPasswd;

    public void process(String string, Vector vector, Hashtable hashtable, String string2) {
        if (DSConfigMgr.debugger.messageEnabled()) {
            DSConfigMgr.debugger.message("in LDAPUser.process()");
        }
        this.userID = (String)hashtable.get("name");
        int n = 0;
        while (n < vector.size()) {
            String string3;
            GenericNode genericNode = (GenericNode)vector.elementAt(n);
            if (genericNode._name.equals("DirDN")) {
                this.userName = genericNode._pcdata;
            }
            this.userType = (string3 = (String)hashtable.get("type")) == null || string3.equalsIgnoreCase("auth") ? Type.AUTH_BASIC : (string3.equalsIgnoreCase("proxy") ? Type.AUTH_PROXY : (string3.equalsIgnoreCase("rebind") ? Type.AUTH_REBIND : (string3.equalsIgnoreCase("admin") ? Type.AUTH_ADMIN : Type.AUTH_ANONYMOUS)));
            if (genericNode._name.equals("DirPassword")) {
                this.userPasswd = genericNode._pcdata;
            }
            ++n;
        }
    }

    protected String getAuthID() {
        if (this.userName == null) {
            return "";
        }
        return this.userName;
    }

    protected String getPasswd() {
        if (this.userPasswd == null) {
            return "";
        }
        return Crypt.decode(this.userPasswd);
    }

    public Type getAuthType() {
        return this.userType;
    }

    public String getUserID() {
        return this.userID;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("UserID=");
        stringBuffer.append(this.userID);
        stringBuffer.append(" UserName=");
        stringBuffer.append(this.userName);
        stringBuffer.append(" authType=");
        stringBuffer.append(this.userType.toString());
        stringBuffer.append(" authPassword=");
        stringBuffer.append(this.userPasswd);
        return stringBuffer.toString();
    }

    public static class Type {
        int authType = -1;
        public static final Type AUTH_ANONYMOUS = new Type(0);
        public static final Type AUTH_BASIC = new Type(1);
        public static final Type AUTH_PROXY = new Type(2);
        public static final Type AUTH_REBIND = new Type(3);
        public static final Type AUTH_ADMIN = new Type(4);

        private Type(int n) {
            this.authType = n;
        }

        public boolean equals(Type type) {
            return this.authType == type.authType;
        }

        public String toString() {
            if (this.equals(AUTH_ANONYMOUS)) {
                return "ANONYMOUS";
            }
            if (this.equals(AUTH_BASIC)) {
                return "BASIC";
            }
            if (this.equals(AUTH_PROXY)) {
                return "PROXY";
            }
            if (this.equals(AUTH_REBIND)) {
                return "REBIND";
            }
            if (this.equals(AUTH_ADMIN)) {
                return "ADMIN";
            }
            return "ANONYMOUS";
        }
    }
}

