/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.ldap;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;
import netscape.ldap.LDAPAttribute;

public class Attr
implements Serializable,
Cloneable {
    String _name;
    private ArrayList _stringValues;
    private ArrayList _byteValues;
    private LDAPAttribute _ldapAttribute;

    public Attr() {
    }

    public Attr(String string) {
        this._name = string.toLowerCase();
    }

    public Attr(String string, String string2) {
        this._name = string.toLowerCase();
        this._stringValues = new ArrayList(1);
        this._stringValues.add(string2);
    }

    public Attr(String string, String[] stringArray) {
        this._name = string.toLowerCase();
        int n = stringArray.length;
        this._stringValues = new ArrayList(n);
        int n2 = 0;
        while (n2 < n) {
            this._stringValues.add(stringArray[n2]);
            ++n2;
        }
    }

    public Attr(String string, byte[] byArray) {
        this._name = string.toLowerCase();
        this._byteValues = new ArrayList(1);
        this._byteValues.add(byArray);
    }

    public Attr(String string, byte[][] byArray) {
        this._name = string.toLowerCase();
        this._byteValues = new ArrayList(1);
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            this._byteValues.add(byArray[n2]);
            ++n2;
        }
    }

    public Attr(LDAPAttribute lDAPAttribute) {
        this._name = lDAPAttribute.getName().toLowerCase();
        this._ldapAttribute = lDAPAttribute;
    }

    public LDAPAttribute toLDAPAttribute() {
        int n = 0;
        LDAPAttribute lDAPAttribute = null;
        if (this._stringValues != null) {
            n = this._stringValues.size();
            if (n == 0) {
                lDAPAttribute = new LDAPAttribute(this._name);
            } else if (n == 1) {
                lDAPAttribute = new LDAPAttribute(this._name, (String)this._stringValues.get(0));
            } else if (n > 1) {
                lDAPAttribute = new LDAPAttribute(this._name);
                int n2 = 0;
                while (n2 < n) {
                    lDAPAttribute.addValue((String)this._stringValues.get(n2));
                    ++n2;
                }
            }
        } else if (this._byteValues != null) {
            lDAPAttribute = new LDAPAttribute(this._name);
            n = this._byteValues.size();
            int n3 = 0;
            while (n3 < n) {
                lDAPAttribute.addValue((byte[])this._byteValues.get(n3));
                ++n3;
            }
        } else if (this._ldapAttribute != null) {
            lDAPAttribute = this._ldapAttribute;
        } else if (this._name != null) {
            lDAPAttribute = new LDAPAttribute(this._name);
        }
        return lDAPAttribute;
    }

    public void setValue(String string) {
        if (this._stringValues == null) {
            this.setupStringValues();
        }
        this._stringValues.clear();
        this.addValue(string);
    }

    public void addValue(String string) {
        if (this._stringValues == null) {
            this.setupStringValues();
        }
        if (!this._stringValues.contains(string)) {
            this._stringValues.add(string);
        }
    }

    public void addValues(String[] stringArray) {
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.addValue(stringArray[n2]);
            ++n2;
        }
    }

    public void removeValue(String string) {
        if (this._stringValues == null) {
            this.setupStringValues();
        }
        int n = this._stringValues.size();
        int n2 = 0;
        while (n2 < n) {
            if (this._stringValues.get(n2).equals(string)) {
                this._stringValues.remove(n2);
                break;
            }
            ++n2;
        }
    }

    public void setValue(byte[] byArray) {
        if (this._byteValues == null) {
            this.setupByteValues();
        }
        this._byteValues.clear();
        this.addValue(byArray);
    }

    public void addValue(byte[] byArray) {
        if (this._byteValues == null) {
            this.setupByteValues();
        }
        this._byteValues.add(byArray);
    }

    public void addValues(byte[][] byArray) {
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.addValue(byArray[n2]);
            ++n2;
        }
    }

    public void removeValue(byte[] byArray) {
        if (this._byteValues == null) {
            this.setupByteValues();
        }
        int n = this._byteValues.size();
        int n2 = 0;
        while (n2 < n) {
            if (this._byteValues.get(n2).equals(byArray)) {
                this._byteValues.remove(n2);
                break;
            }
            ++n2;
        }
    }

    public String getName() {
        return this._name;
    }

    public String getName(Locale locale) {
        return Attr.getName(this._name, locale);
    }

    public static String getName(String string, Locale locale) {
        String string2 = null;
        String string3 = Attr.getBaseName(string);
        if (locale == null) {
            string2 = string3;
        } else {
            String string4 = locale.toString();
            if (string4.length() > 0) {
                StringBuffer stringBuffer = new StringBuffer(string3);
                stringBuffer.append(";lang-");
                stringBuffer.append(string4);
                string2 = stringBuffer.toString();
            }
        }
        return string2;
    }

    public String getBaseName() {
        String string = null;
        string = this._name == null ? null : LDAPAttribute.getBaseName((String)this._name);
        return string;
    }

    public static String getBaseName(String string) {
        return LDAPAttribute.getBaseName((String)string);
    }

    public String getValue() {
        String string = null;
        if (this._stringValues == null) {
            this.setupStringValues();
        }
        if (this._stringValues.size() != 0) {
            string = (String)this._stringValues.get(0);
        }
        return string;
    }

    public String[] getStringValues() {
        String[] stringArray = null;
        if (this._stringValues == null) {
            this.setupStringValues();
        }
        int n = this._stringValues.size();
        stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = (String)this._stringValues.get(n2);
            ++n2;
        }
        return stringArray;
    }

    public boolean contains(String string) {
        boolean bl = false;
        if (this._stringValues == null) {
            this.setupStringValues();
        }
        int n = this._stringValues.size();
        int n2 = 0;
        while (n2 < n) {
            if (this._stringValues.get(n2).equals(string)) {
                bl = true;
                break;
            }
            ++n2;
        }
        return bl;
    }

    public byte[] getByteValue() {
        byte[] byArray = null;
        if (this._byteValues == null) {
            this.setupByteValues();
        }
        if (this._byteValues.size() != 0) {
            byArray = (byte[])this._byteValues.get(0);
        }
        return byArray;
    }

    public byte[][] getByteValues() {
        byte[][] byArrayArray = null;
        if (this._byteValues == null) {
            this.setupByteValues();
        }
        int n = this._byteValues.size();
        byArrayArray = new byte[n][];
        int n2 = 0;
        while (n2 < n) {
            byArrayArray[n2] = (byte[])this._byteValues.get(n2);
            ++n2;
        }
        return byArrayArray;
    }

    public boolean contains(byte[] byArray) {
        boolean bl = false;
        if (this._byteValues == null) {
            this.setupByteValues();
        }
        int n = this._byteValues.size();
        int n2 = 0;
        while (n2 < n) {
            if (this._byteValues.get(n2).equals(byArray)) {
                bl = true;
                break;
            }
            ++n2;
        }
        return bl;
    }

    public int size() {
        int n = 0;
        if (this._stringValues != null) {
            n = this._stringValues.size();
        } else if (this._byteValues != null) {
            n = this._byteValues.size();
        } else if (this._ldapAttribute != null) {
            n = this._ldapAttribute.size();
        }
        return n;
    }

    public Object clone() {
        Attr attr = null;
        try {
            attr = (Attr)super.clone();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this._stringValues != null) {
            attr._stringValues = (ArrayList)this._stringValues.clone();
        }
        if (this._byteValues != null) {
            attr._byteValues = (ArrayList)this._byteValues.clone();
        } else if (this._ldapAttribute != null) {
            attr._ldapAttribute = this._ldapAttribute;
        }
        return attr;
    }

    public String toString() {
        if (this._stringValues == null) {
            this.setupStringValues();
        }
        return "Name : " + this._name + this._stringValues;
    }

    private void setupStringValues() {
        if (this._ldapAttribute != null) {
            String[] stringArray = this._ldapAttribute.getStringValueArray();
            int n = stringArray.length;
            this._stringValues = new ArrayList(n);
            int n2 = 0;
            while (n2 < n) {
                this._stringValues.add(stringArray[n2]);
                ++n2;
            }
        } else {
            this._stringValues = new ArrayList();
        }
    }

    private void setupByteValues() {
        if (this._ldapAttribute != null) {
            byte[][] byArray = this._ldapAttribute.getByteValueArray();
            int n = byArray.length;
            this._byteValues = new ArrayList(n);
            int n2 = 0;
            while (n2 < n) {
                this._byteValues.add(byArray[n2]);
                ++n2;
            }
        } else {
            this._byteValues = new ArrayList();
        }
    }
}

