/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.comm.share;

import com.iplanet.am.util.XMLUtils;
import com.iplanet.services.comm.share.RequestSetParser;
import com.iplanet.services.comm.share.Response;
import com.iplanet.services.comm.share.ResponseSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class ResponseSetParser {
    Document document;

    public ResponseSetParser(Document document) {
        this.document = document;
    }

    public ResponseSetParser(String string) {
        this.document = XMLUtils.toDOMDocument(string, RequestSetParser.debug);
    }

    public ResponseSet parseXML() {
        if (this.document == null) {
            return null;
        }
        Element element = this.document.getDocumentElement();
        ResponseSet responseSet = new ResponseSet();
        this.setResponseSetAttributes(element, responseSet);
        NodeList nodeList = element.getElementsByTagName("Response");
        if (nodeList == null) {
            return responseSet;
        }
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            responseSet.addResponse(this.parseResponseElement((Element)nodeList.item(n2)));
            ++n2;
        }
        return responseSet;
    }

    public void setResponseSetAttributes(Element element, ResponseSet responseSet) {
        String string = element.getAttribute("vers");
        if (string != null) {
            responseSet.setResponseSetVersion(string);
        }
        if ((string = element.getAttribute("svcid")) != null) {
            responseSet.setServiceID(string);
        }
        if ((string = element.getAttribute("reqid")) != null) {
            responseSet.setRequestSetID(string);
        }
    }

    private Response parseResponseElement(Element element) {
        Node node;
        Response response = new Response();
        String string = element.getAttribute("dtdid");
        if (string != null) {
            response.setDtdID(string);
        }
        if ((node = element.getFirstChild()) != null) {
            response.setContent(node.getNodeValue());
        }
        return response;
    }
}

