/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.comm.share;

import com.iplanet.services.comm.share.Notification;
import com.iplanet.services.comm.share.NotificationSetParser;
import java.util.Vector;

public class NotificationSet {
    private static final String sccsID = "$Id: NotificationSet.java,v 1.15 2005/06/24 16:55:28 vs125812 Exp $ $Date: 2005/06/24 16:55:28 $  Sun Microsystems, Inc.";
    static final String QUOTE = "\"";
    static final String NL = "\n";
    static final String BEGIN_CDATA = "<![CDATA[";
    static final String END_CDATA = "]]>";
    private String notificationSetVersion;
    private String serviceID;
    private String notificationSetID;
    private Vector notificationVector = new Vector();
    private static int notificationCount = 0;

    public NotificationSet(String string) {
        this.serviceID = string;
        this.notificationSetVersion = "1.0";
        this.notificationSetID = Integer.toString(notificationCount++);
    }

    NotificationSet() {
    }

    public static NotificationSet parseXML(String string) {
        NotificationSetParser notificationSetParser = new NotificationSetParser(string);
        return notificationSetParser.parseXML();
    }

    public String getServiceID() {
        return this.serviceID;
    }

    public Vector getNotifications() {
        return this.notificationVector;
    }

    public void addNotification(Notification notification) {
        this.notificationVector.addElement(notification);
    }

    public String toXMLString() {
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append("<?xml version=").append(QUOTE).append("1.0").append(QUOTE).append(" encoding=").append(QUOTE).append("UTF-8").append(QUOTE).append(" standalone=").append(QUOTE).append("yes").append(QUOTE).append("?>").append(NL);
        stringBuffer.append("<NotificationSet vers=").append(QUOTE).append(this.notificationSetVersion).append(QUOTE).append(" svcid=").append(QUOTE).append(this.serviceID).append(QUOTE).append(" notid=").append(QUOTE).append(this.notificationSetID).append(QUOTE).append(">").append(NL);
        int n = this.notificationVector.size();
        int n2 = 0;
        while (n2 < n) {
            Notification notification = (Notification)this.notificationVector.elementAt(n2);
            stringBuffer.append("<Notification");
            if (notification.getDtdID() != null) {
                stringBuffer.append(" dtdid=").append(QUOTE).append(notification.getDtdID()).append(QUOTE);
            }
            stringBuffer.append(">");
            stringBuffer.append(BEGIN_CDATA).append(notification.getContent()).append(END_CDATA);
            stringBuffer.append("</Notification>").append(NL);
            ++n2;
        }
        stringBuffer.append("</NotificationSet>");
        return stringBuffer.toString();
    }

    void setNotificationSetVersion(String string) {
        this.notificationSetVersion = string;
    }

    void setServiceID(String string) {
        this.serviceID = string;
    }

    void setNotificationSetID(String string) {
        this.notificationSetID = string;
    }
}

