/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.cdm.clientschema;

import com.iplanet.am.sdk.AMEntity;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMSearchControl;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.Debug;
import com.iplanet.services.cdm.clientschema.AMClientCapException;
import com.iplanet.services.cdm.clientschema.AMClientDataListener;
import com.iplanet.services.ldap.event.DSEvent;
import com.iplanet.services.ldap.event.IDSEventListener;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import netscape.ldap.util.DN;

public class AMClientCapData
implements IDSEventListener {
    private static final String SERVICE_VERSION = "1.0";
    private static final String SERVICE_NAME = "SunAMClientData";
    private static final String BUNDLE_NAME = "amClientData";
    private static String OBJECTCLASS = "objectclass";
    private static String CLIENT_OBJECTCLASS = "sunAMClient";
    private static String UMS_ADD_TEMPLATE_NAME = "Client";
    private static String UMS_SRCH_TEMPLATE_NAME = "BasicClientSearch";
    private static String CLIENT_PREFIX = "sunamclient";
    private static final String CREATE_FAILED = "901";
    private static final String MISSING_PROP_CT = "903";
    private static final String CT_EXISTS = "904";
    private static final String ADD_FAILED = "905";
    private static final String CANNOT_MOD_INT_DB = "906";
    private static final String MODIFY_FAILED = "907";
    private static final String DELETE_FAILED = "908";
    private static final String[] dsameAttributeNames = new String[]{"generalPropertyNames", "hardwarePlatformNames", "softwarePlatformNames", "networkCharacteristicsNames", "browserUANames", "wapCharacteristicsNames", "pushCharacteristicsNames", "additionalPropertiesNames"};
    private static final String DBSTORE_SUBSCHEMA_ID = "clientDBStore";
    private static final String CLIENT_SUBSCHEMA_ID = "clientData";
    private static final String INTERNAL_DB = "internalData";
    private static final String EXTERNAL_DB = "externalData";
    private static final String INTERNAL_DATA = "ou=internalData";
    private static final String EXTERNAL_DATA = "ou=externalData";
    public static final int INTERNAL = 1;
    public static final int EXTERNAL = 2;
    public static final int ADDED = 1;
    public static final int REMOVED = 2;
    public static final int MODIFIED = 4;
    private static final String CLIENT_TYPE = "clientType";
    private static final String USER_AGENT = "userAgent";
    private static final String PARENT_ID = "parentId";
    private static final String ADD_PROPS = "additionalProperties";
    private static final String EQUALS = "=";
    private static final String COMMA = ",";
    private static String CLIENTTYPE_ATTR = "ou";
    public static final String ADD_PROP_SEPARATOR = "=";
    public static final String ADDITIONAL_PROPERTIES_ATTR = CLIENT_PREFIX + "additionalProperties";
    private static final String PROFILE_MANAGER_XML_ATTR = "profileManagerXML";
    private static final String ENABLE_CLIENT_CREATION_ATTR = "enableClientCreation";
    private static SSOToken adminToken = null;
    private static Debug debug = Debug.getInstance("amClientSchema");
    private static AMStoreConnection amConnection = null;
    private static ServiceManager sManager = null;
    private static String topLevelDN = null;
    private static String clientDataDN = null;
    private static String CLIENT_DATA_DN_PREFIX = "ou=1.0,ou=SunAMClientData,ou=ClientData";
    private static AMClientCapData internalInstance = null;
    private static AMClientCapData externalInstance = null;
    private static Set wholeClient = new HashSet();
    private static Set minClient = new HashSet();
    private static ServiceSchema clientServiceSchema = null;
    private static ServiceSchema clientSchema = null;
    private static Map schemaMap = null;
    private static Map schemaToLDAP = new HashMap();
    private static Map LDAPToSchema = new HashMap();
    protected static final String SEARCH_FILTER = "(" + OBJECTCLASS + "=" + CLIENT_OBJECTCLASS + ")";
    protected static final int OPERATIONS = 7;
    private int databaseType = 0;
    private String dbStr = null;
    private AMOrganizationalUnit amClientOrg = null;
    private List listeners = new ArrayList(2);
    private String databaseDN = null;

    private AMClientCapData(int n) throws Exception {
        String string = null;
        this.databaseType = n;
        if (this.isInternalInstance()) {
            string = INTERNAL_DATA;
            this.dbStr = "InternalDB:: ";
        } else {
            string = EXTERNAL_DATA;
            this.dbStr = "ExternalDB:: ";
        }
        this.init(string);
    }

    private synchronized void init(String string) throws Exception {
        String string2 = this.getServiceName();
        if (adminToken == null) {
            adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            sManager = new ServiceManager(adminToken);
            ServiceSchemaManager serviceSchemaManager = sManager.getSchemaManager(string2, SERVICE_VERSION);
            clientServiceSchema = serviceSchemaManager.getGlobalSchema();
            clientSchema = clientServiceSchema.getSubSchema(DBSTORE_SUBSCHEMA_ID);
            clientSchema = clientSchema.getSubSchema(CLIENT_SUBSCHEMA_ID);
            amConnection = new AMStoreConnection(adminToken);
            topLevelDN = amConnection.getOrganizationDN(null, null);
            AMClientCapData.initClientSchema();
            this.initConfigurationInfo(clientServiceSchema);
            clientDataDN = CLIENT_DATA_DN_PREFIX + COMMA + topLevelDN;
        }
        this.databaseDN = string + COMMA + clientDataDN;
        this.amClientOrg = amConnection.getOrganizationalUnit(this.databaseDN);
    }

    private void initConfigurationInfo(ServiceSchema serviceSchema) {
        String string;
        Set set = this.getServiceAttribute(serviceSchema, "configInfo");
        if (set == null) {
            set = Collections.EMPTY_SET;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            int n = string.indexOf("=");
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            if (string2.equalsIgnoreCase(OBJECTCLASS)) {
                CLIENT_OBJECTCLASS = string3;
                continue;
            }
            if (string2.equalsIgnoreCase("umsAddTemplateName")) {
                UMS_ADD_TEMPLATE_NAME = string3;
                continue;
            }
            if (string2.equalsIgnoreCase("umsSearchTemplateName")) {
                UMS_SRCH_TEMPLATE_NAME = string3;
                continue;
            }
            if (string2.equalsIgnoreCase("prefixForAttr")) {
                CLIENT_PREFIX = string3;
                continue;
            }
            if (string2.equalsIgnoreCase("rdn")) {
                CLIENTTYPE_ATTR = string3;
                continue;
            }
            if (string2.equalsIgnoreCase("clientDN")) {
                CLIENT_DATA_DN_PREFIX = string3;
                continue;
            }
            if (!string2.equalsIgnoreCase("minimalClientAttrs")) continue;
            this.addToSet(string3, minClient);
        }
        if (minClient.size() == 0) {
            string = CLIENTTYPE_ATTR + COMMA + USER_AGENT + COMMA + PARENT_ID;
            this.addToSet(string, minClient);
        }
    }

    private void addToSet(String string, Set set) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, COMMA);
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            string2 = string2.equalsIgnoreCase("rdn") ? CLIENTTYPE_ATTR : CLIENT_PREFIX + string2;
            set.add(string2);
        }
    }

    private void initEventListeners(SSOToken sSOToken, String string) {
    }

    private boolean isInternalInstance() {
        return this.databaseType == 1;
    }

    private static void initClientSchema() {
        Set set = AMClientCapData.getSchemaElements();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = CLIENT_PREFIX + string;
            if (string.equals(CLIENT_TYPE)) {
                string2 = CLIENTTYPE_ATTR;
            }
            wholeClient.add(string2);
            String string3 = string2.toLowerCase();
            LDAPToSchema.put(string3, string);
            schemaToLDAP.put(string, string2);
        }
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    public static synchronized AMClientCapData getInternalInstance() throws AMClientCapException {
        if (internalInstance == null) {
            try {
                internalInstance = new AMClientCapData(1);
            }
            catch (Exception exception) {
                internalInstance = null;
                debug.error("InternalDB:: Create instance object failed: ", exception);
                throw new AMClientCapException(BUNDLE_NAME, CREATE_FAILED, null);
            }
        }
        return internalInstance;
    }

    public static synchronized AMClientCapData getExternalInstance() throws AMClientCapException {
        if (externalInstance == null) {
            try {
                externalInstance = new AMClientCapData(2);
            }
            catch (Exception exception) {
                externalInstance = null;
                debug.error("ExternalDB:: Create instance object failed: ", exception);
                throw new AMClientCapException(BUNDLE_NAME, CREATE_FAILED, null);
            }
        }
        return externalInstance;
    }

    private String generateClientDN(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(CLIENTTYPE_ATTR);
        stringBuffer.append("=");
        stringBuffer.append(string);
        stringBuffer.append(COMMA);
        stringBuffer.append(this.databaseDN);
        return stringBuffer.toString();
    }

    public Map getProperties(String string) {
        Map map = null;
        String string2 = this.generateClientDN(string);
        try {
            AMEntity aMEntity = amConnection.getEntity(string2);
            if (aMEntity.isExists()) {
                Map map2 = aMEntity.getAttributes();
                map = this.parsePropertyNames(map2);
            }
        }
        catch (Exception exception) {
            debug.warning(this.dbStr + "Could not get Client: " + string, exception);
        }
        return map;
    }

    public Map loadMinimalClient(String string) {
        Map map = null;
        String string2 = this.generateClientDN(string);
        try {
            AMEntity aMEntity = amConnection.getEntity(string2);
            if (aMEntity.isExists()) {
                Map map2 = aMEntity.getAttributes(minClient);
                map = this.parsePropertyNames(map2);
            }
        }
        catch (Exception exception) {
            debug.warning(this.dbStr + "Could not get Client: " + string, exception);
        }
        return map;
    }

    private Map parsePropertyNames(Map map) {
        HashMap hashMap = new HashMap();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            String string = (String)iterator.next();
            Set set = (Set)map.get(string);
            if (set.size() == 0) continue;
            if (string.equalsIgnoreCase(ADDITIONAL_PROPERTIES_ATTR)) {
                object = set.iterator();
                while (object.hasNext()) {
                    String string2 = (String)object.next();
                    int n = string2.indexOf("=");
                    String string3 = string2.substring(0, n);
                    String string4 = string2.substring(n + 1);
                    this.addToMap(hashMap, string3, string4);
                }
                continue;
            }
            object = (String)LDAPToSchema.get(string);
            if (object == null) continue;
            this.addToMap(hashMap, (String)object, set);
        }
        return hashMap;
    }

    private void addToMap(Map map, String string, String string2) {
        HashSet<String> hashSet = (HashSet<String>)map.get(string);
        if (hashSet == null) {
            hashSet = new HashSet<String>(2);
            map.put(string, hashSet);
        }
        hashSet.add(string2);
    }

    private void addToMap(Map map, String string, Set set) {
        Set set2 = (Set)map.get(string);
        if (set2 == null) {
            map.put(string, set);
        } else {
            set2.addAll(set);
        }
    }

    public String getProfileManagerXML() {
        String string = null;
        Set set = this.getServiceAttribute(PROFILE_MANAGER_XML_ATTR);
        if (set != null) {
            Iterator iterator = set.iterator();
            string = (String)iterator.next();
        }
        return string;
    }

    private Set getServiceAttribute(String string) {
        Set set = this.getServiceAttribute(clientServiceSchema, string);
        return set;
    }

    private Set getServiceAttribute(ServiceSchema serviceSchema, String string) {
        Set set = null;
        Map map = serviceSchema.getAttributeDefaults();
        if (map != null) {
            set = (Set)map.get(string);
        }
        return set;
    }

    public Set getPropertyNames(String string) {
        Set set = null;
        if (string != null) {
            set = this.getServiceAttribute(string);
        }
        return set;
    }

    public boolean isClientPresent(String string) {
        String string2 = this.generateClientDN(string);
        boolean bl = false;
        try {
            AMEntity aMEntity = amConnection.getEntity(string2);
            bl = aMEntity.isExists();
        }
        catch (SSOException sSOException) {
            // empty catch block
        }
        return bl;
    }

    private String getClientType(Map map) {
        String string = null;
        Set set = (Set)map.get(CLIENT_TYPE);
        if (set != null && set.size() > 0) {
            Iterator iterator = set.iterator();
            string = (String)iterator.next();
        }
        return string;
    }

    private Map getKnownProperties(Map map) {
        Object object;
        HashMap<String, Set> hashMap = new HashMap<String, Set>();
        HashSet<String> hashSet = new HashSet<String>(5);
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            String string = (String)schemaToLDAP.get(object);
            Set set = (Set)map.get(object);
            if (string == null) {
                if (set == null || set.size() == 0) continue;
                String string2 = null;
                Iterator iterator2 = set.iterator();
                while (iterator2.hasNext()) {
                    String string3 = (String)iterator2.next();
                    string2 = string2 == null ? string3 : string2 + COMMA + string3;
                }
                hashSet.add((String)object + "=" + string2);
                continue;
            }
            hashMap.put(string, set);
        }
        if (hashSet.size() > 0) {
            object = (Set)map.get(ADD_PROPS);
            if (object != null) {
                hashSet.addAll((Collection<String>)object);
            }
            hashMap.put(ADDITIONAL_PROPERTIES_ATTR, hashSet);
        }
        return hashMap;
    }

    public int addClient(SSOToken sSOToken, Map map) throws AMClientCapException {
        int n = 0;
        String string = this.getClientType(map);
        Map map2 = this.getKnownProperties(map);
        HashMap<String, Map> hashMap = new HashMap<String, Map>(1);
        hashMap.put(string, map2);
        try {
            AMStoreConnection aMStoreConnection = new AMStoreConnection(sSOToken);
            AMOrganizationalUnit aMOrganizationalUnit = aMStoreConnection.getOrganizationalUnit(this.databaseDN);
            aMOrganizationalUnit.createEntities(UMS_ADD_TEMPLATE_NAME, hashMap);
        }
        catch (Exception exception) {
            Object[] objectArray = new String[]{string};
            AMClientCapException aMClientCapException = new AMClientCapException(BUNDLE_NAME, ADD_FAILED, objectArray);
            String string2 = aMClientCapException.getMessage();
            debug.error(this.dbStr + string2, exception);
            throw aMClientCapException;
        }
        return n;
    }

    public int modifyClient(SSOToken sSOToken, Map map) throws AMClientCapException {
        int n = 0;
        if (this.isInternalInstance()) {
            throw new AMClientCapException(BUNDLE_NAME, CANNOT_MOD_INT_DB, null);
        }
        String string = this.getClientType(map);
        try {
            AMStoreConnection aMStoreConnection = new AMStoreConnection(sSOToken);
            String string2 = this.generateClientDN(string);
            AMEntity aMEntity = aMStoreConnection.getEntity(string2);
            if (aMEntity.isExists()) {
                Map map2 = this.getKnownProperties(map);
                map2.remove(CLIENTTYPE_ATTR);
                aMEntity.setAttributes(map2);
                aMEntity.store();
            } else {
                n = this.addClient(sSOToken, map);
            }
        }
        catch (Exception exception) {
            Object[] objectArray = new String[]{string};
            AMClientCapException aMClientCapException = new AMClientCapException(BUNDLE_NAME, MODIFY_FAILED, objectArray);
            String string3 = aMClientCapException.getMessage();
            debug.error(this.dbStr + string3, exception);
            throw aMClientCapException;
        }
        return n;
    }

    public int removeClient(SSOToken sSOToken, String string) throws AMClientCapException {
        boolean bl = false;
        if (this.isInternalInstance()) {
            throw new AMClientCapException(BUNDLE_NAME, CANNOT_MOD_INT_DB, null);
        }
        try {
            AMStoreConnection aMStoreConnection = new AMStoreConnection(sSOToken);
            String string2 = this.generateClientDN(string);
            AMEntity aMEntity = aMStoreConnection.getEntity(string2);
            aMEntity.delete();
        }
        catch (Exception exception) {
            Object[] objectArray = new String[]{string};
            AMClientCapException aMClientCapException = new AMClientCapException(BUNDLE_NAME, DELETE_FAILED, objectArray);
            String string3 = aMClientCapException.getMessage();
            debug.error(this.dbStr + string3, exception);
            throw aMClientCapException;
        }
        return 0;
    }

    public static synchronized Set getSchemaElements() {
        Map map = AMClientCapData.getSchemaMap();
        Set set = map.keySet();
        return set;
    }

    public AttributeSchema getAttributeSchema(String string) {
        Map map = AMClientCapData.getSchemaMap();
        AttributeSchema attributeSchema = (AttributeSchema)map.get(string);
        return attributeSchema;
    }

    private static synchronized Map getSchemaMap() {
        if (schemaMap == null) {
            Set set = clientSchema.getAttributeSchemas();
            schemaMap = new HashMap();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                AttributeSchema attributeSchema = (AttributeSchema)iterator.next();
                String string = attributeSchema.getName();
                schemaMap.put(string, attributeSchema);
            }
        }
        return schemaMap;
    }

    public boolean canCreateInternalClients() {
        boolean bl = false;
        Set set = this.getServiceAttribute(ENABLE_CLIENT_CREATION_ATTR);
        if (set != null) {
            Iterator iterator = set.iterator();
            Boolean bl2 = new Boolean((String)iterator.next());
            bl = bl2;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(AMClientDataListener aMClientDataListener) {
        List list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(aMClientDataListener)) {
                this.listeners.add(aMClientDataListener);
            }
        }
    }

    public void eventError(String string) {
        debug.warning("Handled eventError() Notification: " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entryChanged(DSEvent dSEvent) {
        String string = dSEvent.getID();
        DN dN = new DN(string);
        String[] stringArray = dN.explodeDN(true);
        if (debug.messageEnabled()) {
            debug.message("entryChanged() Notification for: " + string);
        }
        if (stringArray == null || stringArray.length < 2) {
            return;
        }
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        int n = dSEvent.getEventType();
        if (string3 == null || string2 == null) {
            return;
        }
        int n2 = -1;
        if (string3.equalsIgnoreCase(INTERNAL_DB)) {
            n2 = 1;
        } else if (string3.equalsIgnoreCase(EXTERNAL_DB)) {
            n2 = 2;
        } else {
            debug.warning("Unknown db: " + string3 + " : client = " + string2);
            return;
        }
        if (debug.messageEnabled()) {
            debug.message("Notifying Listeners:: ClientType = " + string2 + " : DB = " + n2 + " : OP = " + n);
        }
        List list = this.listeners;
        synchronized (list) {
            int n3 = this.listeners.size();
            for (int i = 0; i < n3; ++i) {
                AMClientDataListener aMClientDataListener = (AMClientDataListener)this.listeners.get(i);
                try {
                    aMClientDataListener.clientChanged(string2, n2, n);
                    continue;
                }
                catch (Throwable throwable) {
                    debug.warning("Event Notification failed: ", throwable);
                }
            }
        }
    }

    public void allEntriesChanged() {
    }

    public String[] getClassifications() {
        return dsameAttributeNames;
    }

    public Set getMinimalClientInfo() {
        HashSet<Map> hashSet = new HashSet<Map>();
        AMSearchControl aMSearchControl = new AMSearchControl();
        aMSearchControl.setReturnAttributes(minClient);
        try {
            long l = System.currentTimeMillis();
            AMSearchResults aMSearchResults = this.amClientOrg.searchEntities("*", aMSearchControl, null, UMS_SRCH_TEMPLATE_NAME);
            long l2 = System.currentTimeMillis();
            if (debug.messageEnabled()) {
                debug.message(this.dbStr + "getMinimalClientInfo() Srch Time (ms) = " + (l2 - l));
            }
            l = System.currentTimeMillis();
            Map map = aMSearchResults.getResultAttributes();
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Map map2 = (Map)map.get(string);
                Map map3 = this.parsePropertyNames(map2);
                hashSet.add(map3);
            }
            l2 = System.currentTimeMillis();
            if (debug.messageEnabled()) {
                debug.message(this.dbStr + "getMinimalClientInfo() Parse Time (ms) = " + (l2 - l));
            }
        }
        catch (Exception exception) {
            debug.error(this.dbStr + " getMinimalClientInfo(): Search Error: ", exception);
        }
        return hashSet;
    }

    public String getBase() {
        return clientDataDN;
    }

    public String getFilter() {
        return SEARCH_FILTER;
    }

    public int getOperations() {
        return 7;
    }

    public int getScope() {
        return 2;
    }

    public void setListeners(Map map) {
    }
}

