/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.cdm;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.OrderedSet;
import com.iplanet.services.cdm.Client;
import com.iplanet.services.cdm.ClientException;
import com.iplanet.services.cdm.ClientTypesManager;
import com.iplanet.services.cdm.clientschema.AMClientCapData;
import com.iplanet.services.cdm.clientschema.AMClientCapException;
import com.iplanet.services.cdm.clientschema.AMClientDataListener;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class DefaultClientTypesManager
implements ClientTypesManager,
AMClientDataListener {
    private static String CLASS = "DefaultClientTypesManager: ";
    protected static final String CDM_SERVICE_NAME = "iPlanetAMClientDetection";
    private static final String CDM_DEFAULT_CLIENT_TYPES_ATTR = "iplanet-am-client-detection-default-client-type";
    private static Debug debug = Debug.getInstance("amClientDetection");
    private static SSOToken internalToken = null;
    private static String defaultClientType = null;
    private static Map internalClientData = new Hashtable();
    private static Map externalClientData = new Hashtable();
    private static Map mergedClientData = new Hashtable();
    private static Map userAgentMap = new Hashtable();
    private static Map clientTypeMap = new Hashtable();
    private static Set updatedClients = new HashSet();
    private static Map partialMatchMap = new Hashtable();
    private static Map loadedClientsMap = new Hashtable();
    private static Map loadedInternalClients = new Hashtable();
    private static Map loadedExternalClients = new Hashtable();
    private static Map baseProfiles = new TreeMap();
    private static final String PARENT_ID = "parentId";
    private static final String CLIENT_TYPE = "clientType";
    private static final String USER_AGENT = "userAgent";
    private static AMClientCapData intCapInstance = null;
    private static AMClientCapData extCapInstance = null;
    private static boolean isInitialized;

    public void initManager() {
        Map map = userAgentMap;
        synchronized (map) {
            if (!isInitialized) {
                isInitialized = true;
                long l = System.currentTimeMillis();
                this.initMinimalInternalClientTypesData();
                this.initMinimalExternalClientTypesData();
                this.mergeInternalWithExternal();
                this.loadMaps();
                long l2 = System.currentTimeMillis();
                if (debug.messageEnabled()) {
                    debug.message(CLASS + "Load AllClients Time (ms) = " + (l2 - l));
                }
                intCapInstance.addListener(this);
                extCapInstance.addListener(this);
            }
        }
    }

    private static String getDefaultClientTypeFromService() throws SMSException, SSOException {
        ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(CDM_SERVICE_NAME, internalToken);
        ServiceSchema serviceSchema = serviceSchemaManager.getGlobalSchema();
        Map map = serviceSchema.getAttributeDefaults();
        String string = (String)((Set)map.get(CDM_DEFAULT_CLIENT_TYPES_ATTR)).toArray()[0];
        return string;
    }

    private static SSOToken getInternalToken() throws SSOException {
        return (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
    }

    private void initMinimalInternalClientTypesData() {
        Set set = intCapInstance.getMinimalClientInfo();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map map = (Map)iterator.next();
            String string = this.getClientType(map);
            if (string == null || string.length() <= 0) {
                debug.error(CLASS + "Found clientType == NULL in internal DB");
                continue;
            }
            internalClientData.put(string, map);
            Set set2 = (Set)map.get(PARENT_ID);
            if (set2 == null || !set2.contains(string)) continue;
            TreeMap treeMap = new TreeMap();
            TreeMap treeMap2 = new TreeMap();
            treeMap.put(string, treeMap2);
            baseProfiles.put(string, treeMap);
            if (!debug.messageEnabled()) continue;
            debug.message(CLASS + "BaseProfile: " + string);
        }
    }

    private void initMinimalExternalClientTypesData() {
        Set set = extCapInstance.getMinimalClientInfo();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map map = (Map)iterator.next();
            String string = this.getClientType(map);
            if (string != null && string.length() > 0) {
                Map map2 = this.mergeWithInternal(string, map);
                if (map2 != null) {
                    map = map2;
                }
                externalClientData.put(string, map);
                continue;
            }
            debug.error(CLASS + "Found clientType == NULL in external DB");
        }
    }

    private String getClientType(Map map) {
        return this.getFirstString((Set)map.get(CLIENT_TYPE));
    }

    private Map mergeWithParent(Map map) {
        String string = this.getClientType(map);
        String string2 = this.getParentID(map);
        Map map2 = map;
        Map map3 = null;
        OrderedSet orderedSet = new OrderedSet();
        while (string2 != null && !string.equals(string2)) {
            map3 = (Map)mergedClientData.get(string2);
            if (map3 == null) {
                debug.error(CLASS + "clientdata null for: " + string2);
                map2 = null;
                break;
            }
            map2 = this.mergeMap(map3, map);
            orderedSet.add(string2);
            map = map2;
            string = this.getClientType(map3);
            string2 = this.getParentID(map3);
        }
        if (map2 != null) {
            map2.put(PARENT_ID, orderedSet);
        }
        return map2;
    }

    private Map mergeWithInternal(String string, Map map) {
        Map map2 = null;
        Map map3 = (Map)internalClientData.get(string);
        if (map3 != null) {
            map2 = this.mergeMap(map3, map);
        }
        return map2;
    }

    private Map mergeMap(Map map, Map map2) {
        Map map3 = null;
        if (map != null) {
            map3 = new HashMap(map);
        }
        if (map2 != null) {
            if (map3 != null) {
                map3.putAll(map2);
            } else {
                map3 = map2;
            }
        }
        return map3;
    }

    private void mergeInternalWithExternal() {
        mergedClientData = this.mergeMap(internalClientData, externalClientData);
    }

    protected void loadMaps() {
        Set set = mergedClientData.keySet();
        Iterator iterator = set.iterator();
        String string = null;
        Map map = null;
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            map = (Map)mergedClientData.get(string);
            this.setParentStyles(map);
        }
        iterator = set.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            map = (Map)mergedClientData.get(string);
            this.addToClientMap(string, map);
        }
    }

    protected Client addToClientMap(String string, Map map) {
        return this.addToClientMap(string, map, true);
    }

    protected Client addToClientMap(String string, Map map, boolean bl) {
        Client client = new Client(string, map);
        String string2 = client.getProperty(USER_AGENT);
        if (string2 != null) {
            userAgentMap.put(string2, string);
        }
        clientTypeMap.put(string, client);
        if (bl) {
            this.storeInProfilesMap(client);
        }
        return client;
    }

    protected void removeFromClientMap(String string, Client client) {
        clientTypeMap.remove(string);
        mergedClientData.remove(string);
        String string2 = null;
        if (client != null && (string2 = client.getProperty(USER_AGENT)) != null) {
            userAgentMap.remove(string2);
        }
        this.removeFromProfilesMap(string, client);
    }

    protected void storeInProfilesMap(Client client) {
        Set set = client.getProperties(PARENT_ID);
        String string = client.getClientType();
        Map map = this.getStylesProfileMap(string, set);
        if (map != null) {
            map.put(string, client);
        }
    }

    private void handleParentChange(String string, Map map) {
        Client client = (Client)clientTypeMap.get(string);
        if (client == null) {
            this.addToClientMap(string, map);
            mergedClientData.put(string, map);
            return;
        }
        Set set = client.getProperties(PARENT_ID);
        String string2 = this.getFirstString(set);
        String string3 = this.getParentID(map);
        if (!string3.equals(string2)) {
            this.removeFromProfilesMap(string, client);
            map = this.mergeWithParent(map);
            if (map != null) {
                this.addToClientMap(string, map);
            }
        }
        mergedClientData.put(string, map);
    }

    protected void removeFromProfilesMap(String string, Client client) {
        if (client == null) {
            return;
        }
        Set set = client.getProperties(PARENT_ID);
        Map map = this.getStylesProfileMap(string, set);
        if (map != null) {
            map.remove(string);
        }
    }

    protected Map getStylesProfileMap(String string, Set set) {
        String string2 = null;
        String string3 = null;
        if (string == null || set == null) {
            return null;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            string3 = string2;
            string2 = (String)iterator.next();
        }
        if (string3 == null) {
            string3 = string2;
        }
        Map map = null;
        Map map2 = (Map)baseProfiles.get(string2);
        if (map2 != null) {
            if (map2.containsKey(string)) {
                map2 = null;
            } else {
                map = (Map)map2.get(string3);
                if (map != null) {
                    map2 = map;
                }
            }
        }
        return map2;
    }

    private String getFirstString(Set set) {
        String string = null;
        if (set != null && set.iterator().hasNext()) {
            string = (String)set.iterator().next();
        }
        return string;
    }

    protected Client addToIndexes(String string, Map map) {
        return this.addToIndexes(string, map, true);
    }

    protected Client addToIndexes(String string, Map map, boolean bl) {
        mergedClientData.put(string, map);
        Client client = this.addToClientMap(string, map, bl);
        String string2 = client.getProperty(USER_AGENT);
        if (string2 != null) {
            partialMatchMap.remove(string2);
            if (partialMatchMap.containsValue(string)) {
                Iterator iterator = partialMatchMap.values().iterator();
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    if (string3 == null || !string3.equals(string)) continue;
                    iterator.remove();
                }
            }
        }
        return client;
    }

    public Client getFromUserAgentMap(String string) {
        String string2 = string != null ? (String)userAgentMap.get(string) : null;
        Client client = null;
        if (string2 != null) {
            client = this.getClientInstance(string2);
        }
        return client;
    }

    public Set userAgentSet() {
        Set set = userAgentMap.keySet();
        return set;
    }

    public String getPartiallyMatchedClient(String string) {
        String string2 = (String)partialMatchMap.get(string);
        return string2;
    }

    public void addToPartialMatchMap(String string, String string2) {
        partialMatchMap.put(string, string2);
    }

    public Client addClient(SSOToken sSOToken, String string, Map map, boolean bl) throws AMClientCapException {
        Client client = null;
        if (map == null || map.size() == 0) {
            return client;
        }
        if (debug.messageEnabled()) {
            debug.message(CLASS + "Adding new Client: " + map);
        }
        if (bl) {
            Map map2 = internalClientData;
            synchronized (map2) {
                intCapInstance.addClient(sSOToken, map);
                map = this.mergeWithParent(map);
                internalClientData.put(string, map);
            }
        } else {
            map = this.mergeWithParent(map);
        }
        client = this.addToIndexes(string, map, bl);
        if (!bl) {
            loadedClientsMap.put(string, client);
        }
        return client;
    }

    public boolean canCreateClients() {
        return intCapInstance.canCreateInternalClients();
    }

    public Map getAllClientInstances() {
        return clientTypeMap;
    }

    public Set getAllClientTypes() {
        return clientTypeMap.keySet();
    }

    public Client getClientInstance(String string) {
        if (string.equals("default")) {
            string = defaultClientType;
        }
        Client client = null;
        client = (Client)loadedClientsMap.get(string);
        if (client == null) {
            client = this.loadClient(string);
        }
        return client;
    }

    public Client getClientInstance(String string, SSOToken sSOToken) {
        return this.getClientInstance(string);
    }

    public Map getClientTypeData(String string) {
        Object object;
        if (string.equals("default")) {
            string = defaultClientType;
        }
        if (mergedClientData.get(string) == null) {
            object = this.loadClient(string);
        }
        object = (Map)mergedClientData.get(string);
        return object;
    }

    protected Client loadClient(String string) {
        Client client = null;
        long l = System.currentTimeMillis();
        Map map = this.loadInternalClient(string);
        Map map2 = this.loadExternalClient(string);
        if (map == null && map2 == null) {
            return client;
        }
        Map map3 = this.mergeMap(map, map2);
        String string2 = string;
        String string3 = this.getParentID(map3);
        OrderedSet orderedSet = new OrderedSet();
        while (string3 != null && !string2.equals(string3)) {
            orderedSet.add(string3);
            Map map4 = this.loadInternalClient(string3);
            if (map4 == null) break;
            map3 = this.mergeMap(map4, map3);
            string2 = this.getClientType(map4);
            string3 = this.getParentID(map4);
        }
        if (orderedSet.size() > 0) {
            map3.put(PARENT_ID, orderedSet);
        }
        mergedClientData.put(string, map3);
        client = new Client(string, map3);
        loadedClientsMap.put(string, client);
        long l2 = System.currentTimeMillis();
        if (debug.messageEnabled()) {
            debug.message(CLASS + "Load Client " + string + " Time (ms) = " + (l2 - l));
        }
        return client;
    }

    protected Map loadInternalClient(String string) {
        Map map = (Map)loadedInternalClients.get(string);
        if (map == null) {
            map = intCapInstance.getProperties(string);
            if (map == null) {
                return null;
            }
            loadedInternalClients.put(string, map);
            internalClientData.put(string, map);
        }
        return map;
    }

    protected Map loadExternalClient(String string) {
        Map map = (Map)loadedExternalClients.get(string);
        if (map == null) {
            map = extCapInstance.getProperties(string);
            if (map == null) {
                return null;
            }
            loadedExternalClients.put(string, map);
            externalClientData.put(string, map);
        }
        return map;
    }

    private String getParentID(Map map) {
        Set set = (Set)map.get(PARENT_ID);
        String string = this.getFirstString(set);
        return string;
    }

    public String getDefaultClientType() {
        return defaultClientType;
    }

    public void updateClientData() throws ClientException {
    }

    public void store(SSOToken sSOToken) throws SMSException, SSOException {
    }

    public void setDirty(String string, Map map) {
    }

    public void clientChanged(String string, int n, int n2) {
        if (debug.messageEnabled()) {
            debug.message(CLASS + "clientChanged() Notification: " + "clientType = " + string + " :DB = " + n + " : Op = " + n2);
        }
        if (string == null || string.length() == 0) {
            return;
        }
        if (n2 == 1) {
            if (n == 1) {
                if (!internalClientData.containsKey(string)) {
                    Map map = intCapInstance.loadMinimalClient(string);
                    Map map2 = (Map)mergedClientData.get(string);
                    Map map3 = this.mergeMap(map2, map);
                    this.handleParentChange(string, map3);
                    this.unloadClient(string);
                }
            } else if (n == 2) {
                Set set = updatedClients;
                synchronized (set) {
                    if (!externalClientData.containsKey(string)) {
                        Map map = extCapInstance.loadMinimalClient(string);
                        Map map4 = (Map)mergedClientData.get(string);
                        Map map5 = this.mergeMap(map4, map);
                        this.handleParentChange(string, map5);
                        this.unloadClient(string);
                    }
                }
            }
        } else if (n2 == 4) {
            Set set = updatedClients;
            synchronized (set) {
                if (updatedClients.contains(string)) {
                    updatedClients.remove(string);
                } else {
                    Map map = extCapInstance.loadMinimalClient(string);
                    Map map6 = (Map)mergedClientData.get(string);
                    Map map7 = this.mergeMap(map6, map);
                    this.handleParentChange(string, map7);
                    this.unloadClient(string);
                }
            }
        } else if (n2 == 2) {
            if (externalClientData.containsKey(string)) {
                this.removeFromMaps(string);
            }
        } else {
            debug.warning(CLASS + "clientChanged(): unknown OpType");
        }
    }

    public Set getBaseProfileNames() {
        return baseProfiles.keySet();
    }

    public Set getStyles(String string) {
        Set set = null;
        Map map = (Map)baseProfiles.get(string);
        if (map != null) {
            set = map.keySet();
        }
        return set;
    }

    public Map getClients(String string, String string2) {
        Map map = null;
        Map map2 = (Map)baseProfiles.get(string);
        if (map2 != null) {
            map = (Map)map2.get(string2);
        }
        return map;
    }

    public int addClientExternal(SSOToken sSOToken, Map map) throws AMClientCapException {
        Map map2 = externalClientData;
        synchronized (map2) {
            extCapInstance.addClient(sSOToken, map);
            String string = this.getClientType(map);
            Map map3 = this.mergeWithParent(map);
            externalClientData.put(string, map3);
            Client client = this.addToIndexes(string, map3);
        }
        return 0;
    }

    public int modifyClientExternal(SSOToken sSOToken, Map map) throws AMClientCapException {
        if (map == null || map.size() == 0) {
            return 0;
        }
        Set set = updatedClients;
        synchronized (set) {
            extCapInstance.modifyClient(sSOToken, map);
            String string = this.getClientType(map);
            if (!externalClientData.containsKey(string)) {
                externalClientData.put(string, map);
            } else {
                updatedClients.add(string);
            }
            Map map2 = (Map)mergedClientData.get(string);
            map = this.mergeMap(map2, map);
            this.handleParentChange(string, map);
            this.unloadClient(string);
        }
        return 0;
    }

    public int removeClientExternal(SSOToken sSOToken, String string) throws AMClientCapException {
        Map map = externalClientData;
        synchronized (map) {
            extCapInstance.removeClient(sSOToken, string);
            this.removeFromMaps(string);
        }
        return 0;
    }

    protected void removeFromMaps(String string) {
        Client client = (Client)clientTypeMap.get(string);
        externalClientData.remove(string);
        Map map = (Map)internalClientData.get(string);
        if (map == null) {
            this.removeFromClientMap(string, client);
        } else {
            this.handleParentChange(string, map);
        }
        this.unloadClient(string);
    }

    protected void setParentStyles(Map map) {
        if (map == null) {
            return;
        }
        Set set = (Set)map.get(PARENT_ID);
        String string = this.getFirstString(set);
        String string2 = this.getClientType(map);
        Map map2 = (Map)mergedClientData.get(string);
        if (map2 == null) {
            debug.error("ParentMap for clientType = " + string2 + ", parentId = " + string + " was null");
            return;
        }
        if (baseProfiles.containsKey(string)) {
            Map map3;
            Set set2 = null;
            set2 = (Set)map.get(USER_AGENT);
            if (set2 == null && (map3 = (Map)baseProfiles.get(string)).get(string2) == null) {
                map3.put(string2, new TreeMap());
                if (debug.messageEnabled()) {
                    debug.message(CLASS + "Creating Style: " + string2 + " : Parent : " + string);
                }
            }
        } else {
            OrderedSet orderedSet = new OrderedSet();
            orderedSet.add(string);
            Set set3 = (Set)map2.get(PARENT_ID);
            orderedSet.addAll(set3);
            map.put(PARENT_ID, orderedSet);
        }
    }

    private void unloadClient(String string) {
        loadedInternalClients.remove(string);
        loadedExternalClients.remove(string);
        loadedClientsMap.remove(string);
    }

    static {
        try {
            internalToken = DefaultClientTypesManager.getInternalToken();
            defaultClientType = DefaultClientTypesManager.getDefaultClientTypeFromService();
            try {
                intCapInstance = AMClientCapData.getInternalInstance();
            }
            catch (AMClientCapException aMClientCapException) {
                debug.error(CLASS + "Unable to get instance of InternalData");
            }
            try {
                extCapInstance = AMClientCapData.getExternalInstance();
            }
            catch (AMClientCapException aMClientCapException) {
                debug.error(CLASS + "Unable to get instance of ExternalData");
            }
        }
        catch (Throwable throwable) {
            debug.error(CLASS + "init() failed: ", throwable);
        }
        isInitialized = false;
    }
}

