/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.cdm;

import com.iplanet.am.util.Debug;
import com.iplanet.services.cdm.ClientException;
import com.iplanet.services.cdm.ClientsManager;
import com.iplanet.services.cdm.G11NSettings;
import com.iplanet.services.cdm.ICDMConstants;
import com.iplanet.services.cdm.clientschema.AMClientCapData;
import com.iplanet.sso.SSOToken;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Observable;
import java.util.Set;

public class Client
extends Observable
implements ICDMConstants {
    private static final String CLIENT_TYPE = "clientType";
    private static final String ADD_PROP_ATTR = AMClientCapData.ADDITIONAL_PROPERTIES_ATTR;
    private static final String SEPARATOR = "=";
    private static G11NSettings g11nSettings = G11NSettings.getInstance();
    private static Debug debug = Debug.getInstance("amClientDetection");
    private String cType = null;
    private HashMap profileMap = null;
    private Set additionalProperties = null;

    public Client() {
    }

    public Client(String string, Map map) {
        this.profileMap = new HashMap(map.size());
        this.profileMap.putAll(map);
        this.cType = string;
        this.additionalProperties = this.separateAdditionalProperties(this.profileMap);
    }

    public static Client getInstance(String string) throws ClientException {
        return ClientsManager.getInstance(string);
    }

    protected static Client getInstance(String string, SSOToken sSOToken) throws ClientException {
        return Client.getInstance(string);
    }

    public static Client getDefaultInstance() {
        return ClientsManager.getDefaultInstance();
    }

    public static Iterator getAllInstances() {
        return ClientsManager.getAllInstances();
    }

    protected static Iterator getAllInstances(SSOToken sSOToken) {
        return Client.getAllInstances();
    }

    public String getClientType() {
        return this.cType;
    }

    public String getProperty(String string) {
        String string2 = null;
        Set set = null;
        set = this.getPropertiesInternal(string);
        if (set != null) {
            Iterator iterator = set.iterator();
            string2 = (String)iterator.next();
        }
        return string2;
    }

    private Set getPropertiesInternal(String string) {
        Set set = (Set)this.profileMap.get(string);
        return set;
    }

    public Set getProperties(String string) {
        Set set = this.getPropertiesInternal(string);
        Set set2 = null;
        if (set != null) {
            set2 = Collections.unmodifiableSet(set);
        }
        return set2;
    }

    public Set getPropertyNames() {
        Set set = this.profileMap.keySet();
        return set;
    }

    public String getCharset(Locale locale) {
        try {
            return g11nSettings.getCharset(this.cType, locale);
        }
        catch (ClientException clientException) {
            debug.error("Client.getCharset ", clientException);
            return "ISO-8859-1";
        }
    }

    public Set getAdditionalProperties() {
        return this.additionalProperties;
    }

    protected Set separateAdditionalProperties(Map map) {
        Set set = null;
        if (map != null && (set = (Set)map.get(ADD_PROP_ATTR)) != null && set.size() > 0) {
            map.remove(ADD_PROP_ATTR);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                int n = string.indexOf(SEPARATOR);
                if (n <= 0) continue;
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                HashSet<String> hashSet = new HashSet<String>(1);
                hashSet.add(string3);
                map.put(string2, hashSet);
            }
        }
        return set;
    }
}

