/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.am.util.ThreadPool;
import com.iplanet.am.util.ThreadPoolException;
import com.iplanet.dpro.session.Session;
import com.iplanet.dpro.session.SessionException;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.dpro.session.service.SessionService;
import com.iplanet.dpro.session.share.SessionInfo;
import com.iplanet.dpro.session.share.SessionRequest;
import com.iplanet.dpro.session.share.SessionResponse;
import com.sun.identity.common.MapFactory;
import com.sun.identity.session.util.RestrictedTokenAction;
import com.sun.identity.session.util.RestrictedTokenContext;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;

public class SessionPoller
extends Thread {
    Map sessionTable;
    private SessionService sessionService = null;
    public static Debug debug;
    static long period;
    private static ThreadPool threadPool;
    private static final int DEFAULT_POOL_SIZE = 5;
    private static final int DEFAULT_THRESHOLD = 10000;
    private static boolean cacheBasedPolling;

    public SessionPoller(Map map) {
        this.sessionTable = map;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        while (true) {
            Enumeration enumeration = MapFactory.elements(this.sessionTable);
            long l = System.currentTimeMillis() + period;
            try {
                while (enumeration.hasMoreElements()) {
                    final Session session = (Session)enumeration.nextElement();
                    SessionID sessionID = session.getID();
                    try {
                        if (cacheBasedPolling && session.maxCachingTimeReached() && !session.getIsPolling()) {
                            RestrictedTokenContext.doUsing(session.getContext(), new RestrictedTokenAction(){

                                public Object run() throws Exception {
                                    SessionPoller.this.doPoll(session);
                                    return null;
                                }
                            });
                            continue;
                        }
                        if (!session.maxIdleTimeReached() || session.getIsPolling()) continue;
                        RestrictedTokenContext.doUsing(session.getContext(), new RestrictedTokenAction(){

                            public Object run() throws Exception {
                                SessionPoller.this.doPoll(session);
                                return null;
                            }
                        });
                    }
                    catch (SessionException sessionException) {
                        Session.removeSID(sessionID);
                        debug.message("session is not in timeout state so clean it", sessionException);
                    }
                }
            }
            catch (Exception exception) {
                debug.error("Exception encountered while polling", exception);
            }
            try {
                long l2 = l - System.currentTimeMillis();
                if (l2 <= 0L) continue;
                Thread.sleep(l2);
                continue;
            }
            catch (Exception exception) {
                if (!debug.warningEnabled()) continue;
                debug.warning("SessionPoller runtime exception", exception);
                continue;
            }
            break;
        }
    }

    private void doPoll(Session session) {
        try {
            session.setIsPolling(true);
            threadPool.run(new SessionPollerSender(session));
        }
        catch (ThreadPoolException threadPoolException) {
            session.setIsPolling(false);
            debug.error("Send Polling Error: ", threadPoolException);
        }
    }

    static {
        int n;
        int n2;
        block6: {
            debug = null;
            period = 180000L;
            threadPool = null;
            cacheBasedPolling = Boolean.valueOf(SystemProperties.get("com.iplanet.am.session.client.polling.cacheBased", "false"));
            debug = Debug.getInstance("amSession");
            String string = SystemProperties.get("com.iplanet.am.session.client.polling.period");
            try {
                period = Long.parseLong(string);
                period *= 1000L;
            }
            catch (Exception exception) {
                if (!debug.messageEnabled()) break block6;
                debug.message("Can not get the polling time");
            }
        }
        try {
            n2 = Integer.parseInt(SystemProperties.get("com.sun.identity.session.polling.threadpool.size"));
        }
        catch (Exception exception) {
            n2 = 5;
        }
        try {
            n = Integer.parseInt(SystemProperties.get("com.sun.identity.session.polling.threadpool.threshold"));
        }
        catch (Exception exception) {
            n = 10000;
        }
        threadPool = new ThreadPool("amSessionPoller", n2, n, true, debug);
    }

    class SessionPollerSender
    implements Runnable {
        SessionInfo info = null;
        Session session = null;
        SessionID sid = null;

        public SessionPollerSender(Session session) {
            this.session = session;
            this.sid = this.session.getID();
        }

        public void run() {
            block10: {
                block9: {
                    try {
                        SessionRequest sessionRequest = new SessionRequest(0, this.sid.toString(), false);
                        SessionResponse sessionResponse = Session.sendPLLRequest(this.session.getSessionServiceURL(), sessionRequest);
                        if (sessionResponse.getException() != null) {
                            Session.removeSID(this.sid);
                            return;
                        }
                        Vector vector = sessionResponse.getSessionInfoVector();
                        this.info = (SessionInfo)vector.elementAt(0);
                    }
                    catch (Exception exception) {
                        Session.removeSID(this.sid);
                        if (!debug.messageEnabled()) break block9;
                        debug.message("Could not connect to the session server" + exception.getMessage());
                    }
                }
                if (this.info != null) {
                    if (debug.messageEnabled()) {
                        debug.message("Updating" + this.info.toXMLString());
                    }
                    try {
                        if (this.info.state.equals("invalid") || this.info.state.equals("destroyed")) {
                            Session.removeSID(this.sid);
                            break block10;
                        }
                        this.session.update(this.info);
                    }
                    catch (SessionException sessionException) {
                        Session.removeSID(this.sid);
                        debug.error("Exception encountered while update in polling", sessionException);
                    }
                } else {
                    Session.removeSID(this.sid);
                }
            }
            this.session.setIsPolling(false);
        }
    }
}

