/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session;

import com.iplanet.am.util.Debug;
import com.iplanet.dpro.session.Session;
import com.iplanet.dpro.session.SessionEvent;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.dpro.session.share.SessionInfo;
import com.iplanet.dpro.session.share.SessionNotification;
import com.iplanet.services.comm.client.NotificationHandler;
import com.iplanet.services.comm.share.Notification;
import java.util.Map;
import java.util.Vector;

public class SessionNotificationHandler
implements NotificationHandler {
    private static final String sccsID = "@(#)SessionNotificationHandler.java   1.8  00/03/29 03/29/00  Sun Microsystems, Inc.";
    private Map sessionTable;
    public static SessionNotificationHandler handler = null;
    public static Debug sessionDebug = null;

    public SessionNotificationHandler(Map map) {
        this.sessionTable = map;
    }

    public void process(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            Notification notification = (Notification)vector.elementAt(n);
            SessionNotification sessionNotification = SessionNotification.parseXML(notification.getContent());
            if (sessionNotification != null) {
                this.processNotification(sessionNotification);
            }
            ++n;
        }
    }

    public void processNotification(SessionNotification sessionNotification) {
        SessionInfo sessionInfo = sessionNotification.getSessionInfo();
        sessionDebug.message("SESSION NOTIFICATION : " + sessionInfo.toXMLString());
        SessionID sessionID = new SessionID(sessionInfo.sid);
        Session session = (Session)this.sessionTable.get(sessionID);
        if (session != null && !sessionInfo.state.equals("valid")) {
            this.sessionTable.remove(sessionID);
        }
        try {
            if (session == null) {
                if (Session.getAllSessionEventListeners().size() == 0) {
                    return;
                }
                session = new Session(sessionID);
            }
            session.update(sessionInfo);
        }
        catch (Exception exception) {
            sessionDebug.error("SessionNotificationHandler:processNotification : ", exception);
            this.sessionTable.remove(sessionID);
            return;
        }
        SessionEvent sessionEvent = new SessionEvent(session, sessionNotification.getNotificationType(), sessionNotification.getNotificationTime());
        Session.invokeListeners(sessionEvent);
    }

    static {
        sessionDebug = Debug.getInstance("amSession");
    }
}

