/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.dpro.session.Session;
import com.iplanet.dpro.session.SessionID;
import com.sun.identity.common.MapFactory;
import java.util.Enumeration;
import java.util.Map;

public class SessionCacheCleaner
extends Thread {
    Map sessionTable;
    public static Debug debug;
    static long period;

    public SessionCacheCleaner(Map map) {
        this.sessionTable = map;
    }

    public void run() {
        while (true) {
            if (debug.messageEnabled()) {
                debug.message("Session Cache Cleaner started");
            }
            try {
                Enumeration enumeration = MapFactory.elements(this.sessionTable);
                long l = System.currentTimeMillis() + period;
                while (enumeration.hasMoreElements()) {
                    Session session = (Session)enumeration.nextElement();
                    SessionID sessionID = session.getID();
                    try {
                        if (!session.cleanupTimeReached()) continue;
                        Session.removeSID(sessionID);
                        if (!debug.messageEnabled()) continue;
                        debug.message("Session Destroyed, Caching time exceeded the Max Session Time");
                    }
                    catch (Exception exception) {
                        debug.error("Exception occured while cleaning up Session Cache", exception);
                    }
                }
                long l2 = l - System.currentTimeMillis();
                if (l2 <= 0L) continue;
                Thread.sleep(l2);
                continue;
            }
            catch (Exception exception) {
                if (!debug.messageEnabled()) continue;
                debug.message("Exception occured in the Session Cache Cleaner thread");
                continue;
            }
            break;
        }
    }

    static {
        block3: {
            debug = null;
            period = 3600000L;
            debug = Debug.getInstance("amSession");
            String string = SystemProperties.get("com.iplanet.am.session.client.cleanup.period");
            try {
                period = Long.parseLong(string);
                period = period * 1000L * 60L;
            }
            catch (Exception exception) {
                if (!debug.messageEnabled()) break block3;
                debug.message("Cannot get the cleanup timedefaulting to 60 minutes");
            }
        }
        if (debug.messageEnabled()) {
            debug.message("Session Cache cleanup interval in Minutes:" + period / 60000L);
        }
    }
}

