/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session;

import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.dpro.session.SessionCacheCleaner;
import com.iplanet.dpro.session.SessionEvent;
import com.iplanet.dpro.session.SessionException;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.dpro.session.SessionListener;
import com.iplanet.dpro.session.SessionNotificationHandler;
import com.iplanet.dpro.session.SessionPoller;
import com.iplanet.dpro.session.SessionTimedOutException;
import com.iplanet.dpro.session.TokenRestriction;
import com.iplanet.dpro.session.TokenRestrictionFactory;
import com.iplanet.dpro.session.service.SessionService;
import com.iplanet.dpro.session.share.SessionBundle;
import com.iplanet.dpro.session.share.SessionEncodeURL;
import com.iplanet.dpro.session.share.SessionInfo;
import com.iplanet.dpro.session.share.SessionRequest;
import com.iplanet.dpro.session.share.SessionResponse;
import com.iplanet.services.comm.client.PLLClient;
import com.iplanet.services.comm.share.Request;
import com.iplanet.services.comm.share.RequestSet;
import com.iplanet.services.comm.share.Response;
import com.iplanet.services.naming.WebtopNaming;
import com.sun.identity.common.MapFactory;
import com.sun.identity.session.util.RestrictedTokenAction;
import com.sun.identity.session.util.RestrictedTokenContext;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.servlet.http.HttpServletResponse;

public class Session {
    private SessionID sessionID;
    private int sessionType;
    private String clientID;
    private String clientDomain;
    private long maxSessionTime;
    private long maxIdleTime;
    private long maxCachingTime;
    private long sessionIdleTime;
    private long sessionTimeLeft;
    private long timedOutAt = 0L;
    private int sessionState = 0;
    private Map sessionProperties = null;
    private URL sessionServiceURL = null;
    private int eventType = -1;
    private long latestRefreshTime;
    private static final String httpSessionTrackingCookieName = SystemProperties.get("com.iplanet.am.session.failover.httpSessionTrackingCookieName", "JSESSIONID");
    boolean needToReset = false;
    private SessionService sessionService = null;
    private boolean sessionIsLocal = false;
    public static final int INVALID = 0;
    public static final int VALID = 1;
    public static final int INACTIVE = 2;
    public static final int DESTROYED = 3;
    public static final int USER_SESSION = 0;
    public static final int APPLICATION_SESSION = 1;
    public static final String SESSION_HANDLE_PROP = "SessionHandle";
    public static final String TOKEN_RESTRICTION_PROP = "TokenRestriction";
    public static final String SESSION_SERVICE = "session";
    private static String cookieName = SystemProperties.get("com.iplanet.am.cookie.name");
    private String cookieStr;
    Boolean cookieMode = null;
    private TokenRestriction restriction = null;
    private Object context = null;
    private static long purgeDelay;
    private static Debug sessionDebug;
    private static boolean pollingEnabled;
    private static boolean sessionCleanupEnabled;
    private static Thread sp;
    private static Thread sc;
    private static Map sessionTable;
    private static Map sessionServiceURLTable;
    private Vector sessionEventListeners = null;
    private static Vector allSessionEventListeners;
    private static int maxSessionTableSize;
    private boolean isPolling = false;
    private static String serverID;
    static /* synthetic */ Class class$com$iplanet$dpro$session$Session;

    protected void setIsPolling(boolean bl) {
        this.isPolling = bl;
    }

    protected boolean getIsPolling() {
        return this.isPolling;
    }

    Session(SessionID sessionID) {
        this.sessionID = sessionID;
        this.sessionProperties = MapFactory.getMap();
        this.sessionEventListeners = new Vector();
        if (Session.isServerMode()) {
            this.sessionService = SessionService.getSessionService();
        }
        this.latestRefreshTime = System.currentTimeMillis() / 1000L;
    }

    public static String getCookieName() {
        return cookieName;
    }

    public SessionID getID() {
        return this.sessionID;
    }

    public int getType() {
        return this.sessionType;
    }

    public String getClientID() {
        return this.clientID;
    }

    public String getClientDomain() {
        return this.clientDomain;
    }

    public long getMaxSessionTime() {
        return this.maxSessionTime;
    }

    public long getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public boolean isTimedOut() throws SessionException {
        if (this.timedOutAt > 0L) {
            return true;
        }
        if (this.maxCachingTimeReached()) {
            try {
                this.refresh(false);
            }
            catch (SessionTimedOutException sessionTimedOutException) {
                this.timedOutAt = this.latestRefreshTime = System.currentTimeMillis() / 1000L;
            }
        }
        return this.timedOutAt > 0L;
    }

    public long getTimeLeftBeforePurge() throws SessionException {
        if (!this.isTimedOut()) {
            return -1L;
        }
        long l = System.currentTimeMillis() / 1000L;
        long l2 = this.timedOutAt + purgeDelay * 60L - l;
        return l2 > 0L ? l2 : 0L;
    }

    public long getMaxCachingTime() {
        return this.maxCachingTime;
    }

    public long getIdleTime() throws SessionException {
        if (this.maxCachingTimeReached()) {
            this.refresh(false);
        }
        return this.sessionIdleTime;
    }

    public long getTimeLeft() throws SessionException {
        if (this.maxCachingTimeReached()) {
            this.refresh(false);
        }
        return this.sessionTimeLeft;
    }

    public int getState(boolean bl) throws SessionException {
        if (this.maxCachingTimeReached()) {
            this.refresh(bl);
        } else if (bl) {
            this.needToReset = true;
        }
        return this.sessionState;
    }

    private void setState(int n) {
        this.sessionState = n;
    }

    public int getEventType() {
        return this.eventType;
    }

    public String getProperty(String string) throws SessionException {
        if (this.maxCachingTimeReached()) {
            this.refresh(false);
        }
        return (String)this.sessionProperties.get(string);
    }

    public void setProperty(String string, String string2) throws SessionException {
        try {
            if (this.isLocal()) {
                this.sessionService.setProperty(this.sessionID, string, string2);
            } else {
                SessionRequest sessionRequest = new SessionRequest(6, this.sessionID.toString(), false);
                sessionRequest.setPropertyName(string);
                sessionRequest.setPropertyValue(string2);
                SessionResponse sessionResponse = this.getSessionResponse(this.getSessionServiceURL(), sessionRequest);
            }
            this.sessionProperties.put(string, string2);
        }
        catch (Exception exception) {
            throw new SessionException(exception);
        }
    }

    public URL getSessionServiceURL() throws SessionException {
        if (Session.isServerMode()) {
            return Session.getSessionServiceURL(this.sessionID);
        }
        if (this.sessionServiceURL == null) {
            this.sessionServiceURL = Session.getSessionServiceURL(this.sessionID);
        }
        return this.sessionServiceURL;
    }

    public void destroySession(Session session) throws SessionException {
        try {
            if (session.isLocal()) {
                this.sessionService.destroySession(this, session.getID());
            } else {
                SessionRequest sessionRequest = new SessionRequest(2, this.sessionID.toString(), false);
                sessionRequest.setDestroySessionID(session.getID().toString());
                session.getSessionResponse(session.getSessionServiceURL(), sessionRequest);
            }
        }
        catch (Exception exception) {
            Session.removeSID(session.getID());
            throw new SessionException(exception);
        }
        Session.removeSID(session.getID());
    }

    public void logout() throws SessionException {
        try {
            if (this.isLocal()) {
                this.sessionService.logout(this.sessionID);
            } else {
                SessionRequest sessionRequest = new SessionRequest(3, this.sessionID.toString(), false);
                this.getSessionResponse(this.getSessionServiceURL(), sessionRequest);
            }
        }
        catch (Exception exception) {
            Session.removeSID(this.sessionID);
            throw new SessionException(exception);
        }
        Session.removeSID(this.sessionID);
    }

    protected static void removeSID(SessionID sessionID) {
        Session session = null;
        session = (Session)sessionTable.remove(sessionID);
        if (session != null) {
            session.setState(3);
            long l = System.currentTimeMillis();
            SessionEvent sessionEvent = new SessionEvent(session, 5, l);
            Session.invokeListeners(sessionEvent);
        }
    }

    protected static void invokeListeners(SessionEvent sessionEvent) {
        Session session = sessionEvent.getSession();
        Vector vector = session.getSessionEventListeners();
        Vector vector2 = Session.getAllSessionEventListeners();
        int n = 0;
        while (n < vector.size()) {
            SessionListener sessionListener = (SessionListener)vector.elementAt(n);
            sessionListener.sessionChanged(sessionEvent);
            ++n;
        }
        int n2 = 0;
        while (n2 < vector2.size()) {
            SessionListener sessionListener = (SessionListener)vector2.elementAt(n2);
            sessionListener.sessionChanged(sessionEvent);
            ++n2;
        }
    }

    public void addSessionListener(SessionListener sessionListener) throws SessionException {
        if (this.sessionState != 1) {
            throw new SessionException(SessionBundle.rbName, "invalidSessionState", null);
        }
        this.sessionEventListeners.addElement(sessionListener);
    }

    public static Session getSession(SessionID sessionID) throws SessionException {
        if (sessionID.toString() == null || sessionID.toString().length() == 0) {
            throw new SessionException(SessionBundle.rbName, "invalidSessionID", null);
        }
        Session session = (Session)sessionTable.get(sessionID);
        if (session != null) {
            TokenRestriction tokenRestriction = session.getRestriction();
            try {
                if (tokenRestriction != null && !tokenRestriction.isSatisfied(RestrictedTokenContext.getCurrent())) {
                    throw new SessionException(SessionBundle.rbName, "restrictionViolation", null);
                }
            }
            catch (SessionException sessionException) {
                throw sessionException;
            }
            catch (Exception exception) {
                throw new SessionException(exception);
            }
            if (session.maxCachingTimeReached()) {
                session.refresh(false);
            }
            return session;
        }
        session = new Session(sessionID);
        session.refresh(true);
        session.context = RestrictedTokenContext.getCurrent();
        sessionTable.put(sessionID, session);
        if (!pollingEnabled) {
            session.addInternalSessionListener();
        }
        return session;
    }

    public static SessionResponse sendPLLRequest(URL uRL, SessionRequest sessionRequest) throws SessionException {
        try {
            String string = cookieName + "=" + sessionRequest.getSessionID();
            SessionID sessionID = new SessionID(sessionRequest.getSessionID());
            if (sessionID.getTail() != null) {
                string = string + ";" + httpSessionTrackingCookieName + "=" + sessionID.getTail();
            }
            Request request = new Request(sessionRequest.toXMLString());
            RequestSet requestSet = new RequestSet(SESSION_SERVICE);
            requestSet.addRequest(request);
            Vector vector = PLLClient.send(uRL, string, requestSet);
            if (vector.size() != 1) {
                throw new SessionException(SessionBundle.rbName, "unexpectedResponse", null);
            }
            Response response = (Response)vector.elementAt(0);
            return SessionResponse.parseXML(response.getContent());
        }
        catch (Exception exception) {
            throw new SessionException(exception);
        }
    }

    public AMSearchResults getValidSessions(String string, String string2) throws SessionException {
        String string3 = this.sessionID.getSessionServerProtocol();
        String string4 = string;
        String string5 = this.sessionID.getSessionServerPort();
        int n = string4.indexOf("://");
        if (n != -1) {
            string3 = string4.substring(0, n);
            string4 = string4.substring(n + 3);
        }
        if ((n = string4.indexOf(":")) != -1) {
            string5 = string4.substring(n + 1);
            string4 = string4.substring(0, n);
        }
        URL uRL = Session.getSessionServiceURL(string3, string4, string5);
        return this.getValidSessions(uRL, string2);
    }

    Vector getSessionEventListeners() {
        return this.sessionEventListeners;
    }

    static Vector getAllSessionEventListeners() {
        return allSessionEventListeners;
    }

    public static URL getSessionServiceURL(SessionID sessionID) throws SessionException {
        String string = null;
        if (Session.isServerMode()) {
            SessionService sessionService = SessionService.getSessionService();
            if (sessionService.isSiteEnabled() && sessionService.isLocalSite(sessionID)) {
                if (sessionService.isSessionFailoverEnabled()) {
                    return Session.getSessionServiceURL(sessionService.getCurrentHostServer(sessionID));
                }
                string = sessionID.getExtension("S1");
                return Session.getSessionServiceURL(string);
            }
        } else {
            String string2;
            string = sessionID.getExtension("S1");
            if (string != null && (string2 = WebtopNaming.getSecondarySites(string)) != null && serverID != null && string2.indexOf(serverID) != -1) {
                return Session.getSessionServiceURL(serverID);
            }
        }
        return Session.getSessionServiceURL(sessionID.getSessionServerProtocol(), sessionID.getSessionServer(), sessionID.getSessionServerPort());
    }

    public static URL getSessionServiceURL(String string, String string2, String string3) throws SessionException {
        String string4 = string + "://" + string2 + ":" + string3;
        URL uRL = (URL)sessionServiceURLTable.get(string4);
        if (uRL == null) {
            try {
                uRL = WebtopNaming.getServiceURL(SESSION_SERVICE, string, string2, string3);
                sessionServiceURLTable.put(string4, uRL);
                return uRL;
            }
            catch (Exception exception) {
                throw new SessionException(exception);
            }
        }
        return uRL;
    }

    public static URL getSessionServiceURL(String string) throws SessionException {
        try {
            URL uRL = new URL(WebtopNaming.getServerFromID(string));
            return Session.getSessionServiceURL(uRL.getProtocol(), uRL.getHost(), Integer.toString(uRL.getPort()));
        }
        catch (Exception exception) {
            throw new SessionException(exception);
        }
    }

    protected boolean maxCachingTimeReached() {
        long l = System.currentTimeMillis() / 1000L - this.latestRefreshTime;
        return l > this.maxCachingTime * 60L;
    }

    protected boolean maxIdleTimeReached() {
        long l = System.currentTimeMillis() / 1000L - this.latestRefreshTime;
        return l > this.maxIdleTime * 60L;
    }

    protected boolean cleanupTimeReached() {
        long l = System.currentTimeMillis() / 1000L - this.latestRefreshTime;
        return l > this.maxSessionTime * 60L;
    }

    private AMSearchResults getValidSessions(URL uRL, String string) throws SessionException {
        try {
            Object object;
            int[] nArray = new int[]{0};
            Vector vector = null;
            if (this.sessionService != null && this.sessionService.isLocalSessionService(uRL)) {
                vector = this.sessionService.getValidSessions(this, string, nArray);
            } else {
                object = new SessionRequest(1, this.sessionID.toString(), false);
                if (string != null) {
                    ((SessionRequest)object).setPattern(string);
                }
                SessionResponse sessionResponse = this.getSessionResponseWithoutRetry(uRL, (SessionRequest)object);
                vector = sessionResponse.getSessionInfoVector();
                nArray[0] = sessionResponse.getStatus();
            }
            object = new Hashtable();
            int n = vector.size();
            Session session = null;
            int n2 = 0;
            while (n2 < n) {
                SessionInfo sessionInfo = (SessionInfo)vector.elementAt(n2);
                SessionID sessionID = new SessionID(sessionInfo.sid);
                session = new Session(sessionID);
                session.sessionServiceURL = uRL;
                session.update(sessionInfo);
                ((Hashtable)object).put(sessionInfo.sid, session);
                ++n2;
            }
            return new AMSearchResults(((Hashtable)object).size(), ((Hashtable)object).keySet(), nArray[0], (Map)object);
        }
        catch (Exception exception) {
            sessionDebug.error("Session:getValidSession : ", exception);
            throw new SessionException(SessionBundle.rbName, "getValidSessionsError", null);
        }
    }

    public void addSessionListenerOnAllSessions(SessionListener sessionListener) throws SessionException {
        if (!pollingEnabled) {
            try {
                String string = WebtopNaming.getNotificationURL().toString();
                if (this.sessionService == null) {
                    throw new SessionException(SessionBundle.rbName, "unsupportedFunction", null);
                }
                this.sessionService.addSessionListenerOnAllSessions(this, string);
            }
            catch (Exception exception) {
                throw new SessionException(exception);
            }
        }
        allSessionEventListeners.addElement(sessionListener);
    }

    public void refresh(final boolean bl) throws SessionException {
        this.sessionIsLocal = this.checkSessionLocal();
        Object object = RestrictedTokenContext.getCurrent();
        if (object == null) {
            object = this.context;
        }
        try {
            RestrictedTokenContext.doUsing(object, new RestrictedTokenAction(){

                public Object run() throws Exception {
                    Session.this.doRefresh(bl);
                    return null;
                }
            });
        }
        catch (Exception exception) {
            Session.removeSID(this.sessionID);
            if (sessionDebug.messageEnabled()) {
                sessionDebug.message("session.Refresh Removed SID:" + this.sessionID);
            }
            throw new SessionException(exception);
        }
    }

    private void doRefresh(boolean bl) throws SessionException {
        SessionInfo sessionInfo = null;
        boolean bl2 = bl || this.needToReset;
        this.needToReset = false;
        if (this.isLocal()) {
            sessionInfo = this.sessionService.getSessionInfo(this.sessionID, bl2);
        } else {
            SessionRequest sessionRequest = new SessionRequest(0, this.sessionID.toString(), bl2);
            SessionResponse sessionResponse = this.getSessionResponse(this.getSessionServiceURL(), sessionRequest);
            if (sessionResponse.getException() != null) {
                throw new SessionException(SessionBundle.rbName, "invalidSessionState", null);
            }
            Vector vector = sessionResponse.getSessionInfoVector();
            if (vector.size() != 1) {
                throw new SessionException(SessionBundle.rbName, "unexpectedSession", null);
            }
            sessionInfo = (SessionInfo)vector.elementAt(0);
        }
        this.update(sessionInfo);
        this.latestRefreshTime = System.currentTimeMillis() / 1000L;
    }

    synchronized void update(SessionInfo sessionInfo) throws SessionException {
        String string;
        if (sessionInfo.stype.equals("user")) {
            this.sessionType = 0;
        } else if (sessionInfo.stype.equals("application")) {
            this.sessionType = 1;
        }
        this.clientID = sessionInfo.cid;
        this.clientDomain = sessionInfo.cdomain;
        this.maxSessionTime = Long.parseLong(sessionInfo.maxtime);
        this.maxIdleTime = Long.parseLong(sessionInfo.maxidle);
        this.maxCachingTime = Long.parseLong(sessionInfo.maxcaching);
        this.sessionIdleTime = Long.parseLong(sessionInfo.timeidle);
        this.sessionTimeLeft = Long.parseLong(sessionInfo.timeleft);
        if (sessionInfo.state.equals("invalid")) {
            this.sessionState = 0;
        } else if (sessionInfo.state.equals("valid")) {
            this.sessionState = 1;
        } else if (sessionInfo.state.equals("inactive")) {
            this.sessionState = 2;
        } else if (sessionInfo.state.equals("destroyed")) {
            this.sessionState = 3;
        }
        this.sessionProperties = sessionInfo.properties;
        if (this.timedOutAt <= 0L && (string = (String)this.sessionProperties.get("SessionTimedOut")) != null) {
            try {
                this.timedOutAt = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                sessionDebug.error("Invalid timeout value " + string, numberFormatException);
            }
        }
        this.latestRefreshTime = System.currentTimeMillis() / 1000L;
        string = (String)this.sessionProperties.get(TOKEN_RESTRICTION_PROP);
        if (string != null) {
            try {
                this.restriction = TokenRestrictionFactory.unmarshal(string);
            }
            catch (Exception exception) {
                throw new SessionException(exception);
            }
        }
    }

    private SessionResponse getSessionResponseWithoutRetry(URL uRL, SessionRequest sessionRequest) throws SessionException {
        try {
            SessionResponse sessionResponse;
            Object object = RestrictedTokenContext.getCurrent();
            if (object != null) {
                sessionRequest.setRequester(RestrictedTokenContext.marshal(object));
            }
            if ((sessionResponse = Session.sendPLLRequest(uRL, sessionRequest)).getException() != null) {
                String string;
                if (this.timedOutAt <= 0L && (string = sessionResponse.getException()).indexOf("SessionTimedOutException") != -1) {
                    this.timedOutAt = System.currentTimeMillis() / 1000L;
                }
                throw new SessionException(sessionResponse.getException());
            }
            return sessionResponse;
        }
        catch (Exception exception) {
            throw new SessionException(exception);
        }
    }

    private SessionResponse getSessionResponse(URL uRL, SessionRequest sessionRequest) throws SessionException {
        if (Session.isServerMode() && SessionService.getUseInternalRequestRouting()) {
            try {
                return this.getSessionResponseWithoutRetry(uRL, sessionRequest);
            }
            catch (SessionException sessionException) {
                URL uRL2;
                String string = this.sessionService.getCurrentHostServer(this.sessionID);
                if (!this.sessionService.checkServerUp(string) && !(uRL2 = this.getSessionServiceURL()).equals(uRL)) {
                    return this.getSessionResponseWithoutRetry(uRL2, sessionRequest);
                }
                throw sessionException;
            }
        }
        return this.getSessionResponseWithoutRetry(uRL, sessionRequest);
    }

    private void addInternalSessionListener() {
        try {
            if (SessionNotificationHandler.handler == null) {
                SessionNotificationHandler.handler = new SessionNotificationHandler(sessionTable);
                PLLClient.addNotificationHandler(SESSION_SERVICE, SessionNotificationHandler.handler);
            }
            String string = WebtopNaming.getNotificationURL().toString();
            if (this.isLocal()) {
                this.sessionService.addSessionListener(this.sessionID, string);
            } else {
                SessionRequest sessionRequest = new SessionRequest(4, this.sessionID.toString(), false);
                sessionRequest.setNotificationURL(string);
                SessionResponse sessionResponse = this.getSessionResponse(this.getSessionServiceURL(), sessionRequest);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String encodeURL(HttpServletResponse httpServletResponse, String string) {
        return this.encodeURL(httpServletResponse, string, cookieName);
    }

    public String encodeURL(HttpServletResponse httpServletResponse, String string, String string2) {
        String string3 = httpServletResponse.encodeURL(string);
        return this.encodeURL(string3, (short)0, true, string2);
    }

    public String encodeURL(String string, boolean bl) {
        return this.encodeURL(string, bl, cookieName);
    }

    public String encodeURL(String string, boolean bl, String string2) {
        return this.encodeURL(string, (short)0, bl);
    }

    public String encodeURL(String string) {
        return this.encodeURL(string, cookieName);
    }

    public String encodeURL(String string, String string2) {
        return this.encodeURL(string, (short)0, true, string2);
    }

    public String encodeURL(String string, short s, boolean bl) {
        return this.encodeURL(string, s, bl, cookieName);
    }

    public String encodeURL(String string, short s, boolean bl, String string2) {
        String string3 = string;
        if (string != null && string.length() > 0 && !this.getCookieSupport()) {
            if (this.cookieStr != null && this.cookieStr.length() > 0 && Session.foundCookieName(this.cookieStr, string2)) {
                string3 = SessionEncodeURL.buildCookieString(string, this.cookieStr, s, bl);
            } else if (this.sessionID != null) {
                this.cookieStr = SessionEncodeURL.createCookieString(string2, this.sessionID.toString());
                string3 = SessionEncodeURL.encodeURL(this.cookieStr, string, s, bl);
            }
        }
        return string3;
    }

    private String getClientType() {
        String string = null;
        try {
            string = this.getProperty("clientType");
        }
        catch (SessionException sessionException) {
            // empty catch block
        }
        return string;
    }

    private boolean getCookieSupport() {
        boolean bl = false;
        try {
            Boolean bl2 = this.sessionID.getCookieMode();
            if (bl2 != null) {
                bl = bl2;
            } else if (this.cookieMode != null) {
                bl = this.cookieMode;
            } else {
                String string = this.getProperty("cookieSupport");
                if (string != null) {
                    bl = string.equals("true");
                }
            }
        }
        catch (Exception exception) {
            sessionDebug.error("Error getting cookieSupport value: ", exception);
            bl = true;
        }
        if (sessionDebug.messageEnabled()) {
            sessionDebug.message("Session: getCookieSupport: " + bl);
        }
        return bl;
    }

    public void setCookieMode(Boolean bl) {
        if (sessionDebug.messageEnabled()) {
            sessionDebug.message("CookieMode is:" + bl);
        }
        if (bl != null) {
            this.cookieMode = bl;
        }
    }

    boolean isLocal() {
        return this.sessionIsLocal;
    }

    public static void markNonLocal(SessionID sessionID) {
        Session session = (Session)sessionTable.get(sessionID);
        if (session != null) {
            session.sessionIsLocal = false;
        }
    }

    private boolean checkSessionLocal() throws SessionException {
        if (Session.isServerMode()) {
            return this.sessionService.checkSessionLocal(this.sessionID);
        }
        return false;
    }

    private TokenRestriction getRestriction() throws SessionException {
        return this.restriction;
    }

    Object getContext() {
        return this.context;
    }

    static boolean isServerMode() {
        return WebtopNaming.isServerMode();
    }

    public static boolean foundCookieName(String string, String string2) {
        boolean bl = false;
        String string3 = null;
        if (sessionDebug.messageEnabled()) {
            sessionDebug.message("CookieNameStr is :" + string3);
            sessionDebug.message("cookieName is :" + string2);
        }
        if (string != null && string.length() != 0) {
            string3 = string.substring(0, string.indexOf("="));
        }
        if (string3 != null && string3.equals(string2)) {
            bl = true;
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        sessionDebug = Debug.getInstance("amSession");
        pollingEnabled = false;
        sessionCleanupEnabled = Boolean.valueOf(SystemProperties.get("com.iplanet.am.session.client.cleanup.enable", "true"));
        sessionTable = MapFactory.getMap();
        sessionServiceURLTable = MapFactory.getMap();
        allSessionEventListeners = new Vector();
        maxSessionTableSize = 1000;
        serverID = null;
        try {
            serverID = WebtopNaming.getAMServerID();
        }
        catch (Exception exception) {
            serverID = null;
        }
        if (!Session.isServerMode()) {
            pollingEnabled = Boolean.valueOf(SystemProperties.get("com.iplanet.am.session.client.polling.enable", "false"));
        }
        String string = SystemProperties.get("com.iplanet.am.session.purgedelay", "120");
        try {
            purgeDelay = Long.parseLong(string);
        }
        catch (Exception exception) {
            purgeDelay = 120L;
        }
        if (pollingEnabled) {
            Class clazz = class$com$iplanet$dpro$session$Session == null ? (class$com$iplanet$dpro$session$Session = Session.class$("com.iplanet.dpro.session.Session")) : class$com$iplanet$dpro$session$Session;
            synchronized (clazz) {
                if (sp == null) {
                    sp = new SessionPoller(sessionTable);
                    sp.setName("amSessionPollerMain");
                    sp.setDaemon(true);
                    sp.start();
                }
            }
        } else {
            sessionDebug.message("Session Cache cleanup is set to " + sessionCleanupEnabled);
            if (sessionCleanupEnabled) {
                sc = new SessionCacheCleaner(sessionTable);
                sc.setDaemon(true);
                sc.start();
            }
        }
    }
}

