/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMCacheManager;
import com.iplanet.am.sdk.AMDirectoryManager;
import com.iplanet.am.sdk.AMDirectoryWrapper;
import com.iplanet.am.sdk.AMObjectListener;
import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdEventListener;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.jaxrpc.SOAPClient;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import netscape.ldap.util.DN;

public final class IdRepoListener {
    private Map configMap = null;
    private static AMObjectListener remoteListener = null;
    private static Debug debug = Debug.getInstance("idrepoListener");
    protected static SOAPClient sclient = new SOAPClient("dummy");

    public void allObjectsChanged() {
        if (debug.messageEnabled()) {
            debug.message("IdRepoListener: allObjectsChanged Called!");
        }
        AMDirectoryManager aMDirectoryManager = AMDirectoryWrapper.getInstance();
        aMDirectoryManager.clearCache(AMCacheManager.idrepoCache);
        String string = (String)this.configMap.get("realm");
        ArrayList arrayList = (ArrayList)AMIdentityRepository.listeners.get(string);
        if (arrayList != null) {
            int n = arrayList.size();
            int n2 = 0;
            while (n2 < n) {
                IdEventListener idEventListener = (IdEventListener)arrayList.get(n2);
                idEventListener.allIdentitiesChanged();
                ++n2;
            }
        }
        if (remoteListener != null) {
            remoteListener.allObjectsChanged();
        }
    }

    public void objectChanged(String string, int n, Map map) {
        if (debug.messageEnabled()) {
            debug.message("objectChanged called = name:: " + string + "  type:: " + n + "\n  configmap = " + this.configMap);
        }
        String string2 = (String)this.configMap.get("realm");
        ArrayList arrayList = (ArrayList)AMIdentityRepository.listeners.get(string2);
        AMDirectoryManager aMDirectoryManager = AMDirectoryWrapper.getInstance();
        String[] stringArray = this.getChangedIds(string, map);
        int n2 = 0;
        while (n2 < stringArray.length) {
            aMDirectoryManager.dirtyCache(AMCacheManager.idrepoCache, stringArray[n2], 4, false, false, Collections.EMPTY_SET);
            if (arrayList != null) {
                int n3 = arrayList.size();
                int n4 = 0;
                while (n4 < n3) {
                    IdEventListener idEventListener = (IdEventListener)arrayList.get(n4);
                    switch (n) {
                        case 1: 
                        case 4: {
                            idEventListener.identityChanged(stringArray[n2]);
                            break;
                        }
                        case 2: {
                            idEventListener.identityDeleted(stringArray[n2]);
                            break;
                        }
                        case 8: {
                            idEventListener.identityRenamed(stringArray[n2]);
                        }
                    }
                    ++n4;
                }
            }
            if (remoteListener != null) {
                remoteListener.objectChanged(stringArray[n2], n, this.configMap);
            }
            ++n2;
        }
    }

    public Map getConfigMap() {
        return this.configMap;
    }

    public static void addRemoteListener(AMObjectListener aMObjectListener) {
        remoteListener = aMObjectListener;
    }

    public void setConfigMap(Map map) {
        this.configMap = map;
    }

    public void setServiceAttributes(String string, Map map) throws IdRepoException {
        String string2 = (String)this.configMap.get("realm");
        String string3 = (String)this.configMap.get("plugin-name");
        if (string2 == null || string3 == null) {
            AMIdentityRepository.debug.error("IdRepoListener.setServiveAttribute: realm or plugin name is null");
            Object[] objectArray = new Object[]{string, IdType.ROLE.getName()};
            throw new IdRepoException("amIdRepo", "105", objectArray);
        }
        try {
            SSOToken sSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            ServiceConfigManager serviceConfigManager = new ServiceConfigManager(sSOToken, "sunIdentityRepositoryService", "1.0");
            ServiceConfig serviceConfig = serviceConfigManager.getOrganizationConfig(string2, null);
            if (serviceConfig == null) {
                return;
            }
            ServiceConfig serviceConfig2 = serviceConfig.getSubConfig(string3);
            if (serviceConfig2 == null) {
                return;
            }
            Map map2 = serviceConfig2.getAttributes();
            HashSet<String> hashSet = (HashSet<String>)map2.get("sun-idrepo-ldapv3-config-service-attributes");
            if (hashSet == null || hashSet == Collections.EMPTY_SET) {
                hashSet = new HashSet<String>();
            }
            String string4 = sclient.encodeMap("result", map);
            hashSet = new HashSet();
            hashSet.add(string4);
            map2.put("sun-idrepo-ldapv3-config-service-attributes", hashSet);
            serviceConfig2.setAttributes(map2);
        }
        catch (SMSException sMSException) {
            AMIdentityRepository.debug.error("IdRepoListener: Unable to set service attributes", sMSException);
            Object[] objectArray = new Object[]{string, IdType.ROLE.getName()};
            throw new IdRepoException("amIdRepo", "105", objectArray);
        }
        catch (SSOException sSOException) {
            AMIdentityRepository.debug.error("IdRepoListener: Unable to set service attributes", sSOException);
            Object[] objectArray = new Object[]{string, IdType.ROLE.getName()};
            throw new IdRepoException("amIdRepo", "105", objectArray);
        }
    }

    private String[] getChangedIds(String string, Map map) {
        int n = IdUtils.supportedTypes.size();
        if (map == null) {
            String[] stringArray = new String[]{string};
            return stringArray;
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        if (map == null || map.isEmpty()) {
            stringArray[n2] = string;
            return stringArray;
        }
        String string2 = (String)map.get("realm");
        String string3 = (String)map.get("amsdk");
        boolean bl = string3 != null;
        Iterator iterator = IdUtils.supportedTypes.iterator();
        while (iterator.hasNext()) {
            IdType idType = (IdType)iterator.next();
            String string4 = DN.isDN(string) ? new DN(string).explodeDN(true)[0] : string;
            String string5 = "id=" + string4 + ",ou=" + idType.getName() + "," + string2;
            if (bl) {
                string5 = string5 + ",amsdkdn=" + string;
            }
            stringArray[n2] = string5;
            ++n2;
        }
        return stringArray;
    }
}

