/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMAssignableDynamicGroup;
import com.iplanet.am.sdk.AMCommonUtils;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMNamingAttrManager;
import com.iplanet.am.sdk.AMObjectImpl;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.sdk.AMServiceUtils;
import com.iplanet.am.sdk.AMStaticGroup;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import netscape.ldap.util.DN;
import netscape.ldap.util.RDN;

class AMUserImpl
extends AMObjectImpl
implements AMUser {
    static String roleDNsAN = "nsroledn";
    static String statusAN = "inetUserStatus";
    static String nsroleAN = "nsrole";
    static RDN ContainerDefaultTemplateRoleRDN = new RDN(AMNamingAttrManager.getNamingAttr(8) + "=" + "ContainerDefaultTemplateRole");
    private static AMStoreConnection amsc = null;

    public AMUserImpl(SSOToken sSOToken, String string) {
        super(sSOToken, string, 1);
    }

    public String rename(String string, boolean bl) throws AMException, SSOException {
        this.entryDN = this.dsManager.renameEntry(this.token, this.profileType, this.entryDN, string, bl);
        return this.entryDN;
    }

    public Set getFilteredRoleDNs() throws AMException, SSOException {
        HashSet<String> hashSet = new HashSet<String>(1);
        hashSet.add(nsroleAN);
        Map map = this.getAttributesFromDataStore(hashSet);
        Set set = (Set)map.get(nsroleAN);
        Set set2 = this.getRoleDNs();
        Iterator iterator = set2.iterator();
        HashSet<String> hashSet2 = new HashSet<String>();
        while (iterator.hasNext()) {
            hashSet2.add(new DN((String)iterator.next()).toRFCString().toLowerCase());
        }
        HashSet<String> hashSet3 = new HashSet<String>();
        if (set == null) {
            return hashSet3;
        }
        iterator = set.iterator();
        AMUserImpl.getAMStoreConnection();
        while (iterator.hasNext()) {
            DN dN;
            RDN rDN;
            String string = (String)iterator.next();
            if (hashSet2.contains(new DN(string).toRFCString().toLowerCase()) || (rDN = (RDN)(dN = new DN(string)).getRDNs().firstElement()).equals(ContainerDefaultTemplateRoleRDN) || !this.isAMManagedRole(string)) continue;
            hashSet3.add(dN.toString());
        }
        return hashSet3;
    }

    public Set getRoleDNs() throws AMException, SSOException {
        HashSet<String> hashSet = new HashSet<String>(5);
        hashSet.add(roleDNsAN);
        Map map = this.getAttributes(hashSet);
        Set set = (Set)map.get(roleDNsAN);
        return set == null ? Collections.EMPTY_SET : set;
    }

    private static void getAMStoreConnection() throws SSOException {
        if (amsc == null) {
            SSOToken sSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            amsc = new AMStoreConnection(sSOToken);
        }
    }

    private boolean isAMManagedRole(String string) throws SSOException {
        try {
            int n = amsc.getAMObjectType(string);
            return n == 6 || n == 8;
        }
        catch (AMException aMException) {
            AMObjectImpl.debug.message(string + " is not an AM managed role");
            return false;
        }
    }

    public Set getAllRoleDNs() throws AMException, SSOException {
        HashSet<String> hashSet = new HashSet<String>(1);
        hashSet.add(nsroleAN);
        Map map = this.getAttributesFromDataStore(hashSet);
        Set set = (Set)map.get(nsroleAN);
        HashSet<String> hashSet2 = new HashSet<String>();
        Iterator iterator = set.iterator();
        AMUserImpl.getAMStoreConnection();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            DN dN = new DN(string);
            RDN rDN = (RDN)dN.getRDNs().firstElement();
            if (rDN.equals(ContainerDefaultTemplateRoleRDN) || !this.isAMManagedRole(string)) continue;
            hashSet2.add(string);
        }
        return hashSet2;
    }

    public void assignRole(AMRole aMRole) throws AMException, SSOException {
        this.assignRole(aMRole.getDN());
    }

    public void assignRole(String string) throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(this.entryDN);
        this.dsManager.modifyMemberShip(this.token, hashSet, string, 6, 1);
    }

    public void removeRole(AMRole aMRole) throws AMException, SSOException {
        this.removeRole(aMRole.getDN());
    }

    public void removeRole(String string) throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(this.entryDN);
        this.dsManager.modifyMemberShip(this.token, hashSet, string, 6, 2);
    }

    public Set getStaticGroupDNs() throws AMException, SSOException {
        return this.getAttribute("iplanet-am-static-group-dn");
    }

    public void assignStaticGroup(AMStaticGroup aMStaticGroup) throws AMException, SSOException {
        this.assignStaticGroup(aMStaticGroup.getDN());
    }

    public void assignStaticGroup(String string) throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(this.entryDN);
        this.dsManager.modifyMemberShip(this.token, hashSet, string, 9, 1);
    }

    public void removeStaticGroup(AMStaticGroup aMStaticGroup) throws AMException, SSOException {
        this.removeStaticGroup(aMStaticGroup.getDN());
    }

    public void removeStaticGroup(String string) throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(this.entryDN);
        this.dsManager.modifyMemberShip(this.token, hashSet, string, 9, 2);
    }

    public Set getAssignableDynamicGroupDNs() throws AMException, SSOException {
        return this.getAttribute("memberof");
    }

    public void assignAssignableDynamicGroup(AMAssignableDynamicGroup aMAssignableDynamicGroup) throws AMException, SSOException {
        this.assignAssignableDynamicGroup(aMAssignableDynamicGroup.getDN());
    }

    public void assignAssignableDynamicGroup(String string) throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(this.entryDN);
        this.dsManager.modifyMemberShip(this.token, hashSet, string, 12, 1);
    }

    public void removeAssignableDynamicGroup(AMAssignableDynamicGroup aMAssignableDynamicGroup) throws AMException, SSOException {
        this.removeAssignableDynamicGroup(aMAssignableDynamicGroup.getDN());
    }

    public void removeAssignableDynamicGroup(String string) throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(this.entryDN);
        this.dsManager.modifyMemberShip(this.token, hashSet, string, 12, 2);
    }

    public void activate() throws AMException, SSOException {
        this.setStringAttribute(statusAN, "active");
        this.store();
    }

    public void deactivate() throws AMException, SSOException {
        this.setStringAttribute(statusAN, "inactive");
        this.store();
    }

    public boolean isActivated() throws AMException, SSOException {
        return this.getStringAttribute(statusAN).equalsIgnoreCase("active");
    }

    public void assignServices(Set set) throws AMException, SSOException {
        Object object;
        Object object2;
        if (set == null || set.isEmpty()) {
            return;
        }
        Set set2 = this.getAssignedServices();
        Set set3 = new HashSet();
        HashSet<Object> hashSet = new HashSet<Object>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            if (set2.contains(object2)) {
                AMObjectImpl.debug.error(AMSDKBundle.getString("125"));
                throw new AMException(AMSDKBundle.getString("125"), "125");
            }
            hashSet.add(object2);
            object = AMServiceUtils.getServiceObjectClasses(this.token, hashSet);
            set3.addAll(object);
        }
        object2 = this.getAttribute("objectclass");
        set3 = AMCommonUtils.combineOCs(set3, (Set)object2);
        this.setAttribute("objectclass", set3);
        this.store();
        object = hashSet.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            try {
                ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(string, this.token);
                ServiceSchema serviceSchema = null;
                Object[] objectArray = new Object[]{string};
                serviceSchema = serviceSchemaManager.getSchema(SchemaType.USER);
                if (serviceSchema == null) {
                    serviceSchema = serviceSchemaManager.getSchema(SchemaType.DYNAMIC);
                }
                if (serviceSchema != null) continue;
                AMObjectImpl.debug.error(AMSDKBundle.getString("1001"));
                throw new AMException(AMSDKBundle.getString("1001", objectArray), "1001", objectArray);
            }
            catch (SMSException sMSException) {
                AMObjectImpl.debug.error("AMUserImpl: schema type validation failed-> " + string, sMSException);
            }
        }
    }
}

