/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMCacheManager;
import com.iplanet.am.sdk.AMCompliance;
import com.iplanet.am.sdk.AMDCTree;
import com.iplanet.am.sdk.AMDirectoryManager;
import com.iplanet.am.sdk.AMDirectoryWrapper;
import com.iplanet.am.sdk.AMEvent;
import com.iplanet.am.sdk.AMEventManager;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMObjectImpl;
import com.iplanet.am.sdk.AMObjectListener;
import com.iplanet.am.sdk.AMSDKRepo;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.IdRepoListener;
import com.iplanet.am.util.Debug;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import netscape.ldap.util.DN;

public class AMIdRepoListener
implements AMObjectListener {
    private AMDirectoryManager dsManager;
    private Debug debug = AMEventManager.debug;

    AMIdRepoListener() {
        this.dsManager = AMDirectoryWrapper.getInstance();
    }

    public void objectChanged(String string, int n, Map map) {
        String string2;
        block6: {
            if (this.debug.messageEnabled()) {
                this.debug.message("AMIdRepoListener.objectChanged(): name: " + string + " type: " + n);
            }
            string2 = new DN(string).toRFCString().toLowerCase();
            this.dsManager.dirtyCache(AMCacheManager.sdkCache, string2, n, false, false, Collections.EMPTY_SET);
            AMStoreConnection.updateCache(string2, n);
            try {
                if (AMCompliance.isComplianceUserDeletionEnabled()) {
                    AMCompliance.cleanDeletedOrgCache(string2);
                }
                if (AMDCTree.isRequired()) {
                    AMDCTree.cleanDomainMap(string2);
                }
            }
            catch (AMException aMException) {
                if (!this.debug.warningEnabled()) break block6;
                this.debug.warning("AMIdRepoListener.objectChanged() AMException occured: ", aMException);
            }
        }
        AMObjectImpl.notifyEntryEvent(string2, n, false);
        Iterator iterator = AMSDKRepo.listeners.iterator();
        while (iterator.hasNext()) {
            IdRepoListener idRepoListener = (IdRepoListener)iterator.next();
            Map map2 = idRepoListener.getConfigMap();
            idRepoListener.objectChanged(string2, n, map2);
        }
    }

    public void objectsChanged(String string, int n, Set set, Map map) {
        block6: {
            String string2;
            block5: {
                if (this.debug.messageEnabled()) {
                    this.debug.message("AMIdRepoListener.objectsChanged(): parentName: " + string + " type: " + n + "\n config map= " + map);
                }
                string2 = new DN(string).toRFCString().toLowerCase();
                this.dsManager.dirtyCache(AMCacheManager.sdkCache, string2, n, true, false, set);
                AMStoreConnection.updateCache(string2, n);
                try {
                    if (AMCompliance.isComplianceUserDeletionEnabled()) {
                        AMCompliance.cleanDeletedOrgCache(string2);
                    }
                    if (AMDCTree.isRequired()) {
                        AMDCTree.cleanDomainMap(string2);
                    }
                }
                catch (AMException aMException) {
                    if (!this.debug.warningEnabled()) break block5;
                    this.debug.warning("AMIdRepoListener.objectsChanged() AMException occured: ", aMException);
                }
            }
            AMObjectImpl.notifyEntryEvent(string2, n, true);
            Iterator iterator = AMSDKRepo.listeners.iterator();
            if (!iterator.hasNext()) break block6;
            IdRepoListener idRepoListener = (IdRepoListener)iterator.next();
            Map map2 = idRepoListener.getConfigMap();
            idRepoListener.allObjectsChanged();
        }
    }

    public void permissionsChanged(String string, Map map) {
        block1: {
            if (this.debug.messageEnabled()) {
                this.debug.message("AMIdRepoListener.permissionsChanged(): orgName: " + string);
            }
            String string2 = new DN(string).toRFCString().toLowerCase();
            this.dsManager.dirtyCache(AMCacheManager.sdkCache, string2, 4, false, true, Collections.EMPTY_SET);
            AMStoreConnection.updateCache(string2, 4);
            AMObjectImpl.notifyACIChangeEvent(string2, 4);
            Iterator iterator = AMSDKRepo.listeners.iterator();
            if (!iterator.hasNext()) break block1;
            IdRepoListener idRepoListener = (IdRepoListener)iterator.next();
            Map map2 = idRepoListener.getConfigMap();
            idRepoListener.allObjectsChanged();
        }
    }

    public void allObjectsChanged() {
        block0: {
            this.debug.error("AMIdRepoListener: Received all objects changed event from event service");
            AMDirectoryManager aMDirectoryManager = AMCacheManager.getInstance();
            aMDirectoryManager.clearCache(AMCacheManager.sdkCache);
            AMEvent aMEvent = new AMEvent(AMStoreConnection.rootSuffix);
            AMObjectImpl.notifyAffectedDNs(AMStoreConnection.rootSuffix, aMEvent);
            Iterator iterator = AMSDKRepo.listeners.iterator();
            if (!iterator.hasNext()) break block0;
            IdRepoListener idRepoListener = (IdRepoListener)iterator.next();
            idRepoListener.allObjectsChanged();
        }
    }

    public Map getConfigMap() {
        return null;
    }

    public void setConfigMap(Map map) {
    }
}

