/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMCacheManager;
import com.iplanet.am.sdk.AMCommonUtils;
import com.iplanet.am.sdk.AMDirectoryManager;
import com.iplanet.am.sdk.AMEventManager;
import com.iplanet.am.sdk.AMEventManagerException;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;

public class AMDirectoryWrapper {
    private static AMDirectoryManager instance = null;
    private static final String CACHE_ENABLED_DISABLED_KEY = "com.iplanet.am.sdk.caching.enabled";
    private static Debug debug = AMCommonUtils.debug;
    private static boolean cachingEnabled;

    private static void initializeEventManager() {
        try {
            AMEventManager aMEventManager = new AMEventManager(instance);
            aMEventManager.start();
        }
        catch (AMEventManagerException aMEventManagerException) {
            debug.error("AMDirectoryWrapper.initializeEventManager(): Unable to start event manager: ", aMEventManagerException);
        }
    }

    public static AMDirectoryManager getInstance() {
        return instance;
    }

    protected static boolean isCachingEnabled() {
        return cachingEnabled;
    }

    static {
        String string = System.getProperty(CACHE_ENABLED_DISABLED_KEY);
        if (string == null || string.length() == 0) {
            string = SystemProperties.get(CACHE_ENABLED_DISABLED_KEY, "true");
        }
        if (string.equalsIgnoreCase("true")) {
            cachingEnabled = true;
            instance = AMCacheManager.getInstance();
            AMDirectoryWrapper.initializeEventManager();
        } else {
            cachingEnabled = false;
            instance = AMDirectoryManager.getInstance();
        }
        if (debug.messageEnabled()) {
            debug.message("AMDirectoryWrapper.static{} - Caching Mode: " + cachingEnabled);
        }
    }
}

