/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMCommonUtils;
import com.iplanet.am.sdk.AMConstants;
import com.iplanet.am.sdk.AMEntryExistsException;
import com.iplanet.am.sdk.AMEventManagerException;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMHashMap;
import com.iplanet.am.sdk.AMObjectListener;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.sdk.AMSearchFilterManager;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.am.sdk.AMUserEntryProcessed;
import com.iplanet.am.sdk.ComplianceInterface;
import com.iplanet.am.sdk.DCTreeInterface;
import com.iplanet.am.sdk.DirectoryManagerInterface;
import com.iplanet.am.sdk.IdRepoListener;
import com.iplanet.am.util.Cache;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.OrderedSet;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.naming.WebtopNaming;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.ums.SearchControl;
import com.sun.identity.common.CaseInsensitiveHashMap;
import com.sun.identity.common.CaseInsensitiveHashSet;
import com.sun.identity.delegation.DelegationEvaluator;
import com.sun.identity.delegation.DelegationException;
import com.sun.identity.delegation.DelegationPermission;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdOperation;
import com.sun.identity.idm.IdRepo;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdRepoFatalException;
import com.sun.identity.idm.IdRepoServiceListener;
import com.sun.identity.idm.IdRepoUnsupportedOpException;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchOpModifier;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.idm.RepoSearchResults;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.security.ProviderException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import netscape.ldap.util.DN;

public class AMDirectoryManager
implements AMConstants {
    protected static Debug debug = AMCommonUtils.debug;
    protected static Debug idd = Debug.getInstance("amIdm");
    protected static boolean isUserPluginInitialized = false;
    private static AMUserEntryProcessed userEntry = null;
    private static final String SDK_PACKAGE_NAME_PROPERTY = "com.iplanet.am.sdk.package";
    private static final String DEFAULT_SDK_PACKAGE = "com.iplanet.am.sdk.ldap";
    private static final String SDK_REMOTE_PACKAGE = "com.iplanet.am.sdk.remote";
    private static final String directoryMgrClass = "DirectoryManager";
    private static final String dcTreeClass = "DCTree";
    private static final String complianceClass = "Compliance";
    private static final String DELEGATION_ATTRS_NAME = "attributes";
    protected String sdkPackageName;
    protected DirectoryManagerInterface dMgr;
    protected DCTreeInterface dcTree;
    protected ComplianceInterface compliance;
    protected static Map idRepoMap = new HashMap();
    protected static Map namingAttrMap = new HashMap();
    private static AMDirectoryManager instance = null;
    private static boolean remote = false;
    private static HashSet readAction = new HashSet(2);
    private static HashSet writeAction = new HashSet(2);
    protected static ServiceSchemaManager idRepoServiceSchemaManager;
    protected static ServiceSchema idRepoSubSchema;
    protected static Set idRepoPlugins;

    protected AMDirectoryManager() {
        Class<?> clazz;
        Class<?> clazz2;
        Object object;
        block22: {
            readAction.add("READ");
            writeAction.add("MODIFY");
            try {
                this.sdkPackageName = SystemProperties.get(SDK_PACKAGE_NAME_PROPERTY, DEFAULT_SDK_PACKAGE);
                object = Class.forName(this.sdkPackageName + "." + directoryMgrClass);
                clazz2 = Class.forName(this.sdkPackageName + "." + dcTreeClass);
                clazz = Class.forName(this.sdkPackageName + "." + complianceClass);
                this.dMgr = (DirectoryManagerInterface)((Class)object).newInstance();
                this.dcTree = (DCTreeInterface)clazz2.newInstance();
                this.compliance = (ComplianceInterface)clazz.newInstance();
                if (this.sdkPackageName.equals(SDK_REMOTE_PACKAGE)) {
                    remote = true;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (WebtopNaming.isServerMode()) {
                    debug.error("SDK Package classes not found: " + this.sdkPackageName, classNotFoundException);
                } else if (debug.messageEnabled()) {
                    debug.message("Default SDK Package not found: " + this.sdkPackageName);
                }
            }
            catch (Exception exception) {
                if (WebtopNaming.isServerMode()) {
                    debug.error("AMDirectoryManager: exception in instantiation of directory access classes", exception);
                }
                if (!debug.messageEnabled()) break block22;
                debug.message("AMDirectoryManager: exception in instantiation of directory access classes", exception);
            }
        }
        if (this.dMgr == null || this.dcTree == null || this.compliance == null) {
            if (debug.warningEnabled()) {
                debug.warning("AMDirectoryManager: Configured/Default AMSDK DirectoryManager failed, trying JAXPRC or LDAP");
            }
            try {
                if (this.sdkPackageName.equals(DEFAULT_SDK_PACKAGE)) {
                    object = Class.forName("com.iplanet.am.sdk.remote.DirectoryManager");
                    clazz2 = Class.forName("com.iplanet.am.sdk.remote.DCTree");
                    clazz = Class.forName("com.iplanet.am.sdk.remote.Compliance");
                    this.dMgr = (DirectoryManagerInterface)((Class)object).newInstance();
                    this.dcTree = (DCTreeInterface)clazz2.newInstance();
                    this.compliance = (ComplianceInterface)clazz.newInstance();
                    remote = true;
                    if (debug.warningEnabled()) {
                        debug.warning("AMDirectoryManager: Using default JAX RPC implementation");
                    }
                } else {
                    object = Class.forName("com.iplanet.am.sdk.ldap.DirectoryManager");
                    clazz2 = Class.forName("com.iplanet.am.sdk.ldap.DCTree");
                    clazz = Class.forName("com.iplanet.am.sdk.ldap.Compliance");
                    this.dMgr = (DirectoryManagerInterface)((Class)object).newInstance();
                    this.dcTree = (DCTreeInterface)clazz2.newInstance();
                    this.compliance = (ComplianceInterface)clazz.newInstance();
                    remote = false;
                    if (debug.warningEnabled()) {
                        debug.warning("AMDirectoryManager: Using default LDAP implementation");
                    }
                }
            }
            catch (Exception exception) {
                debug.error("Unable to initialize the data access layer", exception);
                throw new ProviderException(AMSDKBundle.getString("300"));
            }
        }
        if (!remote) {
            if (debug.messageEnabled()) {
                debug.message("AMDirectoryManager:  In server mode..setting up ServiceListener");
            }
            object = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            try {
                clazz2 = new IdRepoServiceListener();
                clazz = new ServiceConfigManager((SSOToken)object, "sunIdentityRepositoryService", "1.0");
                ((ServiceConfigManager)((Object)clazz)).addListener((ServiceListener)((Object)clazz2));
                idRepoServiceSchemaManager = new ServiceSchemaManager((SSOToken)object, "sunIdentityRepositoryService", "1.0");
                idRepoSubSchema = idRepoServiceSchemaManager.getOrganizationSchema();
                idRepoPlugins = idRepoSubSchema.getSubSchemaNames();
                idRepoServiceSchemaManager.addListener((ServiceListener)((Object)clazz2));
            }
            catch (SMSException sMSException) {
                if (debug.warningEnabled()) {
                    debug.warning("AMDirectoryManager: Unable to set up a service listener for IdRepo", sMSException);
                }
            }
            catch (SSOException sSOException) {
                debug.error("AMDirectoryManager: Unable to set up a service listener for IdRepo", sSOException);
            }
        }
    }

    protected static synchronized AMDirectoryManager getInstance() {
        if (instance == null) {
            debug.message("AMDirectoryManager.getInstance(): Creating a new Instance of AMDirectoryManager()");
            instance = new AMDirectoryManager();
        }
        return instance;
    }

    protected String getEntryNotFoundMsgID(int n) {
        switch (n) {
            case 6: 
            case 7: 
            case 8: {
                return "465";
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return "466";
            }
            case 2: {
                return "467";
            }
            case 1: {
                return "468";
            }
            case 3: {
                return "469";
            }
            case 5: {
                return "470";
            }
            case 4: {
                return "471";
            }
        }
        return "461";
    }

    private String getEntryExistsMsgID(int n) {
        switch (n) {
            case 6: 
            case 7: 
            case 8: {
                return "472";
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return "473";
            }
            case 2: {
                return "474";
            }
            case 1: {
                return "475";
            }
            case 3: {
                return "476";
            }
            case 5: {
                return "477";
            }
            case 4: {
                return "483";
            }
        }
        return "462";
    }

    protected void dirtyCache(Cache cache, String string, int n, boolean bl, boolean bl2, Set set) {
    }

    public synchronized void clearCache(Cache cache) {
    }

    public void addListener(SSOToken sSOToken, AMObjectListener aMObjectListener) throws AMEventManagerException {
        if (this.dMgr != null) {
            this.dMgr.addListener(sSOToken, aMObjectListener, null);
            if (debug.messageEnabled()) {
                debug.message("AMDirectoryManager:addListner: Added Listeners");
            }
        } else if (debug.warningEnabled()) {
            debug.warning("AMDirectoryManager:addListner: Unable to add listener -- no DirectoryManagerInterface plugin configured");
        }
    }

    public boolean doesEntryExists(SSOToken sSOToken, String string) {
        return this.dMgr.doesEntryExists(sSOToken, string);
    }

    public int getObjectType(SSOToken sSOToken, String string) throws AMException, SSOException {
        return this.dMgr.getObjectType(sSOToken, string);
    }

    public int getObjectType(SSOToken sSOToken, String string, Map map) throws AMException, SSOException {
        return this.dMgr.getObjectType(sSOToken, string, map);
    }

    public Map getDCTreeAttributes(SSOToken sSOToken, String string, Set set, boolean bl, int n) throws AMException, SSOException {
        return this.dMgr.getDCTreeAttributes(sSOToken, string, set, bl, n);
    }

    public Map getAttributes(SSOToken sSOToken, String string, int n) throws AMException, SSOException {
        if (!remote && this.checkRealmPermission(sSOToken, string, readAction)) {
            sSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        }
        return this.dMgr.getAttributes(sSOToken, string, n);
    }

    public Map getAttributes(SSOToken sSOToken, String string, Set set, int n) throws AMException, SSOException {
        if (!remote && this.checkRealmPermission(sSOToken, string, readAction)) {
            sSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        }
        return this.dMgr.getAttributes(sSOToken, string, set, n);
    }

    public Map getAttributesByteValues(SSOToken sSOToken, String string, int n) throws AMException, SSOException {
        return this.dMgr.getAttributesByteValues(sSOToken, string, n);
    }

    public Map getAttributesByteValues(SSOToken sSOToken, String string, Set set, int n) throws AMException, SSOException {
        return this.dMgr.getAttributesByteValues(sSOToken, string, set, n);
    }

    public Map getAttributes(SSOToken sSOToken, String string, boolean bl, boolean bl2, int n) throws AMException, SSOException {
        if (!remote && this.checkRealmPermission(sSOToken, string, readAction)) {
            sSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        }
        return this.dMgr.getAttributes(sSOToken, string, bl, bl2, n);
    }

    public Map getAttributes(SSOToken sSOToken, String string, Set set, boolean bl, boolean bl2, int n) throws AMException, SSOException {
        if (!remote && this.checkRealmPermission(sSOToken, string, readAction)) {
            sSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        }
        return this.dMgr.getAttributes(sSOToken, string, set, bl, bl2, n);
    }

    public String getOrgSearchFilter(String string) {
        String string2 = AMSearchFilterManager.getSearchFilter(2, string, null, true);
        String string3 = AMSearchFilterManager.getSearchFilter(3, string, null, true);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(|").append(string2).append(string3);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String getOrganizationDN(SSOToken sSOToken, String string) throws AMException {
        return this.dMgr.getOrganizationDN(sSOToken, string);
    }

    public String verifyAndGetOrgDN(SSOToken sSOToken, String string, String string2) throws AMException {
        return this.dMgr.verifyAndGetOrgDN(sSOToken, string, string2);
    }

    public Map getExternalAttributes(SSOToken sSOToken, String string, Set set, int n) throws AMException {
        return this.dMgr.getExternalAttributes(sSOToken, string, set, n);
    }

    public void updateUserAttribute(SSOToken sSOToken, Set set, String string, boolean bl) throws AMException {
        this.dMgr.updateUserAttribute(sSOToken, set, string, bl);
    }

    public void createEntry(SSOToken sSOToken, String string, int n, String string2, Map map) throws AMEntryExistsException, AMException {
        try {
            this.dMgr.createEntry(sSOToken, string, n, string2, map);
        }
        catch (AMException aMException) {
            if (!remote && aMException.getErrorCode().equals("460") && this.checkRealmPermission(sSOToken, string2, writeAction)) {
                SSOToken sSOToken2 = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
                this.dMgr.createEntry(sSOToken2, string, n, string2, map);
            }
            throw aMException;
        }
    }

    public void removeEntry(SSOToken sSOToken, String string, int n, boolean bl, boolean bl2) throws AMException, SSOException {
        try {
            this.dMgr.removeEntry(sSOToken, string, n, bl, bl2);
        }
        catch (AMException aMException) {
            if (!remote && aMException.getErrorCode().equals("460") && this.checkRealmPermission(sSOToken, string, writeAction)) {
                SSOToken sSOToken2 = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
                this.dMgr.removeEntry(sSOToken2, string, n, bl, bl2);
            }
            throw aMException;
        }
    }

    public void removeAdminRole(SSOToken sSOToken, String string, boolean bl) throws SSOException, AMException {
        this.dMgr.removeAdminRole(sSOToken, string, bl);
    }

    public Set search(SSOToken sSOToken, String string, String string2, int n) throws AMException {
        if (!remote && this.checkRealmPermission(sSOToken, string, readAction)) {
            sSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        }
        return this.dMgr.search(sSOToken, string, string2, n);
    }

    public AMSearchResults search(SSOToken sSOToken, String string, String string2, SearchControl searchControl, String[] stringArray) throws AMException {
        if (!remote && this.checkRealmPermission(sSOToken, string, readAction)) {
            sSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        }
        return this.dMgr.search(sSOToken, string, string2, searchControl, stringArray);
    }

    public Set getMembers(SSOToken sSOToken, String string, int n) throws AMException {
        return this.dMgr.getMembers(sSOToken, string, n);
    }

    public String renameEntry(SSOToken sSOToken, int n, String string, String string2, boolean bl) throws AMException {
        return this.dMgr.renameEntry(sSOToken, n, string, string2, bl);
    }

    public void setAttributes(SSOToken sSOToken, String string, int n, Map map, Map map2, boolean bl) throws AMException, SSOException {
        try {
            this.dMgr.setAttributes(sSOToken, string, n, map, map2, bl);
        }
        catch (AMException aMException) {
            if (!remote && aMException.getErrorCode().equals("460") && this.checkRealmPermission(sSOToken, string, writeAction)) {
                SSOToken sSOToken2 = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
                this.dMgr.setAttributes(sSOToken2, string, n, map, map2, bl);
            }
            throw aMException;
        }
    }

    public String[] getGroupFilterAndScope(SSOToken sSOToken, String string, int n) throws AMException, SSOException {
        return this.dMgr.getGroupFilterAndScope(sSOToken, string, n);
    }

    public void setGroupFilter(SSOToken sSOToken, String string, String string2) throws AMException, SSOException {
        this.dMgr.setGroupFilter(sSOToken, string, string2);
    }

    public void modifyMemberShip(SSOToken sSOToken, Set set, String string, int n, int n2) throws AMException {
        this.dMgr.modifyMemberShip(sSOToken, set, string, n, n2);
    }

    public Set getRegisteredServiceNames(SSOToken sSOToken, String string) throws AMException {
        if (!remote && this.checkRealmPermission(sSOToken, string, readAction)) {
            sSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        }
        return this.dMgr.getRegisteredServiceNames(sSOToken, string);
    }

    public void registerService(SSOToken sSOToken, String string, String string2) throws AMException, SSOException {
        try {
            this.dMgr.registerService(sSOToken, string, string2);
        }
        catch (AMException aMException) {
            if (!remote && aMException.getErrorCode().equals("460") && this.checkRealmPermission(sSOToken, string, writeAction)) {
                SSOToken sSOToken2 = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
                this.dMgr.registerService(sSOToken2, string, string2);
            }
            throw aMException;
        }
    }

    public void unRegisterService(SSOToken sSOToken, String string, int n, String string2, AMTemplate aMTemplate, int n2) throws AMException {
        try {
            this.dMgr.unRegisterService(sSOToken, string, n, string2, aMTemplate, n2);
        }
        catch (AMException aMException) {
            if (!remote && aMException.getErrorCode().equals("460") && this.checkRealmPermission(sSOToken, string, writeAction)) {
                SSOToken sSOToken2 = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
                this.dMgr.unRegisterService(sSOToken2, string, n, string2, aMTemplate, n2);
            }
            throw aMException;
        }
    }

    public void unRegisterService(SSOToken sSOToken, String string, int n, String string2, int n2) throws AMException {
        try {
            this.dMgr.unRegisterService(sSOToken, string, n, string2, null, n2);
        }
        catch (AMException aMException) {
            if (!remote && aMException.getErrorCode().equals("460") && this.checkRealmPermission(sSOToken, string, writeAction)) {
                SSOToken sSOToken2 = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
                this.dMgr.unRegisterService(sSOToken2, string, n, string2, null, n2);
            }
            throw aMException;
        }
    }

    public String getAMTemplateDN(SSOToken sSOToken, String string, int n, String string2, int n2) throws AMException {
        return this.dMgr.getAMTemplateDN(sSOToken, string, n, string2, n2);
    }

    public String createAMTemplate(SSOToken sSOToken, String string, int n, String string2, Map map, int n2) throws AMException {
        return this.dMgr.createAMTemplate(sSOToken, string, n, string2, map, n2);
    }

    public Set getAttributesForSchema(String string) {
        return this.dMgr.getAttributesForSchema(string);
    }

    public Set getTopLevelContainers(SSOToken sSOToken) throws AMException, SSOException {
        return this.dMgr.getTopLevelContainers(sSOToken);
    }

    public AMIdentity create(SSOToken sSOToken, IdType idType, String string, Map map, String string2) throws IdRepoException, SSOException {
        Object object;
        Object object2;
        IdRepoException idRepoException = null;
        if (remote) {
            return this.dMgr.create(sSOToken, idType, string, map, string2);
        }
        this.checkPermission(sSOToken, string2, string, map.keySet(), IdOperation.CREATE, idType);
        Set set = this.getIdRepoPlugins(sSOToken, string2);
        Object object3 = null;
        Set set2 = new HashSet();
        set2 = this.getConfiguredPlugins(sSOToken, string2, set, IdOperation.CREATE, idType);
        if (set2 == null || set2.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator iterator = set2.iterator();
        int n = set2.size();
        while (iterator.hasNext()) {
            IdRepo idRepo = (IdRepo)iterator.next();
            try {
                object2 = idRepo.getConfiguration();
                map = this.mapAttributeNames(map, (Map)object2);
                object = idRepo.create(sSOToken, idType, string, map);
                if (!idRepo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo")) continue;
                object3 = object;
            }
            catch (IdRepoUnsupportedOpException idRepoUnsupportedOpException) {
                if (idRepo != null && idd.warningEnabled()) {
                    idd.warning("Unable to create identity in the following repository" + idRepo.getClass().getName() + ":: " + idRepoUnsupportedOpException.getMessage());
                }
                --n;
                idRepoException = idRepoUnsupportedOpException;
            }
            catch (IdRepoFatalException idRepoFatalException) {
                idd.error("Create: Fatal Exception", idRepoFatalException);
                throw idRepoFatalException;
            }
            catch (IdRepoException idRepoException2) {
                if (idRepo != null && idd.warningEnabled()) {
                    idd.warning("Unable to create identity in the following repository" + idRepo.getClass().getName() + " :: " + idRepoException2.getMessage());
                }
                --n;
                idRepoException = idRepoException2;
            }
        }
        object2 = this.getNamingAttribute(idType) + string + ",ou=" + idType.getName() + ",amOrgName";
        object = new AMIdentity(sSOToken, string, idType, string2, (String)object3);
        if (n == 0) {
            idd.error("Unable to create identity " + idType.getName() + " :: " + string + "in any of the configured data stores", idRepoException);
            throw idRepoException;
        }
        return object;
    }

    public void delete(SSOToken sSOToken, IdType idType, String string, String string2, String string3) throws IdRepoException, SSOException {
        IdRepoException idRepoException = null;
        if (remote) {
            this.dMgr.delete(sSOToken, idType, string, string2, string3);
            return;
        }
        this.checkPermission(sSOToken, string2, string, null, IdOperation.DELETE, idType);
        Set set = this.getIdRepoPlugins(sSOToken, string2);
        Set set2 = new HashSet();
        set2 = this.getConfiguredPlugins(sSOToken, string2, set, IdOperation.DELETE, idType);
        if (set2 == null || set2.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator iterator = set2.iterator();
        int n = set2.size();
        while (iterator.hasNext()) {
            IdRepo idRepo = (IdRepo)iterator.next();
            try {
                if (idRepo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo") && string3 != null) {
                    idRepo.delete(sSOToken, idType, string3);
                    continue;
                }
                idRepo.delete(sSOToken, idType, string);
            }
            catch (IdRepoUnsupportedOpException idRepoUnsupportedOpException) {
                if (idd.warningEnabled()) {
                    idd.warning("Unable to delete identity in the following repository" + idRepo.getClass().getName() + " :: " + idRepoUnsupportedOpException.getMessage());
                }
                --n;
                idRepoException = idRepoUnsupportedOpException;
            }
            catch (IdRepoFatalException idRepoFatalException) {
                idd.error("Delete: Fatal Exception ", idRepoFatalException);
                throw idRepoFatalException;
            }
            catch (IdRepoException idRepoException2) {
                if (idRepo != null && idd.warningEnabled()) {
                    idd.warning("Unable to delete identity in the following repository" + idRepo.getClass().getName() + " :: " + idRepoException2.getMessage());
                }
                --n;
                idRepoException = idRepoException2;
            }
        }
        if (n == 0) {
            idd.error("Unable to delete identity " + idType.getName() + " :: " + string + "in any of the configured data stores", idRepoException);
            throw idRepoException;
        }
    }

    public Map getAttributes(SSOToken sSOToken, IdType idType, String string, Set set, String string2, String string3, boolean bl) throws IdRepoException, SSOException {
        Map map;
        IdRepoException idRepoException = null;
        if (remote) {
            return this.dMgr.getAttributes(sSOToken, idType, string, set, string2, string3);
        }
        this.checkPermission(sSOToken, string2, string, set, IdOperation.READ, idType);
        Set set2 = this.getIdRepoPlugins(sSOToken, string2);
        Set set3 = new HashSet();
        set3 = this.getConfiguredPlugins(sSOToken, string2, set2, IdOperation.READ, idType);
        if (set3 == null || set3.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator iterator = set3.iterator();
        int n = set3.size();
        HashSet<Map> hashSet = new HashSet<Map>();
        while (iterator.hasNext()) {
            IdRepo idRepo = (IdRepo)iterator.next();
            try {
                map = idRepo.getConfiguration();
                set = this.mapAttributeNames(set, map);
                Map map2 = null;
                map2 = idRepo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo") && string3 != null ? (bl ? idRepo.getAttributes(sSOToken, idType, string3, set) : idRepo.getBinaryAttributes(sSOToken, idType, string, set)) : (bl ? idRepo.getAttributes(sSOToken, idType, string, set) : idRepo.getBinaryAttributes(sSOToken, idType, string, set));
                map2 = this.reverseMapAttributeNames(map2, map);
                hashSet.add(map2);
            }
            catch (IdRepoUnsupportedOpException idRepoUnsupportedOpException) {
                if (idd.warningEnabled()) {
                    idd.warning("Unable to read identity in the following repository" + idRepo.getClass().getName() + " :: " + idRepoUnsupportedOpException.getMessage());
                }
                --n;
                idRepoException = idRepoUnsupportedOpException;
            }
            catch (IdRepoFatalException idRepoFatalException) {
                idd.error("GetAttributes: Fatal Exception ", idRepoFatalException);
                throw idRepoFatalException;
            }
            catch (IdRepoException idRepoException2) {
                if (idRepo != null && idd.warningEnabled()) {
                    idd.warning("Unable to read identity in the following repository" + idRepo.getClass().getName() + " :: " + idRepoException2.getMessage());
                }
                --n;
                idRepoException = idRepoException2;
            }
        }
        if (n == 0) {
            idd.error("Unable to get attributes for identity " + idType.getName() + "::" + string + " in any configured data store", idRepoException);
            throw idRepoException;
        }
        map = this.combineAttrMaps(hashSet, bl);
        return map;
    }

    public Map getAttributes(SSOToken sSOToken, IdType idType, String string, String string2, String string3) throws IdRepoException, SSOException {
        Map map;
        IdRepoException idRepoException = null;
        if (remote) {
            return this.dMgr.getAttributes(sSOToken, idType, string, string2, string3);
        }
        this.checkPermission(sSOToken, string2, string, null, IdOperation.READ, idType);
        Set set = this.getIdRepoPlugins(sSOToken, string2);
        Set set2 = new HashSet();
        set2 = this.getConfiguredPlugins(sSOToken, string2, set, IdOperation.READ, idType);
        if (set2 == null || set2.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator iterator = set2.iterator();
        int n = set2.size();
        HashSet<Map> hashSet = new HashSet<Map>();
        while (iterator.hasNext()) {
            IdRepo idRepo = (IdRepo)iterator.next();
            try {
                map = idRepo.getConfiguration();
                Map map2 = null;
                map2 = idRepo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo") && string3 != null ? idRepo.getAttributes(sSOToken, idType, string3) : idRepo.getAttributes(sSOToken, idType, string);
                map2 = this.reverseMapAttributeNames(map2, map);
                hashSet.add(map2);
            }
            catch (IdRepoUnsupportedOpException idRepoUnsupportedOpException) {
                if (idRepo != null && idd.warningEnabled()) {
                    idd.warning("Unable to read identity in the following repository" + idRepo.getClass().getName() + " :: " + idRepoUnsupportedOpException.getMessage());
                }
                --n;
                idRepoException = idRepoUnsupportedOpException;
            }
            catch (IdRepoFatalException idRepoFatalException) {
                idd.error("GetAttributes: Fatal Exception ", idRepoFatalException);
                throw idRepoFatalException;
            }
            catch (IdRepoException idRepoException2) {
                if (idRepo != null && idd.warningEnabled()) {
                    idd.warning("Unable to read identity in the following repository" + idRepo.getClass().getName() + " :: " + idRepoException2.getMessage());
                }
                --n;
                idRepoException = idRepoException2;
            }
        }
        if (n == 0) {
            idd.error("Unable to get attributes for identity " + idType.getName() + "::" + string + " in any configured data store", idRepoException);
            throw idRepoException;
        }
        map = this.combineAttrMaps(hashSet, true);
        return map;
    }

    public Set getMembers(SSOToken sSOToken, IdType idType, String string, String string2, IdType idType2, String string3) throws IdRepoException, SSOException {
        IdRepoException idRepoException = null;
        if (remote) {
            return this.dMgr.getMembers(sSOToken, idType, string, string2, idType2, string3);
        }
        this.checkPermission(sSOToken, string2, string, null, IdOperation.READ, idType);
        Set set = this.getIdRepoPlugins(sSOToken, string2);
        Set set2 = new HashSet();
        set2 = this.getConfiguredPlugins(sSOToken, string2, set, IdOperation.READ, idType);
        if (set2 == null || set2.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator iterator = set2.iterator();
        int n = set2.size();
        HashSet<Set> hashSet = new HashSet<Set>();
        HashSet hashSet2 = new HashSet();
        boolean bl = false;
        while (iterator.hasNext()) {
            IdRepo idRepo = (IdRepo)iterator.next();
            try {
                Set set3;
                boolean bl2 = idRepo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo");
                Set set4 = set3 = bl2 && string3 != null ? idRepo.getMembers(sSOToken, idType, string3, idType2) : idRepo.getMembers(sSOToken, idType, string, idType2);
                if (bl2) {
                    hashSet2.addAll(set3);
                    bl = true;
                    continue;
                }
                hashSet.add(set3);
            }
            catch (IdRepoUnsupportedOpException idRepoUnsupportedOpException) {
                if (idRepo != null && idd.warningEnabled()) {
                    idd.warning("Unable to read identity members in the following repository" + idRepo.getClass().getName() + " :: " + idRepoUnsupportedOpException.getMessage());
                }
                --n;
                idRepoException = idRepoUnsupportedOpException;
            }
            catch (IdRepoFatalException idRepoFatalException) {
                idd.error("Get Members: Fatal Exception ", idRepoFatalException);
                throw idRepoFatalException;
            }
            catch (IdRepoException idRepoException2) {
                if (idRepo != null && idd.warningEnabled()) {
                    idd.warning("Unable to read identity members in the following repository" + idRepo.getClass().getName() + " :: " + idRepoException2.getMessage());
                }
                --n;
                idRepoException = idRepoException2;
            }
        }
        if (n == 0) {
            idd.error("Unable to get members for identity " + idType.getName() + "::" + string + " in any configured data store", idRepoException);
            throw idRepoException;
        }
        Set set5 = this.combineMembers(sSOToken, hashSet, idType2, string2, bl, hashSet2);
        return set5;
    }

    public Set getMemberships(SSOToken sSOToken, IdType idType, String string, IdType idType2, String string2, String string3) throws IdRepoException, SSOException {
        IdRepoException idRepoException = null;
        if (remote) {
            return this.dMgr.getMemberships(sSOToken, idType, string, idType2, string2, string3);
        }
        this.checkPermission(sSOToken, string2, string, null, IdOperation.READ, idType);
        Set set = this.getIdRepoPlugins(sSOToken, string2);
        Set set2 = new HashSet();
        set2 = this.getConfiguredPlugins(sSOToken, string2, set, IdOperation.READ, idType);
        if (set2 == null || set2.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator iterator = set2.iterator();
        int n = set2.size();
        HashSet<Set> hashSet = new HashSet<Set>();
        HashSet hashSet2 = new HashSet();
        boolean bl = false;
        while (iterator.hasNext()) {
            IdRepo idRepo = (IdRepo)iterator.next();
            try {
                Set set3;
                boolean bl2 = idRepo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo");
                Set set4 = set3 = bl2 && string3 != null ? idRepo.getMemberships(sSOToken, idType, string3, idType2) : idRepo.getMemberships(sSOToken, idType, string, idType2);
                if (bl2) {
                    hashSet2.addAll(set3);
                    bl = true;
                    continue;
                }
                hashSet.add(set3);
            }
            catch (IdRepoUnsupportedOpException idRepoUnsupportedOpException) {
                if (idRepo != null && idd.warningEnabled()) {
                    idd.warning("Unable to get memberships in the following repository" + idRepo.getClass().getName() + " :: " + idRepoUnsupportedOpException.getMessage());
                }
                --n;
                idRepoException = idRepoUnsupportedOpException;
            }
            catch (IdRepoFatalException idRepoFatalException) {
                idd.error("Get memberships: Fatal Exception ", idRepoFatalException);
                throw idRepoFatalException;
            }
            catch (IdRepoException idRepoException2) {
                if (idRepo != null && idd.warningEnabled()) {
                    idd.warning("Unable to read identity in the following repository" + idRepo.getClass().getName(), idRepoException2);
                }
                --n;
                idRepoException = idRepoException2;
            }
        }
        if (n == 0) {
            idd.error("Unable to get members for identity " + idType.getName() + "::" + string + " in any configured data store", idRepoException);
            throw idRepoException;
        }
        Set set5 = this.combineMembers(sSOToken, hashSet, idType2, string2, bl, hashSet2);
        return set5;
    }

    public boolean isExists(SSOToken sSOToken, IdType idType, String string, String string2) throws SSOException, IdRepoException {
        if (remote) {
            return this.dMgr.isExists(sSOToken, idType, string, string2);
        }
        Set set = this.getIdRepoPlugins(sSOToken, string2);
        Set set2 = new HashSet();
        set2 = this.getConfiguredPlugins(sSOToken, string2, set, IdOperation.READ, idType);
        if (set2 == null || set2.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator iterator = set2.iterator();
        int n = set2.size();
        boolean bl = false;
        while (iterator.hasNext()) {
            IdRepo idRepo = (IdRepo)iterator.next();
            bl = idRepo.isExists(sSOToken, idType, string);
            if (!bl) continue;
        }
        return bl;
    }

    public boolean isActive(SSOToken sSOToken, IdType idType, String string, String string2, String string3) throws SSOException, IdRepoException {
        IdRepoException idRepoException = null;
        if (remote) {
            return this.dMgr.isActive(sSOToken, idType, string, string2, string3);
        }
        this.checkPermission(sSOToken, string2, string, null, IdOperation.READ, idType);
        Set set = this.getIdRepoPlugins(sSOToken, string2);
        Set set2 = new HashSet();
        set2 = this.getConfiguredPlugins(sSOToken, string2, set, IdOperation.READ, idType);
        if (set2 == null || set2.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator iterator = set2.iterator();
        int n = set2.size();
        boolean bl = false;
        while (iterator.hasNext()) {
            IdRepo idRepo = (IdRepo)iterator.next();
            try {
                bl = idRepo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo") && string3 != null ? idRepo.isActive(sSOToken, idType, string3) : idRepo.isActive(sSOToken, idType, string);
                if (!bl) continue;
                break;
            }
            catch (IdRepoFatalException idRepoFatalException) {
                idd.error("IsActive: Fatal Exception ", idRepoFatalException);
                throw idRepoFatalException;
            }
            catch (IdRepoException idRepoException2) {
                if (idRepo != null && idd.warningEnabled()) {
                    idd.warning("Unable to check isActive identity in the following repository" + idRepo.getClass().getName() + " :: " + idRepoException2.getMessage());
                }
                --n;
                idRepoException = idRepoException2;
            }
        }
        if (n == 0) {
            idd.error("Unable to check if identity is active " + idType.getName() + "::" + string + " in any configured data store", idRepoException);
            throw idRepoException;
        }
        return bl;
    }

    public void modifyMemberShip(SSOToken sSOToken, IdType idType, String string, Set set, IdType idType2, int n, String string2) throws IdRepoException, SSOException {
        IdRepoException idRepoException = null;
        if (remote) {
            this.dMgr.modifyMemberShip(sSOToken, idType, string, set, idType2, n, string2);
            return;
        }
        this.checkPermission(sSOToken, string2, string, null, IdOperation.EDIT, idType);
        Set set2 = this.getIdRepoPlugins(sSOToken, string2);
        Set set3 = new HashSet();
        set3 = this.getConfiguredPlugins(sSOToken, string2, set2, IdOperation.EDIT, idType);
        if (set3 == null || set3.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator iterator = set3.iterator();
        int n2 = set3.size();
        HashSet hashSet = new HashSet();
        while (iterator.hasNext()) {
            IdRepo idRepo = (IdRepo)iterator.next();
            try {
                idRepo.modifyMemberShip(sSOToken, idType, string, set, idType2, n);
            }
            catch (IdRepoUnsupportedOpException idRepoUnsupportedOpException) {
                if (idRepo != null && idd.warningEnabled()) {
                    idd.warning("Unable to modify memberships  in the following repository" + idRepo.getClass().getName() + " :: " + idRepoUnsupportedOpException.getMessage());
                }
                --n2;
                idRepoException = idRepoUnsupportedOpException;
            }
            catch (IdRepoFatalException idRepoFatalException) {
                idd.error("Modify membership: Fatal Exception ", idRepoFatalException);
                throw idRepoFatalException;
            }
            catch (IdRepoException idRepoException2) {
                if (idRepo != null && idd.warningEnabled()) {
                    idd.error("Unable to modify memberships in the following repository" + idRepo.getClass().getName() + " :: " + idRepoException2.getMessage());
                }
                --n2;
                idRepoException = idRepoException2;
            }
        }
        if (n2 == 0) {
            idd.error("Unable to modify members for identity " + idType.getName() + "::" + string + " in any configured data store", idRepoException);
            throw idRepoException;
        }
    }

    public void removeAttributes(SSOToken sSOToken, IdType idType, String string, Set set, String string2, String string3) throws IdRepoException, SSOException {
        IdRepoException idRepoException = null;
        if (remote) {
            this.dMgr.removeAttributes(sSOToken, idType, string, set, string2, string3);
            return;
        }
        this.checkPermission(sSOToken, string2, string, set, IdOperation.EDIT, idType);
        Set set2 = this.getIdRepoPlugins(sSOToken, string2);
        Set set3 = new HashSet();
        set3 = this.getConfiguredPlugins(sSOToken, string2, set2, IdOperation.EDIT, idType);
        if (set3 == null || set3.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator iterator = set3.iterator();
        int n = set3.size();
        while (iterator.hasNext()) {
            IdRepo idRepo = (IdRepo)iterator.next();
            try {
                Map map = idRepo.getConfiguration();
                set = this.mapAttributeNames(set, map);
                if (idRepo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo") && string3 != null) {
                    idRepo.removeAttributes(sSOToken, idType, string3, set);
                    continue;
                }
                idRepo.removeAttributes(sSOToken, idType, string, set);
            }
            catch (IdRepoUnsupportedOpException idRepoUnsupportedOpException) {
                if (idRepo != null && idd.warningEnabled()) {
                    idd.warning("Unable to modify identity in the following repository" + idRepo.getClass().getName() + " :: " + idRepoUnsupportedOpException.getMessage());
                }
                --n;
                idRepoException = idRepoUnsupportedOpException;
            }
            catch (IdRepoFatalException idRepoFatalException) {
                idd.error("Remove attributes: Fatal Exception ", idRepoFatalException);
                throw idRepoFatalException;
            }
            catch (IdRepoException idRepoException2) {
                if (idRepo != null && idd.warningEnabled()) {
                    idd.warning("Unable to remove attributes in the following repository" + idRepo.getClass().getName() + " :: " + idRepoException2.getMessage());
                }
                --n;
                idRepoException = idRepoException2;
            }
        }
        if (n == 0) {
            idd.error("Unable to remove attributes  for identity " + idType.getName() + "::" + string + " in any configured data store", idRepoException);
            throw idRepoException;
        }
    }

    public IdSearchResults search(SSOToken sSOToken, IdType idType, String string, Map map, boolean bl, int n, int n2, Set set, String string2) throws IdRepoException, SSOException {
        Object object;
        IdRepoException idRepoException = null;
        if (remote) {
            return this.dMgr.search(sSOToken, idType, string, map, bl, n, n2, set, string2);
        }
        this.checkPermission(sSOToken, string2, null, null, IdOperation.READ, idType);
        Set set2 = this.getIdRepoPlugins(sSOToken, string2);
        Set set3 = new HashSet();
        set3 = this.getConfiguredPlugins(sSOToken, string2, set2, IdOperation.READ, idType);
        if (set3 == null || set3.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator iterator = set3.iterator();
        int n3 = set3.size();
        Object[][] objectArray = new Object[1][2];
        boolean bl2 = false;
        Object[][] objectArray2 = new Object[n3][2];
        int n4 = 0;
        while (iterator.hasNext()) {
            IdRepo idRepo = (IdRepo)iterator.next();
            try {
                object = idRepo.getConfiguration();
                RepoSearchResults repoSearchResults = idRepo.search(sSOToken, idType, string, map, bl, n, n2, set);
                if (idRepo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo")) {
                    objectArray[0][0] = repoSearchResults;
                    objectArray[0][1] = object;
                    bl2 = true;
                    continue;
                }
                objectArray2[n4][0] = repoSearchResults;
                objectArray2[n4][1] = object;
                ++n4;
            }
            catch (IdRepoUnsupportedOpException idRepoUnsupportedOpException) {
                if (idRepo != null && idd.warningEnabled()) {
                    idd.warning("Unable to search in the following repository" + idRepo.getClass().getName() + " :: " + idRepoUnsupportedOpException.getMessage());
                }
                --n3;
                idRepoException = idRepoUnsupportedOpException;
            }
            catch (IdRepoFatalException idRepoFatalException) {
                idd.error("Search: Fatal Exception ", idRepoFatalException);
                throw idRepoFatalException;
            }
            catch (IdRepoException idRepoException2) {
                if (idRepo != null && idd.warningEnabled()) {
                    idd.warning("Unable to search identity in the following repository" + idRepo.getClass().getName() + " :: " + idRepoException2.getMessage());
                }
                --n3;
                idRepoException = idRepoException2;
            }
        }
        if (n3 == 0) {
            idd.error("Unable to search for identity " + idType.getName() + "::" + string + " in any configured data store", idRepoException);
            throw idRepoException;
        }
        object = this.combineSearchResults(sSOToken, objectArray2, n4, idType, string2, bl2, objectArray);
        return object;
    }

    public IdSearchResults search(SSOToken sSOToken, IdType idType, String string, IdSearchControl idSearchControl, String string2) throws IdRepoException, SSOException {
        Object object;
        IdRepoException idRepoException = null;
        if (remote) {
            return this.dMgr.search(sSOToken, idType, string, idSearchControl, string2);
        }
        this.checkPermission(sSOToken, string2, null, null, IdOperation.READ, idType);
        Set set = this.getIdRepoPlugins(sSOToken, string2);
        Set set2 = new HashSet();
        set2 = this.getConfiguredPlugins(sSOToken, string2, set, IdOperation.READ, idType);
        if (set2 == null || set2.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator iterator = set2.iterator();
        int n = set2.size();
        Object[][] objectArray = new Object[1][2];
        boolean bl = false;
        Object[][] objectArray2 = new Object[n][2];
        int n2 = 0;
        int n3 = idSearchControl.getTimeOut();
        int n4 = idSearchControl.getMaxResults();
        Set set3 = idSearchControl.getReturnAttributes();
        boolean bl2 = idSearchControl.isGetAllReturnAttributesEnabled();
        IdSearchOpModifier idSearchOpModifier = idSearchControl.getSearchModifier();
        int n5 = -1;
        if (idSearchOpModifier.equals(IdSearchOpModifier.AND)) {
            n5 = 1;
        } else if (idSearchOpModifier.equals(IdSearchOpModifier.OR)) {
            n5 = 0;
        }
        Map map = idSearchControl.getSearchModifierMap();
        boolean bl3 = idSearchControl.isRecursive();
        while (iterator.hasNext()) {
            IdRepo idRepo = (IdRepo)iterator.next();
            try {
                object = idRepo.getConfiguration();
                RepoSearchResults repoSearchResults = idRepo.search(sSOToken, idType, string, n3, n4, set3, bl2, n5, map, bl3);
                if (idRepo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo")) {
                    objectArray[0][0] = repoSearchResults;
                    objectArray[0][1] = object;
                    bl = true;
                    continue;
                }
                objectArray2[n2][0] = repoSearchResults;
                objectArray2[n2][1] = object;
                ++n2;
            }
            catch (IdRepoUnsupportedOpException idRepoUnsupportedOpException) {
                if (idRepo != null && idd.warningEnabled()) {
                    idd.error("Unable to search in the following repository" + idRepo.getClass().getName() + " :: " + idRepoUnsupportedOpException.getMessage());
                }
                --n;
                idRepoException = idRepoUnsupportedOpException;
            }
            catch (IdRepoFatalException idRepoFatalException) {
                idd.error("Search: Fatal Exception ", idRepoFatalException);
                throw idRepoFatalException;
            }
            catch (IdRepoException idRepoException2) {
                if (idRepo != null && idd.warningEnabled()) {
                    idd.warning("Unable to search identity in the following repository" + idRepo.getClass().getName() + " :: " + idRepoException2.getMessage());
                }
                --n;
                idRepoException = idRepoException2;
            }
        }
        if (n == 0) {
            idd.error("Unable to search for identity " + idType.getName() + "::" + string + " in any configured data store", idRepoException);
            throw idRepoException;
        }
        object = this.combineSearchResults(sSOToken, objectArray2, n2, idType, string2, bl, objectArray);
        return object;
    }

    public IdSearchResults getSpecialIdentities(SSOToken sSOToken, IdType idType, String string) throws IdRepoException, SSOException {
        Object[][] objectArray;
        Object object;
        Object object2;
        OrderedSet orderedSet = new OrderedSet();
        IdRepo idRepo = null;
        if (ServiceManager.isConfigMigratedTo70() && ServiceManager.getBaseDN().equalsIgnoreCase(string)) {
            object2 = "com.sun.identity.idm.plugins.internal.SpecialRepo";
            object = null;
            objectArray = idRepoMap;
            synchronized (objectArray) {
                object = (IdRepo)idRepoMap.get(object2);
            }
            if (object == null) {
                try {
                    Class<?> clazz = Class.forName((String)object2);
                    idRepo = (IdRepo)clazz.newInstance();
                    idRepo.initialize(new HashMap());
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("realm", string);
                    IdRepoListener idRepoListener = new IdRepoListener();
                    idRepoListener.setConfigMap(hashMap);
                    idRepo.addListener(sSOToken, idRepoListener);
                    Map map = idRepoMap;
                    synchronized (map) {
                        idRepoMap.put(object2, idRepo);
                    }
                    Set set = idRepo.getSupportedOperations(idType);
                    if (set != null && set.contains(IdOperation.READ)) {
                        orderedSet.add(idRepo);
                    }
                }
                catch (Exception exception) {
                    idd.error("Unable to instantiate plugin: " + (String)object2, exception);
                }
            } else {
                Set set = ((IdRepo)object).getSupportedOperations(idType);
                if (set != null && set.contains(IdOperation.READ)) {
                    orderedSet.add(object);
                }
            }
        }
        if (orderedSet.isEmpty()) {
            return new IdSearchResults(idType, string);
        }
        object2 = (IdRepo)orderedSet.iterator().next();
        object = ((IdRepo)object2).search(sSOToken, idType, "*", 0, 0, Collections.EMPTY_SET, false, 0, Collections.EMPTY_MAP, false);
        objectArray = new Object[1][2];
        objectArray[0][0] = object;
        objectArray[0][1] = Collections.EMPTY_MAP;
        return this.combineSearchResults(sSOToken, objectArray, 1, idType, string, false, null);
    }

    public void setAttributes(SSOToken sSOToken, IdType idType, String string, Map map, boolean bl, String string2, String string3, boolean bl2) throws IdRepoException, SSOException {
        IdRepoException idRepoException = null;
        if (remote) {
            this.dMgr.setAttributes(sSOToken, idType, string, map, bl, string2, string3);
            return;
        }
        this.checkPermission(sSOToken, string2, string, map.keySet(), IdOperation.EDIT, idType);
        Set set = this.getIdRepoPlugins(sSOToken, string2);
        Set set2 = new HashSet();
        set2 = map.containsKey("objectclass") ? this.getConfiguredPlugins(sSOToken, string2, set, IdOperation.SERVICE, idType) : this.getConfiguredPlugins(sSOToken, string2, set, IdOperation.EDIT, idType);
        if (set2 == null || set2.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator iterator = set2.iterator();
        int n = set2.size();
        while (iterator.hasNext()) {
            IdRepo idRepo = (IdRepo)iterator.next();
            try {
                Map map2 = idRepo.getConfiguration();
                map = this.mapAttributeNames(map, map2);
                if (idRepo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo") && string3 != null) {
                    if (bl2) {
                        idRepo.setAttributes(sSOToken, idType, string3, map, bl);
                        continue;
                    }
                    idRepo.setBinaryAttributes(sSOToken, idType, string3, map, bl);
                    continue;
                }
                if (bl2) {
                    idRepo.setAttributes(sSOToken, idType, string, map, bl);
                    continue;
                }
                idRepo.setBinaryAttributes(sSOToken, idType, string, map, bl);
            }
            catch (IdRepoUnsupportedOpException idRepoUnsupportedOpException) {
                if (idRepo != null && idd.warningEnabled()) {
                    idd.warning("AMDirectoryManager:setAttributes: Unable to set attributes in the following repository" + idRepo.getClass().getName() + " :: " + idRepoUnsupportedOpException.getMessage());
                }
                --n;
                idRepoException = idRepoUnsupportedOpException;
            }
            catch (IdRepoFatalException idRepoFatalException) {
                idd.error("Set Attributes: Fatal Exception ", idRepoFatalException);
                throw idRepoFatalException;
            }
            catch (IdRepoException idRepoException2) {
                if (idRepo != null && idd.warningEnabled()) {
                    idd.warning("Unable to modify identity in the following repository" + idRepo.getClass().getName() + " :: " + idRepoException2.getMessage());
                }
                --n;
                idRepoException = idRepoException2;
            }
        }
        if (n == 0) {
            idd.error("Unable to set attributes  for identity " + idType.getName() + "::" + string + " in any configured data store", idRepoException);
            throw idRepoException;
        }
    }

    public Set getAssignedServices(SSOToken sSOToken, IdType idType, String string, Map map, String string2, String string3) throws IdRepoException, SSOException {
        IdRepoException idRepoException = null;
        if (remote) {
            return this.dMgr.getAssignedServices(sSOToken, idType, string, map, string2, string3);
        }
        this.checkPermission(sSOToken, string2, string, null, IdOperation.SERVICE, idType);
        Set set = this.getIdRepoPlugins(sSOToken, string2);
        Set set2 = new HashSet();
        set2 = this.getConfiguredPlugins(sSOToken, string2, set, IdOperation.SERVICE, idType);
        if (set2 == null || set2.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator iterator = set2.iterator();
        int n = set2.size();
        Object object = null;
        HashSet hashSet = new HashSet();
        while (iterator.hasNext()) {
            IdRepo idRepo = (IdRepo)iterator.next();
            Map map2 = idRepo.getConfiguration();
            try {
                Set set3 = null;
                set3 = idRepo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo") && string3 != null ? idRepo.getAssignedServices(sSOToken, idType, string3, map) : idRepo.getAssignedServices(sSOToken, idType, string, map);
                if (set3 == null || set3.isEmpty()) continue;
                hashSet.addAll(set3);
            }
            catch (IdRepoUnsupportedOpException idRepoUnsupportedOpException) {
                if (object != null && idd.warningEnabled()) {
                    idd.error("AMDirectoryManager.getAssignedServices: Services not supported for repository " + idRepo.getClass().getName() + " :: " + idRepoUnsupportedOpException.getMessage());
                }
                --n;
                idRepoException = idRepoUnsupportedOpException;
            }
            catch (IdRepoFatalException idRepoFatalException) {
                idd.error("GetAssignedServices: Fatal Exception ", idRepoFatalException);
                throw idRepoFatalException;
            }
            catch (IdRepoException idRepoException2) {
                if (object != null && idd.warningEnabled()) {
                    idd.warning("Unable to get services for identity in the following repository" + object.getClass().getName() + " :: " + idRepoException2.getMessage());
                }
                --n;
                idRepoException = idRepoException2;
            }
        }
        if (n == 0) {
            idd.error("Unable to get assigned services for identity " + idType.getName() + "::" + string + " in any configured data store", idRepoException);
            throw idRepoException;
        }
        return hashSet;
    }

    public void assignService(SSOToken sSOToken, IdType idType, String string, String string2, SchemaType schemaType, Map map, String string3, String string4) throws IdRepoException, SSOException {
        IdRepoException idRepoException = null;
        if (remote) {
            this.dMgr.assignService(sSOToken, idType, string, string2, schemaType, map, string3, string4);
            return;
        }
        this.checkPermission(sSOToken, string3, string, null, IdOperation.SERVICE, idType);
        Set set = this.getIdRepoPlugins(sSOToken, string3);
        Set set2 = new HashSet();
        set2 = this.getConfiguredPlugins(sSOToken, string3, set, IdOperation.SERVICE, idType);
        if (set2 == null || set2.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator iterator = set2.iterator();
        int n = set2.size();
        Object object = null;
        while (iterator.hasNext()) {
            IdRepo idRepo = (IdRepo)iterator.next();
            Map map2 = idRepo.getConfiguration();
            try {
                map = this.mapAttributeNames(map, map2);
                if (idRepo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo") && string4 != null) {
                    idRepo.assignService(sSOToken, idType, string4, string2, schemaType, map);
                    continue;
                }
                idRepo.assignService(sSOToken, idType, string, string2, schemaType, map);
            }
            catch (IdRepoUnsupportedOpException idRepoUnsupportedOpException) {
                if (object != null && idd.warningEnabled()) {
                    idd.error("AMDirectoryManager.assignServices: Assign Services not supported for repository " + idRepo.getClass().getName() + " :: " + idRepoUnsupportedOpException.getMessage());
                }
                --n;
                idRepoException = idRepoUnsupportedOpException;
            }
            catch (IdRepoFatalException idRepoFatalException) {
                idd.error("AssignService: FatalException ", idRepoFatalException);
                throw idRepoFatalException;
            }
            catch (IdRepoException idRepoException2) {
                if (object != null && idd.warningEnabled()) {
                    idd.error("Unable to assign Service identity in the following repository" + object.getClass().getName() + " :: " + idRepoException2.getMessage());
                }
                --n;
                idRepoException = idRepoException2;
            }
        }
        if (n == 0) {
            idd.error("Unable to assign service  for identity " + idType.getName() + "::" + string + " in any configured data store", idRepoException);
            throw idRepoException;
        }
    }

    public void unassignService(SSOToken sSOToken, IdType idType, String string, String string2, Map map, String string3, String string4) throws IdRepoException, SSOException {
        IdRepoException idRepoException = null;
        if (remote) {
            this.dMgr.unassignService(sSOToken, idType, string, string2, map, string3, string4);
            return;
        }
        this.checkPermission(sSOToken, string3, string, null, IdOperation.SERVICE, idType);
        Set set = this.getIdRepoPlugins(sSOToken, string3);
        Set set2 = new HashSet();
        set2 = this.getConfiguredPlugins(sSOToken, string3, set, IdOperation.SERVICE, idType);
        if (set2 == null || set2.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator iterator = set2.iterator();
        int n = set2.size();
        Object object = null;
        while (iterator.hasNext()) {
            IdRepo idRepo = (IdRepo)iterator.next();
            Map map2 = idRepo.getConfiguration();
            try {
                map = this.mapAttributeNames(map, map2);
                if (idRepo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo") && string4 != null) {
                    idRepo.unassignService(sSOToken, idType, string4, string2, map);
                    continue;
                }
                idRepo.unassignService(sSOToken, idType, string, string2, map);
            }
            catch (IdRepoUnsupportedOpException idRepoUnsupportedOpException) {
                if (object != null && idd.warningEnabled()) {
                    idd.error("AMDirectoryManager.assignServices: Assign Services not supported for repository " + idRepo.getClass().getName() + " :: " + idRepoUnsupportedOpException.getMessage());
                }
                --n;
                idRepoException = idRepoUnsupportedOpException;
            }
            catch (IdRepoFatalException idRepoFatalException) {
                idd.error("UnassignService: Fatal Exception ", idRepoFatalException);
                throw idRepoFatalException;
            }
            catch (IdRepoException idRepoException2) {
                if (object != null && idd.warningEnabled()) {
                    idd.warning("Unable to unassign service in the following repository" + object.getClass().getName() + " :: " + idRepoException2.getMessage());
                }
                --n;
                idRepoException = idRepoException2;
            }
        }
        if (n == 0) {
            idd.error("Unable to unassign Service for identity " + idType.getName() + "::" + string + " in any configured data store", idRepoException);
            throw idRepoException;
        }
    }

    public Map getServiceAttributes(SSOToken sSOToken, IdType idType, String string, String string2, Set set, String string3, String string4) throws IdRepoException, SSOException {
        Object object;
        if (remote) {
            return this.dMgr.getServiceAttributes(sSOToken, idType, string, string2, set, string3, string4);
        }
        this.checkPermission(sSOToken, string3, string, null, IdOperation.SERVICE, idType);
        Set set2 = this.getIdRepoPlugins(sSOToken, string3);
        Set set3 = new HashSet();
        set3 = this.getConfiguredPlugins(sSOToken, string3, set2, IdOperation.SERVICE, idType);
        if (set3 == null || set3.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator iterator = set3.iterator();
        int n = set3.size();
        Object object2 = null;
        HashSet<Map> hashSet = new HashSet<Map>();
        IdRepoException idRepoException = null;
        while (iterator.hasNext()) {
            object = (IdRepo)iterator.next();
            Map map = ((IdRepo)object).getConfiguration();
            try {
                Set set4 = this.mapAttributeNames(set, map);
                Map map2 = null;
                map2 = object.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo") && string4 != null ? ((IdRepo)object).getServiceAttributes(sSOToken, idType, string4, string2, set) : ((IdRepo)object).getServiceAttributes(sSOToken, idType, string, string2, set);
                map2 = this.reverseMapAttributeNames(map2, map);
                hashSet.add(map2);
            }
            catch (IdRepoUnsupportedOpException idRepoUnsupportedOpException) {
                if (object2 != null && idd.warningEnabled()) {
                    idd.warning("AMDirectoryManager.getServiceAttributes: Services not supported for repository " + object.getClass().getName() + " :: " + idRepoUnsupportedOpException.getMessage());
                }
                --n;
                idRepoException = idRepoUnsupportedOpException;
            }
            catch (IdRepoFatalException idRepoFatalException) {
                idd.error("GetServiceAttributes: Fatal Exception ", idRepoFatalException);
                throw idRepoFatalException;
            }
            catch (IdRepoException idRepoException2) {
                if (object2 != null && idd.warningEnabled()) {
                    idd.warning("AMDirectoryManager.getServiceAttributes: Unable to get service attributes for the repository" + object2.getClass().getName() + " :: " + idRepoException2.getMessage());
                }
                --n;
                idRepoException = idRepoException2;
            }
        }
        if (n == 0) {
            idd.error("Unable to get service attributes for identity " + idType.getName() + "::" + string + " in any configured data store", idRepoException);
            throw idRepoException;
        }
        object = this.combineAttrMaps(hashSet, true);
        return object;
    }

    public void modifyService(SSOToken sSOToken, IdType idType, String string, String string2, SchemaType schemaType, Map map, String string3, String string4) throws IdRepoException, SSOException {
        Object[] objectArray;
        IdRepoException idRepoException = null;
        if (remote) {
            this.dMgr.modifyService(sSOToken, idType, string, string2, schemaType, map, string3, string4);
            return;
        }
        this.checkPermission(sSOToken, string3, string, null, IdOperation.SERVICE, idType);
        Set set = this.getIdRepoPlugins(sSOToken, string3);
        Set set2 = new HashSet();
        set2 = this.getConfiguredPlugins(sSOToken, string3, set, IdOperation.SERVICE, idType);
        if (set2 == null || set2.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator iterator = set2.iterator();
        int n = set2.size();
        Object object = null;
        while (iterator.hasNext()) {
            objectArray = (Object[])iterator.next();
            Map map2 = objectArray.getConfiguration();
            try {
                map = this.mapAttributeNames(map, map2);
                if (objectArray.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo") && string4 != null) {
                    objectArray.modifyService(sSOToken, idType, string4, string2, schemaType, map);
                    continue;
                }
                objectArray.modifyService(sSOToken, idType, string, string2, schemaType, map);
            }
            catch (IdRepoUnsupportedOpException idRepoUnsupportedOpException) {
                if (object != null && idd.warningEnabled()) {
                    idd.error("AMDirectoryManager.modifyServices: Modify Services not supported for repository " + objectArray.getClass().getName() + " :: " + idRepoUnsupportedOpException.getMessage());
                }
                --n;
                idRepoException = idRepoUnsupportedOpException;
            }
            catch (IdRepoFatalException idRepoFatalException) {
                idd.error("ModifyService: Fatal Exception ", idRepoFatalException);
                throw idRepoFatalException;
            }
            catch (IdRepoException idRepoException2) {
                if (object != null && idd.warningEnabled()) {
                    idd.warning("Unable to modify service in the following repository" + object.getClass().getName() + " :: " + idRepoException2.getMessage());
                }
                --n;
                idRepoException = idRepoException2;
            }
        }
        if (n == 0) {
            idd.error("Unable to modify service attributes for identity " + idType.getName() + "::" + string + " in any configured data store");
            objectArray = new Object[]{IdOperation.SERVICE.toString()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "302", objectArray);
        }
    }

    public Set getSupportedTypes(SSOToken sSOToken, String string) throws IdRepoException, SSOException {
        Object var3_3 = null;
        if (remote) {
            return this.dMgr.getSupportedTypes(sSOToken, string);
        }
        HashSet hashSet = new HashSet();
        Set set = this.getIdRepoPlugins(sSOToken, string);
        Set set2 = this.getAllConfiguredPlugins(sSOToken, string, set);
        if (set2 == null || set2.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            IdRepo idRepo = (IdRepo)iterator.next();
            Set set3 = idRepo.getSupportedTypes();
            if (set3 == null || set3.isEmpty()) continue;
            hashSet.addAll(set3);
        }
        hashSet.retainAll(IdUtils.supportedTypes);
        return hashSet;
    }

    public Set getSupportedOperations(SSOToken sSOToken, IdType idType, String string) throws IdRepoException, SSOException {
        if (remote) {
            return this.dMgr.getSupportedOperations(sSOToken, idType, string);
        }
        HashSet hashSet = new HashSet();
        Set set = this.getIdRepoPlugins(sSOToken, string);
        Set set2 = this.getAllConfiguredPlugins(sSOToken, string, set);
        if (set2 == null || set2.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            IdRepo idRepo = (IdRepo)iterator.next();
            Set set3 = idRepo.getSupportedOperations(idType);
            if (set3 == null || set3.isEmpty()) continue;
            hashSet.addAll(set3);
        }
        return hashSet;
    }

    public void cleanupIdRepoPlugins() {
        Object object;
        Object object2;
        idd.message("AMDM: Cleanup IdRepo Plugins is called...\n Cleaning up the map.." + idRepoMap);
        HashSet hashSet = new HashSet();
        Map map = idRepoMap;
        synchronized (map) {
            object2 = idRepoMap.keySet();
            object = object2.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                Object v = idRepoMap.get(string);
                if (v instanceof IdRepo) {
                    hashSet.add(idRepoMap.get(string));
                    continue;
                }
                Map map2 = (Map)v;
                hashSet.addAll(map2.values());
            }
            idRepoMap.clear();
        }
        object2 = hashSet.iterator();
        while (object2.hasNext()) {
            object = (IdRepo)object2.next();
            ((IdRepo)object).removeListener();
            ((IdRepo)object).shutdown();
        }
    }

    private Set getIdRepoPlugins(SSOToken sSOToken, String string) {
        if (idRepoPlugins == null) {
            return Collections.EMPTY_SET;
        }
        if (ServiceManager.isCoexistenceMode() && !idRepoPlugins.contains("amSDK")) {
            idRepoPlugins.add("amSDK");
        }
        return idRepoPlugins;
    }

    public static void idRepoServiceSchemaChanged() {
        idRepoPlugins = idRepoSubSchema.getSubSchemaNames();
    }

    private Set getConfiguredPlugins(SSOToken sSOToken, String string, Set set, IdOperation idOperation, IdType idType) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        HashSet<String> hashSet;
        Object object7;
        Object object8;
        Object object9;
        Object object10;
        Object object11;
        OrderedSet orderedSet = new OrderedSet();
        if (ServiceManager.isConfigMigratedTo70() && ServiceManager.getBaseDN().equalsIgnoreCase(string)) {
            object11 = "com.sun.identity.idm.plugins.internal.SpecialRepo";
            object10 = null;
            object9 = null;
            object8 = idRepoMap;
            synchronized (object8) {
                object10 = (IdRepo)idRepoMap.get(object11);
            }
            if (object10 == null) {
                try {
                    object7 = Class.forName((String)object11);
                    hashSet = (IdRepo)((Class)object7).newInstance();
                    ((IdRepo)((Object)hashSet)).initialize(new HashMap());
                    object6 = new HashMap();
                    object6.put((String)"realm", (String)string);
                    object5 = new IdRepoListener();
                    ((IdRepoListener)object5).setConfigMap((Map)object6);
                    ((IdRepo)((Object)hashSet)).addListener(sSOToken, (IdRepoListener)object5);
                    object4 = idRepoMap;
                    synchronized (object4) {
                        idRepoMap.put(object11, hashSet);
                    }
                    object3 = ((IdRepo)((Object)hashSet)).getSupportedOperations(idType);
                    if (object3 != null && object3.contains(idOperation)) {
                        orderedSet.add(hashSet);
                    }
                }
                catch (Exception exception) {
                    idd.error("Unable to instantiate plguin: " + (String)object11, exception);
                }
            } else {
                object7 = ((IdRepo)object10).getSupportedOperations(idType);
                if (object7 != null && object7.contains(idOperation)) {
                    orderedSet.add(object10);
                }
            }
        }
        if (ServiceManager.isCoexistenceMode()) {
            object11 = "com.iplanet.am.sdk.AMSDKRepo";
            object10 = string + ":" + "amSDK";
            object9 = null;
            object8 = idRepoMap;
            synchronized (object8) {
                object7 = idRepoMap.get(object10);
                if (object7 instanceof IdRepo) {
                    object9 = (IdRepo)idRepoMap.get(object10);
                }
            }
            if (object9 == null) {
                object7 = new HashMap();
                hashSet = new HashSet<String>();
                hashSet.add(DNMapper.realmNameToAMSDKName(string));
                object7.put("amSDKOrgName", hashSet);
                try {
                    object6 = Class.forName((String)object11);
                    object5 = (IdRepo)((Class)object6).newInstance();
                    ((IdRepo)object5).initialize((Map)object7);
                    object4 = new HashMap<String, String>();
                    object4.put("realm", string);
                    object4.put("amsdk", "true");
                    object3 = new IdRepoListener();
                    ((IdRepoListener)object3).setConfigMap((Map)object4);
                    ((IdRepo)object5).addListener(sSOToken, (IdRepoListener)object3);
                    object2 = idRepoMap;
                    synchronized (object2) {
                        idRepoMap.put(object10, object5);
                    }
                    object = ((IdRepo)object5).getSupportedOperations(idType);
                    if (object != null && object.contains(idOperation)) {
                        orderedSet.add(object5);
                    }
                }
                catch (Exception exception) {
                    idd.error("Unable to instantiate plugin: " + (String)object11, exception);
                }
            } else {
                object7 = ((IdRepo)object9).getSupportedOperations(idType);
                if (object7 != null && object7.contains(idOperation)) {
                    orderedSet.add(object9);
                }
            }
        }
        object11 = set.iterator();
        while (object11.hasNext()) {
            object10 = (String)object11.next();
            object9 = string + ":" + (String)object10;
            object8 = null;
            object7 = null;
            hashSet = idRepoMap;
            synchronized (hashSet) {
                object6 = idRepoMap.get(object9);
                if (object6 instanceof Map) {
                    object7 = (Map)object6;
                }
            }
            if (object7 != null) {
                object6 = object7.keySet().iterator();
                while (object6.hasNext()) {
                    object5 = (String)object6.next();
                    object8 = (IdRepo)object7.get(object5);
                    object4 = ((IdRepo)object8).getSupportedOperations(idType);
                    if (object4 == null || !object4.contains(idOperation)) continue;
                    orderedSet.add(object8);
                }
                continue;
            }
            object6 = this.getConfiguredPluginNames(string, (String)object10);
            if (object6 == null || object6.isEmpty()) {
                object5 = idRepoMap;
                synchronized (object5) {
                    if (!idRepoMap.containsKey(object9)) {
                        idRepoMap.put(object9, Collections.EMPTY_MAP);
                    }
                    continue;
                }
            }
            object5 = object6.iterator();
            while (object5.hasNext()) {
                object4 = (String)object5.next();
                object3 = this.getConfigMap(string, (String)object10, (String)object4);
                if (object3 == null || object3.isEmpty() || (object2 = (Set)object3.get("sunIdRepoClass")) == null) continue;
                object = (String)object2.iterator().next();
                try {
                    Class<?> clazz = Class.forName((String)object);
                    IdRepo idRepo = (IdRepo)clazz.newInstance();
                    idRepo.initialize((Map)object3);
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("realm", string);
                    if (((String)object).equals("com.iplanet.am.sdk.AMSDKRepo")) {
                        hashMap.put("amsdk", "true");
                    }
                    hashMap.put("plugin-name", object4);
                    IdRepoListener idRepoListener = new IdRepoListener();
                    idRepoListener.setConfigMap(hashMap);
                    idRepo.addListener(sSOToken, idRepoListener);
                    Map map = idRepoMap;
                    synchronized (map) {
                        HashMap hashMap2 = (HashMap)idRepoMap.get(object9);
                        if (hashMap2 == null) {
                            hashMap2 = new HashMap();
                        }
                        hashMap2.put(object4, idRepo);
                        idRepoMap.put(object9, hashMap2);
                    }
                    if (!idRepo.getSupportedOperations(idType).contains(idOperation)) continue;
                    orderedSet.add(idRepo);
                }
                catch (Exception exception) {
                    idd.error("Unable to instantiate plugin: " + (String)object, exception);
                }
            }
        }
        return orderedSet;
    }

    private Set getAllConfiguredPlugins(SSOToken sSOToken, String string, Set set) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Set set2;
        Map map;
        Object object6;
        Object object7;
        HashMap<String, String> hashMap;
        Object object8;
        Object object9;
        Object object10;
        Object object11;
        Object object12;
        OrderedSet orderedSet = new OrderedSet();
        if (ServiceManager.isConfigMigratedTo70() && ServiceManager.getBaseDN().equalsIgnoreCase(string)) {
            object12 = "com.sun.identity.idm.plugins.internal.SpecialRepo";
            object11 = null;
            object10 = idRepoMap;
            synchronized (object10) {
                object11 = (IdRepo)idRepoMap.get(object12);
            }
            if (object11 == null) {
                try {
                    object9 = Class.forName((String)object12);
                    object8 = (IdRepo)((Class)object9).newInstance();
                    ((IdRepo)object8).initialize(new HashMap());
                    hashMap = new HashMap<String, String>();
                    hashMap.put("realm", string);
                    object7 = new IdRepoListener();
                    ((IdRepoListener)object7).setConfigMap(hashMap);
                    ((IdRepo)object8).addListener(sSOToken, (IdRepoListener)object7);
                    object6 = idRepoMap;
                    synchronized (object6) {
                        idRepoMap.put(object12, object8);
                    }
                    orderedSet.add(object8);
                }
                catch (Exception exception) {
                    idd.error("Unable to instantiate plguin: " + (String)object12, exception);
                }
            } else {
                orderedSet.add(object11);
            }
        }
        if (ServiceManager.isCoexistenceMode()) {
            object12 = "com.iplanet.am.sdk.AMSDKRepo";
            object11 = string + ":amSDK";
            object10 = null;
            object9 = idRepoMap;
            synchronized (object9) {
                object10 = (IdRepo)idRepoMap.get(object11);
            }
            if (object10 == null) {
                map = new HashMap();
                set2 = new HashSet<String>();
                set2.add(DNMapper.realmNameToAMSDKName(string));
                map.put("amSDKOrgName", set2);
                try {
                    object5 = Class.forName((String)object12);
                    object4 = (IdRepo)((Class)object5).newInstance();
                    ((IdRepo)object4).initialize(map);
                    object3 = new HashMap<String, String>();
                    object3.put("realm", string);
                    object3.put("amsdk", "true");
                    object2 = new IdRepoListener();
                    ((IdRepoListener)object2).setConfigMap((Map)object3);
                    ((IdRepo)object4).addListener(sSOToken, (IdRepoListener)object2);
                    object = idRepoMap;
                    synchronized (object) {
                        idRepoMap.put(object11, object4);
                    }
                    orderedSet.add(object4);
                }
                catch (Exception exception) {
                    idd.error("Unable to instantiate plugin: " + (String)object12, exception);
                }
            } else {
                orderedSet.add(object10);
            }
        }
        object12 = set.iterator();
        while (object12.hasNext()) {
            object11 = (String)object12.next();
            object10 = string + ":" + (String)object11;
            object9 = null;
            object8 = null;
            hashMap = idRepoMap;
            synchronized (hashMap) {
                object7 = idRepoMap.get(object10);
                if (object7 instanceof Map) {
                    object8 = (Map)object7;
                }
            }
            if (object8 != null) {
                object7 = object8.keySet().iterator();
                while (object7.hasNext()) {
                    object6 = (IdRepo)object8.get(object7.next());
                    orderedSet.add(object6);
                }
                continue;
            }
            object7 = this.getConfiguredPluginNames(string, (String)object11);
            if (object7 == null) {
                object6 = idRepoMap;
                synchronized (object6) {
                    idRepoMap.put(object10, Collections.EMPTY_MAP);
                    continue;
                }
            }
            object6 = object7.iterator();
            while (object6.hasNext()) {
                String string2 = (String)object6.next();
                map = this.getConfigMap(string, (String)object11, string2);
                if (map == null || map.isEmpty() || (set2 = (Set)map.get("sunIdRepoClass")) == null) continue;
                object5 = (String)set2.iterator().next();
                try {
                    object4 = Class.forName((String)object5);
                    object3 = (IdRepo)((Class)object4).newInstance();
                    ((IdRepo)object3).initialize(map);
                    object2 = new HashMap();
                    object2.put("realm", string);
                    if (((String)object5).equals("com.iplanet.am.sdk.AMSDKRepo")) {
                        object2.put("amsdk", "true");
                    }
                    object2.put("plugin-name", string2);
                    object = new IdRepoListener();
                    ((IdRepoListener)object).setConfigMap((Map)object2);
                    ((IdRepo)object3).addListener(sSOToken, (IdRepoListener)object);
                    Map map2 = idRepoMap;
                    synchronized (map2) {
                        HashMap<String, Object> hashMap2 = (HashMap<String, Object>)idRepoMap.get(object10);
                        if (hashMap2 == null) {
                            hashMap2 = new HashMap<String, Object>();
                        }
                        hashMap2.put(string2, object3);
                        idRepoMap.put(object10, hashMap2);
                    }
                    orderedSet.add(object3);
                }
                catch (Exception exception) {
                    idd.error("Unable to instantiate plugin: " + (String)object5, exception);
                }
            }
        }
        return orderedSet;
    }

    private Set getConfiguredPluginNames(String string, String string2) {
        HashSet<String> hashSet = new HashSet<String>();
        SSOToken sSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        try {
            ServiceConfigManager serviceConfigManager = new ServiceConfigManager(sSOToken, "sunIdentityRepositoryService", "1.0");
            if (serviceConfigManager == null) {
                return hashSet;
            }
            ServiceConfig serviceConfig = serviceConfigManager.getOrganizationConfig(string, null);
            if (serviceConfig == null) {
                return hashSet;
            }
            ServiceConfig serviceConfig2 = null;
            Set set = serviceConfig.getSubConfigNames();
            if (set != null && !set.isEmpty()) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    serviceConfig2 = serviceConfig.getSubConfig(string3);
                    if (serviceConfig2 == null || !serviceConfig2.getSchemaID().equalsIgnoreCase(string2)) continue;
                    hashSet.add(string3);
                }
            }
            return hashSet;
        }
        catch (SMSException sMSException) {
            if (ServiceManager.isConfigMigratedTo70()) {
                idd.error("SM Exception: unable to get plugin information", sMSException);
            }
            return hashSet;
        }
        catch (SSOException sSOException) {
            idd.error("SSO Exception: ", sSOException);
            return hashSet;
        }
    }

    private Map getConfigMap(String string, String string2, String string3) {
        SSOToken sSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        if (ServiceManager.isCoexistenceMode() && string2.equals("amSDK")) {
            HashMap hashMap = new HashMap();
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(DNMapper.realmNameToAMSDKName(string));
            hashMap.put("amSDKOrgName", hashSet);
            return hashMap;
        }
        Map map = Collections.EMPTY_MAP;
        try {
            ServiceConfigManager serviceConfigManager = new ServiceConfigManager(sSOToken, "sunIdentityRepositoryService", "1.0");
            if (serviceConfigManager == null) {
                return map;
            }
            ServiceConfig serviceConfig = serviceConfigManager.getOrganizationConfig(string, null);
            if (serviceConfig == null) {
                return map;
            }
            ServiceConfig serviceConfig2 = serviceConfig.getSubConfig(string3);
            if (serviceConfig2 != null && serviceConfig2.getSchemaID().equalsIgnoreCase(string2)) {
                map = serviceConfig2.getAttributes();
            }
            return map;
        }
        catch (SMSException sMSException) {
            idd.error("SM Exception: unable to get plugin information", sMSException);
            return map;
        }
        catch (SSOException sSOException) {
            idd.error("SSO Exception: ", sSOException);
            return map;
        }
    }

    private Map combineAttrMaps(Set set, boolean bl) {
        AMHashMap aMHashMap = new AMHashMap();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map map = (Map)iterator.next();
            if (map == null) continue;
            Iterator iterator2 = map.keySet().iterator();
            while (iterator2.hasNext()) {
                Object object;
                Object object2;
                String string = (String)iterator2.next();
                if (bl) {
                    object2 = (Set)aMHashMap.get(string);
                    object = (Set)map.get(string);
                    if (object2 != null) {
                        object2.addAll(object);
                        continue;
                    }
                    object2 = new HashSet((Set)map.get(string));
                    aMHashMap.put(string, object2);
                    continue;
                }
                object2 = (byte[][])aMHashMap.get(string);
                object = (byte[][])map.get(string);
                int n = ((Object)object).length;
                if (object2 != null) {
                    n = ((Object)object2).length + ((Object)object).length;
                    byte[][] byArrayArray = new byte[n][];
                    int n2 = 0;
                    while (n2 < ((HashSet<E>)object2).length) {
                        byArrayArray[n2] = (byte[])object2[n2];
                        ++n2;
                    }
                    int n3 = 0;
                    while (n3 < ((Object)object).length) {
                        byArrayArray[n3] = (byte[])object[n3];
                        ++n3;
                    }
                    object2 = byArrayArray;
                } else {
                    object2 = (byte[][])object.clone();
                }
                aMHashMap.put(string, object2);
            }
        }
        return aMHashMap;
    }

    private Map mapAttributeNames(Map map, Map map2) {
        Map map3;
        if (map == null || map.isEmpty()) {
            return map;
        }
        Map[] mapArray = this.getAttributeNameMap(map2);
        if (mapArray == null) {
            map3 = map;
        } else {
            map3 = new CaseInsensitiveHashMap();
            Map map4 = mapArray[0];
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (map4.containsKey(string)) {
                    map3.put((String)map4.get(string), (Set)map.get(string));
                    continue;
                }
                map3.put(string, (Set)map.get(string));
            }
        }
        return map3;
    }

    private Set mapAttributeNames(Set set, Map map) {
        Set set2;
        if (set == null || set.isEmpty()) {
            return set;
        }
        Map[] mapArray = this.getAttributeNameMap(map);
        if (mapArray == null) {
            set2 = set;
        } else {
            set2 = new CaseInsensitiveHashSet();
            Map map2 = mapArray[0];
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (map2.containsKey(string)) {
                    set2.add((String)map2.get(string));
                    continue;
                }
                set2.add(string);
            }
        }
        return set2;
    }

    private Map reverseMapAttributeNames(Map map, Map map2) {
        Map map3;
        if (map == null || map.isEmpty()) {
            return map;
        }
        Map[] mapArray = this.getAttributeNameMap(map2);
        if (mapArray == null) {
            map3 = map;
        } else {
            map3 = new CaseInsensitiveHashMap();
            Map map4 = mapArray[1];
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (map4.containsKey(string)) {
                    map3.put((String)map4.get(string), (Set)map.get(string));
                    continue;
                }
                map3.put(string, (Set)map.get(string));
            }
        }
        return map3;
    }

    private Set combineMembers(SSOToken sSOToken, Set set, IdType idType, String string, boolean bl, Set set2) {
        Object object;
        Object object2;
        Object object3;
        Iterator iterator;
        HashSet<Object> hashSet = new HashSet<Object>();
        CaseInsensitiveHashMap caseInsensitiveHashMap = new CaseInsensitiveHashMap();
        if (bl && set2 != null) {
            iterator = set2.iterator();
            while (iterator.hasNext()) {
                object3 = (String)iterator.next();
                object2 = object3;
                if (DN.isDN(object3)) {
                    object2 = new DN((String)object3).explodeDN(true)[0];
                }
                object = new AMIdentity(sSOToken, (String)object2, idType, string, (String)object3);
                hashSet.add(object);
                caseInsensitiveHashMap.put(object2, object);
            }
        }
        iterator = set.iterator();
        while (iterator.hasNext()) {
            object3 = (Set)iterator.next();
            if (object3 == null) continue;
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                String string2 = object;
                if (DN.isDN((String)object)) {
                    string2 = new DN((String)object).explodeDN(true)[0];
                }
                if (caseInsensitiveHashMap.containsKey(string2)) continue;
                AMIdentity aMIdentity = new AMIdentity(sSOToken, string2, idType, string, null);
                hashSet.add(aMIdentity);
                caseInsensitiveHashMap.put(string2, aMIdentity);
            }
        }
        return hashSet;
    }

    private IdSearchResults combineSearchResults(SSOToken sSOToken, Object[][] objectArray, int n, IdType idType, String string, boolean bl, Object[][] objectArray2) {
        Object object;
        String string2;
        Object object2;
        Object object3;
        Iterator iterator;
        Object object4;
        Object object5;
        CaseInsensitiveHashMap caseInsensitiveHashMap = new CaseInsensitiveHashMap();
        CaseInsensitiveHashMap caseInsensitiveHashMap2 = new CaseInsensitiveHashMap();
        int n2 = 0;
        if (bl) {
            RepoSearchResults repoSearchResults = (RepoSearchResults)objectArray2[0][0];
            object5 = (Map)objectArray2[0][1];
            object4 = repoSearchResults.getSearchResults();
            iterator = repoSearchResults.getResultAttributes();
            object3 = object4.iterator();
            while (object3.hasNext()) {
                object2 = (String)object3.next();
                string2 = new DN((String)object2).explodeDN(true)[0];
                caseInsensitiveHashMap.put(string2, object2);
                object = new HashSet();
                object.add((Map)iterator.get(object2));
                caseInsensitiveHashMap2.put(string2, object);
            }
            n2 = repoSearchResults.getErrorCode();
        }
        int n3 = 0;
        while (n3 < n) {
            object5 = (RepoSearchResults)objectArray[n3][0];
            object4 = (Map)objectArray[n3][1];
            iterator = ((RepoSearchResults)object5).getSearchResults().iterator();
            object3 = ((RepoSearchResults)object5).getResultAttributes();
            while (iterator.hasNext()) {
                object2 = (String)iterator.next();
                string2 = object2;
                object = (Map)object3.get(object2);
                if (DN.isDN((String)object2)) {
                    string2 = new DN((String)object2).explodeDN(true)[0];
                }
                object = this.reverseMapAttributeNames((Map)object, (Map)object4);
                HashSet<Object> hashSet = (HashSet<Object>)caseInsensitiveHashMap2.get(string2);
                if (hashSet == null) {
                    hashSet = new HashSet<Object>();
                }
                hashSet.add(object);
                caseInsensitiveHashMap2.put(string2, hashSet);
            }
            ++n3;
        }
        object5 = new IdSearchResults(idType, string);
        object4 = caseInsensitiveHashMap2.keySet().iterator();
        while (object4.hasNext()) {
            iterator = (String)object4.next();
            object3 = this.combineAttrMaps((Set)caseInsensitiveHashMap2.get(iterator), true);
            object2 = new AMIdentity(sSOToken, (String)((Object)iterator), idType, string, (String)caseInsensitiveHashMap.get(iterator));
            ((IdSearchResults)object5).addResult((AMIdentity)object2, (Map)object3);
        }
        ((IdSearchResults)object5).setErrorCode(n2);
        return object5;
    }

    private String getNamingAttribute(IdType idType) throws SSOException {
        if (namingAttrMap.containsKey(idType)) {
            return (String)namingAttrMap.get(idType);
        }
        SSOToken sSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        try {
            ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager("sunIdentityRepositoryService", sSOToken);
            ServiceSchema serviceSchema = serviceSchemaManager.getGlobalSchema();
            Map map = serviceSchema.getAttributeDefaults();
            Set set = (Set)map.get("SupportedIdentities");
            if (set != null) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    if (!string.startsWith(idType.getName())) continue;
                    String string2 = string.substring(string.indexOf("=") + 1);
                    namingAttrMap.put(idType, string2);
                    return string2;
                }
            }
        }
        catch (SMSException sMSException) {
            idd.error("AMDM.getNamingAttr:Unable to read service shema", sMSException);
        }
        return "uid";
    }

    private Map[] getAttributeNameMap(Map map) {
        Set set = (Set)map.get("sunIdRepoAttributeMapping");
        if (set == null || set.isEmpty()) {
            return null;
        }
        Map[] mapArray = new Map[2];
        int n = set.size();
        mapArray[0] = new CaseInsensitiveHashMap(n);
        mapArray[1] = new CaseInsensitiveHashMap(n);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            int n2 = string.indexOf(61);
            if (n2 > -1) {
                String string2 = string.substring(0, n2);
                String string3 = string.substring(n2 + 1);
                mapArray[0].put(string2, string3);
                mapArray[1].put(string3, string2);
                continue;
            }
            mapArray[0].put(string, string);
            mapArray[1].put(string, string);
        }
        return mapArray;
    }

    private boolean checkPermission(SSOToken sSOToken, String string, String string2, Set set, IdOperation idOperation, IdType idType) throws IdRepoException, SSOException {
        if (!ServiceManager.isConfigMigratedTo70()) {
            return true;
        }
        HashSet hashSet = null;
        hashSet = idOperation.equals(IdOperation.READ) ? readAction : writeAction;
        try {
            DelegationEvaluator delegationEvaluator = new DelegationEvaluator();
            String string3 = idType.getName();
            if (string2 != null) {
                string3 = string3 + "/" + string2;
            }
            DelegationPermission delegationPermission = new DelegationPermission(string, "sunIdentityRepositoryService", "1.0", "application", string3, (Set)hashSet, Collections.EMPTY_MAP);
            HashMap<String, Set> hashMap = Collections.EMPTY_MAP;
            if (set != null) {
                hashMap = new HashMap<String, Set>();
                hashMap.put(DELEGATION_ATTRS_NAME, set);
            }
            if (!delegationEvaluator.isAllowed(sSOToken, delegationPermission, hashMap)) {
                Object[] objectArray = new Object[]{idOperation.getName(), sSOToken.getPrincipal().getName()};
                throw new IdRepoException("amIdRepo", "402", objectArray);
            }
            return true;
        }
        catch (DelegationException delegationException) {
            idd.error("AMDirectoryManager.checkPermission Got Delegation Exception: ", delegationException);
            Object[] objectArray = new Object[]{idOperation.getName(), sSOToken.getPrincipal().getName()};
            throw new IdRepoException("amIdRepo", "402", objectArray);
        }
    }

    private boolean checkRealmPermission(SSOToken sSOToken, String string, Set set) {
        boolean bl;
        block5: {
            bl = false;
            if (sSOToken != null) {
                try {
                    DelegationEvaluator delegationEvaluator = new DelegationEvaluator();
                    DelegationPermission delegationPermission = new DelegationPermission(string, "sunAMRealmService", "1.0", "*", "*", set, Collections.EMPTY_MAP);
                    if (delegationEvaluator.isAllowed(sSOToken, delegationPermission, null)) {
                        bl = true;
                    }
                }
                catch (DelegationException delegationException) {
                    debug.error("AMDirectoryManager.checkRealmPermission: Got Delegation Exception: ", delegationException);
                }
                catch (SSOException sSOException) {
                    if (!debug.messageEnabled()) break block5;
                    debug.message("AMDirectoryManager.checkRealmPermission: Invalid SSOToken: ", sSOException);
                }
            }
        }
        return bl;
    }
}

