/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMCommonUtils;
import com.iplanet.am.sdk.AMDCTree;
import com.iplanet.am.sdk.AMDirectoryManager;
import com.iplanet.am.sdk.AMEntryExistsException;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMHashMap;
import com.iplanet.am.sdk.AMNamingAttrManager;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.sdk.AMUserImpl;
import com.iplanet.am.sdk.CacheBlock;
import com.iplanet.am.sdk.CacheStats;
import com.iplanet.am.util.Cache;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.security.AdminTokenAction;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import netscape.ldap.util.DN;

class AMCacheManager
extends AMDirectoryManager {
    private static boolean cachingEnabled = true;
    private static int maxSize = 10000;
    private static AMDirectoryManager instance = null;
    protected static Cache sdkCache;
    private CacheStats cacheStats;
    protected static Cache idrepoCache;

    private static void initializeParams() {
        String string = SystemProperties.get("com.iplanet.am.sdk.cache.maxSize", "10000");
        try {
            maxSize = Integer.parseInt(string);
            if (maxSize < 1) {
                maxSize = 10000;
            }
            if (AMDirectoryManager.debug.messageEnabled()) {
                AMDirectoryManager.debug.message("AMCachingManager.intializeParams() Caching size set to: " + maxSize);
            }
        }
        catch (NumberFormatException numberFormatException) {
            maxSize = 10000;
            AMDirectoryManager.debug.warning("AMCachingManager.initializeParams() - invalid value for cache size specified. Setting to default value: " + maxSize);
        }
    }

    private AMCacheManager() {
        this.initializeCache();
        this.cacheStats = CacheStats.getInstance();
    }

    private void initializeCache() {
        sdkCache = new Cache(maxSize);
        idrepoCache = new Cache(maxSize);
    }

    protected int getCachesize() {
        return sdkCache.size();
    }

    protected static synchronized AMDirectoryManager getInstance() {
        if (instance == null) {
            AMDirectoryManager.debug.message("AMCacheManager.getInstance(): Creating a new Instance of AMCacheManager()");
            instance = new AMCacheManager();
        }
        return instance;
    }

    protected static int getMaxSize() {
        return maxSize;
    }

    protected static boolean isCachingEnabled() {
        return cachingEnabled;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n<<<<<<< BEGIN SDK CACHE CONTENTS >>>>>>>>");
        if (!sdkCache.isEmpty()) {
            Enumeration enumeration = sdkCache.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                CacheBlock cacheBlock = (CacheBlock)sdkCache.get(string);
                stringBuffer.append("\nSDK Cache Block: ").append(string);
                stringBuffer.append(cacheBlock.toString());
            }
        } else {
            stringBuffer.append("<empty>");
        }
        stringBuffer.append("\n<<<<<<< END SDK CACHE CONTENTS >>>>>>>>");
        return stringBuffer.toString();
    }

    private void removeCachedAttributes(Cache cache, String string, Set set) {
        Enumeration enumeration = cache.keys();
        while (enumeration.hasMoreElements()) {
            CacheBlock cacheBlock;
            int n;
            int n2;
            String string2 = (String)enumeration.nextElement();
            if (!string2.regionMatches(true, (n2 = string2.length()) - (n = string.length()), string, 0, n) || (cacheBlock = (CacheBlock)cache.get(string2)) == null || !cacheBlock.isExists()) continue;
            cacheBlock.removeAttributes(set);
        }
    }

    private void clearCachedEntries(Cache cache, String string) {
        Enumeration enumeration = cache.keys();
        while (enumeration.hasMoreElements()) {
            CacheBlock cacheBlock;
            int n;
            int n2;
            String string2 = (String)enumeration.nextElement();
            if (!string2.regionMatches(true, (n2 = string2.length()) - (n = string.length()), string, 0, n) || (cacheBlock = (CacheBlock)cache.get(string2)) == null) continue;
            cacheBlock.clear();
        }
    }

    protected void dirtyCache(Cache cache, String string, int n, boolean bl, boolean bl2, Set set) {
        String string2 = string;
        string = AMCommonUtils.formatToRFC(string);
        switch (n) {
            case 1: {
                CacheBlock cacheBlock = this.getFromCache(cache, string);
                if (cacheBlock != null) {
                    cacheBlock.setExists(true);
                }
                if (!bl) break;
                this.removeCachedAttributes(cache, string, set);
                break;
            }
            case 2: {
                CacheBlock cacheBlock = (CacheBlock)cache.remove(string);
                if (cacheBlock != null) {
                    cacheBlock.clear();
                }
                if (!bl) break;
                this.removeCachedAttributes(cache, string, set);
                break;
            }
            case 8: {
                CacheBlock cacheBlock = (CacheBlock)cache.remove(string);
                if (cacheBlock != null) {
                    cacheBlock.clear();
                }
                if (!bl) break;
                this.removeCachedAttributes(cache, string, set);
                break;
            }
            case 4: {
                CacheBlock cacheBlock = this.getFromCache(cache, string);
                if (cacheBlock != null) {
                    cacheBlock.clear();
                }
                if (bl) {
                    this.removeCachedAttributes(cache, string, set);
                    break;
                }
                if (!bl2) break;
                this.clearCachedEntries(cache, string);
            }
        }
        if (AMDirectoryManager.debug.messageEnabled()) {
            AMDirectoryManager.debug.message("AMCacheManager.dirtyCache(): Cache dirtied because of Event Notification. Parameters - eventType: " + n + ", cosType: " + bl + ", aciChange: " + bl2 + ", fullDN: " + string2 + "; rfcDN =" + string);
        }
        string = string2;
    }

    public synchronized void clearCache() {
        sdkCache.clear();
        idrepoCache.clear();
        this.initializeCache();
    }

    private synchronized void removeFromCache(Cache cache, String string) {
        String string2 = AMCommonUtils.formatToRFC(string);
        cache.remove(string2);
    }

    private void dirtyCache(String string) {
        String string2 = AMCommonUtils.formatToRFC(string);
        CacheBlock cacheBlock = (CacheBlock)sdkCache.get(string2);
        if (cacheBlock != null) {
            cacheBlock.clear();
        }
    }

    private void dirtyCache(Cache cache, Set set) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = AMCommonUtils.formatToRFC(string);
            CacheBlock cacheBlock = this.getFromCache(cache, string2);
            if (cacheBlock == null) continue;
            cacheBlock.clear();
        }
    }

    private void updateCache(SSOToken sSOToken, Cache cache, String string, Map map, Map map2) throws SSOException {
        String string2 = AMCommonUtils.formatToRFC(string);
        CacheBlock cacheBlock = (CacheBlock)cache.get(string2);
        if (cacheBlock != null && cacheBlock.isExists()) {
            String string3 = AMCommonUtils.getPrincipalDN(sSOToken);
            cacheBlock.replaceAttributes(string3, map, map2);
        }
    }

    public void createEntry(SSOToken sSOToken, String string, int n, String string2, Map map) throws AMEntryExistsException, AMException {
        super.createEntry(sSOToken, string, n, string2, map);
        String string3 = AMNamingAttrManager.getNamingAttr(n) + "=" + string + "," + string2;
        this.removeFromCache(sdkCache, string3);
    }

    private void validateEntry(SSOToken sSOToken, CacheBlock cacheBlock) throws AMException {
        if (!cacheBlock.isExists()) {
            Object[] objectArray = new String[]{cacheBlock.getEntryDN()};
            boolean bl = super.doesEntryExists(sSOToken, objectArray[0]);
            if (AMDirectoryManager.debug.messageEnabled()) {
                AMDirectoryManager.debug.message("AMCacheManager : validateEntry :DN " + objectArray[0] + " got from DS & exists: " + bl);
            }
            if (bl) {
                String string = AMCommonUtils.formatToRFC(objectArray[0]);
                cacheBlock = new CacheBlock((String)objectArray[0], bl);
                sdkCache.put(string, cacheBlock);
            } else {
                String string = AMCommonUtils.getUserLocale(sSOToken);
                throw new AMException(AMSDKBundle.getString("461", objectArray, string), "461", objectArray);
            }
        }
    }

    public boolean doesEntryExists(SSOToken sSOToken, String string) {
        String string2 = AMCommonUtils.formatToRFC(string);
        CacheBlock cacheBlock = (CacheBlock)sdkCache.get(string2);
        if (cacheBlock != null) {
            if (AMDirectoryManager.debug.messageEnabled()) {
                AMDirectoryManager.debug.message("AMCacheManager.doesEntryExist(): entryDN: " + string + " found in cache & exists: " + cacheBlock.isExists());
            }
            return cacheBlock.isExists();
        }
        boolean bl = super.doesEntryExists(sSOToken, string2);
        if (AMDirectoryManager.debug.messageEnabled()) {
            AMDirectoryManager.debug.message("AMCacheManager.doesEntryExist(): entryDN: " + string + " got from DS & exists: " + bl);
        }
        cacheBlock = new CacheBlock(string, bl);
        sdkCache.put(string2, cacheBlock);
        return bl;
    }

    private void setOrganizationDNs(String string, Set set) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            CacheBlock cacheBlock = (CacheBlock)sdkCache.get(string2);
            if (cacheBlock == null) {
                cacheBlock = new CacheBlock(string2, string, true);
                sdkCache.put(string2, cacheBlock);
                continue;
            }
            cacheBlock.setOrganizationDN(string);
        }
        if (AMDirectoryManager.debug.messageEnabled() && !set.isEmpty()) {
            AMDirectoryManager.debug.message("AMCacheManager.setOrganizationDNs(): Set org DNs as: " + string + " for children: " + set);
        }
    }

    public void updateUserAttribute(SSOToken sSOToken, Set set, String string, boolean bl) throws AMException {
        super.updateUserAttribute(sSOToken, set, string, bl);
        this.dirtyCache(sdkCache, set);
    }

    public String getOrganizationDN(SSOToken sSOToken, String string) throws AMException {
        if (string.equals("") || !DN.isDN(string)) {
            AMDirectoryManager.debug.error("AMCacheManager.getOrganizationDN() Invalid DN: " + string);
            throw new AMException(sSOToken, "157");
        }
        DN dN = new DN(string);
        String string2 = "";
        HashSet<String> hashSet = new HashSet<String>();
        boolean bl = false;
        boolean bl2 = false;
        while (!bl && !bl2) {
            CacheBlock cacheBlock;
            boolean bl3 = true;
            String string3 = dN.toRFCString().toLowerCase();
            if (AMDirectoryManager.debug.messageEnabled()) {
                AMDirectoryManager.debug.message("AMCacheManager.getOrganizationDN() - looping Organization DN for entry: " + string3);
            }
            if ((cacheBlock = (CacheBlock)sdkCache.get(string3)) != null) {
                string2 = cacheBlock.getOrganizationDN();
                if (string2 != null) {
                    if (AMDirectoryManager.debug.messageEnabled()) {
                        AMDirectoryManager.debug.message("AMCacheManager.getOrganizationDN(): found OrganizationDN: " + string2 + " for: " + string3);
                    }
                    bl2 = true;
                    this.setOrganizationDNs(string2, hashSet);
                    continue;
                }
                if (cacheBlock.getObjectType() == 2 || cacheBlock.getObjectType() == 3) {
                    string2 = string3;
                    bl2 = true;
                    hashSet.add(string3);
                    this.setOrganizationDNs(string2, hashSet);
                    continue;
                }
                if (cacheBlock.getObjectType() != -9999) {
                    bl3 = false;
                }
            }
            hashSet.add(string3);
            if (bl3) {
                string2 = this.dMgr.verifyAndGetOrgDN(sSOToken, string, string3);
            }
            if (string2 != null && string2.length() > 0) {
                bl2 = true;
                this.setOrganizationDNs(string2, hashSet);
                continue;
            }
            if (dN.countRDNs() == 1) {
                bl = true;
                AMDirectoryManager.debug.error("AMCacheManager.getOrgnizationDN(): Reached root suffix. Unable to get parent Org");
                continue;
            }
            dN = dN.getParent();
        }
        return string2;
    }

    public int getObjectType(SSOToken sSOToken, String string) throws AMException, SSOException {
        int n = -9999;
        String string2 = AMCommonUtils.formatToRFC(string);
        CacheBlock cacheBlock = (CacheBlock)sdkCache.get(string2);
        if (cacheBlock != null) {
            this.validateEntry(sSOToken, cacheBlock);
            n = cacheBlock.getObjectType();
            if (n != -9999) {
                return n;
            }
        }
        SSOToken sSOToken2 = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        if (cacheBlock == null) {
            n = super.getObjectType(sSOToken2, string2);
            cacheBlock = new CacheBlock(string2, true);
            sdkCache.put(string2, cacheBlock);
        } else {
            n = super.getObjectType(sSOToken2, string2, cacheBlock.getAttributes(AMCommonUtils.getPrincipalDN(sSOToken2), false));
        }
        cacheBlock.setObjectType(n);
        if (n == 2 || n == 3) {
            cacheBlock.setOrganizationDN(string2);
        }
        return n;
    }

    public Map getExternalAttributes(SSOToken sSOToken, String string, Set set, int n) throws AMException {
        String string2 = n == 1 ? new DN(string).getParent().toString() : string;
        String string3 = this.getOrganizationDN(sSOToken, string2);
        if (AMCommonUtils.isExternalGetAttributesEnabled(string3)) {
            return super.getExternalAttributes(sSOToken, string, set, n);
        }
        return null;
    }

    public Map getAttributes(SSOToken sSOToken, String string, int n) throws AMException, SSOException {
        boolean bl = true;
        boolean bl2 = false;
        return this.getAttributes(sSOToken, string, bl, bl2, n);
    }

    public Map getAttributes(SSOToken sSOToken, String string, Set set, int n) throws AMException, SSOException {
        boolean bl = true;
        boolean bl2 = false;
        return this.getAttributes(sSOToken, string, set, bl, bl2, n);
    }

    public Map getAttributesByteValues(SSOToken sSOToken, String string, int n) throws AMException, SSOException {
        boolean bl = true;
        boolean bl2 = true;
        return this.getAttributes(sSOToken, string, bl2, bl, n);
    }

    public Map getAttributesByteValues(SSOToken sSOToken, String string, Set set, int n) throws AMException, SSOException {
        boolean bl = true;
        boolean bl2 = true;
        return this.getAttributes(sSOToken, string, set, bl2, bl, n);
    }

    public Map getAttributes(SSOToken sSOToken, String string, boolean bl, boolean bl2, int n) throws AMException, SSOException {
        AMHashMap aMHashMap;
        CacheBlock cacheBlock;
        this.cacheStats.incrementRequestCount();
        String string2 = AMCommonUtils.getPrincipalDN(sSOToken);
        String string3 = AMCommonUtils.formatToRFC(string);
        if (AMDirectoryManager.debug.messageEnabled()) {
            AMDirectoryManager.debug.message("In AMCacheManager.getAttributes(SSOTokenentryDN, ignoreCompliance) (" + string2 + ", " + string + ", " + bl + " method.");
        }
        if ((cacheBlock = (CacheBlock)sdkCache.get(string3)) != null) {
            this.validateEntry(sSOToken, cacheBlock);
            if (cacheBlock.hasCompleteSet(string2)) {
                this.cacheStats.updateHitCount();
                if (AMDirectoryManager.debug.messageEnabled()) {
                    AMDirectoryManager.debug.message("AMCacheManager.getAttributes(): foundall attributes in Cache.");
                }
                aMHashMap = (AMHashMap)cacheBlock.getAttributes(string2, bl2);
            } else {
                if (AMDirectoryManager.debug.messageEnabled()) {
                    AMDirectoryManager.debug.message("AMCacheManager.getAttributes():  complete attribute set NOT found in cache. Getting from DS.");
                }
                aMHashMap = (AMHashMap)super.getAttributes(sSOToken, string, bl, bl2, n);
                cacheBlock.putAttributes(string2, aMHashMap, null, true, bl2);
            }
        } else {
            aMHashMap = (AMHashMap)super.getAttributes(sSOToken, string, bl, bl2, n);
            cacheBlock = new CacheBlock(string, true);
            cacheBlock.putAttributes(string2, aMHashMap, null, true, bl2);
            if (AMDirectoryManager.debug.messageEnabled()) {
                AMDirectoryManager.debug.message("AMCacheManager.getAttributes(): attributes NOT found in cache. Fetched from DS.");
            }
            sdkCache.put(string3, cacheBlock);
        }
        Map map = this.getExternalAttributes(sSOToken, string, null, n);
        if (map != null && !map.isEmpty()) {
            if (AMDirectoryManager.debug.messageEnabled()) {
                AMDirectoryManager.debug.message("AMCacheManager.getAttributes(): External attributes present. Adding them with original list");
            }
            aMHashMap.putAll(map);
        }
        return aMHashMap;
    }

    private AMHashMap getPluginAttrsAndUpdateCache(SSOToken sSOToken, String string, String string2, CacheBlock cacheBlock, AMHashMap aMHashMap, Set set, boolean bl, int n) throws AMException {
        Map map = this.getExternalAttributes(sSOToken, string2, set, n);
        if (map != null && !map.isEmpty()) {
            Set set2 = map.keySet();
            cacheBlock.removeAttributes(set2);
            if (AMDirectoryManager.debug.messageEnabled()) {
                AMDirectoryManager.debug.message("AMCacheManager.getPluginAttrsAndUpdateCache(): External attributes present. Adding them with original list. External Attributes: " + set2);
            }
            aMHashMap.putAll(map);
        }
        return aMHashMap;
    }

    public Map getAttributes(SSOToken sSOToken, String string, Set set, boolean bl, boolean bl2, int n) throws AMException, SSOException {
        String string2;
        CacheBlock cacheBlock;
        if (set == null || set.isEmpty()) {
            return this.getAttributes(sSOToken, string, bl, bl2, n);
        }
        this.cacheStats.incrementRequestCount();
        if (AMDCTree.isRequired()) {
            this.getAttributes(sSOToken, string, bl, bl2, n);
        }
        String string3 = AMCommonUtils.getPrincipalDN(sSOToken);
        if (AMDirectoryManager.debug.messageEnabled()) {
            AMDirectoryManager.debug.message("In AMCacheManager.getAttributes(SSOTokenentryDN, attrNames, ignoreCompliance, byteValues) (" + string3 + ", " + string + ", " + set + ", " + bl + ", " + bl2 + " method.");
        }
        if ((cacheBlock = (CacheBlock)sdkCache.get(string2 = AMCommonUtils.formatToRFC(string))) == null) {
            if (AMDirectoryManager.debug.messageEnabled()) {
                AMDirectoryManager.debug.message("AMCacheManager.getAttributes():  NO entry found in Cache. Getting all these attributes from DS: " + set);
            }
            AMHashMap aMHashMap = (AMHashMap)super.getAttributes(sSOToken, string, set, bl, bl2, n);
            Set set2 = aMHashMap.getMissingAndEmptyKeys(set);
            cacheBlock = new CacheBlock(string2, true);
            cacheBlock.putAttributes(string3, aMHashMap, set2, false, bl2);
            sdkCache.put(string2, cacheBlock);
            if (!set2.isEmpty()) {
                aMHashMap = this.getPluginAttrsAndUpdateCache(sSOToken, string3, string, cacheBlock, aMHashMap, set2, bl2, n);
            }
            return aMHashMap;
        }
        this.validateEntry(sSOToken, cacheBlock);
        AMHashMap aMHashMap = (AMHashMap)cacheBlock.getAttributes(string3, set, bl2);
        Set set3 = aMHashMap.getMissingKeys(set);
        if (!set3.isEmpty()) {
            boolean bl3 = cacheBlock.hasCompleteSet(string3);
            if (!bl3 || set3.contains(AMUserImpl.roleDNsAN) || set3.contains(AMUserImpl.nsroleAN)) {
                AMHashMap aMHashMap2;
                if (AMDirectoryManager.debug.messageEnabled()) {
                    AMDirectoryManager.debug.message("AMCacheManager.getAttributes(): Trying to get these missing attributes from DS: " + set3);
                }
                if ((aMHashMap2 = (AMHashMap)super.getAttributes(sSOToken, string, set3, bl, bl2, n)) != null) {
                    aMHashMap.putAll(aMHashMap2);
                    Set set4 = aMHashMap2.getMissingAndEmptyKeys(set3);
                    aMHashMap2.putAll(cacheBlock.getAttributes(string3, bl2));
                    cacheBlock.putAttributes(string3, aMHashMap2, set4, bl3, bl2);
                    set3 = set4;
                }
            } else {
                cacheBlock.putAttributes(string3, cacheBlock.getAttributes(string3, bl2), set3, bl3, bl2);
            }
            if (!set3.isEmpty()) {
                aMHashMap = this.getPluginAttrsAndUpdateCache(sSOToken, string3, string, cacheBlock, aMHashMap, set3, bl2, n);
            }
        } else {
            if (AMDirectoryManager.debug.messageEnabled()) {
                AMDirectoryManager.debug.message("AMCacheManager.getAttributes():  found all attributes in Cache.");
            }
            this.cacheStats.updateHitCount();
        }
        return aMHashMap;
    }

    public String renameEntry(SSOToken sSOToken, int n, String string, String string2, boolean bl) throws AMException {
        String string3 = super.renameEntry(sSOToken, n, string, string2, bl);
        String string4 = AMCommonUtils.formatToRFC(string);
        CacheBlock cacheBlock = (CacheBlock)sdkCache.remove(string4);
        string3 = AMCommonUtils.formatToRFC(string3);
        sdkCache.put(string3, cacheBlock);
        return string3;
    }

    public void setAttributes(SSOToken sSOToken, String string, int n, Map map, Map map2, boolean bl) throws AMException, SSOException {
        super.setAttributes(sSOToken, string, n, map, map2, bl);
        if (n == 1) {
            this.updateCache(sSOToken, sdkCache, string, map, map2);
        } else if (n != 1) {
            this.dirtyCache(string);
        }
    }

    public void removeEntry(SSOToken sSOToken, String string, int n, boolean bl, boolean bl2) throws AMException, SSOException {
        super.removeEntry(sSOToken, string, n, bl, bl2);
        this.removeFromCache(sdkCache, string);
    }

    public String createAMTemplate(SSOToken sSOToken, String string, int n, String string2, Map map, int n2) throws AMException {
        String string3 = super.createAMTemplate(sSOToken, string, n, string2, map, n2);
        String string4 = AMCommonUtils.formatToRFC(string3);
        CacheBlock cacheBlock = (CacheBlock)sdkCache.get(string4);
        if (cacheBlock != null) {
            cacheBlock.setExists(true);
        }
        return string3;
    }

    public Map getAttributes(SSOToken sSOToken, IdType idType, String string, Set set, String string2, String string3) throws IdRepoException, SSOException {
        AMIdentity aMIdentity = new AMIdentity(sSOToken, string, idType, string2, string3);
        String string4 = IdUtils.getUniversalId(aMIdentity).toLowerCase();
        AMIdentity aMIdentity2 = IdUtils.getIdentity(sSOToken);
        String string5 = IdUtils.getUniversalId(aMIdentity2).toLowerCase();
        CacheBlock cacheBlock = (CacheBlock)idrepoCache.get(string4);
        if (set == null || set.isEmpty()) {
            return this.getAttributes(sSOToken, idType, string, string2, string3);
        }
        if (AMDirectoryManager.debug.messageEnabled()) {
            AMDirectoryManager.debug.message("In AMCacheManager.getAttributes(SSOTokentype, name, attrNames, amOrgName, amsdkDN) (" + string5 + ", " + string4 + ", " + set + " ," + string2 + " , " + string3 + " method.");
        }
        if (cacheBlock == null) {
            if (AMDirectoryManager.debug.messageEnabled()) {
                AMDirectoryManager.debug.message("AMCacheManager.getAttributes():  NO entry found in Cachefor key = " + string4 + ". Getting all these attributes from DS: " + set);
            }
            AMHashMap aMHashMap = (AMHashMap)super.getAttributes(sSOToken, idType, string, set, string2, string3, true);
            Set set2 = aMHashMap.getMissingAndEmptyKeys(set);
            cacheBlock = new CacheBlock(string4, true);
            cacheBlock.putAttributes(string5, aMHashMap, set2, false, false);
            idrepoCache.put(string4, cacheBlock);
            return aMHashMap;
        }
        AMHashMap aMHashMap = (AMHashMap)cacheBlock.getAttributes(string5, set, false);
        Set set3 = aMHashMap.getMissingKeys(set);
        if (!set3.isEmpty()) {
            if (AMDirectoryManager.debug.messageEnabled()) {
                AMDirectoryManager.debug.message("AMCacheManager.getAttributes(): Trying to get these missing attributes from DS: " + set3);
            }
            AMHashMap aMHashMap2 = (AMHashMap)super.getAttributes(sSOToken, idType, string, set, string2, string3, true);
            aMHashMap.putAll(aMHashMap2);
            Set set4 = aMHashMap2.getMissingAndEmptyKeys(set3);
            cacheBlock.putAttributes(string5, aMHashMap2, set4, false, false);
        } else if (AMDirectoryManager.debug.messageEnabled()) {
            AMDirectoryManager.debug.message("AMCacheManager.getAttributes():  found all attributes in Cache.");
        }
        return aMHashMap;
    }

    public Map getAttributes(SSOToken sSOToken, IdType idType, String string, String string2, String string3) throws IdRepoException, SSOException {
        AMHashMap aMHashMap;
        AMIdentity aMIdentity = new AMIdentity(sSOToken, string, idType, string2, string3);
        String string4 = IdUtils.getUniversalId(aMIdentity).toLowerCase();
        AMIdentity aMIdentity2 = IdUtils.getIdentity(sSOToken);
        String string5 = IdUtils.getUniversalId(aMIdentity2).toLowerCase();
        CacheBlock cacheBlock = (CacheBlock)idrepoCache.get(string4);
        if (cacheBlock != null) {
            if (cacheBlock.hasCompleteSet(string5)) {
                if (AMDirectoryManager.debug.messageEnabled()) {
                    AMDirectoryManager.debug.message("AMCacheManager.getAttributes(): foundall attributes in Cache.");
                }
                aMHashMap = (AMHashMap)cacheBlock.getAttributes(string5, false);
            } else {
                if (AMDirectoryManager.debug.messageEnabled()) {
                    AMDirectoryManager.debug.message("AMCacheManager.getAttributes():  complete attribute set NOT found in cache. Getting from DS.");
                }
                aMHashMap = (AMHashMap)super.getAttributes(sSOToken, idType, string, string2, string3);
                cacheBlock.putAttributes(string5, aMHashMap, null, true, false);
            }
        } else {
            aMHashMap = (AMHashMap)super.getAttributes(sSOToken, idType, string, string2, string3);
            cacheBlock = new CacheBlock(string4, true);
            cacheBlock.putAttributes(string5, aMHashMap, null, true, false);
            idrepoCache.put(string4, cacheBlock);
            if (AMDirectoryManager.debug.messageEnabled()) {
                AMDirectoryManager.debug.message("AMCacheManager.getAttributes(): attributes NOT found in cache. Fetched from DS.");
            }
        }
        return aMHashMap;
    }

    public void setAttributes(SSOToken sSOToken, IdType idType, String string, Map map, boolean bl, String string2, String string3) throws IdRepoException, SSOException {
        super.setAttributes(sSOToken, idType, string, map, bl, string2, string3, true);
        AMIdentity aMIdentity = new AMIdentity(sSOToken, string, idType, string2, string3);
        String string4 = IdUtils.getUniversalId(aMIdentity).toLowerCase();
        if (idType.equals(IdType.USER)) {
            this.updateCache(sSOToken, idrepoCache, string4, map, null);
        } else {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(string4);
            this.dirtyCache(idrepoCache, hashSet);
        }
    }

    public void setGroupFilter(SSOToken sSOToken, String string, String string2) throws AMException, SSOException {
        super.setGroupFilter(sSOToken, string, string2);
    }

    private CacheBlock getFromCache(Cache cache, String string) {
        int n;
        CacheBlock cacheBlock = (CacheBlock)cache.get(string);
        if (cacheBlock == null && (n = string.indexOf("amsdkdn=")) > -1) {
            String string2 = string.substring(0, n);
            cacheBlock = (CacheBlock)cache.get(string2);
        }
        return cacheBlock;
    }

    static {
        AMCacheManager.initializeParams();
    }
}

