/*
 * Decompiled with CFR 0.152.
 */
package com.sun.liberty;

import com.iplanet.am.util.AMURLEncDec;
import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.federation.accountmgmt.FSAccountManager;
import com.sun.identity.federation.accountmgmt.FSAccountMgmtException;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSCircleOfTrustDescriptor;
import com.sun.identity.federation.alliance.FSHostedProviderDescriptor;
import com.sun.identity.federation.alliance.FSLocalConfigurationDescriptor;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSNameIdentifierMappingRequest;
import com.sun.identity.federation.message.FSNameIdentifierMappingResponse;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.federation.services.FSLoginHelper;
import com.sun.identity.federation.services.FSLoginHelperException;
import com.sun.identity.federation.services.FSSOAPService;
import com.sun.identity.federation.services.FSSession;
import com.sun.identity.federation.services.FSSessionManager;
import com.sun.identity.federation.services.FSSessionPartner;
import com.sun.identity.federation.services.namemapping.FSNameMappingHandler;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.common.SAMLException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LibertyManager {
    static Debug debug = null;
    static boolean messageEnabled = false;
    private static FSAllianceManager allianceMgr = null;
    private static FSAccountManager accountMgr = null;

    public static Iterator getIDPList() {
        Set set = null;
        HashSet<String> hashSet = new HashSet<String>();
        try {
            set = allianceMgr.getAllActiveProviderIds();
            if (set != null && !set.isEmpty()) {
                Iterator iterator = set.iterator();
                FSProviderDescriptor fSProviderDescriptor = null;
                while (iterator.hasNext()) {
                    String string;
                    String string2 = (String)iterator.next();
                    fSProviderDescriptor = allianceMgr.getProvider(string2);
                    String string3 = fSProviderDescriptor.getProviderRole();
                    if ((string3 = string3.toLowerCase()).indexOf(string = "IDP".toLowerCase()) == -1) continue;
                    hashSet.add(string2);
                }
            }
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            debug.error("LibertyManager: getIDPList: Error while getting  Active ProviderIds  ", (Throwable)((Object)fSAllianceManagementException));
        }
        return hashSet.iterator();
    }

    public static Iterator getIDPList(String string) {
        return LibertyManager.getList(string, "SP", "IDP");
    }

    public static Iterator getSPList() {
        Set set = null;
        HashSet<String> hashSet = new HashSet<String>();
        try {
            set = allianceMgr.getAllActiveProviderIds();
            if (set != null && !set.isEmpty()) {
                Iterator iterator = set.iterator();
                FSProviderDescriptor fSProviderDescriptor = null;
                while (iterator.hasNext()) {
                    String string;
                    String string2 = (String)iterator.next();
                    fSProviderDescriptor = allianceMgr.getProvider(string2);
                    String string3 = fSProviderDescriptor.getProviderRole();
                    if ((string3 = string3.toLowerCase()).indexOf(string = "SP".toLowerCase()) == -1) continue;
                    hashSet.add(string2);
                }
            }
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            debug.error("LibertyManager: getIDPList: Error while getting  Active ProviderIds  ", (Throwable)((Object)fSAllianceManagementException));
            return null;
        }
        return hashSet.iterator();
    }

    public static Iterator getSPList(String string) {
        return LibertyManager.getList(string, "IDP", "SP");
    }

    public static boolean getIDPFederationStatus(String string, String string2) {
        boolean bl = false;
        try {
            bl = accountMgr.isFederationActive(string, string2);
        }
        catch (FSAccountMgmtException fSAccountMgmtException) {
            debug.error("LibertyManager: getIDPFederationStatus: Couldnot get Federation Status ", (Throwable)((Object)fSAccountMgmtException));
        }
        return bl;
    }

    public static boolean getSPFederationStatus(String string, String string2) {
        boolean bl = false;
        try {
            bl = accountMgr.isFederationActive(string, string2);
        }
        catch (FSAccountMgmtException fSAccountMgmtException) {
            debug.error("LibertyManager: getIDPFederationStatus: Couldnot get Federation Status ", (Throwable)((Object)fSAccountMgmtException));
        }
        return bl;
    }

    public static String getNonce(String string) {
        Random random = new Random();
        long l = random.nextLong();
        String string2 = String.valueOf(l);
        return string2;
    }

    public static boolean checkNonce(String string, String string2) {
        return true;
    }

    public static String getIntroducedProvider(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getParameter("_liberty_idp");
        return string;
    }

    private static Iterator getList(String string, String string2, String string3) {
        HashSet<String> hashSet = new HashSet<String>();
        Set set = new HashSet();
        FSHostedProviderDescriptor fSHostedProviderDescriptor = null;
        FSLocalConfigurationDescriptor fSLocalConfigurationDescriptor = null;
        string3 = string3.toLowerCase();
        if (string == null) {
            debug.error("LibertyManager: getIDPList: null ProviderID");
            return null;
        }
        if (messageEnabled) {
            debug.message("LibertyManager: ProviderID is " + string + " and Role is " + string3);
        }
        try {
            FSProviderDescriptor fSProviderDescriptor = null;
            fSHostedProviderDescriptor = allianceMgr.getHostedProvider(string, string2);
            fSLocalConfigurationDescriptor = fSHostedProviderDescriptor.getLocalConfiguration();
            set = fSLocalConfigurationDescriptor.getTrustedProviders();
            if (set != null && !set.isEmpty()) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    fSProviderDescriptor = allianceMgr.getProvider(string4);
                    String string5 = fSProviderDescriptor.getProviderStatus();
                    String string6 = fSProviderDescriptor.getProviderRole().toLowerCase();
                    if (messageEnabled) {
                        debug.message("LibertyManager: For providerId " + string4 + " status is " + string5 + " and Role is " + string6);
                    }
                    if (!string5.equals("active") || string6.indexOf(string3) == -1) continue;
                    hashSet.add(string4);
                }
            }
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            debug.error("LibertyManager: Error getting providerDesc", (Throwable)((Object)fSAllianceManagementException));
        }
        return hashSet.iterator();
    }

    public static String getMetaAliasKey() {
        return "metaAlias";
    }

    public static String getTerminationProviderIDKey() {
        return "_liberty_id";
    }

    public static String getRequestIDKey() {
        return "RequestID";
    }

    public static String getProviderIDKey() {
        return "_liberty_idp";
    }

    public static String getLRURLKey() {
        return "RelayState";
    }

    public static String getCOTKey() {
        return "cotkey";
    }

    public static String getSelectedProviderKey() {
        return "selectedprovider";
    }

    public static String getFedErrorKey() {
        return "federror";
    }

    public static String getFedRemarkKey() {
        return "fedremark";
    }

    public static String getUser(HttpServletRequest httpServletRequest) {
        SSOToken sSOToken = null;
        try {
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            sSOToken = sSOTokenManager.createSSOToken(httpServletRequest);
            if (sSOToken != null && sSOTokenManager.isValidToken(sSOToken)) {
                debug.message("LibertyManager: getUser: token is valid");
                AMIdentity aMIdentity = IdUtils.getIdentity(sSOToken);
                return IdUtils.getUniversalId(aMIdentity);
            }
            return null;
        }
        catch (SSOException sSOException) {
            debug.error("LibertyManager: getUser: SSOException: ", (Throwable)sSOException);
            return null;
        }
        catch (IdRepoException idRepoException) {
            debug.error("LibertyManager: getUser: IdRepoException: ", (Throwable)idRepoException);
            return null;
        }
    }

    public static String getHomeURL(String string) {
        FSHostedProviderDescriptor fSHostedProviderDescriptor = null;
        try {
            fSHostedProviderDescriptor = allianceMgr.getHostedProvider(string);
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            debug.error("LibertyManager: getHomeURL: Error  while getting the HostedProvider from Alliance mgmt", (Throwable)((Object)fSAllianceManagementException));
        }
        if (fSHostedProviderDescriptor != null) {
            String string2 = fSHostedProviderDescriptor.getLocalConfiguration().getProviderHomePageURL();
            return string2;
        }
        return null;
    }

    public static String getHomeURL(String string, String string2) {
        FSHostedProviderDescriptor fSHostedProviderDescriptor = null;
        try {
            fSHostedProviderDescriptor = allianceMgr.getHostedProvider(string, string2);
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            debug.error("LibertyManager: getHomeURL: Error  while getting the HostedProvider from Alliance mgmt", (Throwable)((Object)fSAllianceManagementException));
        }
        if (fSHostedProviderDescriptor != null) {
            String string3 = fSHostedProviderDescriptor.getLocalConfiguration().getProviderHomePageURL();
            return string3;
        }
        return null;
    }

    public static String getPreLoginServletURL(String string, HttpServletRequest httpServletRequest) {
        String string2 = LibertyManager.getMetaAlias(string);
        String string3 = FSServiceUtils.getServicesBaseURL(httpServletRequest);
        String string4 = string3 + "/preLogin";
        return string4 + "?" + "metaAlias" + "=" + string2;
    }

    public static String getPreLoginServletURL(String string, String string2, HttpServletRequest httpServletRequest) {
        String string3 = LibertyManager.getMetaAlias(string, string2);
        String string4 = FSServiceUtils.getServicesBaseURL(httpServletRequest);
        String string5 = string4 + "/preLogin";
        return string5 + "?" + "metaAlias" + "=" + string3;
    }

    public static String getLoginURL(HttpServletRequest httpServletRequest) {
        String string = FSServiceUtils.getServicesBaseURL(httpServletRequest) + "/UI/Login" + "?" + "arg" + "=" + "newsession";
        if (messageEnabled) {
            debug.message("LibertyManager: getLoginURL:  returnURL = " + string);
        }
        return string;
    }

    public static String getInterSiteURL(HttpServletRequest httpServletRequest) {
        String string = FSServiceUtils.getServicesBaseURL(httpServletRequest) + "/" + "IntersiteTransferService";
        if (messageEnabled) {
            debug.message("LibertyManager::getInterSiteURL:: returnURL = " + string);
        }
        return string;
    }

    public static String getProviderID(String string) {
        try {
            FSHostedProviderDescriptor fSHostedProviderDescriptor = allianceMgr.getHostedProviderByMetaAlias(string);
            if (fSHostedProviderDescriptor != null) {
                return fSHostedProviderDescriptor.getEntityID();
            }
            return null;
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            debug.error("LibertyManager: getProviderID: Error getting ID", (Throwable)((Object)fSAllianceManagementException));
            return null;
        }
    }

    public static Set getProvidersToFederate(String string, String string2) {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = LibertyManager.getIDPList(string);
        Set set = null;
        try {
            set = accountMgr.readAllFederatedProviderID(string, string2);
            String string3 = null;
            while (iterator.hasNext()) {
                string3 = (String)iterator.next();
                if (set.contains(string3)) continue;
                hashSet.add(string3);
            }
        }
        catch (FSAccountMgmtException fSAccountMgmtException) {
            debug.error("LibertyManager: getUnFederatedIDPList: Error while  getting allFederatedProviderID from Account Mgmt", (Throwable)((Object)fSAccountMgmtException));
        }
        return hashSet;
    }

    public static Set getFederatedProviders(String string) {
        Set set = new HashSet();
        try {
            set = accountMgr.readAllFederatedProviderID(string);
        }
        catch (FSAccountMgmtException fSAccountMgmtException) {
            debug.error("LibertyManager: getFederatedProviders: Error while  getting federatedProviderIDs from Account Mgmt", (Throwable)((Object)fSAccountMgmtException));
        }
        return set;
    }

    public static Set getListOfCOTs(String string) {
        FSHostedProviderDescriptor fSHostedProviderDescriptor = null;
        try {
            fSHostedProviderDescriptor = allianceMgr.getHostedProvider(string);
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            debug.error("LibertyManager: getListOfURL: Error  while getting the HostedProvider from Alliance mgmt", (Throwable)((Object)fSAllianceManagementException));
        }
        HashSet<String> hashSet = new HashSet<String>();
        if (fSHostedProviderDescriptor != null) {
            Set set = fSHostedProviderDescriptor.getListOfCOTs();
            if (set != null && !set.isEmpty()) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    try {
                        FSCircleOfTrustDescriptor fSCircleOfTrustDescriptor = allianceMgr.getCircleOfTrust(string2);
                        String string3 = fSCircleOfTrustDescriptor.getWriterServiceURL();
                        String string4 = fSCircleOfTrustDescriptor.getCircleOfTrustStatus();
                        if (string3 == null || string3.length() <= 0 || !string4.equalsIgnoreCase("active")) continue;
                        hashSet.add(string2);
                    }
                    catch (FSAllianceManagementException fSAllianceManagementException) {
                        debug.error("LibertyManager: getListOfCots FSAllianceManagement Exception caught ", (Throwable)((Object)fSAllianceManagementException));
                    }
                }
            }
            if (hashSet != null && hashSet.size() > 0) {
                if (messageEnabled) {
                    debug.message("LibertyManager: getListOfCots returning  cot set with " + hashSet);
                }
            } else if (messageEnabled) {
                debug.message("LibertyManager::getListOfCots returning null. Looks like COT is not set");
            }
        }
        return hashSet;
    }

    public static Set getListOfCOTs(String string, String string2) {
        FSHostedProviderDescriptor fSHostedProviderDescriptor = null;
        try {
            fSHostedProviderDescriptor = allianceMgr.getHostedProvider(string, string2);
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            debug.error("LibertyManager: getListOfURL: Error  while getting the HostedProvider from Alliance mgmt", (Throwable)((Object)fSAllianceManagementException));
        }
        HashSet<String> hashSet = new HashSet<String>();
        if (fSHostedProviderDescriptor != null) {
            Set set = fSHostedProviderDescriptor.getListOfCOTs();
            if (set != null && !set.isEmpty()) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    try {
                        FSCircleOfTrustDescriptor fSCircleOfTrustDescriptor = allianceMgr.getCircleOfTrust(string3);
                        String string4 = fSCircleOfTrustDescriptor.getWriterServiceURL();
                        String string5 = fSCircleOfTrustDescriptor.getCircleOfTrustStatus();
                        if (string4 == null || string4.length() <= 0 || !string5.equalsIgnoreCase("active")) continue;
                        hashSet.add(string3);
                    }
                    catch (FSAllianceManagementException fSAllianceManagementException) {
                        debug.error("LibertyManager: getListOfCots FSAllianceManagement Exception caught ", (Throwable)((Object)fSAllianceManagementException));
                    }
                }
            }
            if (hashSet != null && hashSet.size() > 0) {
                if (messageEnabled) {
                    debug.message("LibertyManager: getListOfCots returning  cot set with " + hashSet);
                }
            } else if (messageEnabled) {
                debug.message("LibertyManager::getListOfCots returning null. Looks like COT is not set");
            }
        }
        return hashSet;
    }

    public static String getMetaAlias(String string) {
        String string2 = "";
        try {
            FSHostedProviderDescriptor fSHostedProviderDescriptor = allianceMgr.getHostedProvider(string);
            FSLocalConfigurationDescriptor fSLocalConfigurationDescriptor = fSHostedProviderDescriptor.getLocalConfiguration();
            string2 = fSLocalConfigurationDescriptor.getProviderAlias();
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            debug.error("LibertyManager: Error Getting metaAlias", (Throwable)((Object)fSAllianceManagementException));
        }
        if (messageEnabled) {
            debug.message("LibertyManager: getMetaAlias: providerID is " + string + " and corresponding metaAlias is " + string2);
        }
        return string2;
    }

    public static String getMetaAlias(String string, String string2) {
        String string3 = "";
        try {
            FSHostedProviderDescriptor fSHostedProviderDescriptor = allianceMgr.getHostedProvider(string, string2);
            FSLocalConfigurationDescriptor fSLocalConfigurationDescriptor = fSHostedProviderDescriptor.getLocalConfiguration();
            string3 = fSLocalConfigurationDescriptor.getProviderAlias();
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            debug.error("LibertyManager: Error Getting metaAlias", (Throwable)((Object)fSAllianceManagementException));
        }
        if (messageEnabled) {
            debug.message("LibertyManager: getMetaAlias: providerID is " + string + " and corresponding metaAlias is " + string3);
        }
        return string3;
    }

    public static String getFederationDonePageURL(String string, HttpServletRequest httpServletRequest) {
        FSHostedProviderDescriptor fSHostedProviderDescriptor = null;
        try {
            fSHostedProviderDescriptor = allianceMgr.getHostedProvider(string);
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            debug.error("LibertyManager: getFederationDonePageURL: Error  while getting the HostedProvider from Alliance mgmt", (Throwable)((Object)fSAllianceManagementException));
        }
        if (fSHostedProviderDescriptor != null) {
            String string2 = fSHostedProviderDescriptor.getLocalConfiguration().getFederationDonePageURL(httpServletRequest);
            return string2;
        }
        return null;
    }

    public static String getFederationDonePageURL(String string, String string2, HttpServletRequest httpServletRequest) {
        FSHostedProviderDescriptor fSHostedProviderDescriptor = null;
        try {
            fSHostedProviderDescriptor = allianceMgr.getHostedProvider(string, string2);
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            debug.error("LibertyManager: getFederationDonePageURL: Error  while getting the HostedProvider from Alliance mgmt", (Throwable)((Object)fSAllianceManagementException));
        }
        if (fSHostedProviderDescriptor != null) {
            String string3 = fSHostedProviderDescriptor.getLocalConfiguration().getFederationDonePageURL(httpServletRequest);
            return string3;
        }
        return null;
    }

    public static String getTerminationDonePageURL(String string, HttpServletRequest httpServletRequest) {
        FSHostedProviderDescriptor fSHostedProviderDescriptor = null;
        try {
            fSHostedProviderDescriptor = allianceMgr.getHostedProvider(string);
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            debug.error("LibertyManager: getTerminationDonePageURL: Error  while getting the HostedProvider from Alliance mgmt", (Throwable)((Object)fSAllianceManagementException));
        }
        if (fSHostedProviderDescriptor != null) {
            String string2 = fSHostedProviderDescriptor.getLocalConfiguration().getTerminationDonePageURL(httpServletRequest);
            return string2;
        }
        return null;
    }

    public static String getTerminationDonePageURL(String string, String string2, HttpServletRequest httpServletRequest) {
        FSHostedProviderDescriptor fSHostedProviderDescriptor = null;
        try {
            fSHostedProviderDescriptor = allianceMgr.getHostedProvider(string, string2);
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            debug.error("LibertyManager: getTerminationDonePageURL: Error  while getting the HostedProvider from Alliance mgmt", (Throwable)((Object)fSAllianceManagementException));
        }
        if (fSHostedProviderDescriptor != null) {
            String string3 = fSHostedProviderDescriptor.getLocalConfiguration().getTerminationDonePageURL(httpServletRequest);
            return string3;
        }
        return null;
    }

    public static String getTerminationURL(String string, HttpServletRequest httpServletRequest) {
        String string2 = LibertyManager.getMetaAlias(string);
        String string3 = FSServiceUtils.getServicesBaseURL(httpServletRequest);
        return string3 + "/federation-terminate" + "?" + "metaAlias" + "=" + string2;
    }

    public static String getTerminationURL(String string, String string2, HttpServletRequest httpServletRequest) {
        String string3 = LibertyManager.getMetaAlias(string, string2);
        String string4 = FSServiceUtils.getServicesBaseURL(httpServletRequest);
        return string4 + "/federation-terminate" + "?" + "metaAlias" + "=" + string3;
    }

    public static String getNameRegistrationURL(String string, HttpServletRequest httpServletRequest) {
        String string2 = LibertyManager.getMetaAlias(string);
        String string3 = FSServiceUtils.getServicesBaseURL(httpServletRequest);
        return string3 + "/InitiateRegistration" + "?" + "metaAlias" + "=" + string2;
    }

    public static String getNameRegistrationURL(String string, String string2, HttpServletRequest httpServletRequest) {
        String string3 = LibertyManager.getMetaAlias(string, string2);
        String string4 = FSServiceUtils.getServicesBaseURL(httpServletRequest);
        return string4 + "/InitiateRegistration" + "?" + "metaAlias" + "=" + string3;
    }

    public static String getErrorPageURL(String string, HttpServletRequest httpServletRequest) {
        FSHostedProviderDescriptor fSHostedProviderDescriptor = null;
        try {
            fSHostedProviderDescriptor = allianceMgr.getHostedProvider(string);
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            debug.error("LibertyManager: getErrorPageURL: Error  while getting the HostedProvider from Alliance mgmt", (Throwable)((Object)fSAllianceManagementException));
        }
        if (fSHostedProviderDescriptor != null) {
            String string2 = fSHostedProviderDescriptor.getLocalConfiguration().getErrorPageURL(httpServletRequest);
            return string2;
        }
        return null;
    }

    public static String getErrorPageURL(String string, String string2, HttpServletRequest httpServletRequest) {
        FSHostedProviderDescriptor fSHostedProviderDescriptor = null;
        try {
            fSHostedProviderDescriptor = allianceMgr.getHostedProvider(string, string2);
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            debug.error("LibertyManager: getErrorPageURL: Error  while getting the HostedProvider from Alliance mgmt", (Throwable)((Object)fSAllianceManagementException));
        }
        if (fSHostedProviderDescriptor != null) {
            String string3 = fSHostedProviderDescriptor.getLocalConfiguration().getErrorPageURL(httpServletRequest);
            return string3;
        }
        return null;
    }

    public static String getFederationHandlerURL(HttpServletRequest httpServletRequest) {
        String string = FSServiceUtils.getServicesBaseURL(httpServletRequest) + "/" + "federation";
        if (messageEnabled) {
            debug.message("LibertyManager: getFederationHandler: returnURL = " + string);
        }
        return string;
    }

    public static String getConsentHandlerURL(HttpServletRequest httpServletRequest) {
        String string = FSServiceUtils.getServicesBaseURL(httpServletRequest) + "/" + "consentHandler";
        if (messageEnabled) {
            debug.message("LibertyManager: getConsentHandler: returnURL = " + string);
        }
        return string;
    }

    public static boolean isLogoutSuccess(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getParameter("logoutStatus");
        return string == null || string.equalsIgnoreCase("logoutSuccess");
    }

    public static boolean isTerminationSuccess(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getParameter("termStatus");
        return string == null || string.equalsIgnoreCase("termSuccess");
    }

    public static boolean isFederationCancelled(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getParameter("termStatus");
        return string != null && string.equalsIgnoreCase("cancel");
    }

    public static boolean isTerminationCancelled(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getParameter("termStatus");
        return string != null && string.equalsIgnoreCase("cancel");
    }

    public static String getNewRequest(HttpServletRequest httpServletRequest) {
        Object object;
        String string = httpServletRequest.getParameter("RelayState");
        String string2 = httpServletRequest.getParameter("metaAlias");
        String string3 = LibertyManager.getProviderID(string2);
        Map map = LibertyManager.getHeaderMap(httpServletRequest);
        String string4 = null;
        if (string == null || string.length() <= 0) {
            object = null;
            try {
                object = allianceMgr.getHostedProvider(string3);
                string4 = ((FSHostedProviderDescriptor)object).getLocalConfiguration().getProviderHomePageURL();
            }
            catch (FSAllianceManagementException fSAllianceManagementException) {
                debug.error("LibertyManager: getNewRequest: Error while getting the HostedProvider from Alliance mgmt", (Throwable)((Object)fSAllianceManagementException));
            }
            if (messageEnabled) {
                debug.message("LibertyManager: getNewRequestID. no goto in queryString.Assinging targetURL = " + string4);
            }
            string = string4;
        }
        try {
            object = new FSLoginHelper(httpServletRequest);
            Map map2 = ((FSLoginHelper)object).createAuthnRequest(map, string, null, string2, null, true);
            if (map2 != null) {
                String string5 = (String)map2.get("RequestID");
                if (messageEnabled) {
                    debug.message("LibertyManager: getNewRequestID: new request created with id " + string5);
                }
                return string5;
            }
            debug.error("LibertyManager: getNewRequestID  Could not create new request ");
            return null;
        }
        catch (FSLoginHelperException fSLoginHelperException) {
            debug.error("LibertyManager::getNewRequestIDIn login helper exception ", (Throwable)((Object)fSLoginHelperException));
            return null;
        }
    }

    private static Map getHeaderMap(HttpServletRequest httpServletRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Enumeration enumeration = httpServletRequest.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            String string2 = httpServletRequest.getHeader(string);
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    public static String cleanQueryString(HttpServletRequest httpServletRequest) {
        String string;
        Object object;
        Enumeration enumeration = httpServletRequest.getParameterNames();
        String string2 = new String();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (((String)object).equalsIgnoreCase("metaAlias") || ((String)object).equalsIgnoreCase("RequestID") || ((String)object).equalsIgnoreCase("RelayState")) {
                if (!messageEnabled) continue;
                debug.message("Libertymanager::cleanQueryString  found metaAlias or LRURL or AUTH_REQUEST_ID.");
                continue;
            }
            string = httpServletRequest.getParameter((String)object);
            string2 = string2 == null || string2.length() < 1 ? (String)object + "=" + AMURLEncDec.encode((String)string) : string2 + "&amp;" + (String)object + "=" + AMURLEncDec.encode((String)string);
        }
        object = httpServletRequest.getSession();
        string = (String)object.getAttribute("authlevel");
        if (string != null) {
            string2 = string2 == null || string2.length() < 1 ? "authlevel=" + string : string2 + "&amp;" + "authlevel" + "=" + string;
        }
        if (messageEnabled) {
            debug.message("Libertymanager::cleanQueryString  returning with " + string2);
        }
        return string2;
    }

    public static String getSuccintID(String string) {
        String string2;
        FSProviderDescriptor fSProviderDescriptor = null;
        try {
            fSProviderDescriptor = allianceMgr.getProvider(string);
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            debug.error("LibertyManager.getSuccintID: alliancemanager error ", (Throwable)((Object)fSAllianceManagementException));
        }
        if (fSProviderDescriptor != null && (string2 = fSProviderDescriptor.getProviderSuccinctID()) != null) {
            debug.message("LibertyManager.getSuccintID: return String " + string2);
            return string2;
        }
        return null;
    }

    public static String getSuccintID(String string, String string2) {
        String string3;
        FSProviderDescriptor fSProviderDescriptor = null;
        try {
            fSProviderDescriptor = allianceMgr.getProvider(string, string2);
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            debug.error("LibertyManager.getSuccintID: alliancemanager error ", (Throwable)((Object)fSAllianceManagementException));
        }
        if (fSProviderDescriptor != null && (string3 = fSProviderDescriptor.getProviderSuccinctID()) != null) {
            debug.message("LibertyManager.getSuccintID: return String " + string3);
            return string3;
        }
        return null;
    }

    public static Set getRegisteredProviders(String string) {
        Set set = new HashSet();
        try {
            set = accountMgr.readAllFederatedProviderID(string);
        }
        catch (FSAccountMgmtException fSAccountMgmtException) {
            debug.error("LibertyManager: getRegisteredProviders: Error while  getting federatedProviderIDs from Account Mgmt", (Throwable)((Object)fSAccountMgmtException));
        }
        return set;
    }

    public static String getNameRegistrationProviderIDKey() {
        return "_liberty_id";
    }

    public static boolean isNameRegistrationCancelled(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getParameter("regisStatus");
        return string != null && string.equalsIgnoreCase("cancel");
    }

    public static boolean isNameRegistrationSuccess(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getParameter("regisStatus");
        return string != null && string.equalsIgnoreCase("regisSuccess");
    }

    public static String getNameRegistrationDonePageURL(String string, HttpServletRequest httpServletRequest) {
        FSHostedProviderDescriptor fSHostedProviderDescriptor = null;
        try {
            fSHostedProviderDescriptor = allianceMgr.getHostedProvider(string);
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            debug.error("LibertyManager: getTerminationDonePageURL: Error  while getting the HostedProvider from Alliance mgmt", (Throwable)((Object)fSAllianceManagementException));
        }
        if (fSHostedProviderDescriptor != null) {
            String string2 = fSHostedProviderDescriptor.getLocalConfiguration().getNameRegistrationDonePageURL(httpServletRequest);
            return string2;
        }
        return null;
    }

    public static String getNameRegistrationDonePageURL(String string, String string2, HttpServletRequest httpServletRequest) {
        FSHostedProviderDescriptor fSHostedProviderDescriptor = null;
        try {
            fSHostedProviderDescriptor = allianceMgr.getHostedProvider(string, string2);
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            debug.error("LibertyManager: getTerminationDonePageURL: Error  while getting the HostedProvider from Alliance mgmt", (Throwable)((Object)fSAllianceManagementException));
        }
        if (fSHostedProviderDescriptor != null) {
            String string3 = fSHostedProviderDescriptor.getLocalConfiguration().getNameRegistrationDonePageURL(httpServletRequest);
            return string3;
        }
        return null;
    }

    public static String getAuthnRequestEnvelope(HttpServletRequest httpServletRequest) {
        FSLoginHelper fSLoginHelper = new FSLoginHelper(httpServletRequest);
        String string = fSLoginHelper.createAuthnRequestEnvelope(httpServletRequest);
        return string;
    }

    public static boolean isLECPProfile(HttpServletRequest httpServletRequest) {
        return FSServiceUtils.isLECPProfile(httpServletRequest);
    }

    public static String getLECPHeaderName() {
        return "Liberty-Enabled";
    }

    public static String getLECPContentType() {
        return "application/vnd.liberty-request+xml";
    }

    public static NodeList getDiscoveryBootStrapResourceOfferings(HttpServletRequest httpServletRequest, String string) {
        if (httpServletRequest == null || string == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("LibertyManager.getDiscoveryResourceOffering: null Input params");
            }
            return null;
        }
        try {
            SSOToken sSOToken = SSOTokenManager.getInstance().createSSOToken(httpServletRequest);
            FSSessionManager fSSessionManager = FSSessionManager.getInstance(string);
            FSSession fSSession = fSSessionManager.getSession(sSOToken);
            if (fSSession == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("LibertyManager.getDiscoveryResourceOfferings: Theres no liberty session for this token");
                }
                return null;
            }
            return fSSession.getBootStrapResourceOfferings();
        }
        catch (Exception exception) {
            FSUtils.debug.error("LibertyManager.getDiscoveryResourceOfferings Exception while retrieving discovery boot strap info.", (Throwable)exception);
            return null;
        }
    }

    public static NodeList getDiscoveryBootStrapResourceOfferings(HttpServletRequest httpServletRequest, String string, String string2) {
        if (httpServletRequest == null || string == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("LibertyManager.getDiscoveryResourceOffering: null Input params");
            }
            return null;
        }
        try {
            SSOToken sSOToken = SSOTokenManager.getInstance().createSSOToken(httpServletRequest);
            FSSessionManager fSSessionManager = FSSessionManager.getInstance(string);
            FSSession fSSession = fSSessionManager.getSession(sSOToken);
            if (fSSession == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("LibertyManager.getDiscoveryResourceOfferings: Theres no liberty session for this token");
                }
                return null;
            }
            return fSSession.getBootStrapResourceOfferings();
        }
        catch (Exception exception) {
            FSUtils.debug.error("LibertyManager.getDiscoveryResourceOfferings Exception while retrieving discovery boot strap info.", (Throwable)exception);
            return null;
        }
    }

    public static List getDiscoveryBootStrapCredentials(HttpServletRequest httpServletRequest, String string) {
        if (httpServletRequest == null || string == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("LibertyManager.getDiscoveryCredentials: null Input params");
            }
            return null;
        }
        try {
            SSOToken sSOToken = SSOTokenManager.getInstance().createSSOToken(httpServletRequest);
            FSSessionManager fSSessionManager = FSSessionManager.getInstance(string);
            FSSession fSSession = fSSessionManager.getSession(sSOToken);
            if (fSSession == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("LibertyManager.getDiscoveryCredentials: Theres no liberty session for this token");
                }
                return null;
            }
            return fSSession.getBootStrapCredential();
        }
        catch (Exception exception) {
            FSUtils.debug.error("LibertyManager.getDiscoveryCredentials Exception while retrieving discovery boot strap info.", (Throwable)exception);
            return null;
        }
    }

    public static List getDiscoveryBootStrapCredentials(HttpServletRequest httpServletRequest, String string, String string2) {
        if (httpServletRequest == null || string == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("LibertyManager.getDiscoveryCredentials: null Input params");
            }
            return null;
        }
        try {
            SSOToken sSOToken = SSOTokenManager.getInstance().createSSOToken(httpServletRequest);
            FSSessionManager fSSessionManager = FSSessionManager.getInstance(string);
            FSSession fSSession = fSSessionManager.getSession(sSOToken);
            if (fSSession == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("LibertyManager.getDiscoveryCredentials: Theres no liberty session for this token");
                }
                return null;
            }
            return fSSession.getBootStrapCredential();
        }
        catch (Exception exception) {
            FSUtils.debug.error("LibertyManager.getDiscoveryCredentials Exception while retrieving discovery boot strap info.", (Throwable)exception);
            return null;
        }
    }

    private static String getUniqueProviderID(String string, String string2) {
        if (string2.equalsIgnoreCase("SP")) {
            return string + "|SP";
        }
        if (string2.equalsIgnoreCase("IDP")) {
            return string + "|IDP";
        }
        return string;
    }

    public static String getProviderRole(String string) {
        try {
            FSHostedProviderDescriptor fSHostedProviderDescriptor = allianceMgr.getHostedProviderByMetaAlias(string);
            if (fSHostedProviderDescriptor != null) {
                return fSHostedProviderDescriptor.getProviderRole();
            }
            return null;
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            debug.error("LibertyManager: getProviderRole: Error getting Provider Role", (Throwable)((Object)fSAllianceManagementException));
            return null;
        }
    }

    public static NameIdentifier getMappedNameIdentifier(String string, SSOToken sSOToken, String string2) {
        FSProviderDescriptor fSProviderDescriptor;
        String string3 = "LibertyManager.getMappedNameIdentifier: ";
        String string4 = LibertyManager.getProviderID(string);
        if (debug.messageEnabled()) {
            debug.message("NameMappingRequester: hostedEntityID=" + string4);
        }
        String string5 = string4 + "|SP";
        AMIdentity aMIdentity = null;
        try {
            aMIdentity = IdUtils.getIdentity(sSOToken);
        }
        catch (IdRepoException idRepoException) {
            debug.error("IdRepoException caught when trying to get user identity from SSO token:", (Throwable)idRepoException);
            return null;
        }
        catch (SSOException sSOException) {
            debug.error("SSOException caught when trying to get user DN from SSO token:", (Throwable)sSOException);
            return null;
        }
        if (debug.messageEnabled()) {
            debug.message(string3 + "amId=" + IdUtils.getUniversalId(aMIdentity));
        }
        FSNameMappingHandler fSNameMappingHandler = new FSNameMappingHandler(string4);
        NameIdentifier nameIdentifier = null;
        if (debug.messageEnabled()) {
            debug.message(string3 + "targetNamespace (remoteSPEntityID)=" + string2);
        }
        FSSessionManager fSSessionManager = FSSessionManager.getInstance(string4);
        FSSession fSSession = null;
        if (fSSessionManager != null) {
            fSSession = fSSessionManager.getSession(sSOToken);
        }
        FSSessionPartner fSSessionPartner = null;
        if (fSSession == null) {
            debug.error(string3 + "session is null");
            return null;
        }
        fSSessionPartner = fSSession.getCurrentSessionPartner();
        String string6 = null;
        if (fSSessionPartner != null) {
            string6 = fSSessionPartner.getPartner();
        }
        String string7 = FSUtils.getEntityID(string6);
        if (debug.messageEnabled()) {
            debug.message(string3 + "Remote IDP EntityID = " + string7);
        }
        try {
            nameIdentifier = fSNameMappingHandler.getNameIdentifier(aMIdentity, string7, true);
        }
        catch (Exception exception) {
            debug.error(string3 + "Exception caught when trying to get Name " + "Identifier between local SP and remote IDP: ", (Throwable)exception);
            return null;
        }
        if (debug.messageEnabled()) {
            debug.message(string3 + "Name Identifier between local SP and " + " remote IDP: " + nameIdentifier.toString());
        }
        FSNameIdentifierMappingRequest fSNameIdentifierMappingRequest = null;
        try {
            fSNameIdentifierMappingRequest = new FSNameIdentifierMappingRequest(string4, nameIdentifier, string2);
        }
        catch (FSMsgException fSMsgException) {
            debug.error(string3, (Throwable)((Object)fSMsgException));
            return null;
        }
        if (FSServiceUtils.isSigningOn()) {
            fSProviderDescriptor = null;
            try {
                fSProviderDescriptor = FSServiceUtils.getAllianceInstance().getProvider(string5);
            }
            catch (FSAllianceManagementException fSAllianceManagementException) {
                debug.error(string3, (Throwable)((Object)fSAllianceManagementException));
                return null;
            }
            try {
                fSNameIdentifierMappingRequest.signXML(fSProviderDescriptor.getSigningKeyAlias());
            }
            catch (SAMLException sAMLException) {
                debug.error(string3, (Throwable)sAMLException);
                return null;
            }
        }
        fSProviderDescriptor = null;
        try {
            fSProviderDescriptor = FSServiceUtils.getAllianceInstance().getProvider(string6);
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            debug.error(string3, (Throwable)((Object)fSAllianceManagementException));
            return null;
        }
        String string8 = fSProviderDescriptor.getSOAPEndPoint();
        if (debug.messageEnabled()) {
            debug.message(string3 + "IDP's soap end point=" + string8);
        }
        FSSOAPService fSSOAPService = FSSOAPService.getInstance();
        SOAPMessage sOAPMessage = fSSOAPService.bindNameMappingRequest(fSNameIdentifierMappingRequest);
        SOAPMessage sOAPMessage2 = null;
        try {
            sOAPMessage2 = fSSOAPService.sendNameMappingMessage(sOAPMessage, string8);
        }
        catch (IOException iOException) {
            debug.error(string3, (Throwable)iOException);
            return null;
        }
        catch (SOAPException sOAPException) {
            debug.error(string3, (Throwable)sOAPException);
            return null;
        }
        Element element = fSSOAPService.parseSOAPMessage(sOAPMessage2);
        FSNameIdentifierMappingResponse fSNameIdentifierMappingResponse = null;
        try {
            fSNameIdentifierMappingResponse = new FSNameIdentifierMappingResponse(element);
        }
        catch (FSMsgException fSMsgException) {
            debug.error(string3, (Throwable)((Object)fSMsgException));
            return null;
        }
        if (debug.messageEnabled()) {
            String string9 = null;
            try {
                string9 = fSNameIdentifierMappingResponse.toXMLString();
            }
            catch (FSMsgException fSMsgException) {
                debug.error(string3, (Throwable)((Object)fSMsgException));
                return null;
            }
            debug.message(string3 + "NameIdentifierMappingResponse: " + string9);
        }
        if (FSServiceUtils.isSigningOn()) {
            if (FSNameMappingHandler.verifyNameIdMappingResponseSignature(element, sOAPMessage2)) {
                if (debug.messageEnabled()) {
                    debug.message(string3 + "Success in verifying Name Identifier Mapping" + " Response Signature");
                }
            } else {
                debug.error(string3 + "Failed verifying Name Identifier Mapping " + "Response");
                return null;
            }
        }
        return fSNameIdentifierMappingResponse.getNameIdentifier();
    }

    static {
        debug = Debug.getInstance((String)"amFederation");
        if (debug.messageEnabled()) {
            messageEnabled = true;
        }
        allianceMgr = FSServiceUtils.getAllianceInstance();
        try {
            accountMgr = FSAccountManager.getInstance();
        }
        catch (FSAccountMgmtException fSAccountMgmtException) {
            debug.error("LibertyManager: Couldnt get AccountMgr instance", (Throwable)((Object)fSAccountMgmtException));
        }
    }
}

