/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.xmlenc;

import com.sun.identity.saml.common.SAMLUtilsCommon;
import com.sun.identity.saml.xmlsig.KeyProvider;
import com.sun.identity.xmlenc.EncryptionException;
import com.sun.identity.xmlenc.EncryptionProvider;
import com.sun.identity.xmlenc.EncryptionUtils;
import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import com.sun.org.apache.xml.security.Init;
import com.sun.org.apache.xml.security.encryption.EncryptedData;
import com.sun.org.apache.xml.security.encryption.EncryptedKey;
import com.sun.org.apache.xml.security.encryption.XMLCipher;
import com.sun.org.apache.xml.security.keys.KeyInfo;
import com.sun.org.apache.xml.security.keys.content.X509Data;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AMEncryptionProvider
implements EncryptionProvider {
    private KeyProvider keyProvider = null;
    private static Map keyMap = new HashMap();

    public void initialize(KeyProvider keyProvider) throws EncryptionException {
        if (keyProvider == null) {
            EncryptionUtils.debug.error("AMSignatureProvider.initialize: keystore is null");
            throw new EncryptionException(EncryptionUtils.bundle.getString("nullValues"));
        }
        this.keyProvider = keyProvider;
    }

    public Document encryptAndReplace(Document document, Element element, String string, int n, String string2, int n2) throws EncryptionException {
        return this.encryptAndReplace(document, element, string, n, this.keyProvider.getPublicKey(string2), n2, null, false);
    }

    public Document encryptAndReplace(Document document, Element element, String string, int n, String string2, int n2, String string3) throws EncryptionException {
        return this.encryptAndReplace(document, element, string, n, this.keyProvider.getPublicKey(string2), n2, string3, false);
    }

    public Document encryptAndReplaceResourceID(Document document, Element element, String string, int n, String string2, int n2, String string3) throws EncryptionException {
        return this.encryptAndReplace(document, element, string, n, this.keyProvider.getPublicKey(string2), n2, string3, true);
    }

    public Document encryptAndReplace(Document document, Element element, String string, int n, Key key, int n2, String string2) throws EncryptionException {
        return this.encryptAndReplace(document, element, string, n, key, n2, string2, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Document encryptAndReplace(Document document, Element element, String string, int n, Key key, int n2, String string2, boolean bl) throws EncryptionException {
        if (document == null || element == null || key == null) {
            EncryptionUtils.debug.error("AMEncryptionProvider.encryptAndReplace: Null values");
            throw new EncryptionException(EncryptionUtils.bundle.getString("nullValues"));
        }
        SecretKey secretKey = null;
        if (string2 != null) {
            if (keyMap.containsKey(string2)) {
                secretKey = (SecretKey)keyMap.get(string2);
            } else {
                secretKey = this.generateSecretKey(string, n);
                keyMap.put(string2, secretKey);
            }
        } else {
            secretKey = this.generateSecretKey(string, n);
        }
        if (secretKey == null) {
            throw new EncryptionException(EncryptionUtils.bundle.getString("generateKeyError"));
        }
        try {
            XMLCipher xMLCipher = null;
            String string3 = key.getAlgorithm();
            if (string3.equals("RSA")) {
                xMLCipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#rsa-1_5");
            } else if (string3.equals("DESede")) {
                xMLCipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#kw-tripledes");
            } else {
                if (!string3.equals("AES")) throw new EncryptionException(EncryptionUtils.bundle.getString("unsupportedKeyAlg"));
                if (n2 == 0 || n2 == 128) {
                    xMLCipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#kw-aes128");
                } else if (n == 192) {
                    xMLCipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#kw-aes192");
                } else {
                    if (n != 256) throw new EncryptionException(EncryptionUtils.bundle.getString("invalidKeyStrength"));
                    xMLCipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#kw-aes256");
                }
            }
            xMLCipher.init(3, key);
            EncryptedKey encryptedKey = xMLCipher.encryptKey(document, (Key)secretKey);
            KeyInfo keyInfo = new KeyInfo(document);
            X509Data x509Data = new X509Data(document);
            x509Data.addCertificate((X509Certificate)this.keyProvider.getCertificate((PublicKey)key));
            keyInfo.add(x509Data);
            encryptedKey.setKeyInfo(keyInfo);
            String string4 = null;
            if (bl) {
                string4 = SAMLUtilsCommon.generateID();
                encryptedKey.setId(string4);
            }
            if (EncryptionUtils.debug.messageEnabled()) {
                EncryptionUtils.debug.message("AMEncryptionProvider.encryptAndReplace: Encrypted key = " + this.toString(xMLCipher.martial(document, encryptedKey)));
            }
            String string5 = this.getEncryptionAlgorithm(string, n);
            xMLCipher = XMLCipher.getInstance((String)string5);
            xMLCipher.init(1, (Key)secretKey);
            EncryptedData encryptedData = xMLCipher.getEncryptedData();
            KeyInfo keyInfo2 = encryptedData.getKeyInfo();
            if (keyInfo2 == null) {
                keyInfo2 = new KeyInfo(document);
                encryptedData.setKeyInfo(keyInfo2);
            }
            if (bl) {
                keyInfo2.addKeyName(string2);
                keyInfo2.addRetrievalMethod("#" + string4, null, "http://www.w3.org/2001/04/xmlenc#EncryptedKey");
            } else {
                keyInfo2.add(encryptedKey);
            }
            Document document2 = xMLCipher.doFinal(document, element);
            if (!bl) return document2;
            Element element2 = (Element)document2.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedData").item(0);
            Node node = element2.getParentNode();
            Element element3 = document2.createElementNS("urn:liberty:disco:2003-08", "EncryptedResourceID");
            node.replaceChild(element3, element2);
            element3.appendChild(element2);
            Element element4 = xMLCipher.martial(document, encryptedKey);
            Element element5 = document.createElementNS("http://www.w3.org/2001/04/xmlenc#", "xenc:CarriedKeyName");
            element5.appendChild(document.createTextNode(string2));
            element4.appendChild(element5);
            element3.appendChild(element4);
            return document2;
        }
        catch (Exception exception) {
            EncryptionUtils.debug.error("AMEncryptionProvider.encryptAndReplace: XML Encryption error", (Throwable)exception);
            throw new EncryptionException(exception);
        }
    }

    public Document decryptAndReplace(Document document, String string) throws EncryptionException {
        return this.decryptAndReplace(document, this.keyProvider.getPrivateKey(string));
    }

    public Document decryptAndReplace(Document document, Key key) throws EncryptionException {
        if (document == null || key == null) {
            throw new EncryptionException(EncryptionUtils.bundle.getString("nullValues"));
        }
        Key key2 = null;
        Document document2 = null;
        NodeList nodeList = document.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedData");
        int n = nodeList.getLength();
        if (nodeList == null || n == 0) {
            return document;
        }
        Element element = (Element)document.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedKey").item(0);
        int n2 = 0;
        while (n2 < n) {
            try {
                Element element2 = (Element)nodeList.item(n2);
                XMLCipher xMLCipher = XMLCipher.getInstance();
                xMLCipher.init(2, null);
                EncryptedData encryptedData = xMLCipher.loadEncryptedData(document, element2);
                EncryptedKey encryptedKey = xMLCipher.loadEncryptedKey(document, element);
                if (encryptedKey == null) {
                    encryptedKey = encryptedData.getKeyInfo().itemEncryptedKey(0);
                }
                if (EncryptionUtils.debug.messageEnabled()) {
                    EncryptionUtils.debug.message("AMEncryptionProvider.decryptAndReplace: Encrypted key = " + this.toString(xMLCipher.martial(document, encryptedKey)));
                }
                if (encryptedKey != null) {
                    XMLCipher xMLCipher2 = XMLCipher.getInstance();
                    xMLCipher2.init(4, key);
                    key2 = xMLCipher2.decryptKey(encryptedKey, encryptedData.getEncryptionMethod().getAlgorithm());
                }
                xMLCipher = XMLCipher.getInstance();
                xMLCipher.init(2, key2);
                document2 = xMLCipher.doFinal(document, element2);
            }
            catch (Exception exception) {
                EncryptionUtils.debug.error("AMEncryptionProvider.decryptAndReplace: XML Decryption error.", (Throwable)exception);
                throw new EncryptionException(exception);
            }
            ++n2;
        }
        return document2;
    }

    private String toString(Element element) {
        OutputFormat outputFormat = new OutputFormat();
        outputFormat.setIndenting(true);
        outputFormat.setMethod("xml");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XMLSerializer xMLSerializer = new XMLSerializer(byteArrayOutputStream, outputFormat);
        try {
            xMLSerializer.serialize(element);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toString();
    }

    private String getEncryptionAlgorithm(String string, int n) throws EncryptionException {
        if (string == null) {
            throw new EncryptionException(EncryptionUtils.bundle.getString("nullValues"));
        }
        if (string.equals("AES")) {
            if (n == 0 || n == 128) {
                return "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
            }
            if (n == 192) {
                return "http://www.w3.org/2001/04/xmlenc#aes192-cbc";
            }
            if (n == 256) {
                return "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
            }
            throw new EncryptionException(EncryptionUtils.bundle.getString("invalidKeyStrength"));
        }
        if (string.equals("DESede")) {
            return "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
        }
        throw new EncryptionException(EncryptionUtils.bundle.getString("unsupportedKeyAlg"));
    }

    private SecretKey generateSecretKey(String string, int n) throws EncryptionException {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(string);
            if (n != 0) {
                keyGenerator.init(n);
            }
            return keyGenerator.generateKey();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new EncryptionException(noSuchAlgorithmException);
        }
    }

    static {
        Init.init();
    }
}

