/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm.ldap;

import com.iplanet.am.util.AMResourceBundleCache;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.OrderedSet;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.ldap.DSConfigMgr;
import com.iplanet.services.ldap.LDAPUser;
import com.iplanet.services.ldap.ServerInstance;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.ums.DataLayer;
import com.sun.identity.common.CaseInsensitiveHashMap;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSObject;
import com.sun.identity.sm.SMSObjectListener;
import com.sun.identity.sm.ldap.LDAPEventManager;
import com.sun.identity.sm.ldap.SMDataLayer;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.ModificationItem;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPCompareAttrNames;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPEntryComparator;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.util.DN;

public class SMSLdapObject
extends SMSObject
implements SMSObjectListener {
    static DataLayer dlayer;
    static SMDataLayer smdlayer;
    static int connNumRetry;
    static int connRetryInterval;
    static HashSet retryErrorCodes;
    static String baseDN;
    static Set entriesPresent;
    static Set entriesNotPresent;
    static ResourceBundle bundle;
    static boolean initialized;
    static boolean initializedForNotification;
    static Debug debug;
    static String[] OU_ATTR;
    static String[] O_ATTR;
    static boolean enableProxy;

    public SMSLdapObject() throws SMSException {
        if (!initialized) {
            this.initialize();
        }
    }

    private synchronized void initialize() throws SMSException {
        if (initialized) {
            return;
        }
        debug = Debug.getInstance((String)"amSMSLdap");
        AMResourceBundleCache aMResourceBundleCache = AMResourceBundleCache.getInstance();
        bundle = aMResourceBundleCache.getResBundle("amSDK", Locale.ENGLISH);
        SMSLdapObject.OU_ATTR[0] = this.getNamingAttribute();
        SMSLdapObject.O_ATTR[0] = this.getOrgNamingAttribute();
        String string = SystemProperties.get((String)"com.sun.identity.sm.ldap.enableProxy");
        enableProxy = string != null && string.equalsIgnoreCase("true");
        if (debug.messageEnabled()) {
            debug.message("SMSLdapObject: proxy enable value: " + enableProxy);
        }
        try {
            if (enableProxy) {
                dlayer = DataLayer.getInstance();
                if (debug.messageEnabled()) {
                    debug.message("SMSLdapObject: DataLayer instance obtained.");
                }
            } else {
                smdlayer = SMDataLayer.getInstance();
                if (debug.messageEnabled()) {
                    debug.message("SMSLdapObject: SMDataLayer instance obtained.");
                }
            }
            ServerInstance serverInstance = null;
            DSConfigMgr dSConfigMgr = DSConfigMgr.getDSConfigMgr();
            if (dSConfigMgr != null) {
                serverInstance = dSConfigMgr.getServerInstance(LDAPUser.Type.AUTH_PROXY);
            }
            if (serverInstance != null) {
                baseDN = serverInstance.getBaseDN();
            }
            if (dSConfigMgr == null || serverInstance == null || dlayer == null && smdlayer == null) {
                debug.error("SMSLdapObject: Unable to initialize LDAP");
                throw new SMSException("amSDK", "ums-configmanagererror", null);
            }
            debug.message("SMSLdapObject: LDAP Initialized successfully");
            connNumRetry = DataLayer.getConnNumRetry();
            connRetryInterval = DataLayer.getConnRetryInterval();
            retryErrorCodes = DataLayer.getRetryErrorCodes();
            String string2 = "ou=services," + baseDN;
            if (!SMSLdapObject.entryExists(string2)) {
                HashMap hashMap = new HashMap();
                HashSet<String> hashSet = new HashSet<String>();
                hashSet.add("top");
                hashSet.add("organizationalunit");
                hashMap.put("objectclass", hashSet);
                SMSLdapObject.create(LDAPEventManager.adminPrincipal, string2, hashMap);
            }
        }
        catch (Exception exception) {
            debug.error("SMSEntry: Unable to initalize(exception):", (Throwable)exception);
            throw new SMSException("amSDK", "ums-configmanagererror", null);
        }
        initialized = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map read(SSOToken sSOToken, String string) throws SMSException, SSOException {
        String[] stringArray;
        LDAPEntry lDAPEntry;
        LDAPAttributeSet lDAPAttributeSet;
        block27: {
            if (string == null || string.length() == 0 || !DN.isDN((String)string)) {
                debug.error("SMSLdapObject: Invalid DN=" + string);
                throw new SMSException(new LDAPException(bundle.getString("sms-INVALID_DN") + string, 32), "sms-NO_SUCH_OBJECT");
            }
            if (entriesNotPresent.contains(string)) {
                if (!initializedForNotification) {
                    SMSEntry.registerCallbackHandler(null, this);
                    initializedForNotification = true;
                }
                if (debug.messageEnabled()) {
                    debug.message("SMSLdapObject:read Entry not present: " + string + " (checked in cached)");
                }
                return null;
            }
            lDAPAttributeSet = null;
            LDAPConnection lDAPConnection = SMSLdapObject.getConnection(sSOToken.getPrincipal());
            try {
                block26: {
                    try {
                        lDAPEntry = null;
                        int n = 0;
                        while (n <= connNumRetry) {
                            if (debug.messageEnabled()) {
                                debug.message("SMSLdapObject.read() retry: " + n);
                            }
                            try {
                                lDAPEntry = lDAPConnection.read(string, this.getAttributeNames());
                                break;
                            }
                            catch (LDAPException lDAPException) {
                                if (!retryErrorCodes.contains("" + lDAPException.getLDAPResultCode()) || n == connNumRetry) {
                                    throw lDAPException;
                                }
                                ++n;
                                try {
                                    Thread.currentThread();
                                    Thread.sleep(connRetryInterval);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                        }
                        if (lDAPEntry == null) {
                            if (debug.warningEnabled()) {
                                debug.warning("SMSLdapObject: insufficient access rights to access DN=" + string);
                            }
                            throw new SMSException("amSDK", "sms-INSUFFICIENT_ACCESS_RIGHTS", null);
                        }
                        lDAPAttributeSet = lDAPEntry.getAttributeSet();
                        if (!debug.messageEnabled()) break block26;
                        debug.message("SMSLdapObject: reading entry: " + string);
                    }
                    catch (LDAPException lDAPException) {
                        if (lDAPException.getLDAPResultCode() == 32) {
                            this.objectChanged(string, 1);
                            if (debug.messageEnabled()) {
                                debug.message("SMSLdapObject: entry not present:" + string);
                            }
                        } else {
                            if (debug.warningEnabled()) {
                                debug.warning("SMSLdapObject: Error in accessing entry DN: " + string, (Throwable)lDAPException);
                            }
                            throw new SMSException(lDAPException, "sms-entry-cannot-access");
                        }
                        stringArray = null;
                        SMSLdapObject.releaseConnection(lDAPConnection);
                        break block27;
                    }
                }
                stringArray = null;
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                SMSLdapObject.releaseConnection(lDAPConnection);
                throw throwable;
            }
            SMSLdapObject.releaseConnection(lDAPConnection);
        }
        lDAPEntry = null;
        if (lDAPAttributeSet != null) {
            Enumeration enumeration = lDAPAttributeSet.getAttributes();
            block9: while (enumeration.hasMoreElements()) {
                LDAPAttribute lDAPAttribute = (LDAPAttribute)enumeration.nextElement();
                String string2 = lDAPAttribute.getName();
                if (lDAPAttribute == null) continue;
                HashSet<String> hashSet = new HashSet<String>();
                stringArray = lDAPAttribute.getStringValueArray();
                int n = 0;
                while (true) {
                    if (n >= stringArray.length) {
                        if (lDAPEntry == null) {
                            lDAPEntry = new CaseInsensitiveHashMap(10);
                        }
                        lDAPEntry.put(string2, hashSet);
                        continue block9;
                    }
                    hashSet.add(stringArray[n]);
                    ++n;
                }
            }
        }
        return lDAPEntry;
    }

    public void create(SSOToken sSOToken, String string, Map map) throws SMSException, SSOException {
        SMSLdapObject.create(sSOToken.getPrincipal(), string, map);
        this.objectChanged(string, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void create(Principal principal, String string, Map map) throws SMSException, SSOException {
        LDAPConnection lDAPConnection = SMSLdapObject.getConnection(principal);
        try {
            try {
                int n = 0;
                while (n <= connNumRetry) {
                    if (debug.messageEnabled()) {
                        debug.message("SMSLdapObject.create() retry: " + n);
                    }
                    try {
                        LDAPAttributeSet lDAPAttributeSet = SMSLdapObject.copyMapToAttrSet(map);
                        lDAPConnection.add(new LDAPEntry(string, lDAPAttributeSet));
                        break;
                    }
                    catch (LDAPException lDAPException) {
                        if (!retryErrorCodes.contains("" + lDAPException.getLDAPResultCode()) || n == connNumRetry) {
                            throw lDAPException;
                        }
                        ++n;
                        try {
                            Thread.currentThread();
                            Thread.sleep(connRetryInterval);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (LDAPException lDAPException) {
                debug.error("SMSLdapObject::create() Error in creating entry: " + string + "\nBy Principal: " + principal.getName(), (Throwable)lDAPException);
                throw new SMSException(lDAPException, "sms-entry-cannot-create");
            }
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            SMSLdapObject.releaseConnection(lDAPConnection);
            throw throwable;
        }
        SMSLdapObject.releaseConnection(lDAPConnection);
        if (debug.messageEnabled()) {
            debug.message("SMSLdapObject: Successfully created entry: " + string);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void modify(SSOToken sSOToken, String string, ModificationItem[] modificationItemArray) throws SMSException, SSOException {
        LDAPConnection lDAPConnection = SMSLdapObject.getConnection(sSOToken.getPrincipal());
        try {
            try {
                int n = 0;
                while (n <= connNumRetry) {
                    if (debug.messageEnabled()) {
                        debug.message("SMSLdapObject.modify() retry: " + n);
                    }
                    try {
                        LDAPModificationSet lDAPModificationSet = SMSLdapObject.copyModItemsToLDAPModSet(modificationItemArray);
                        lDAPConnection.modify(string, lDAPModificationSet);
                        break;
                    }
                    catch (LDAPException lDAPException) {
                        if (!retryErrorCodes.contains("" + lDAPException.getLDAPResultCode()) || n == connNumRetry) {
                            throw lDAPException;
                        }
                        ++n;
                        try {
                            Thread.currentThread();
                            Thread.sleep(connRetryInterval);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (LDAPException lDAPException) {
                debug.error("SMSLdapObject::modify() Error in modifying entry: " + string + "\nBy Principal: " + sSOToken.getPrincipal().getName(), (Throwable)lDAPException);
                throw new SMSException(lDAPException, "sms-entry-cannot-modify");
            }
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            SMSLdapObject.releaseConnection(lDAPConnection);
            throw throwable;
        }
        SMSLdapObject.releaseConnection(lDAPConnection);
        if (debug.messageEnabled()) {
            debug.message("SMSLdapObject: Successfully modified entry: " + string);
        }
    }

    public void delete(SSOToken sSOToken, String string) throws SMSException, SSOException {
        Object object;
        Object object2;
        Iterator iterator = this.subEntries(sSOToken, string, "*", 0, false, false).iterator();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            if (debug.messageEnabled()) {
                debug.message("SMSLdapObject: deleting sub-entry: " + (String)object2);
            }
            this.delete(sSOToken, this.getNamingAttribute() + "=" + (String)object2 + "," + string);
        }
        object2 = this.searchSubOrgNames(sSOToken, string, "*", 0, false, false, false).iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            if (debug.messageEnabled()) {
                debug.message("SMSLdapObject: deleting suborganization: " + (String)object);
            }
            this.delete(sSOToken, (String)object);
        }
        object = SMSLdapObject.getConnection(sSOToken.getPrincipal());
        try {
            SMSLdapObject.delete(object, string);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            SMSLdapObject.releaseConnection(object);
            throw throwable;
        }
        SMSLdapObject.releaseConnection(object);
        this.objectChanged(string, 1);
    }

    private static void delete(LDAPConnection lDAPConnection, String string) throws SMSException {
        try {
            int n = 0;
            while (n <= connNumRetry) {
                if (debug.messageEnabled()) {
                    debug.message("SMSLdapObject.delete() retry: " + n);
                }
                try {
                    lDAPConnection.delete(string);
                    break;
                }
                catch (LDAPException lDAPException) {
                    if (!retryErrorCodes.contains("" + lDAPException.getLDAPResultCode()) || n == connNumRetry) {
                        throw lDAPException;
                    }
                    ++n;
                    try {
                        Thread.currentThread();
                        Thread.sleep(connRetryInterval);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        catch (LDAPException lDAPException) {
            if (debug.warningEnabled()) {
                debug.warning("SMSLdapObject:delete() Unable to delete entry:" + string, (Throwable)lDAPException);
            }
            throw new SMSException(lDAPException, "sms-entry-cannot-delete");
        }
    }

    public Set subEntries(SSOToken sSOToken, String string, String string2, int n, boolean bl, boolean bl2) throws SMSException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("SMSLdapObject: SubEntries search: " + string);
        }
        Object[] objectArray = new String[]{string2};
        String string3 = MessageFormat.format(this.getSearchFilter(), objectArray);
        Set set = this.getSubEntries(sSOToken, string, string3, n, bl, bl2);
        return set;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set getSubEntries(SSOToken sSOToken, String string, String string2, int n, boolean bl, boolean bl2) throws SMSException, SSOException {
        OrderedSet orderedSet;
        LDAPSearchResults lDAPSearchResults;
        block22: {
            LDAPConnection lDAPConnection = SMSLdapObject.getConnection(sSOToken.getPrincipal());
            LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection.getSearchConstraints();
            lDAPSearchConstraints.setMaxResults(n);
            lDAPSearchConstraints.setServerTimeLimit(0);
            lDAPSearchResults = null;
            try {
                Object var14_17;
                try {
                    int n2 = 0;
                    while (n2 <= connNumRetry) {
                        if (debug.messageEnabled()) {
                            debug.message("SMSLdapObject.subEntries() retry: " + n2);
                        }
                        try {
                            lDAPSearchResults = lDAPConnection.search(string, 1, string2, OU_ATTR, false, lDAPSearchConstraints);
                            if (!bl) break;
                            orderedSet = new LDAPCompareAttrNames(this.getNamingAttribute(), bl2);
                            lDAPSearchResults.sort((LDAPEntryComparator)orderedSet);
                            break;
                        }
                        catch (LDAPException lDAPException) {
                            if (!retryErrorCodes.contains("" + lDAPException.getLDAPResultCode()) || n2 == connNumRetry) {
                                throw lDAPException;
                            }
                            ++n2;
                            try {
                                Thread.currentThread();
                                Thread.sleep(connRetryInterval);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                }
                catch (LDAPException lDAPException) {
                    if (lDAPException.getLDAPResultCode() == 32) {
                        if (debug.messageEnabled()) {
                            debug.message("SMSLdapObject: entry not present:" + string);
                        }
                    } else {
                        if (debug.warningEnabled()) {
                            debug.warning("SMSLdapObject: Unable to search for sub-entries: " + string, (Throwable)lDAPException);
                        }
                        throw new SMSException(lDAPException, "sms-entry-cannot-search");
                    }
                    var14_17 = null;
                    SMSLdapObject.releaseConnection(lDAPConnection);
                    break block22;
                }
                var14_17 = null;
            }
            catch (Throwable throwable) {
                Object var14_18 = null;
                SMSLdapObject.releaseConnection(lDAPConnection);
                throw throwable;
            }
            SMSLdapObject.releaseConnection(lDAPConnection);
        }
        orderedSet = new OrderedSet();
        while (true) {
            LDAPEntry lDAPEntry;
            if (lDAPSearchResults == null || !lDAPSearchResults.hasMoreElements()) {
                if (debug.messageEnabled()) {
                    debug.message("SMSLdapObject: Successfully obtained sub-entries for : " + string);
                }
                return orderedSet;
            }
            try {
                lDAPEntry = lDAPSearchResults.next();
            }
            catch (LDAPException lDAPException) {
                if (debug.warningEnabled()) {
                    debug.warning("SMSLdapObject: Error in obtaining sub-entries: " + string, (Throwable)lDAPException);
                }
                throw new SMSException(lDAPException, "sms-entry-cannot-obtain");
            }
            orderedSet.add(new DN(lDAPEntry.getDN()).explodeDN(true)[0]);
        }
    }

    public Set schemaSubEntries(SSOToken sSOToken, String string, String string2, String string3, int n, boolean bl, boolean bl2) throws SMSException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("SMSLdapObject: schemaSubEntries search: " + string);
        }
        Object[] objectArray = new String[]{string2, string3};
        String string4 = MessageFormat.format(this.getServiceIdSearchFilter(), objectArray);
        Set set = this.getSubEntries(sSOToken, string, string4, n, bl, bl2);
        return set;
    }

    public String toString() {
        return "SMSLdapObject";
    }

    private static void releaseConnection(LDAPConnection lDAPConnection) {
        if (lDAPConnection != null) {
            if (enableProxy) {
                dlayer.releaseConnection(lDAPConnection);
            } else {
                smdlayer.releaseConnection(lDAPConnection);
            }
        }
    }

    private static LDAPConnection getConnection(Principal principal) throws SMSException {
        LDAPConnection lDAPConnection = null;
        lDAPConnection = enableProxy ? dlayer.getConnection(principal) : smdlayer.getConnection();
        if (lDAPConnection == null) {
            debug.error("SMSLdapObject: Unable to get connection to LDAP server for the principal: " + principal);
            throw new SMSException(new LDAPException(bundle.getString("sms-SERVER_DOWN")), "sms-SERVER_DOWN");
        }
        return lDAPConnection;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set search(SSOToken sSOToken, String string, String string2) throws SSOException, SMSException {
        LDAPSearchConstraints lDAPSearchConstraints;
        if (debug.messageEnabled()) {
            debug.message("SMSLdapObject: search filter: " + string2);
        }
        LDAPConnection lDAPConnection = SMSLdapObject.getConnection(LDAPEventManager.adminPrincipal);
        LDAPSearchResults lDAPSearchResults = null;
        OrderedSet orderedSet = new OrderedSet();
        try {
            try {
                lDAPSearchConstraints = lDAPConnection.getSearchConstraints();
                lDAPSearchConstraints.setMaxResults(0);
                lDAPSearchConstraints.setServerTimeLimit(0);
                int n = 0;
                while (n <= connNumRetry) {
                    if (debug.messageEnabled()) {
                        debug.message("SMSLdapObject.search() retry: " + n);
                    }
                    try {
                        lDAPSearchResults = lDAPConnection.search(string, 2, string2, null, false, lDAPSearchConstraints);
                        break;
                    }
                    catch (LDAPException lDAPException) {
                        if (!retryErrorCodes.contains("" + lDAPException.getLDAPResultCode()) || n == connNumRetry) {
                            throw lDAPException;
                        }
                        ++n;
                        try {
                            Thread.currentThread();
                            Thread.sleep(connRetryInterval);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (LDAPException lDAPException) {
                debug.error("SMSLdapObject: LDAP exception in search for filter match: " + string2, (Throwable)lDAPException);
                throw new SMSException(lDAPException, "sms-error-in-searching");
            }
            Object var12_13 = null;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            SMSLdapObject.releaseConnection(lDAPConnection);
            throw throwable;
        }
        SMSLdapObject.releaseConnection(lDAPConnection);
        while (true) {
            if (!lDAPSearchResults.hasMoreElements()) {
                if (debug.messageEnabled()) {
                    debug.message("SMSLdapObject::search returned successfully: " + string2 + "\n\tObjects: " + orderedSet);
                }
                return orderedSet;
            }
            try {
                lDAPSearchConstraints = lDAPSearchResults.next();
            }
            catch (LDAPException lDAPException) {
                if (debug.warningEnabled()) {
                    debug.warning("SMSLdapObject: Error in searching for filter match: " + string2, (Throwable)lDAPException);
                }
                throw new SMSException(lDAPException, "sms-error-in-searching");
            }
            orderedSet.add(lDAPSearchConstraints.getDN());
        }
    }

    public boolean entryExists(SSOToken sSOToken, String string) {
        if (debug.messageEnabled()) {
            debug.message("SMSLdapObject: checking if entry exists: " + string);
        }
        if (entriesPresent.contains(string)) {
            if (debug.messageEnabled()) {
                debug.message("SMSLdapObject: entry present in cache: " + string);
            }
            return true;
        }
        if (entriesNotPresent.contains(string)) {
            if (debug.messageEnabled()) {
                debug.message("SMSLdapObject: entry present in not-present-cache: " + string);
            }
            return false;
        }
        boolean bl = SMSLdapObject.entryExists(string);
        if (bl) {
            HashSet<String> hashSet = new HashSet<String>(entriesPresent);
            hashSet.add(string);
            entriesPresent = hashSet;
        } else {
            HashSet<String> hashSet = new HashSet<String>(entriesNotPresent);
            hashSet.add(string);
            entriesNotPresent = hashSet;
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean entryExists(String string) {
        boolean bl = false;
        LDAPConnection lDAPConnection = null;
        try {
            try {
                lDAPConnection = SMSLdapObject.getConnection(LDAPEventManager.adminPrincipal);
                lDAPConnection.read(string, OU_ATTR);
                bl = true;
            }
            catch (LDAPException lDAPException) {
                if (debug.warningEnabled()) {
                    debug.warning("SMSLdapObject:entryExists: " + string + "does not exist");
                }
                Object var6_4 = null;
                SMSLdapObject.releaseConnection(lDAPConnection);
                return bl;
            }
            catch (SMSException sMSException) {
                if (debug.warningEnabled()) {
                    debug.warning("SMSLdapObject: SMSException while  checking for entry: " + string, (Throwable)sMSException);
                }
                Object var6_5 = null;
                SMSLdapObject.releaseConnection(lDAPConnection);
                return bl;
            }
            Object var6_3 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            SMSLdapObject.releaseConnection(lDAPConnection);
            throw throwable;
        }
        SMSLdapObject.releaseConnection(lDAPConnection);
        return bl;
    }

    public String getRootSuffix() {
        return baseDN;
    }

    public String registerCallbackHandler(SSOToken sSOToken, SMSObjectListener sMSObjectListener) throws SMSException, SSOException {
        return LDAPEventManager.addObjectChangeListener(sMSObjectListener);
    }

    public void deregisterCallbackHandler(String string) {
        LDAPEventManager.removeObjectChangeListener(string);
    }

    private static LDAPAttributeSet copyMapToAttrSet(Map map) {
        LDAPAttribute[] lDAPAttributeArray = new LDAPAttribute[map.size()];
        Iterator iterator = map.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Set set = (Set)map.get(string);
            lDAPAttributeArray[n] = new LDAPAttribute(string, set.toArray(new String[set.size()]));
            ++n;
        }
        return new LDAPAttributeSet(lDAPAttributeArray);
    }

    private static LDAPModificationSet copyModItemsToLDAPModSet(ModificationItem[] modificationItemArray) throws SMSException {
        LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
        try {
            int n = 0;
            while (n < modificationItemArray.length) {
                Attribute attribute = modificationItemArray[n].getAttribute();
                LDAPAttribute lDAPAttribute = new LDAPAttribute(attribute.getID());
                NamingEnumeration<?> namingEnumeration = attribute.getAll();
                while (namingEnumeration.hasMore()) {
                    lDAPAttribute.addValue((String)namingEnumeration.next());
                }
                switch (modificationItemArray[n].getModificationOp()) {
                    case 1: {
                        lDAPModificationSet.add(0, lDAPAttribute);
                        break;
                    }
                    case 2: {
                        lDAPModificationSet.add(2, lDAPAttribute);
                        break;
                    }
                    case 3: {
                        lDAPModificationSet.add(1, lDAPAttribute);
                    }
                }
                ++n;
            }
        }
        catch (NamingException namingException) {
            throw new SMSException(namingException, "sms-cannot-copy-fromModItemToModSet");
        }
        return lDAPModificationSet;
    }

    public void objectChanged(String string, int n) {
        string = new DN(string).toRFCString().toLowerCase();
        Set set = entriesPresent;
        synchronized (set) {
            if (n == 1) {
                HashSet<String> hashSet = new HashSet<String>();
                Iterator iterator = entriesPresent.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    if (string.equals(new DN(string2).toRFCString().toLowerCase())) continue;
                    hashSet.add(string2);
                }
                entriesPresent = hashSet;
            } else if (n == 0) {
                HashSet<String> hashSet = new HashSet<String>();
                Iterator iterator = entriesNotPresent.iterator();
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    if (string.equals(new DN(string3).toRFCString().toLowerCase())) continue;
                    hashSet.add(string3);
                }
                entriesNotPresent = hashSet;
            }
        }
    }

    public void allObjectsChanged() {
        SMSEntry.debug.error("SMSLDAPObject: got notifications, all objects changed");
        Set set = entriesPresent;
        synchronized (set) {
            entriesPresent.clear();
            entriesNotPresent.clear();
        }
    }

    public Set searchSubOrgNames(SSOToken sSOToken, String string, String string2, int n, boolean bl, boolean bl2, boolean bl3) throws SMSException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("SMSLdapObject:searchSubOrgNames search: " + string);
        }
        Object[] objectArray = new String[]{string2};
        String string3 = "(&(objectclass=sunRealmService)(o={0}))";
        String string4 = MessageFormat.format(string3, objectArray);
        Set set = this.searchSubOrganizationNames(sSOToken, string, string4, n, bl, bl2, bl3);
        return set;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set searchSubOrganizationNames(SSOToken sSOToken, String string, String string2, int n, boolean bl, boolean bl2, boolean bl3) throws SMSException, SSOException {
        OrderedSet orderedSet;
        LDAPSearchResults lDAPSearchResults;
        block23: {
            LDAPConnection lDAPConnection = SMSLdapObject.getConnection(sSOToken.getPrincipal());
            LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection.getSearchConstraints();
            lDAPSearchConstraints.setMaxResults(n);
            lDAPSearchConstraints.setServerTimeLimit(0);
            lDAPSearchResults = null;
            int n2 = 1;
            try {
                Object var16_20;
                try {
                    int n3 = 0;
                    while (n3 <= connNumRetry) {
                        if (debug.messageEnabled()) {
                            debug.message("SMSLdapObject.searchSubOrganizationNames() retry: " + n3);
                        }
                        try {
                            if (bl3) {
                                n2 = 2;
                            }
                            lDAPSearchResults = lDAPConnection.search(string, n2, string2, O_ATTR, false, lDAPSearchConstraints);
                            if (!bl) break;
                            orderedSet = new LDAPCompareAttrNames(this.getOrgNamingAttribute(), bl2);
                            lDAPSearchResults.sort((LDAPEntryComparator)orderedSet);
                            break;
                        }
                        catch (LDAPException lDAPException) {
                            if (!retryErrorCodes.contains("" + lDAPException.getLDAPResultCode()) || n3 == connNumRetry) {
                                throw lDAPException;
                            }
                            ++n3;
                            try {
                                Thread.currentThread();
                                Thread.sleep(connRetryInterval);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                }
                catch (LDAPException lDAPException) {
                    if (lDAPException.getLDAPResultCode() == 32) {
                        if (debug.messageEnabled()) {
                            debug.message("SMSLdapObject: suborg not present:" + string);
                        }
                    } else {
                        if (debug.warningEnabled()) {
                            debug.warning("SMSLdapObject: Unable to search for suborganization names: " + string, (Throwable)lDAPException);
                        }
                        throw new SMSException(lDAPException, "sms-suborg-cannot-search");
                    }
                    var16_20 = null;
                    SMSLdapObject.releaseConnection(lDAPConnection);
                    break block23;
                }
                var16_20 = null;
            }
            catch (Throwable throwable) {
                Object var16_21 = null;
                SMSLdapObject.releaseConnection(lDAPConnection);
                throw throwable;
            }
            SMSLdapObject.releaseConnection(lDAPConnection);
        }
        orderedSet = new OrderedSet();
        while (true) {
            LDAPEntry lDAPEntry;
            if (lDAPSearchResults == null || !lDAPSearchResults.hasMoreElements()) {
                if (debug.messageEnabled()) {
                    debug.message("SMSLdapObject: Successfully obtained suborganization names for : " + string);
                    debug.message("SMSLdapObject: Successfully obtained suborganization names  : " + orderedSet.toString());
                }
                return orderedSet;
            }
            try {
                lDAPEntry = lDAPSearchResults.next();
            }
            catch (LDAPException lDAPException) {
                if (debug.warningEnabled()) {
                    debug.warning("SMSLdapObject: Error in obtaining suborganization names: " + string, (Throwable)lDAPException);
                }
                throw new SMSException(lDAPException, "sms-suborg-cannot-obtain");
            }
            String string3 = lDAPEntry.getDN().toString();
            orderedSet.add(string3);
        }
    }

    public Set searchOrganizationNames(SSOToken sSOToken, String string, int n, boolean bl, boolean bl2, String string2, String string3, Set set) throws SMSException, SSOException {
        String string4;
        if (debug.messageEnabled()) {
            debug.message("SMSLdapObject:searchOrganizationNames search dn: " + string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(&");
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            string4 = (String)iterator.next();
            stringBuffer.append("(|(").append("sunxmlKeyValue").append("=").append(string2).append("-").append(string3).append("=").append(string4).append(")");
            stringBuffer.append("(").append("sunxmlKeyValue").append("=").append(string3).append("=").append(string4).append("))");
        }
        stringBuffer.append(")");
        string4 = stringBuffer.toString();
        String string5 = "(|(&(objectclass=sunRealmService){0})(&(objectclass=sunServiceComponent){0}))";
        Object[] objectArray = new String[]{string4};
        String string6 = MessageFormat.format(string5, objectArray);
        if (debug.messageEnabled()) {
            debug.message("SMSLdapObject:orgNames search filter: " + string6);
        }
        Set set2 = this.getOrgNames(sSOToken, string, string6, n, bl, bl2);
        return set2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set getOrgNames(SSOToken sSOToken, String string, String string2, int n, boolean bl, boolean bl2) throws SMSException, SSOException {
        OrderedSet orderedSet;
        LDAPSearchResults lDAPSearchResults;
        block22: {
            LDAPConnection lDAPConnection = SMSLdapObject.getConnection(sSOToken.getPrincipal());
            LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection.getSearchConstraints();
            lDAPSearchConstraints.setMaxResults(n);
            lDAPSearchConstraints.setServerTimeLimit(0);
            lDAPSearchResults = null;
            int n2 = 2;
            try {
                Object var15_19;
                try {
                    int n3 = 0;
                    while (n3 <= connNumRetry) {
                        if (debug.messageEnabled()) {
                            debug.message("SMSLdapObject.getOrgNames() retry: " + n3);
                        }
                        try {
                            lDAPSearchResults = lDAPConnection.search(string, n2, string2, O_ATTR, false, lDAPSearchConstraints);
                            if (!bl) break;
                            orderedSet = new LDAPCompareAttrNames(this.getOrgNamingAttribute(), bl2);
                            lDAPSearchResults.sort((LDAPEntryComparator)orderedSet);
                            break;
                        }
                        catch (LDAPException lDAPException) {
                            if (!retryErrorCodes.contains("" + lDAPException.getLDAPResultCode()) || n3 == connNumRetry) {
                                throw lDAPException;
                            }
                            ++n3;
                            try {
                                Thread.currentThread();
                                Thread.sleep(connRetryInterval);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                }
                catch (LDAPException lDAPException) {
                    if (lDAPException.getLDAPResultCode() == 32) {
                        if (debug.messageEnabled()) {
                            debug.message("SMSLdapObject: org not present:" + string);
                        }
                    } else {
                        if (debug.warningEnabled()) {
                            debug.warning("SMSLdapObject: Unable to search for organization names: " + string, (Throwable)lDAPException);
                        }
                        throw new SMSException(lDAPException, "sms-org-cannot-search");
                    }
                    var15_19 = null;
                    SMSLdapObject.releaseConnection(lDAPConnection);
                    break block22;
                }
                var15_19 = null;
            }
            catch (Throwable throwable) {
                Object var15_20 = null;
                SMSLdapObject.releaseConnection(lDAPConnection);
                throw throwable;
            }
            SMSLdapObject.releaseConnection(lDAPConnection);
        }
        orderedSet = new OrderedSet();
        while (true) {
            LDAPEntry lDAPEntry;
            if (lDAPSearchResults == null || !lDAPSearchResults.hasMoreElements()) {
                if (debug.messageEnabled()) {
                    debug.message("SMSLdapObject: Successfully obtained organization names for : " + string);
                    debug.message("SMSLdapObject: Successfully obtained organization names  : " + orderedSet.toString());
                }
                return orderedSet;
            }
            try {
                lDAPEntry = lDAPSearchResults.next();
            }
            catch (LDAPException lDAPException) {
                if (debug.warningEnabled()) {
                    debug.warning("SMSLdapObject: Error in obtaining organization names: " + string, (Throwable)lDAPException);
                }
                throw new SMSException(lDAPException, "sms-org-cannot-obtain");
            }
            String string3 = lDAPEntry.getDN().toString();
            orderedSet.add(string3);
        }
    }

    static {
        connNumRetry = 3;
        connRetryInterval = 1000;
        retryErrorCodes = new HashSet();
        entriesPresent = new HashSet();
        entriesNotPresent = new HashSet();
        OU_ATTR = new String[1];
        O_ATTR = new String[1];
    }
}

