/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceAttributeValidator;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class SiteIDValidator
implements ServiceAttributeValidator {
    private static final String PLATFORM_SERVER_LIST = "iplanet-am-platform-server-list";
    private static Debug debug = Debug.getInstance((String)"amSession");
    private Set serverAddrSet = new HashSet();
    private Set serverIdSet = new HashSet();

    public boolean validate(Set set) {
        if (set.size() == 0) {
            return true;
        }
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        Iterator iterator = set.iterator();
        boolean bl = false;
        bl = this.getServerDetails();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            if (stringTokenizer.countTokens() != 2) {
                return false;
            }
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            int n = string3.getBytes().length;
            if (n != 2 || hashSet.contains(string3)) {
                return false;
            }
            hashSet.add(string3);
            if (hashSet2.contains(string2)) {
                return false;
            }
            hashSet2.add(string2);
            if (bl) {
                if (this.serverAddrSet.contains(string2)) {
                    return false;
                }
                if (!this.serverIdSet.contains(string3)) continue;
                return false;
            }
            if (!debug.messageEnabled()) continue;
            debug.message("Unable to get server list information. Server validation cannot be performed");
        }
        return true;
    }

    private boolean getServerDetails() {
        block7: {
            if (!this.serverAddrSet.isEmpty()) {
                return true;
            }
            try {
                Map map;
                Set set;
                ServiceSchema serviceSchema;
                SSOToken sSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
                ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager("iPlanetAMPlatformService", sSOToken);
                if (serviceSchemaManager != null && (serviceSchema = serviceSchemaManager.getGlobalSchema()) != null && (set = (Set)(map = serviceSchema.getAttributeDefaults()).get(PLATFORM_SERVER_LIST)) != null && !set.isEmpty()) {
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        if (string == null) continue;
                        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
                        String string2 = stringTokenizer.nextToken();
                        String string3 = stringTokenizer.nextToken();
                        this.serverAddrSet.add(string2);
                        StringTokenizer stringTokenizer2 = new StringTokenizer(string3, "|");
                        this.serverIdSet.add(stringTokenizer2.nextToken());
                    }
                }
                return true;
            }
            catch (SMSException sMSException) {
                if (debug.messageEnabled()) {
                    debug.message("Site List Validator. Unable to get global config: SMSException", (Throwable)sMSException);
                }
            }
            catch (SSOException sSOException) {
                if (!debug.messageEnabled()) break block7;
                debug.message("Site List Validator. Unable to get global config: SSOException", (Throwable)sSOException);
            }
        }
        return false;
    }
}

