/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.sun.identity.common.CaseInsensitiveHashMap;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SMSUtils {
    protected static final String SERVICE = "Service";
    protected static final String NAME = "name";
    protected static final String VERSION = "version";
    protected static final String SCHEMA = "Schema";
    protected static final String SUB_SCHEMA = "SubSchema";
    protected static final String SUB_CONFIG = "SubConfiguration";
    protected static final String GLOBAL_SCHEMA = "Global";
    protected static final String GLOBAL_CONFIG = "GlobalConfiguration";
    protected static final String ORG_SCHEMA = "Organization";
    protected static final String ORG_ATTRIBUTE_SCHEMA = "OrganizationAttributeSchema";
    protected static final String ORG_CONFIG = "OrganizationConfiguration";
    protected static final String DYNAMIC_SCHEMA = "Dynamic";
    protected static final String USER_SCHEMA = "User";
    protected static final String POLICY_SCHEMA = "Policy";
    protected static final String GROUP_SCHEMA = "Group";
    protected static final String DOMAIN_SCHEMA = "Domain";
    protected static final String GENERIC_SCHEMA = "Generic";
    protected static final String CONFIGURATION = "Configuration";
    protected static final String INSTANCE = "Instance";
    protected static final String GROUP = "group";
    protected static final String URI = "uri";
    protected static final String SERVICE_ID = "id";
    protected static final String PRIORITY = "priority";
    protected static final String COSPRIORITY = "cospriority";
    protected static final String DEFAULT = "default";
    protected static final String RESOURCE_BUNDLE_URL = "i18nJarURL";
    protected static final String PROPERTIES_FILENAME = "i18nFileName";
    protected static final String SERVICE_HIERARCHY = "serviceHierarchy";
    protected static final String PROPERTIES_VIEW_BEAN_URL = "propertiesViewBeanURL";
    protected static final String I18N_KEY = "i18nKey";
    protected static final String REVISION_NUMBER = "revisionNumber";
    protected static final String STATUS_ATTRIBUTE = "statusAttribute";
    protected static final String VALIDATE = "validate";
    protected static final String INHERITANCE = "inheritance";
    protected static final String ISSEARCHABLE = "isSearchable";
    protected static final String PLUGIN_INTERFACE = "PluginInterface";
    protected static final String PLUGIN_INTERFACE_CLASS = "interface";
    protected static final String PLUGIN_SCHEMA = "PluginSchema";
    protected static final String PLUGIN_SCHEMA_INT_NAME = "interfaceName";
    protected static final String PLUGIN_SCHEMA_CLASS_NAME = "className";
    protected static final String PLUGIN_SCHEMA_JAR_URL = "jarURL";
    protected static final String PLUGIN_SCHEMA_ORG_NAME = "organizationName";
    protected static final String PLUGIN_CONFIG = "PluginConfiguration";
    protected static final String PLUGIN_CONFIG_SCHEMA_NAME = "pluginSchemaName";
    protected static final String PLUGIN_CONFIG_INT_NAME = "interfaceName";
    protected static final String PLUGIN_CONFIG_ORG_NAME = "organizationName";
    protected static final String SCHEMA_ATTRIBUTE = "AttributeSchema";
    protected static final String ATTRIBUTE_VALUE_PAIR = "AttributeValuePair";
    protected static final String ATTRIBUTE = "Attribute";
    protected static final String ATTRIBUTE_TYPE = "type";
    protected static final String ATTRIBUTE_UITYPE = "uitype";
    protected static final String ATTRIBUTE_SYNTAX = "syntax";
    protected static final String ATTRIBUTE_DEFAULT = "default";
    protected static final String ATTRIBUTE_RANGE_START = "rangeStart";
    protected static final String ATTRIBUTE_RANGE_END = "rangeEnd";
    protected static final String ATTRIBUTE_MIN_VALUE = "minValue";
    protected static final String ATTRIBUTE_MAX_VALUE = "maxValue";
    protected static final String ATTRIBUTE_VALIDATOR = "validator";
    protected static final String ATTRIBUTE_OPTIONAL = "IsOptional";
    protected static final String ATTRIBUTE_SERVICE_ID = "IsServiceIdentifier";
    protected static final String ATTRIBUTE_RESOURCE_NAME = "IsResourceNameAllowed";
    protected static final String ATTRIBUTE_STATUS_ATTR = "IsStatusAttribute";
    protected static final String HAS_SERVICE_URLS = "HasServiceURLs";
    protected static final String ATTRIBUTE_ANY = "any";
    protected static final String ATTRIBUTE_VIEW_BEAN_URL = "propertiesViewBeanURL";
    protected static final String ATTRIBUTE_VALUE = "Value";
    protected static final String ATTRIBUTE_DEFAULT_ELEMENT = "DefaultValues";
    protected static final String ATTRIBUTE_DEFAULT_CLASS = "DefaultValuesClassName";
    protected static final String CLASS_NAME = "className";
    protected static final String ATTRIBUTE_CHOICE_CLASS = "ChoiceValuesClassName";
    protected static final String ATTRIBUTE_CHOICE_VALUES_ELEMENT = "ChoiceValues";
    protected static final String ATTRIBUTE_CHOICE_VALUE_ELEMENT = "ChoiceValue";
    protected static final String ATTRIBUTE_COS_QUALIFIER = "cosQualifier";
    protected static final String ATTRIBUTE_BOOLEAN_VALUES_ELEMENT = "BooleanValues";
    protected static final String ATTRIBUTE_TRUE_BOOLEAN_ELEMENT = "BooleanTrueValue";
    protected static final String ATTRIBUTE_FALSE_BOOLEAN_ELEMENT = "BooleanFalseValue";
    protected static int counter = 0;

    static int getInstanceID() {
        return counter++;
    }

    public static String getUniqueID() {
        int n = counter++;
        StringBuffer stringBuffer = new StringBuffer(8);
        return stringBuffer.append(n).toString();
    }

    public static Map copyAttributes(Map map) {
        Object object;
        if (map == null) {
            return new HashMap();
        }
        Object object2 = object = map instanceof CaseInsensitiveHashMap ? new CaseInsensitiveHashMap() : new HashMap();
        if (map.size() == 0) {
            return object;
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object v = map.get(string);
            if (v != null && v instanceof Set) {
                Set set = (Set)v;
                if (set.isEmpty()) {
                    if (set == Collections.EMPTY_SET) {
                        ((HashMap)object).put(string, Collections.EMPTY_SET);
                        continue;
                    }
                    ((HashMap)object).put(string, new HashSet());
                    continue;
                }
                ((HashMap)object).put(string, new HashSet(set));
                continue;
            }
            ((HashMap)object).put(string, v);
        }
        return object;
    }

    static Map getAttrsFromEntry(SMSEntry sMSEntry) {
        Object object;
        String string;
        if (SMSEntry.debug.messageEnabled()) {
            SMSEntry.debug.message("SMSUtils: obtains attrs from entry: " + sMSEntry.getDN());
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String[] stringArray = sMSEntry.getAttributeValues("sunKeyValue");
        String[] stringArray2 = sMSEntry.getAttributeValues("sunxmlKeyValue");
        if (stringArray == null && stringArray2 == null) {
            return hashMap;
        }
        int n = 0;
        while (stringArray != null && n < stringArray.length) {
            String string2 = stringArray[n];
            int n2 = string2.indexOf(61);
            if (n2 == -1) {
                SMSEntry.debug.error("SMSUtils: Invalid attribute entry: " + string2 + "\nIn SMSEntry: " + sMSEntry);
            } else {
                String string3 = string2.substring(0, n2);
                string = null;
                if (string2.length() > n2 + 1) {
                    string = string2.substring(n2 + 1);
                }
                if ((object = (HashSet)hashMap.get(string3)) == null) {
                    object = new HashSet();
                    hashMap.put(string3, object);
                }
                if (string != null && !string.equals("")) {
                    object.add(string);
                }
            }
            ++n;
        }
        int n3 = 0;
        while (stringArray2 != null && n3 < stringArray2.length) {
            String string4 = stringArray2[n3];
            int n4 = string4.indexOf(61);
            if (n4 == -1) {
                SMSEntry.debug.error("SMSUtils: Invalid searchable attribute entry: " + string4 + "\nIn SMSEntry: " + sMSEntry);
            } else {
                HashSet<Object> hashSet;
                string = string4.substring(0, n4);
                object = null;
                if (string4.length() > n4 + 1) {
                    object = string4.substring(n4 + 1);
                }
                if ((hashSet = (HashSet<Object>)hashMap.get(string)) == null) {
                    hashSet = new HashSet<Object>();
                    hashMap.put(string, hashSet);
                }
                if (object != null && !((String)object).equals("")) {
                    hashSet.add(object);
                }
            }
            ++n3;
        }
        return hashMap;
    }

    static void setAttributeValuePairs(SMSEntry sMSEntry, Map map, Set set) throws SMSException {
        if (SMSEntry.debug.messageEnabled()) {
            SMSEntry.debug.message("SMSUtils: setting attrs to entry: " + sMSEntry.getDN());
        }
        if (map != null) {
            HashSet<String> hashSet = new HashSet<String>();
            HashSet<String> hashSet2 = new HashSet<String>();
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Object v = map.get(string);
                if (v == null) continue;
                if (v instanceof String) {
                    if (!set.isEmpty() && set.contains(string.toLowerCase())) {
                        hashSet2.add(string + "=" + (String)v);
                        continue;
                    }
                    hashSet.add(string + "=" + (String)v);
                    continue;
                }
                if (!(v instanceof Set)) continue;
                if (((Set)v).isEmpty()) {
                    if (!set.isEmpty() && set.contains(string.toLowerCase())) {
                        hashSet2.add(string + "=");
                    } else {
                        hashSet.add(string + "=");
                    }
                }
                Iterator iterator2 = ((Set)v).iterator();
                int n = 0;
                while (iterator2.hasNext()) {
                    if (!set.isEmpty() && set.contains(string.toLowerCase())) {
                        hashSet2.add(string + "=" + (String)iterator2.next());
                    } else {
                        hashSet.add(string + "=" + (String)iterator2.next());
                    }
                    ++n;
                }
            }
            if (!hashSet.isEmpty()) {
                sMSEntry.setAttribute("sunKeyValue", hashSet.toArray(new String[hashSet.size()]));
            }
            if (!hashSet2.isEmpty()) {
                sMSEntry.setAttribute("sunxmlKeyValue", hashSet2.toArray(new String[hashSet2.size()]));
            }
        }
    }

    static void addAttribute(SMSEntry sMSEntry, String string, Set set, Set set2) throws SMSException {
        if (SMSEntry.debug.messageEnabled()) {
            SMSEntry.debug.message("SMSUtils: adding attributes to entry: " + sMSEntry.getDN());
        }
        if (string == null || set == null) {
            return;
        }
        if (!set2.isEmpty() && set2.contains(string.toLowerCase())) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                sMSEntry.addAttribute("sunxmlKeyValue", string + "=" + (String)iterator.next());
            }
        } else {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                sMSEntry.addAttribute("sunKeyValue", string + "=" + (String)iterator.next());
            }
        }
    }

    static void removeAttribute(SMSEntry sMSEntry, String string) throws SMSException {
        int n;
        String string2;
        String[] stringArray = sMSEntry.getAttributeValues("sunKeyValue");
        String[] stringArray2 = sMSEntry.getAttributeValues("sunxmlKeyValue");
        if (stringArray == null && stringArray2 == null) {
            return;
        }
        if (stringArray != null) {
            string2 = string + "=";
            n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].startsWith(string2)) {
                    sMSEntry.removeAttribute("sunKeyValue", stringArray[n]);
                }
                ++n;
            }
        }
        if (stringArray2 != null) {
            string2 = string + "=";
            n = 0;
            while (n < stringArray2.length) {
                if (stringArray2[n].startsWith(string2)) {
                    sMSEntry.removeAttribute("sunxmlKeyValue", stringArray2[n]);
                }
                ++n;
            }
        }
    }

    static void removeAttributeValues(SMSEntry sMSEntry, String string, Set set, Set set2) throws SMSException {
        if (string == null || set == null || set.isEmpty()) {
            return;
        }
        if (!set2.isEmpty() && set2.contains(string.toLowerCase())) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                sMSEntry.removeAttribute("sunxmlKeyValue", string + "=" + string2);
            }
        } else {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                sMSEntry.removeAttribute("sunKeyValue", string + "=" + string3);
            }
        }
    }

    static void replaceAttributeValue(SMSEntry sMSEntry, String string, String string2, String string3, Set set) throws SMSException {
        if (!set.isEmpty() && set.contains(string.toLowerCase())) {
            sMSEntry.removeAttribute("sunxmlKeyValue", string + "=" + string2);
            sMSEntry.addAttribute("sunxmlKeyValue", string + "=" + string3);
        } else {
            sMSEntry.removeAttribute("sunKeyValue", string + "=" + string2);
            sMSEntry.addAttribute("sunKeyValue", string + "=" + string3);
        }
    }

    static void replaceAttributeValues(SMSEntry sMSEntry, String string, Set set, Set set2, Set set3) throws SMSException {
        SMSUtils.removeAttributeValues(sMSEntry, string, set, set3);
        if (set2 == null || set2.isEmpty()) {
            return;
        }
        if (!set3.isEmpty() && set3.contains(string.toLowerCase())) {
            Iterator iterator = set2.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                sMSEntry.addAttribute("sunxmlKeyValue", string + "=" + string2);
            }
        } else {
            Iterator iterator = set2.iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                sMSEntry.addAttribute("sunKeyValue", string + "=" + string3);
            }
        }
    }
}

