/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.am.util.XMLUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.sm.AttributeSchemaImpl;
import com.sun.identity.sm.AttributeValidator;
import com.sun.identity.sm.CachedSMSEntry;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSSchema;
import com.sun.identity.sm.ServiceSchemaImpl;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

class PluginSchemaImpl
extends ServiceSchemaImpl {
    protected String interfaceName;
    protected String iclass;
    protected String jarURL;
    protected String resourceBundleURL;
    protected String i18nFileName;
    protected String viewBeanURL;
    protected String serviceName;
    protected String version;
    protected String schemaDocument;
    CachedSMSEntry smsEntry;
    private static Map pluginSchemas = new HashMap();
    private static final String pluginSchemasMutex = "PluginSchemaMutext";

    PluginSchemaImpl() {
    }

    PluginSchemaImpl(SSOToken sSOToken, String string, String string2, String string3, String string4, String string5) throws SMSException {
        this.serviceName = string;
        this.version = string2;
        this.name = string3;
        this.interfaceName = string4;
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("ou=").append(string3).append(",").append("ou=").append(string4).append(",").append("ou=PluginConfig,").append("ou=").append(string2).append(",").append("ou=").append(string).append(",").append("ou=services").append(",");
        try {
            this.smsEntry = CachedSMSEntry.getInstance(sSOToken, stringBuffer.toString() + string5, this);
        }
        catch (SSOException sSOException) {
            throw new SMSException(sSOException, "sms-INVALID_SSO_TOKEN");
        }
        if (this.smsEntry.getSMSEntry().getAttributeValues("sunPluginSchema") == null && !string5.equals(SMSEntry.baseDN)) {
            try {
                this.smsEntry = CachedSMSEntry.getInstance(sSOToken, stringBuffer.toString() + SMSEntry.baseDN, this);
            }
            catch (SSOException sSOException) {
                throw new SMSException(sSOException, "sms-INVALID_SSO_TOKEN");
            }
        }
        this.attrSchemas = new HashMap();
        this.update();
    }

    String getName() {
        return this.name;
    }

    String getVersion() {
        return this.version;
    }

    String getInterfaceName() {
        return this.interfaceName;
    }

    String getClassName() {
        return this.iclass;
    }

    String getJarURL() {
        return this.jarURL;
    }

    String getI18NJarURL() {
        return this.resourceBundleURL;
    }

    String getI18NFileName() {
        return this.i18nFileName;
    }

    String getPropertiesViewBeanURL() {
        return this.viewBeanURL;
    }

    String getI18NKey() {
        return this.i18nKey;
    }

    Set getAttributeSchemaNames() {
        return new HashSet(this.attrSchemas.keySet());
    }

    AttributeSchemaImpl getAttributeSchema(String string) {
        return (AttributeSchemaImpl)this.attrSchemas.get(string);
    }

    CachedSMSEntry getCachedSMSEntry() {
        return this.smsEntry;
    }

    synchronized void updateAndNotifyListeners() {
        this.update();
    }

    synchronized void update() {
        Object object;
        Object object2;
        Node node = null;
        String[] stringArray = this.smsEntry.getSMSEntry().getAttributeValues("sunPluginSchema");
        if (stringArray != null) {
            this.schemaDocument = stringArray[0];
            object2 = null;
            try {
                object2 = SMSSchema.getXMLDocument(stringArray[0], false);
            }
            catch (SMSException sMSException) {
                SMSEntry.debug.error("PluginSchemaImpl: XML parser error: " + this.serviceName + "(" + this.version + "): " + this.name, (Throwable)sMSException);
                return;
            }
            object = object2.getElementsByTagName("PluginSchema");
            if (object != null) {
                int n = 0;
                while (n < object.getLength()) {
                    if (XMLUtils.getNodeAttributeValue((Node)object.item(n), (String)"name").equals(this.name)) {
                        node = object.item(n);
                        break;
                    }
                    ++n;
                }
            }
        }
        if (node == null) {
            this.attrSchemas = new HashMap();
            this.attrValidators = new HashMap();
            this.i18nKey = null;
            this.i18nFileName = null;
            this.resourceBundleURL = null;
            this.jarURL = null;
            this.iclass = null;
            this.schemaDocument = SMSSchema.getDummyXML(this.serviceName, this.version);
            return;
        }
        this.iclass = XMLUtils.getNodeAttributeValue(node, (String)"className");
        this.jarURL = XMLUtils.getNodeAttributeValue(node, (String)"jarURL");
        this.resourceBundleURL = XMLUtils.getNodeAttributeValue(node, (String)"i18nJarURL");
        this.i18nFileName = XMLUtils.getNodeAttributeValue(node, (String)"i18nFileName");
        this.viewBeanURL = XMLUtils.getNodeAttributeValue(node, (String)"propertiesViewBeanURL");
        this.i18nKey = XMLUtils.getNodeAttributeValue(node, (String)"i18nKey");
        object2 = new HashMap();
        object = new HashMap();
        Iterator iterator = XMLUtils.getChildNodes((Node)node, (String)"AttributeSchema").iterator();
        while (iterator.hasNext()) {
            Node node2 = (Node)iterator.next();
            String string = XMLUtils.getNodeAttributeValue((Node)node2, (String)"name");
            AttributeSchemaImpl attributeSchemaImpl = (AttributeSchemaImpl)this.attrSchemas.get(string);
            if (attributeSchemaImpl == null) {
                attributeSchemaImpl = new AttributeSchemaImpl(node2);
            } else {
                attributeSchemaImpl.update(node2);
            }
            object2.put(string, attributeSchemaImpl);
            object.put(string, new AttributeValidator(attributeSchemaImpl));
        }
        this.attrSchemas = object2;
        this.attrValidators = object;
    }

    AttributeValidator getAttributeValidator(String string) {
        AttributeValidator attributeValidator = (AttributeValidator)this.attrValidators.get(string);
        if (attributeValidator == null) {
            AttributeSchemaImpl attributeSchemaImpl = this.getAttributeSchema(string);
            if (attributeSchemaImpl == null) {
                return null;
            }
            attributeValidator = new AttributeValidator(attributeSchemaImpl);
            this.attrValidators.put(string, attributeValidator);
        }
        return attributeValidator;
    }

    Document getDocumentCopy() {
        try {
            return SMSSchema.getXMLDocument(this.schemaDocument, false);
        }
        catch (SMSException sMSException) {
            SMSEntry.debug.error("PluginSchemaImpl:: unable to generate XML document: " + this.name);
            return null;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        if (this.getName() != null) {
            stringBuffer.append("Plugin Schema name: ").append(this.getName()).append("\n");
        }
        if (this.attrSchemas.size() > 0) {
            stringBuffer.append("Attribute Schemas:\n");
            Iterator iterator = this.attrSchemas.keySet().iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(this.attrSchemas.get(iterator.next()).toString());
            }
        }
        return stringBuffer.toString();
    }

    static PluginSchemaImpl getInstance(SSOToken sSOToken, String string, String string2, String string3, String string4, String string5) throws SMSException {
        String string6 = DNMapper.orgNameToDN(string5);
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(string6).append(string4).append(string3).append(string).append(string2);
        String string7 = stringBuffer.toString().toLowerCase();
        PluginSchemaImpl pluginSchemaImpl = (PluginSchemaImpl)pluginSchemas.get(string7);
        if (pluginSchemaImpl != null) {
            if (!SMSEntry.cacheSMSEntries) {
                pluginSchemaImpl.update();
            }
            return pluginSchemaImpl;
        }
        String string8 = pluginSchemasMutex;
        synchronized (string8) {
            pluginSchemaImpl = (PluginSchemaImpl)pluginSchemas.get(string7);
            if (pluginSchemaImpl == null) {
                pluginSchemaImpl = new PluginSchemaImpl(sSOToken, string, string2, string3, string4, string6);
                HashMap<String, PluginSchemaImpl> hashMap = new HashMap<String, PluginSchemaImpl>(pluginSchemas);
                hashMap.put(string7, pluginSchemaImpl);
                pluginSchemas = hashMap;
            }
        }
        return pluginSchemaImpl;
    }

    static void clearCache() {
        pluginSchemas = new HashMap();
    }
}

