/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.sm.CachedSMSEntry;
import com.sun.identity.sm.CachedSubEntries;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSEventListenerManager;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSUtils;
import com.sun.identity.sm.ServiceConfigImpl;
import com.sun.identity.sm.ServiceConfigManagerImpl;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import netscape.ldap.util.DN;

class OrganizationConfigManagerImpl {
    private String orgDN;
    private CachedSubEntries subEntries = null;
    private HashMap listenerObjects;
    private String orgNotificationSearchString;
    private static Map configMgrImpls = new HashMap();
    private static final String configMgrMutex = "ConfigMgrMutex";
    private static Map userPrincipals = new HashMap();
    private static Debug debug = SMSEntry.debug;

    private OrganizationConfigManagerImpl(String string, SSOToken sSOToken) throws SMSException {
        this.orgDN = string;
        this.listenerObjects = new HashMap(2);
        SMSEventListenerManager.notifyAllNodeChanges(sSOToken, this);
        if (!string.startsWith("ou=services")) {
            DN dN = new DN("ou=services," + string);
            this.orgNotificationSearchString = dN.toRFCString().toLowerCase();
        } else {
            this.orgNotificationSearchString = string;
        }
    }

    String getOrgDN() {
        return this.orgDN;
    }

    Set getAssignedServices(SSOToken sSOToken) throws SMSException {
        try {
            HashSet<String> hashSet = new HashSet<String>();
            CachedSubEntries cachedSubEntries = null;
            cachedSubEntries = this.orgDN.equals(DNMapper.serviceDN) ? CachedSubEntries.getInstance(sSOToken, this.orgDN) : CachedSubEntries.getInstance(sSOToken, "ou=services," + this.orgDN);
            Iterator iterator = cachedSubEntries.getSubEntries(sSOToken).iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                ServiceConfigManagerImpl serviceConfigManagerImpl = ServiceConfigManagerImpl.getInstance(sSOToken, string, ServiceManager.serviceDefaultVersion(sSOToken, string));
                try {
                    ServiceConfigImpl serviceConfigImpl = serviceConfigManagerImpl.getOrganizationConfig(sSOToken, this.orgDN, null);
                    if (serviceConfigImpl == null || serviceConfigImpl.isNewEntry()) continue;
                    hashSet.add(string);
                }
                catch (SMSException sMSException) {
                    if (sMSException.getExceptionCode() == SMSException.STATUS_NO_PERMISSION) continue;
                    throw sMSException;
                }
            }
            return hashSet;
        }
        catch (SSOException sSOException) {
            debug.error("OrganizationConfigManagerImpl.getAssignedServices Unable to get assigned services", (Throwable)sSOException);
            throw new SMSException(SMSEntry.bundle.getString("sms-INVALID_SSO_TOKEN"), "sms-INVALID_SSO_TOKEN");
        }
    }

    Set getSubOrganizationNames(SSOToken sSOToken) throws SMSException {
        return this.getSubOrganizationNames(sSOToken, "*", false);
    }

    Set getSubOrganizationNames(SSOToken sSOToken, String string, boolean bl) throws SMSException {
        try {
            if (this.subEntries == null) {
                this.subEntries = CachedSubEntries.getInstance(sSOToken, this.orgDN);
            }
            return this.subEntries.searchSubOrgNames(sSOToken, string, bl);
        }
        catch (SSOException sSOException) {
            debug.error("OrganizationConfigManagerImpl: Unable to get sub organization names", (Throwable)sSOException);
            throw new SMSException(SMSEntry.bundle.getString("sms-INVALID_SSO_TOKEN"), "sms-INVALID_SSO_TOKEN");
        }
    }

    synchronized String addListener(ServiceListener serviceListener) {
        String string = SMSUtils.getUniqueID();
        HashMap hashMap = this.listenerObjects;
        synchronized (hashMap) {
            this.listenerObjects.put(string, serviceListener);
        }
        return string;
    }

    public void removeListener(String string) {
        HashMap hashMap = this.listenerObjects;
        synchronized (hashMap) {
            this.listenerObjects.remove(string);
        }
    }

    void entryChanged(String string, int n) {
        if (this.listenerObjects.size() == 0) {
            if (SMSEntry.eventDebug.messageEnabled()) {
                SMSEntry.eventDebug.message("OrgConfigMgrImpl::entryChanged No listeners registered: " + string + "\norgNotificationSearchString: " + this.orgNotificationSearchString);
            }
            return;
        }
        int n2 = 0;
        int n3 = 0;
        if (SMSEntry.eventDebug.messageEnabled()) {
            SMSEntry.eventDebug.message("OrgConfigMgrImpl::entryChanged  DN: " + string + "\norgNotificationSearchString: " + this.orgNotificationSearchString);
        }
        if ((n2 = string.indexOf(this.orgNotificationSearchString)) != -1) {
            CharSequence charSequence;
            int n4;
            n3 = "ou=services".length();
            DN dN = new DN(string.substring(0, n2 - 1));
            String[] stringArray = dN.explodeDN(false);
            if (stringArray[(n4 = stringArray.length) - 1].startsWith("o=")) {
                if (SMSEntry.eventDebug.messageEnabled()) {
                    SMSEntry.eventDebug.message("OrgConfigMgrImpl::entryChanged  Notification not sent since realms names donot match. \nDN: " + string + " And orgNotificationSearchString: " + this.orgNotificationSearchString);
                }
                return;
            }
            stringArray = dN.explodeDN(true);
            String string2 = n4 < 1 ? "" : stringArray[n4 - 1];
            String string3 = n4 < 2 ? "" : stringArray[n4 - 2];
            String string4 = n4 < 4 ? "" : stringArray[n4 - 4];
            String string5 = "";
            if (n4 >= 5) {
                charSequence = new StringBuffer();
                int n5 = n4 - 4;
                while (n5 >= 0) {
                    charSequence.append('/').append(stringArray[n5]);
                    --n5;
                }
                string5 = charSequence.toString();
            } else {
                string5 = "/";
            }
            switch (n) {
                case 0: {
                    n = 1;
                    break;
                }
                case 1: {
                    n = 2;
                    break;
                }
                default: {
                    n = 4;
                }
            }
            charSequence = string.substring(n2 + n3 + 1);
            if (SMSEntry.eventDebug.messageEnabled()) {
                SMSEntry.eventDebug.message("OrganizationConfigManagerImpl:entryChanged() serviceName " + string2);
                SMSEntry.eventDebug.message("OrganizationConfigManagerImpl:entryChanged() version " + string3);
                SMSEntry.eventDebug.message("OrganizationConfigManagerImpl:entryChanged() orgName " + (String)charSequence);
                SMSEntry.eventDebug.message("OrganizationConfigManagerImpl:entryChanged() groupName " + string4);
                SMSEntry.eventDebug.message("OrganizationConfigManagerImpl:entryChanged() compName " + string5);
                SMSEntry.eventDebug.message("OrganizationConfigManagerImpl:entryChanged() type " + n);
            }
            this.notifyOrgConfigChange(string2, string3, (String)charSequence, string4, string5, n);
        }
    }

    void notifyOrgConfigChange(String string, String string2, String string3, String string4, String string5, int n) {
        Map map = Collections.EMPTY_MAP;
        HashMap hashMap = this.listenerObjects;
        synchronized (hashMap) {
            map = (HashMap)this.listenerObjects.clone();
        }
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            ServiceListener serviceListener = (ServiceListener)iterator.next();
            serviceListener.organizationConfigChanged(string, string2, string3, string4, string5, n);
        }
    }

    protected static OrganizationConfigManagerImpl getInstance(SSOToken sSOToken, String string) throws SMSException {
        Object object;
        String string2 = DNMapper.orgNameToDN(string);
        if (string2.equalsIgnoreCase(SMSEntry.baseDN)) {
            string2 = DNMapper.serviceDN;
        }
        if (debug.messageEnabled()) {
            debug.message("OrganizationConfigMgrImpl::getInstance: called: (" + string + ")=" + string2);
        }
        try {
            object = CachedSMSEntry.getInstance(sSOToken, string2, null);
            if (ServiceManager.isCoexistenceMode()) {
                ((CachedSMSEntry)object).update();
            }
            if (((CachedSMSEntry)object).isNewEntry()) {
                if (debug.messageEnabled()) {
                    debug.message("OrganizationConfigManagerImpl::getInstance called with non-existent realm: " + string);
                }
                Object[] objectArray = new String[]{string};
                throw new SMSException("amSDK", "sms-REALM_NAME_NOT_FOUND", objectArray);
            }
        }
        catch (SSOException sSOException) {
            SMSEntry.debug.error("OrganizationConfigManager:Constructor", (Throwable)sSOException);
            throw new SMSException(SMSEntry.bundle.getString("sms-INVALID_SSO_TOKEN"), "sms-INVALID_SSO_TOKEN");
        }
        object = OrganizationConfigManagerImpl.getFromCache(string2, sSOToken);
        if (object != null) {
            return object;
        }
        String string3 = configMgrMutex;
        synchronized (string3) {
            object = OrganizationConfigManagerImpl.getFromCache(string2, sSOToken);
            if (object == null) {
                OrganizationConfigManagerImpl.checkAndUpdatePermission(string2, sSOToken);
                object = new OrganizationConfigManagerImpl(string2, sSOToken);
                HashMap<String, Object> hashMap = new HashMap<String, Object>(configMgrImpls);
                hashMap.put(string2, object);
                configMgrImpls = hashMap;
            }
        }
        if (debug.messageEnabled()) {
            debug.message("OrganizationConfigMgrImpl::getInstance: success: " + string2);
        }
        return object;
    }

    static OrganizationConfigManagerImpl getFromCache(String string, SSOToken sSOToken) throws SMSException {
        Set set;
        OrganizationConfigManagerImpl organizationConfigManagerImpl = (OrganizationConfigManagerImpl)configMgrImpls.get(string);
        if (organizationConfigManagerImpl != null && !(set = (Set)userPrincipals.get(string)).contains(sSOToken.getTokenID().toString())) {
            OrganizationConfigManagerImpl.checkAndUpdatePermission(string, sSOToken);
        }
        return organizationConfigManagerImpl;
    }

    static synchronized void checkAndUpdatePermission(String string, SSOToken sSOToken) throws SMSException {
        try {
            CachedSMSEntry cachedSMSEntry = CachedSMSEntry.getInstance(sSOToken, string, null);
            if (cachedSMSEntry.isNewEntry()) {
                throw new SMSException(SMSEntry.bundle.getString("sms-organization_does_not_exist"), "sms-organization_does_not_exist");
            }
            HashSet<String> hashSet = (HashSet<String>)userPrincipals.get(string);
            hashSet = hashSet == null ? new HashSet<String>() : new HashSet(hashSet);
            hashSet.add(sSOToken.getTokenID().toString());
            HashMap<String, HashSet<String>> hashMap = new HashMap<String, HashSet<String>>(userPrincipals);
            hashMap.put(string, hashSet);
            userPrincipals = hashMap;
        }
        catch (SSOException sSOException) {
            debug.error("OrganizationConfigManagerImpl: Unable to get Instance", (Throwable)sSOException);
            throw new SMSException(SMSEntry.bundle.getString("sms-INVALID_SSO_TOKEN"), "sms-INVALID_SSO_TOKEN");
        }
    }
}

