/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.servlet;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.am.util.XMLUtils;
import com.iplanet.services.util.Base64;
import com.sun.identity.saml.AssertionManager;
import com.sun.identity.saml.assertion.Assertion;
import com.sun.identity.saml.assertion.AssertionIDReference;
import com.sun.identity.saml.assertion.Statement;
import com.sun.identity.saml.common.LogUtils;
import com.sun.identity.saml.common.SAMLCertUtils;
import com.sun.identity.saml.common.SAMLConstants;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequestVersionTooHighException;
import com.sun.identity.saml.common.SAMLRequestVersionTooLowException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLServiceManager;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import com.sun.identity.saml.protocol.AbstractRequest;
import com.sun.identity.saml.protocol.AssertionArtifact;
import com.sun.identity.saml.protocol.Query;
import com.sun.identity.saml.protocol.Request;
import com.sun.identity.saml.protocol.Response;
import com.sun.identity.saml.protocol.Status;
import com.sun.identity.saml.protocol.StatusCode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.messaging.JAXMServlet;
import javax.xml.soap.Detail;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SAMLSOAPReceiver
extends JAXMServlet {
    private static MessageFactory msgFactory = null;
    private static SAMLConstants sc = null;
    public static String localSAMLServiceID = null;

    public void init(ServletConfig servletConfig) throws ServletException {
        String string = SystemProperties.get((String)"com.iplanet.am.server.protocol");
        String string2 = SystemProperties.get((String)"com.iplanet.am.server.host");
        String string3 = SystemProperties.get((String)"com.iplanet.am.server.port");
        localSAMLServiceID = string + "://" + string2 + ":" + string3;
        super.init(servletConfig);
        try {
            msgFactory = MessageFactory.newInstance();
        }
        catch (SOAPException sOAPException) {
            String string4 = SAMLUtilsCommon.bundle.getString("missingSoapMessageFactory");
            SAMLUtilsCommon.debug.error(string4, (Throwable)sOAPException);
            String[] stringArray = new String[]{SAMLUtilsCommon.bundle.getString("missingSoapMessageFactory")};
            LogUtils.error(Level.INFO, "SOAP_MESSAGE_FACTORY_ERROR", stringArray);
            throw new ServletException(sOAPException.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (SAMLUtils.getMaxContentLength() != 0) {
            int n = httpServletRequest.getContentLength();
            if (n == -1) {
                throw new ServletException(SAMLUtilsCommon.bundle.getString("unknownLength"));
            }
            if (n > SAMLUtils.getMaxContentLength()) {
                if (!SAMLUtilsCommon.debug.messageEnabled()) throw new ServletException(SAMLUtilsCommon.bundle.getString("largeContentLength"));
                SAMLUtilsCommon.debug.message("content length too large" + n);
                throw new ServletException(SAMLUtilsCommon.bundle.getString("largeContentLength"));
            }
        }
        String string = httpServletRequest.getRemoteAddr();
        Set set = null;
        set = SAMLSOAPReceiver.checkCaller(httpServletRequest, httpServletResponse);
        if (set != null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message(" got request from a trusted server, processing it now..");
            }
            try {
                MimeHeaders mimeHeaders = JAXMServlet.getHeaders((HttpServletRequest)httpServletRequest);
                ServletInputStream servletInputStream = httpServletRequest.getInputStream();
                SOAPMessage sOAPMessage = msgFactory.createMessage(mimeHeaders, (InputStream)servletInputStream);
                SOAPMessage sOAPMessage2 = null;
                sOAPMessage2 = this.onMessage(httpServletRequest, httpServletResponse, sOAPMessage, set);
                if (sOAPMessage2 == null) return;
                if (sOAPMessage2.saveRequired()) {
                    sOAPMessage2.saveChanges();
                }
                if (this.containsFault(sOAPMessage2)) {
                    if (SAMLUtilsCommon.debug.messageEnabled()) {
                        SAMLUtilsCommon.debug.message("Contains a SOAPFault!");
                    }
                    httpServletResponse.setStatus(500);
                } else {
                    httpServletResponse.setStatus(200);
                }
                JAXMServlet.putHeaders((MimeHeaders)sOAPMessage2.getMimeHeaders(), (HttpServletResponse)httpServletResponse);
                ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
                sOAPMessage2.writeTo((OutputStream)servletOutputStream);
                servletOutputStream.flush();
                return;
            }
            catch (Exception exception) {
                throw new ServletException((Throwable)exception);
            }
        } else {
            SAMLUtilsCommon.debug.error("Error message from SOAP Receiver:" + string + " is untrusted site");
            String[] stringArray = new String[]{SAMLUtilsCommon.bundle.getString("untrustedSite"), string};
            LogUtils.error(Level.INFO, "UNTRUSTED_SITE", stringArray);
            httpServletResponse.sendError(403);
        }
    }

    private boolean containsFault(SOAPMessage sOAPMessage) {
        try {
            SOAPPart sOAPPart = sOAPMessage.getSOAPPart();
            SOAPEnvelope sOAPEnvelope = sOAPPart.getEnvelope();
            SOAPBody sOAPBody = sOAPEnvelope.getBody();
            return sOAPBody.hasFault();
        }
        catch (Exception exception) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Error in containFault!");
            }
            return false;
        }
    }

    private SOAPMessage onMessage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, SOAPMessage sOAPMessage, Set set) {
        try {
            Object object;
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("OnMessage called in receiving servlet");
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            sOAPMessage.writeTo((OutputStream)byteArrayOutputStream);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            Document document = XMLUtils.toDOMDocument((InputStream)byteArrayInputStream, (Debug)SAMLUtilsCommon.debug);
            Element element = document.getDocumentElement();
            String string = document.getDocumentElement().getLocalName();
            if (string == null || string.equals("")) {
                SAMLUtilsCommon.debug.error("Local name of the SOAPElement in  the SOAPMessage passed seems to be missing");
                return this.FormSOAPError(httpServletResponse, "Client", "nullInput", "LocalNameMissing");
            }
            if (!string.equals("Envelope") || !element.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/")) {
                SAMLUtilsCommon.debug.error("SOAPReceiver: Could not parse SOAPMessage, either root element is not Envelope or invalid name space or prefix");
                return this.FormSOAPError(httpServletResponse, "Client", "invalidElement", "envelopeInvalid");
            }
            NodeList nodeList = document.getChildNodes();
            int n = nodeList.getLength();
            if (n <= 0) {
                SAMLUtilsCommon.debug.error("SOAPReceiver: Message does not have body");
                return this.FormSOAPError(httpServletResponse, "Client", "missingBody", null);
            }
            Node node = null;
            int n2 = 0;
            while (n2 < n) {
                node = nodeList.item(n2);
                if (node.getNodeType() == 1 && ((String)(object = node.getLocalName())).equals("Body")) break;
                ++n2;
            }
            object = (Element)node;
            Response response = this.extractProcessRequest(httpServletRequest, (Element)object, set);
            if (((Boolean)SAMLServiceManager.getAttribute("iplanet-am-saml-signresponse")).booleanValue()) {
                response.signXML();
            }
            return this.FormMessageResponse(httpServletResponse, response);
        }
        catch (Exception exception) {
            SAMLUtilsCommon.debug.error("Error in processing Request", (Throwable)exception);
            return this.FormSOAPError(httpServletResponse, "Server", "cannotProcessRequest", null);
        }
    }

    private Response extractProcessRequest(HttpServletRequest httpServletRequest, Element element, Set set) {
        String[] stringArray;
        Object object;
        String[] stringArray2;
        String[] stringArray3;
        String string;
        Response response = null;
        String string2 = SAMLUtilsCommon.generateID();
        String string3 = null;
        ArrayList arrayList = new ArrayList();
        String string4 = null;
        String string5 = string = httpServletRequest.getRemoteAddr();
        String string6 = SAMLUtilsCommon.bundle.getString("invalidRequestLogMessage") + " " + string + ": ";
        String string7 = SAMLUtilsCommon.bundle.getString("responseLogMessage") + " " + string + ": ";
        NodeList nodeList = element.getElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:protocol", "Request");
        int n = nodeList.getLength();
        if (n == 0) {
            SAMLUtilsCommon.debug.error("SOAPReceiver: Body does not have a Request");
            string4 = SAMLUtilsCommon.bundle.getString("missingRequest");
            try {
                Status status = new Status(new StatusCode("samlp:Requester"), string4, null);
                response = new Response(string2, string3, status, string5, arrayList);
            }
            catch (SAMLException sAMLException) {
                SAMLUtilsCommon.debug.error("SOAPReceiver:Fatal error, cannot create status or response:" + sAMLException.getMessage());
            }
            String[] stringArray4 = new String[]{string6, response.toString()};
            LogUtils.error(Level.INFO, "INVALID_REQUEST", stringArray4);
            return response;
        }
        boolean bl = false;
        AbstractRequest abstractRequest = null;
        int n2 = 0;
        while (n2 < n) {
            stringArray3 = nodeList.item(n2);
            if (stringArray3.getNodeType() == 1 && stringArray3.getLocalName().equals("Request")) {
                try {
                    abstractRequest = new Request((Element)stringArray3);
                    SAMLUtilsCommon.debug.message("found request ");
                    if (SAMLUtilsCommon.debug.messageEnabled()) {
                        SAMLUtilsCommon.debug.message(" Received Request:" + ((Request)abstractRequest).toString());
                    }
                    stringArray2 = new String[]{SAMLUtilsCommon.bundle.getString("requestLogMessage") + " " + string, ((Request)abstractRequest).toString()};
                    LogUtils.access(Level.FINE, "SOAP_REQUEST_MESSAGE", stringArray2);
                    string3 = abstractRequest.getRequestID();
                    bl = true;
                    break;
                }
                catch (SAMLRequesterException sAMLRequesterException) {
                    if (SAMLUtilsCommon.debug.messageEnabled()) {
                        SAMLUtilsCommon.debug.message("SOAPReceiver:setting status to samlp:Requester " + sAMLRequesterException.getMessage());
                    }
                    string4 = new String(sAMLRequesterException.getMessage());
                    try {
                        Status status = new Status(new StatusCode("samlp:Requester"), string4, null);
                        response = new Response(string2, string3, status, string5, arrayList);
                    }
                    catch (SAMLException sAMLException) {
                        SAMLUtilsCommon.debug.error("SOAPReceiver:Fatal error, cannot create status or response:" + sAMLException.getMessage());
                    }
                    String[] stringArray5 = new String[]{string6, response.toString()};
                    LogUtils.error(Level.INFO, "INVALID_REQUEST", stringArray5);
                    return response;
                }
                catch (SAMLRequestVersionTooHighException sAMLRequestVersionTooHighException) {
                    String string8 = new String(sAMLRequestVersionTooHighException.getMessage());
                    StringTokenizer stringTokenizer = new StringTokenizer(string8, "|");
                    string3 = stringTokenizer.nextToken();
                    string4 = stringTokenizer.nextToken();
                    if (SAMLUtilsCommon.debug.messageEnabled()) {
                        SAMLUtilsCommon.debug.message("SOAPReceiver:setting status to samlp:VersionMismatch " + string4);
                    }
                    try {
                        Status status = new Status(new StatusCode("samlp:RequestVersionTooHigh"), string4, null);
                        response = new Response(string2, string3, status, string5, arrayList);
                    }
                    catch (SAMLException sAMLException) {
                        SAMLUtilsCommon.debug.error("SOAPReceiver:Fatal error, cannot create status or response:" + sAMLException.getMessage());
                    }
                    String[] stringArray6 = new String[]{string6, response.toString()};
                    LogUtils.error(Level.INFO, "INVALID_REQUEST", stringArray6);
                    return response;
                }
                catch (SAMLRequestVersionTooLowException sAMLRequestVersionTooLowException) {
                    String string9 = new String(sAMLRequestVersionTooLowException.getMessage());
                    StringTokenizer stringTokenizer = new StringTokenizer(string9, "|");
                    string3 = stringTokenizer.nextToken();
                    string4 = stringTokenizer.nextToken();
                    if (SAMLUtilsCommon.debug.messageEnabled()) {
                        SAMLUtilsCommon.debug.message("SOAPReceiver:setting status to samlp:VersionMismatch " + string4);
                    }
                    try {
                        Status status = new Status(new StatusCode("samlp:RequestVersionTooLow"), string4, null);
                        response = new Response(string2, string3, status, string5, arrayList);
                    }
                    catch (SAMLException sAMLException) {
                        SAMLUtilsCommon.debug.error("SOAPReceiver:Fatal error, cannot create status or response:" + sAMLException.getMessage());
                    }
                    String[] stringArray7 = new String[]{string6, response.toString()};
                    LogUtils.error(Level.INFO, "INVALID_REQUEST", stringArray7);
                    return response;
                }
                catch (Exception exception) {
                    if (SAMLUtilsCommon.debug.messageEnabled()) {
                        SAMLUtilsCommon.debug.message("SOAPReceiver:setting status to samlp:Responder " + exception.getMessage());
                    }
                    string4 = new String(exception.getMessage());
                    try {
                        Status status = new Status(new StatusCode("samlp:Responder"), string4, null);
                        response = new Response(string2, string3, status, string5, arrayList);
                    }
                    catch (SAMLException sAMLException) {
                        SAMLUtilsCommon.debug.error("SOAPReceiver:Fatal error, cannot create status or response:" + sAMLException.getMessage());
                    }
                    String[] stringArray8 = new String[]{string6, response.toString()};
                    LogUtils.error(Level.INFO, "INVALID_REQUEST", stringArray8);
                    return response;
                }
            }
            ++n2;
        }
        if (!bl) {
            SAMLUtilsCommon.debug.error("SOAPReceiver: Body does not have a Request");
            string4 = SAMLUtilsCommon.bundle.getString("missingRequest");
            try {
                Status status = new Status(new StatusCode("samlp:Requester"), string4, null);
                response = new Response(string2, string3, status, string5, arrayList);
            }
            catch (SAMLException sAMLException) {
                SAMLUtilsCommon.debug.error("SOAPReceiver:Fatal error, cannot create status or response:" + sAMLException.getMessage());
            }
            stringArray3 = new String[]{string6, response.toString()};
            LogUtils.error(Level.INFO, "INVALID_REQUEST", stringArray3);
            return response;
        }
        if (!abstractRequest.isSignatureValid()) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("SOAPReceiver: couldn't verify the signature on Request.");
            }
            string4 = SAMLUtilsCommon.bundle.getString("cannotVerifyRequest");
            try {
                Status status = new Status(new StatusCode("samlp:Requester"), string4, null);
                response = new Response(string2, string3, status, string5, arrayList);
                response.setMajorVersion(abstractRequest.getMajorVersion());
                response.setMinorVersion(abstractRequest.getMinorVersion());
            }
            catch (SAMLException sAMLException) {
                SAMLUtilsCommon.debug.error("SOAPReceiver:Fatal error, cannot create status or response", (Throwable)sAMLException);
                stringArray2 = new String[]{SAMLUtilsCommon.bundle.getString("cannotBuildResponse")};
                LogUtils.error(Level.INFO, "BUILD_RESPONSE_ERROR", stringArray2);
            }
            stringArray3 = new String[]{string7, response.toString()};
            LogUtils.access(Level.INFO, "SENDING_RESPONSE", stringArray3);
            return response;
        }
        int n3 = ((Request)abstractRequest).getContentType();
        if (n3 == -1) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("SOAPReceiver:Found element in the request which are not supported");
            }
            string4 = SAMLUtilsCommon.bundle.getString("unsupportedElement");
            try {
                Status status = new Status(new StatusCode("samlp:Responder"), string4, null);
                response = new Response(string2, string3, status, string5, arrayList);
                response.setMajorVersion(abstractRequest.getMajorVersion());
                response.setMinorVersion(abstractRequest.getMinorVersion());
            }
            catch (SAMLException sAMLException) {
                SAMLUtilsCommon.debug.error("SOAPReceiver:Fatal error, cannot create status or response", (Throwable)sAMLException);
                String[] stringArray9 = new String[]{SAMLUtilsCommon.bundle.getString("cannotBuildResponse")};
                LogUtils.error(Level.INFO, "BUILD_RESPONSE_ERROR", stringArray9);
            }
            stringArray2 = new String[]{string7, response.toString()};
            LogUtils.access(Level.INFO, "SENDING_RESPONSE", stringArray2);
            return response;
        }
        stringArray2 = abstractRequest.getRespondWith();
        if (!this.parseRespondWith((List)stringArray2)) {
            SAMLUtilsCommon.debug.error("SOAPReceiver:Supported statements are not present in the RespondWith element.");
            string4 = SAMLUtilsCommon.bundle.getString("unsupportedStatement");
            try {
                Status status = new Status(new StatusCode("samlp:Responder"), string4, null);
                response = new Response(string2, string3, status, string5, arrayList);
                response.setMajorVersion(abstractRequest.getMajorVersion());
                response.setMinorVersion(abstractRequest.getMinorVersion());
            }
            catch (SAMLException sAMLException) {
                SAMLUtilsCommon.debug.error("SOAPReceiver:Fatal error, cannot create status or response", (Throwable)sAMLException);
                String[] stringArray10 = new String[]{SAMLUtilsCommon.bundle.getString("cannotBuildResponse")};
                LogUtils.error(Level.INFO, "BUILD_RESPONSE_ERROR", stringArray10);
            }
            String[] stringArray11 = new String[]{string7, response.toString()};
            LogUtils.access(Level.INFO, "SENDING_RESPONSE", stringArray11);
            return response;
        }
        AssertionManager assertionManager = null;
        try {
            assertionManager = AssertionManager.getInstance();
        }
        catch (SAMLException sAMLException) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("SOAPReceiver: Cannot instantiate AssertionManager");
            }
            string4 = sAMLException.getMessage();
            try {
                Status status = new Status(new StatusCode("samlp:Responder"), string4, null);
                response = new Response(string2, string3, status, string5, arrayList);
                response.setMajorVersion(abstractRequest.getMajorVersion());
                response.setMinorVersion(abstractRequest.getMinorVersion());
            }
            catch (SAMLException sAMLException2) {
                SAMLUtilsCommon.debug.error("SOAPReceiver:Fatal error, cannot create status or response", (Throwable)sAMLException2);
                String[] stringArray12 = new String[]{SAMLUtilsCommon.bundle.getString("cannotBuildResponse")};
                LogUtils.error(Level.INFO, "BUILD_RESPONSE_ERROR", stringArray12);
            }
            String[] stringArray13 = new String[]{string7, response.toString()};
            LogUtils.access(Level.INFO, "SENDING_RESPONSE", stringArray13);
            return response;
        }
        List list = null;
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        if (n3 == 3) {
            list = ((Request)abstractRequest).getAssertionArtifact();
            n = list.size();
            object = null;
            int n4 = 0;
            while (n4 < n) {
                AssertionArtifact assertionArtifact = (AssertionArtifact)list.get(n4);
                if (!this.isThisSiteID(assertionArtifact.getSourceID())) {
                    if (SAMLUtilsCommon.debug.messageEnabled()) {
                        SAMLUtilsCommon.debug.message("SOAPReceiver:Artifact has invalid SourceID");
                    }
                    string4 = SAMLUtilsCommon.bundle.getString("mismatchSourceID");
                    try {
                        Status status = new Status(new StatusCode("samlp:Requester"), string4, null);
                        response = new Response(string2, string3, status, string5, arrayList);
                        response.setMajorVersion(abstractRequest.getMajorVersion());
                        response.setMinorVersion(abstractRequest.getMinorVersion());
                    }
                    catch (SAMLException sAMLException) {
                        SAMLUtilsCommon.debug.error("SOAPReceiver:Fatal error, cannot create status or response", (Throwable)sAMLException);
                        String[] stringArray14 = new String[]{SAMLUtilsCommon.bundle.getString("cannotBuildResponse")};
                        LogUtils.error(Level.INFO, "BUILD_RESPONSE_ERROR", stringArray14);
                    }
                    String[] stringArray15 = new String[]{string7, response.toString()};
                    LogUtils.access(Level.INFO, "SENDING_RESPONSE", stringArray15);
                    return response;
                }
                ++n4;
            }
            int n5 = 0;
            while (n5 < n) {
                stringArray = (AssertionArtifact)list.get(n5);
                Assertion assertion = null;
                try {
                    assertion = assertionManager.getAssertion((AssertionArtifact)stringArray, set);
                }
                catch (SAMLException sAMLException) {
                    if (SAMLUtilsCommon.debug.messageEnabled()) {
                        SAMLUtilsCommon.debug.message("SOAPReceiver: could not find matching assertion");
                    }
                    string4 = sAMLException.getMessage();
                    try {
                        Status status = new Status(new StatusCode("samlp:Success"), string4, null);
                        response = new Response(string2, string3, status, string5, arrayList);
                        response.setMajorVersion(abstractRequest.getMajorVersion());
                        response.setMinorVersion(abstractRequest.getMinorVersion());
                    }
                    catch (SAMLException sAMLException3) {
                        SAMLUtilsCommon.debug.error("SOAPReceiver:Fatal error, cannot create status or response", (Throwable)sAMLException3);
                        String[] stringArray16 = new String[]{SAMLUtilsCommon.bundle.getString("cannotBuildResponse")};
                        LogUtils.error(Level.INFO, "BUILD_RESPONSE_ERROR", stringArray16);
                    }
                    String[] stringArray17 = new String[]{string7, response.toString()};
                    LogUtils.access(Level.INFO, "SENDING_RESPONSE", stringArray17);
                    return response;
                }
                if (assertion != null) {
                    arrayList2.add(n5, assertion);
                }
                ++n5;
            }
        } else if (n3 == 2) {
            object = ((Request)abstractRequest).getAssertionIDReference();
            n = object.size();
            int n6 = 0;
            while (n6 < n) {
                AssertionIDReference assertionIDReference = (AssertionIDReference)object.get(n6);
                stringArray = null;
                try {
                    stringArray = assertionManager.getAssertion(assertionIDReference, set);
                }
                catch (SAMLException sAMLException) {
                    if (SAMLUtilsCommon.debug.messageEnabled()) {
                        SAMLUtilsCommon.debug.message("SOAPReceiver: could not find matching assertion");
                    }
                    string4 = sAMLException.getMessage();
                    try {
                        Status status = new Status(new StatusCode("samlp:Success"), string4, null);
                        response = new Response(string2, string3, status, string5, arrayList);
                        response.setMajorVersion(abstractRequest.getMajorVersion());
                        response.setMinorVersion(abstractRequest.getMinorVersion());
                    }
                    catch (SAMLException sAMLException4) {
                        SAMLUtilsCommon.debug.error("SOAPReceiver:Fatal error, cannot create status or response", (Throwable)sAMLException4);
                        String[] stringArray18 = new String[]{SAMLUtilsCommon.bundle.getString("cannotBuildResponse")};
                        LogUtils.error(Level.INFO, "BUILD_RESPONSE_ERROR", stringArray18);
                    }
                    String[] stringArray19 = new String[]{string7, response.toString()};
                    LogUtils.access(Level.INFO, "SENDING_RESPONSE", stringArray19);
                    return response;
                }
                if (stringArray != null) {
                    arrayList2.add(n6, stringArray);
                }
                ++n6;
            }
        } else if (n3 == 0 || n3 == 1 || n3 == 4) {
            object = ((Request)abstractRequest).getQuery();
            if (object != null) {
                Assertion assertion = null;
                try {
                    assertion = assertionManager.getAssertion((Query)object, (String)set.iterator().next());
                }
                catch (SAMLException sAMLException) {
                    if (SAMLUtilsCommon.debug.messageEnabled()) {
                        SAMLUtilsCommon.debug.message("SOAPReceiver: could not find matching assertion");
                    }
                    string4 = sAMLException.getMessage();
                    try {
                        Status status = new Status(new StatusCode("samlp:Success"), string4, null);
                        response = new Response(string2, string3, status, string5, arrayList);
                        response.setMajorVersion(abstractRequest.getMajorVersion());
                        response.setMinorVersion(abstractRequest.getMinorVersion());
                    }
                    catch (SAMLException sAMLException5) {
                        SAMLUtilsCommon.debug.error("SOAPReceiver:Fatal  error, cannot create status or  response", (Throwable)sAMLException5);
                        String[] stringArray20 = new String[]{SAMLUtilsCommon.bundle.getString("cannotBuildResponse")};
                        LogUtils.error(Level.INFO, "BUILD_RESPONSE_ERROR", stringArray20);
                    }
                    String[] stringArray21 = new String[]{string7, response.toString()};
                    LogUtils.access(Level.INFO, "SENDING_RESPONSE", stringArray21);
                    return response;
                }
                if (assertion != null) {
                    arrayList2.add(assertion);
                }
            }
        } else {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("SOAPReceiver:Request contents has element which is not supported at this time");
            }
            string4 = SAMLUtilsCommon.bundle.getString("unsupportedElement");
            try {
                Status status = new Status(new StatusCode("samlp:Responder"), string4, null);
                response = new Response(string2, string3, status, string5, arrayList);
                response.setMajorVersion(abstractRequest.getMajorVersion());
                response.setMinorVersion(abstractRequest.getMinorVersion());
            }
            catch (SAMLException sAMLException) {
                SAMLUtilsCommon.debug.error("SOAPReceiver:Fatal error, cannot create status or response", (Throwable)sAMLException);
                String[] stringArray22 = new String[]{SAMLUtilsCommon.bundle.getString("cannotBuildResponse")};
                LogUtils.error(Level.INFO, "BUILD_RESPONSE_ERROR", stringArray22);
            }
            String[] stringArray23 = new String[]{string7, response.toString()};
            LogUtils.access(Level.INFO, "SENDING_RESPONSE", stringArray23);
            return response;
        }
        int n7 = arrayList2.size();
        if (SAMLUtilsCommon.debug.messageEnabled()) {
            SAMLUtilsCommon.debug.message("found " + n7 + " assertions.");
        }
        int n8 = 0;
        while (n8 < n7) {
            Response response2 = this.validateStatements((Assertion)arrayList2.get(n8), (List)stringArray2, arrayList, n8, string2, string3, string5);
            if (response2 != null) {
                stringArray = new String[]{string7, response.toString()};
                LogUtils.access(Level.INFO, "SENDING_RESPONSE", stringArray);
                response.setMajorVersion(abstractRequest.getMajorVersion());
                response.setMinorVersion(abstractRequest.getMinorVersion());
                return response2;
            }
            ++n8;
        }
        if (n3 == 3) {
            if (arrayList.size() == list.size()) {
                string4 = null;
                if (SAMLUtilsCommon.debug.messageEnabled()) {
                    SAMLUtilsCommon.debug.message("SOAPReceiver: Matching Assertion found");
                }
                try {
                    Status status = new Status(new StatusCode("samlp:Success"), string4, null);
                    response = new Response(string2, string3, status, string5, arrayList);
                    response.setMajorVersion(abstractRequest.getMajorVersion());
                    response.setMinorVersion(abstractRequest.getMinorVersion());
                }
                catch (SAMLException sAMLException) {
                    SAMLUtilsCommon.debug.error("SOAPReceiver:Fatal error, cannot create status or response", (Throwable)sAMLException);
                    stringArray = new String[]{SAMLUtilsCommon.bundle.getString("cannotBuildResponse")};
                    LogUtils.error(Level.INFO, "BUILD_RESPONSE_ERROR", stringArray);
                }
                String[] stringArray24 = new String[]{string7, response.toString()};
                LogUtils.access(Level.FINE, "SENDING_RESPONSE", stringArray24);
                return response;
            }
            string4 = SAMLUtilsCommon.bundle.getString("unequalMatch");
            try {
                Status status = new Status(new StatusCode("samlp:Success"), string4, null);
                response = new Response(string2, string3, status, string5, arrayList);
                response.setMajorVersion(abstractRequest.getMajorVersion());
                response.setMinorVersion(abstractRequest.getMinorVersion());
            }
            catch (SAMLException sAMLException) {
                SAMLUtilsCommon.debug.error("SOAPReceiver:Fatal error, cannot create status or response", (Throwable)sAMLException);
                stringArray = new String[]{SAMLUtilsCommon.bundle.getString("cannotBuildResponse")};
                LogUtils.error(Level.INFO, "BUILD_RESPONSE_ERROR", stringArray);
            }
            String[] stringArray25 = new String[]{string7, response.toString()};
            LogUtils.access(Level.INFO, "SENDING_RESPONSE", stringArray25);
            return response;
        }
        try {
            Status status = new Status(new StatusCode("samlp:Success"), string4, null);
            response = new Response(string2, string3, status, string5, arrayList);
            response.setMajorVersion(abstractRequest.getMajorVersion());
            response.setMinorVersion(abstractRequest.getMinorVersion());
        }
        catch (SAMLException sAMLException) {
            SAMLUtilsCommon.debug.error("SOAPReceiver:Fatal error, cannot create status or response", (Throwable)sAMLException);
            stringArray = new String[]{SAMLUtilsCommon.bundle.getString("cannotBuildResponse")};
            LogUtils.error(Level.INFO, "BUILD_RESPONSE_ERROR", stringArray);
        }
        if (LogUtils.isLoggable(Level.FINER)) {
            String[] stringArray26 = new String[]{string7, response.toString()};
            LogUtils.access(Level.FINER, "SENDING_RESPONSE", stringArray26);
        } else {
            String[] stringArray27 = new String[]{string7, response.getResponseID()};
            LogUtils.access(Level.INFO, "SENDING_RESPONSE", stringArray27);
        }
        return response;
    }

    private SOAPMessage FormSOAPError(HttpServletResponse httpServletResponse, String string, String string2, String string3) {
        SOAPMessage sOAPMessage = null;
        SOAPEnvelope sOAPEnvelope = null;
        SOAPFault sOAPFault = null;
        SOAPBody sOAPBody = null;
        DetailEntry detailEntry = null;
        try {
            sOAPMessage = msgFactory.createMessage();
            sOAPEnvelope = sOAPMessage.getSOAPPart().getEnvelope();
            sOAPBody = sOAPEnvelope.getBody();
            sOAPFault = sOAPBody.addFault();
            sOAPFault.setFaultCode(string);
            sOAPFault.setFaultString(SAMLUtilsCommon.bundle.getString(string2));
            if (string3 != null && !string3.equals("")) {
                Detail detail = sOAPFault.addDetail();
                detailEntry = detail.addDetailEntry(sOAPEnvelope.createName("Problem"));
                detailEntry.addAttribute(sOAPEnvelope.createName("details"), SAMLUtilsCommon.bundle.getString(string3));
            }
        }
        catch (SOAPException sOAPException) {
            SAMLUtilsCommon.debug.error("FormSOAPError:", (Throwable)sOAPException);
            String[] stringArray = new String[]{SAMLUtilsCommon.bundle.getString("soapFaultError")};
            LogUtils.error(Level.INFO, "SOAP_FAULT_ERROR", stringArray);
            httpServletResponse.setStatus(500);
        }
        return sOAPMessage;
    }

    private SOAPMessage FormMessageResponse(HttpServletResponse httpServletResponse, Response response) {
        SOAPMessage sOAPMessage = null;
        MimeHeaders mimeHeaders = new MimeHeaders();
        mimeHeaders.addHeader("Content-Type", "text/xml");
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("<").append("soap-env").append(":Envelope").append(" ").append("xmlns:").append("soap-env").append("=\"").append("http://schemas.xmlsoap.org/soap/envelope/").append("\">").append("\n");
        stringBuffer.append("<").append("soap-env").append(":Body>").append("\n");
        StringBuffer stringBuffer2 = new StringBuffer(100);
        stringBuffer2.append("</").append("soap-env").append(":Body>").append("\n");
        stringBuffer2.append("</").append("soap-env").append(":Envelope>").append("\n");
        try {
            StringBuffer stringBuffer3 = new StringBuffer(300);
            stringBuffer3.append((Object)stringBuffer).append(response.toString()).append((Object)stringBuffer2);
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("response created is: " + stringBuffer3.toString());
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(stringBuffer3.toString().getBytes("UTF-8"));
            sOAPMessage = msgFactory.createMessage(mimeHeaders, (InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        }
        catch (Exception exception) {
            SAMLUtilsCommon.debug.error("could not build response:" + exception.getMessage());
            httpServletResponse.setStatus(500);
            return this.FormSOAPError(httpServletResponse, "Server", "cannotBuildResponse", "cannotVerifyIdentity");
        }
        return sOAPMessage;
    }

    private Response validateStatements(Assertion assertion, List list, List list2, int n, String string, String string2, String string3) {
        Object var8_8 = null;
        String string4 = null;
        Set set = assertion.getStatement();
        int n2 = set.size();
        Response response = null;
        Status status = null;
        if (set.isEmpty() || n2 == 0) {
            SAMLUtilsCommon.debug.error("SOAPReceiver: Assertion found does not have any statements in it");
            string4 = SAMLUtilsCommon.bundle.getString("missingStatement");
            try {
                status = new Status(new StatusCode("samlp:Responder"), string4, null);
                response = new Response(string, string2, status, string3, list2);
            }
            catch (SAMLException sAMLException) {
                SAMLUtilsCommon.debug.error("SOAPReceiver:Fatal error, cannot create status or response", (Throwable)sAMLException);
                String[] stringArray = new String[]{SAMLUtilsCommon.bundle.getString("cannotBuildResponse")};
                LogUtils.error(Level.INFO, "BUILD_RESPONSE_ERROR", stringArray);
            }
            return response;
        }
        boolean bl = false;
        if (list.size() == 0) {
            list2.add(n, assertion);
        } else {
            boolean bl2 = bl = !this.checkAgainstRespondWith(list, set);
            if (!bl) {
                list2.add(n, assertion);
            }
        }
        if (bl) {
            SAMLUtilsCommon.debug.error("SOAPReceiver: Assertion does not  meet respondWith criteria in the received Request");
            string4 = SAMLUtilsCommon.bundle.getString("mismatchRespondWith");
            try {
                status = new Status(new StatusCode("samlp:Success"), string4, null);
                return new Response(string, string2, status, string3, list2);
            }
            catch (SAMLException sAMLException) {
                SAMLUtilsCommon.debug.error("SOAPReceiver:Fatal error,  cannot create status or response", (Throwable)sAMLException);
                String[] stringArray = new String[]{SAMLUtilsCommon.bundle.getString("cannotBuildResponse")};
                LogUtils.error(Level.INFO, "BUILD_RESPONSE_ERROR", stringArray);
            }
        }
        return null;
    }

    private boolean parseRespondWith(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            int n = string.indexOf(":");
            if (n == -1 || n == 0) {
                return false;
            }
            if (string.endsWith(":AuthenticationStatement") || string.endsWith(":AuthorizationDecisionStatement") || string.endsWith(":AttributeStatement")) continue;
            return false;
        }
        return true;
    }

    private boolean checkAgainstRespondWith(List list, Set set) {
        boolean bl = false;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            bl = false;
            Statement statement = (Statement)iterator.next();
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                String string = (String)iterator2.next();
                SAMLUtilsCommon.debug.message("matching respondWith element:" + string);
                switch (statement.getStatementType()) {
                    case 1: {
                        if (!string.endsWith(":AuthenticationStatement")) break;
                        SAMLUtilsCommon.debug.message("matching auth st");
                        bl = true;
                        break;
                    }
                    case 2: {
                        if (!string.endsWith(":AuthorizationDecisionStatement")) break;
                        SAMLUtilsCommon.debug.message("matching authz st");
                        bl = true;
                        break;
                    }
                    case 3: {
                        if (!string.endsWith(":AttributeStatement")) break;
                        SAMLUtilsCommon.debug.message("matching attrib st");
                        bl = true;
                    }
                }
                if (!bl) continue;
                SAMLUtilsCommon.debug.message("match found");
                break;
            }
            if (bl) continue;
            SAMLUtilsCommon.debug.message("mismatch found");
            return false;
        }
        return true;
    }

    protected static Set checkCaller(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        String string = null;
        Set set = null;
        String string2 = httpServletRequest.getRemoteAddr();
        if (SAMLUtilsCommon.debug.messageEnabled()) {
            SAMLUtilsCommon.debug.message("caller's IP:" + string2);
        }
        X509Certificate[] x509CertificateArray = null;
        if (httpServletRequest.isSecure()) {
            try {
                x509CertificateArray = (X509Certificate[])httpServletRequest.getAttribute("javax.servlet.request.X509Certificate");
            }
            catch (Exception exception) {
                SAMLUtilsCommon.debug.error("SAMLSOAPReceiver: Exception", (Throwable)exception);
            }
        }
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            string = string2;
        } else {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("SAMLSOAPReceiver: got all certs from HttpServletRequest =" + x509CertificateArray.length);
            }
            X509Certificate x509Certificate = x509CertificateArray[0];
            SAMLCertUtils.CertEntry certEntry = null;
            certEntry = SAMLCertUtils.getMatchingCertEntry(x509Certificate);
            if (certEntry != null) {
                string = certEntry.getNickName();
                if (SAMLUtilsCommon.debug.messageEnabled()) {
                    SAMLUtilsCommon.debug.message("Found matching nickname:" + string);
                }
            }
        }
        set = SAMLSOAPReceiver.getPartnerSourceID(string);
        if (set == null || set.isEmpty()) {
            return null;
        }
        return set;
    }

    private static Set getPartnerSourceID(String string) {
        Map map = (Map)SAMLServiceManager.getAttribute("iplanet-am-saml-partner-urls");
        if (map != null) {
            HashSet<String> hashSet = new HashSet<String>();
            Set set = map.entrySet();
            Iterator iterator = set.iterator();
            Set set2 = null;
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                SAMLServiceManager.SOAPEntry sOAPEntry = (SAMLServiceManager.SOAPEntry)entry.getValue();
                set2 = sOAPEntry.getHostSet();
                if (set2 == null || !set2.contains(string)) continue;
                hashSet.add((String)entry.getKey());
                if (!SAMLUtilsCommon.debug.messageEnabled()) continue;
                SAMLUtilsCommon.debug.message("getPartnerSourceID: found a matching sid=" + Base64.encode((byte[])SAMLUtils.stringToByteArray((String)entry.getKey())));
            }
            return hashSet;
        }
        return null;
    }

    private boolean isThisSiteID(String string) {
        return ((String)SAMLServiceManager.getAttribute("mysiteid")).equals(string);
    }
}

