/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.servlet;

import com.iplanet.am.util.AMURLEncDec;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.modules.saml.SAMLPrincipal;
import com.sun.identity.saml.AssertionManager;
import com.sun.identity.saml.common.LogUtils;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLServiceManager;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import com.sun.identity.saml.protocol.AssertionArtifact;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.security.auth.Subject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SAMLAwareServlet
extends HttpServlet {
    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        if (httpServletRequest == null || httpServletResponse == null) {
            String[] stringArray = new String[]{SAMLUtilsCommon.bundle.getString("nullInputParameter")};
            LogUtils.error(Level.INFO, "NULL_PARAMETER", stringArray);
            httpServletResponse.sendError(500, SAMLUtilsCommon.bundle.getString("nullInputParameter"));
            return;
        }
        SAMLUtils.checkHTTPContentLength(httpServletRequest);
        String string = httpServletRequest.getParameter((String)SAMLServiceManager.getAttribute("iplanet-am-saml-target-specifier"));
        String string2 = httpServletRequest.getParameter((String)SAMLServiceManager.getAttribute("iplanet-am-saml-artifact-name"));
        if (string == null || string.equals("")) {
            String[] stringArray = new String[]{SAMLUtilsCommon.bundle.getString("missingTargetSite")};
            LogUtils.error(Level.INFO, "MISSING_TARGET", stringArray);
            httpServletResponse.sendError(500, SAMLUtilsCommon.bundle.getString("invalidConfig"));
            return;
        }
        httpServletResponse.setContentType("text/html; charset=UTF-8");
        if (string2 == null || string2.equals("")) {
            this.IntersiteTransfer(httpServletRequest, httpServletResponse, string);
        } else {
            this.ArtifactHandler(httpServletRequest, httpServletResponse);
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this.doGet(httpServletRequest, httpServletResponse);
    }

    private List createArtifact(SSOToken sSOToken, String string, String string2, String string3) throws SAMLException {
        if (sSOToken == null || string == null || string.equals("") || string3 == null || string3.equals("")) {
            throw new SAMLException(SAMLUtilsCommon.bundle.getString("createArtifactError"));
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        AssertionManager assertionManager = AssertionManager.getInstance();
        AssertionArtifact assertionArtifact = assertionManager.createAssertionArtifact(sSOToken.getTokenID().toString(), string, string2, string3);
        if (SAMLUtilsCommon.debug.messageEnabled()) {
            SAMLUtilsCommon.debug.message("AssertionArtifact id = " + assertionArtifact.toString());
        }
        String string4 = assertionArtifact.getAssertionArtifact();
        arrayList.add(string4);
        return arrayList;
    }

    private void IntersiteTransfer(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws IOException, ServletException {
        StringBuffer stringBuffer;
        Object object;
        String[] stringArray;
        URL uRL = new URL(string);
        String string2 = uRL.getHost();
        int n = uRL.getPort();
        if (string2 == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.error("SAMLAwareServlet:IntersiteTransfer:Failed to get host name of target URL.");
            }
            httpServletResponse.sendError(500, SAMLUtilsCommon.bundle.getString("missingTargetHost"));
            return;
        }
        if (SAMLUtilsCommon.debug.messageEnabled()) {
            SAMLUtilsCommon.debug.message("TargetUrl Host = " + string2 + " Port= " + n);
        }
        SAMLServiceManager.SiteEntry siteEntry = null;
        Set set = (Set)SAMLServiceManager.getAttribute("iplanet-am-saml-trusted-server-list");
        if (set == null) {
            httpServletResponse.sendError(500, SAMLUtilsCommon.bundle.getString("nullTrustedSite"));
            return;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            stringArray = null;
            int n2 = 0;
            object = (SAMLServiceManager.SiteEntry)iterator.next();
            stringArray = ((SAMLServiceManager.SiteEntry)object).getHostName();
            n2 = ((SAMLServiceManager.SiteEntry)object).getPort();
            if (n2 != -1) {
                if (string2.indexOf((String)stringArray) == -1 || n == -1 || n != n2) continue;
                siteEntry = object;
                break;
            }
            if (string2.indexOf((String)stringArray) == -1) continue;
            siteEntry = object;
        }
        if (siteEntry != null) {
            Object object2;
            stringArray = null;
            try {
                object2 = SSOTokenManager.getInstance();
                stringArray = object2.createSSOToken(httpServletRequest);
                if (stringArray == null) {
                    SAMLUtilsCommon.debug.error("SSOToken is null.");
                    httpServletResponse.sendError(500, SAMLUtilsCommon.bundle.getString("nullSSOToken"));
                    return;
                }
                if (!object2.isValidToken((SSOToken)stringArray)) {
                    SAMLUtilsCommon.debug.error("SSOToken is invalid.");
                    httpServletResponse.sendError(500, SAMLUtilsCommon.bundle.getString("invalidSSOToken"));
                    return;
                }
            }
            catch (SSOException sSOException) {
                SAMLUtilsCommon.debug.error("IntersiteTransfer", (Throwable)sSOException);
                httpServletResponse.sendError(500, sSOException.getMessage());
                return;
            }
            object2 = new ArrayList();
            try {
                object2 = this.createArtifact((SSOToken)stringArray, siteEntry.getSourceID(), string, siteEntry.getVersion());
            }
            catch (SAMLException sAMLException) {
                SAMLUtilsCommon.debug.error("IntersiteTransfer:Failed to create AssertionArtifact(s)");
                httpServletResponse.sendError(500, sAMLException.getMessage());
                return;
            }
            object = (String)SAMLServiceManager.getAttribute("iplanet-am-saml-target-specifier");
            String string3 = (String)SAMLServiceManager.getAttribute("iplanet-am-saml-artifact-name");
            iterator = object2.iterator();
            stringBuffer = new StringBuffer(1000);
            String string4 = null;
            while (iterator.hasNext()) {
                string4 = AMURLEncDec.encode((String)((String)iterator.next()));
                if (SAMLUtilsCommon.debug.messageEnabled()) {
                    SAMLUtilsCommon.debug.message("Encoded SAML AssertionArtifact " + string4);
                }
                stringBuffer.append("&").append(string3).append("=").append(string4);
            }
        } else {
            stringArray = new String[]{SAMLUtilsCommon.bundle.getString("targetForbidden"), string};
            LogUtils.error(Level.INFO, "TARGET_FORBIDDEN", stringArray);
            httpServletResponse.sendError(403, SAMLUtilsCommon.bundle.getString("targetForbidden") + " " + string);
            return;
        }
        String string5 = siteEntry.getSAMLUrl() + "?" + (String)object + "=" + string + stringBuffer.toString();
        httpServletResponse.setStatus(302);
        httpServletResponse.setHeader("Location", string5);
        String[] stringArray2 = new String[]{SAMLUtilsCommon.bundle.getString("redirectTo"), string, string5};
        LogUtils.access(Level.FINE, "REDIRECT_TO_URL", stringArray2, (SSOToken)stringArray);
        httpServletResponse.sendRedirect(string5);
    }

    private void ArtifactHandler(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        Object object;
        String[] stringArray;
        Map map;
        List list;
        String string;
        PrintWriter printWriter;
        block11: {
            printWriter = httpServletResponse.getWriter();
            Subject subject = null;
            string = httpServletRequest.getParameter((String)SAMLServiceManager.getAttribute("iplanet-am-saml-target-specifier"));
            String string2 = (String)SAMLServiceManager.getAttribute("iplanet-am-saml-artifact-name");
            String[] stringArray2 = httpServletRequest.getParameterValues(string2);
            list = null;
            map = null;
            try {
                subject = SAMLUtils.getAuthSubject(stringArray2, null, httpServletRequest, httpServletResponse, string);
                if (subject != null) {
                    SAMLUtilsCommon.debug.message("Your authenticated principals are : ");
                    stringArray = subject.getPrincipals().iterator();
                    while (stringArray.hasNext()) {
                        object = stringArray.next();
                        if (SAMLUtilsCommon.debug.messageEnabled()) {
                            SAMLUtilsCommon.debug.message("Principal name : " + object.getClass().getName() + " Principal : " + object.getName());
                        }
                        if (!(object instanceof SAMLPrincipal)) continue;
                        SAMLPrincipal sAMLPrincipal = (SAMLPrincipal)object;
                        list = sAMLPrincipal.getAssertions();
                        map = sAMLPrincipal.getAttrMap();
                        if (!SAMLUtilsCommon.debug.messageEnabled()) continue;
                        SAMLUtilsCommon.debug.message("GET Assertion : " + list);
                        SAMLUtilsCommon.debug.message("GET attrMap : " + map);
                    }
                    break block11;
                }
                SAMLUtilsCommon.debug.error("getAuthSubject: null subject");
                String[] stringArray3 = new String[]{SAMLUtilsCommon.bundle.getString("failedCreateSSOToken")};
                LogUtils.error(Level.INFO, "FAILED_TO_CREATE_SSO_TOKEN", stringArray3);
                httpServletResponse.sendError(500, SAMLUtilsCommon.bundle.getString("failedCreateSSOToken"));
                return;
            }
            catch (Exception exception) {
                SAMLUtilsCommon.debug.error("getAuthSubject: ", (Throwable)exception);
                String[] stringArray4 = new String[]{SAMLUtilsCommon.bundle.getString("failedCreateSSOToken")};
                LogUtils.error(Level.INFO, "FAILED_TO_CREATE_SSO_TOKEN", stringArray4);
                httpServletResponse.sendError(500, SAMLUtilsCommon.bundle.getString("failedCreateSSOToken"));
                return;
            }
        }
        stringArray = new String[]{SAMLUtilsCommon.bundle.getString("accessGranted")};
        LogUtils.access(Level.INFO, "ACCESS_GRANTED", stringArray);
        if (SAMLUtils.postYN(string)) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("POST to target:" + string);
            }
            SAMLUtils.postToTarget(httpServletResponse, list, string, map);
        } else if (SAMLUtilsCommon.debug.messageEnabled()) {
            printWriter.println("<html>\n");
            printWriter.println("<head>\n");
            printWriter.println("<title>Access rights validated</title>\n");
            printWriter.println("<meta http-equiv=\"refresh\" content=\"10; URL=" + string + "\">\n");
            printWriter.println("</head>\n");
            printWriter.println("<body>\n");
            printWriter.println("<H1>Access rights validated</H1>\n");
            printWriter.println("<P>We have verified your access rights <STRONG></STRONG> according to the assertion shown below. \n");
            printWriter.println("You are being redirected to the resource.\n");
            printWriter.println("Please wait ......\n");
            printWriter.println("</P>\n");
            printWriter.println("<HR><P>\n");
            object = list.iterator();
            while (object.hasNext()) {
                printWriter.println(SAMLUtils.displayXML((String)object.next()));
            }
            printWriter.println("</P>\n");
            printWriter.println("</body>\n");
            printWriter.println("</html>\n");
            printWriter.flush();
        } else {
            httpServletResponse.sendRedirect(string);
        }
    }
}

