/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.protocol;

import com.iplanet.am.util.XMLUtils;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.w3c.dom.Element;

public class StatusCode {
    private StatusCode subStatusCode = null;
    private String value = null;

    StatusCode() {
    }

    public StatusCode(Element element) throws SAMLException {
        if (element == null) {
            SAMLUtilsCommon.debug.message("StatusCode: null input.");
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        String string = element.getLocalName();
        if (!string.equals("StatusCode")) {
            SAMLUtilsCommon.debug.message("StatusCode: Wrong input: " + string);
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
        }
        this.value = element.getAttribute("Value");
        if (this.value == null || this.value.equals("")) {
            SAMLUtilsCommon.debug.message("StatusCode: empty attribute Value.");
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingAttribute"));
        }
        List list = XMLUtils.getElementsByTagNameNS1((Element)element, (String)"urn:oasis:names:tc:SAML:1.0:protocol", (String)"StatusCode");
        int n = list.size();
        if (n == 1) {
            this.subStatusCode = new StatusCode((Element)list.get(0));
        } else if (n != 0) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("StatusCode: Included more than one <StatusCode> in element " + string);
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("moreElement"));
        }
    }

    public StatusCode(String string, StatusCode statusCode) throws SAMLException {
        this.value = this.checkAndGetValue(string);
        this.subStatusCode = statusCode;
    }

    public StatusCode(String string) throws SAMLException {
        this.value = this.checkAndGetValue(string);
    }

    private String checkAndGetValue(String string) throws SAMLException {
        if (string == null || string.equals("")) {
            SAMLUtilsCommon.debug.message("StatusCode: empty attribute Value.");
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingAttribute"));
        }
        if (string.indexOf(":") == -1) {
            return "samlp:" + string;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        if (stringTokenizer.countTokens() != 2) {
            SAMLUtilsCommon.debug.message("StatusCode: wrong attribute value.");
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongAttrValue"));
        }
        return string;
    }

    public void setStatusCode(StatusCode statusCode) {
        this.subStatusCode = statusCode;
    }

    public StatusCode getStatusCode() {
        return this.subStatusCode;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(100);
        String string = "";
        String string2 = "";
        if (bl) {
            string = "samlp:";
        }
        if (bl2) {
            string2 = " xmlns:samlp=\"urn:oasis:names:tc:SAML:1.0:protocol\"";
        }
        String string3 = "StatusCode";
        stringBuffer.append("<").append(string).append(string3).append(string2).append(" Value=\"");
        if (this.value.startsWith("samlp:")) {
            stringBuffer.append(this.value);
        } else {
            try {
                stringBuffer.append(this.checkAndGetValue(this.value));
            }
            catch (SAMLException sAMLException) {
                SAMLUtilsCommon.debug.error("StatusCode.toString: ", (Throwable)sAMLException);
                stringBuffer.append(this.value);
            }
        }
        stringBuffer.append("\">\n");
        if (this.subStatusCode != null && this.subStatusCode != Collections.EMPTY_LIST) {
            stringBuffer.append(this.subStatusCode.toString(bl, false));
        }
        stringBuffer.append("</").append(string).append(string3).append(">\n");
        return stringBuffer.toString();
    }
}

