/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.remote;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.XMLUtils;
import com.sun.identity.policy.ResourceResult;
import com.sun.identity.policy.remote.AdvicesHandleableByAMResponse;
import com.sun.identity.policy.remote.PolicyEvaluationException;
import com.sun.identity.policy.remote.PolicyService;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.w3c.dom.Node;

public class PolicyResponse {
    public static final int POLICY_RESPONSE_RESOURCE_RESULT = 1;
    public static final int POLICY_ADD_LISTENER_RESPONSE = 2;
    public static final int POLICY_REMOVE_LISTENER_RESPONSE = 3;
    public static final int POLICY_EXCEPTION = 4;
    public static final int POLICY_ADVICES_HANDLEABLE_BY_AM_RESPONSE = 5;
    static final String POLICY_RESPONSE = "PolicyResponse";
    static final String REQUEST_ID = "requestId";
    static final String RESOURCE_RESULT = "ResourceResult";
    static final String ADD_LISTENER_RESPONSE = "AddPolicyListenerResponse";
    static final String REMOVE_LISTENER_RESPONSE = "RemovePolicyListenerResponse";
    static final String ADVICES_HANDLEABLE_BY_AM_RESPONSE = "AdvicesHandleableByAMResponse";
    static final String EXCEPTION_RESPONSE = "Exception";
    static final String CRLF = "\r\n";
    static Debug debug = PolicyService.debug;
    private int methodID = 0;
    private String requestId = null;
    private Set resourceResults = null;
    private AdvicesHandleableByAMResponse advicesHandleableByAMResponse = null;
    private String exceptionMsg = null;

    public int getMethodID() {
        return this.methodID;
    }

    public void setMethodID(int n) {
        this.methodID = n;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String string) {
        this.requestId = string;
    }

    public Set getResourceResults() {
        return this.resourceResults;
    }

    public void setResourceResults(Set set) {
        this.resourceResults = set;
    }

    public AdvicesHandleableByAMResponse getAdvicesHandleableByAMResponse() {
        return this.advicesHandleableByAMResponse;
    }

    public void setAdvicesHandleableByAMResponse(AdvicesHandleableByAMResponse advicesHandleableByAMResponse) {
        this.advicesHandleableByAMResponse = advicesHandleableByAMResponse;
    }

    public String getExceptionMsg() {
        return this.exceptionMsg;
    }

    public void setExceptionMsg(String string) {
        this.exceptionMsg = string;
    }

    public static PolicyResponse parseXML(Node node) throws PolicyEvaluationException {
        PolicyResponse policyResponse = new PolicyResponse();
        Node node2 = null;
        String string = XMLUtils.getNodeAttributeValue((Node)node, (String)REQUEST_ID);
        if (string == null) {
            debug.error("PolicyResponse: missing attribute requestId");
            Object[] objectArray = new String[]{REQUEST_ID};
            throw new PolicyEvaluationException("amPolicy", "missing_attribute", objectArray, null);
        }
        policyResponse.setRequestId(string);
        Set set = XMLUtils.getChildNodes((Node)node, (String)RESOURCE_RESULT);
        if (set != null && set.size() != 0) {
            HashSet<ResourceResult> hashSet = new HashSet<ResourceResult>();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                node2 = (Node)iterator.next();
                ResourceResult resourceResult = null;
                try {
                    resourceResult = ResourceResult.parseResourceResult(node2);
                }
                catch (Exception exception) {
                    debug.error("PolicyResponse: XML parsing error");
                    throw new PolicyEvaluationException("amPolicy", "xml_parsing_error", null, exception);
                }
                hashSet.add(resourceResult);
            }
            policyResponse.setResourceResults(hashSet);
            policyResponse.setMethodID(1);
            return policyResponse;
        }
        node2 = XMLUtils.getChildNode((Node)node, (String)ADD_LISTENER_RESPONSE);
        if (node2 != null) {
            policyResponse.setMethodID(2);
            return policyResponse;
        }
        node2 = XMLUtils.getChildNode((Node)node, (String)REMOVE_LISTENER_RESPONSE);
        if (node2 != null) {
            policyResponse.setMethodID(3);
            return policyResponse;
        }
        node2 = XMLUtils.getChildNode((Node)node, (String)ADVICES_HANDLEABLE_BY_AM_RESPONSE);
        if (node2 != null) {
            policyResponse.setAdvicesHandleableByAMResponse(AdvicesHandleableByAMResponse.parseXML(node2));
            policyResponse.setMethodID(5);
            return policyResponse;
        }
        node2 = XMLUtils.getChildNode((Node)node, (String)EXCEPTION_RESPONSE);
        if (node2 != null) {
            String string2 = XMLUtils.getValueOfValueNode((Node)node2);
            policyResponse.setExceptionMsg(string2);
            policyResponse.setMethodID(4);
            return policyResponse;
        }
        debug.error("PolicyResponse: invalid method specified");
        throw new PolicyEvaluationException("amPolicy", "invalid_policy_response_method", null, null);
    }

    public String toXMLString() {
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("<PolicyResponse requestId=\"" + this.requestId + "\">" + CRLF);
        if (this.methodID == 1) {
            Iterator iterator = this.resourceResults.iterator();
            while (iterator.hasNext()) {
                ResourceResult resourceResult = (ResourceResult)iterator.next();
                stringBuffer.append(resourceResult.toXML());
            }
        } else if (this.methodID == 2) {
            stringBuffer.append("<AddPolicyListenerResponse/>\r\n");
        } else if (this.methodID == 3) {
            stringBuffer.append("<RemovePolicyListenerResponse/>\r\n");
        } else if (this.methodID == 5) {
            stringBuffer.append(this.advicesHandleableByAMResponse.toXMLString());
        } else if (this.methodID == 4) {
            stringBuffer.append("<Exception>\r\n");
            stringBuffer.append(this.exceptionMsg + CRLF);
            stringBuffer.append("</Exception>\r\n");
        }
        stringBuffer.append("</PolicyResponse>\r\n");
        return stringBuffer.toString();
    }
}

