/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.jaas;

import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.service.SSOTokenPrincipal;
import com.sun.identity.policy.client.PolicyEvaluator;
import com.sun.identity.policy.client.PolicyEvaluatorFactory;
import com.sun.identity.policy.jaas.ISPermissionCollection;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.security.auth.Subject;

public class ISPermission
extends Permission {
    private Subject subject;
    private CodeSource codesource;
    private String serviceName;
    private String resourceName;
    private String actions;
    private Set actionSet;
    private Map envParams = Collections.synchronizedMap(Collections.EMPTY_MAP);
    private PolicyEvaluatorFactory policyEvalFactory;
    static Debug debug = Debug.getInstance((String)"amPolicy");
    static /* synthetic */ Class class$com$sun$identity$authentication$service$SSOTokenPrincipal;

    public ISPermission(Subject subject, CodeSource codeSource) {
        super("ISPermission");
        if (debug.messageEnabled()) {
            debug.message("ISPermission(subject,codesource) constructor called ");
        }
        this.subject = subject;
        this.codesource = codeSource;
    }

    public ISPermission(String string, String string2, String string3) {
        super("ISPermission");
        this.serviceName = string;
        this.resourceName = string2;
        this.actions = string3;
        debug.message("ISPermission:: Constructor called");
    }

    public ISPermission(String string, String string2, String string3, Map map) {
        super("ISPermission");
        this.serviceName = string;
        this.resourceName = string2;
        this.actions = string3;
        this.envParams = map;
        debug.message("ISPermission:: Constructor called");
    }

    public String getServiceName() {
        debug.message("ISPermission: getServiceName called");
        return this.serviceName;
    }

    public String getResourceName() {
        debug.message("ISPermission: getResourceName called");
        return this.resourceName;
    }

    public Map getEnvParams() {
        return this.envParams;
    }

    public String getActions() {
        debug.message("ISPermission: getActions called");
        if (debug.messageEnabled()) {
            debug.message("returning actions:" + this.actions);
        }
        return this.actions;
    }

    private boolean actionEquals(String string, String string2) {
        String string3;
        StringTokenizer stringTokenizer;
        Set<String> set = Collections.synchronizedSet(new HashSet());
        Set<String> set2 = Collections.synchronizedSet(new HashSet());
        if (string != null) {
            stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken().trim();
                set.add(string3);
            }
        }
        if (string2 != null) {
            stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken().trim();
                set2.add(string3);
            }
        }
        return set.equals(set2);
    }

    private Set actionSet(String string) {
        if (this.actionSet != null) {
            return this.actionSet;
        }
        this.actionSet = Collections.synchronizedSet(new HashSet());
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                this.actionSet.add(string2);
            }
        }
        return this.actionSet;
    }

    public Subject getSubject() {
        debug.message("ISPermission:: getSubject called ");
        return this.subject;
    }

    public CodeSource getCodeSource() {
        debug.message("ISPermission:: getCodeSource called ");
        return this.codesource;
    }

    public boolean equals(Object object) {
        boolean bl = true;
        debug.message("ISPermission:: equals(Object) called ");
        if (object == this) {
            if (debug.messageEnabled()) {
                debug.message("ISPermission::equals::this " + bl);
            }
            return true;
        }
        if (object instanceof ISPermission) {
            Object object2;
            ISPermission iSPermission = (ISPermission)object;
            Subject subject = iSPermission.getSubject();
            if (subject != null) {
                bl = subject.equals(this.subject);
            } else if (this.subject != null) {
                bl = false;
            }
            if (debug.messageEnabled()) {
                debug.message("ISPermission::subject equals:" + bl);
            }
            if (bl) {
                object2 = iSPermission.getCodeSource();
                if (object2 != null) {
                    bl = ((CodeSource)object2).equals(this.codesource);
                    if (debug.messageEnabled()) {
                        debug.message("ISPermission::codesource equals:" + ((CodeSource)object2).equals(this.codesource));
                    }
                } else if (this.codesource != null) {
                    bl = false;
                }
            }
            if (bl) {
                object2 = iSPermission.getServiceName();
                if (object2 != null) {
                    bl = ((String)object2).equals(this.serviceName);
                    if (debug.messageEnabled()) {
                        debug.message("ISPermission::servicename equals:" + ((String)object2).equals(this.serviceName));
                    }
                } else if (this.serviceName != null) {
                    bl = false;
                }
            }
            if (bl) {
                object2 = iSPermission.getResourceName();
                if (object2 != null) {
                    bl = ((String)object2).equals(this.resourceName);
                    if (debug.messageEnabled()) {
                        debug.message("ISPermission::resourceName equals:" + ((String)object2).equals(this.resourceName));
                    }
                } else if (this.resourceName != null) {
                    bl = false;
                }
            }
            if (bl) {
                object2 = iSPermission.getActions();
                if (object2 != null) {
                    bl = this.actionEquals((String)object2, this.actions);
                    if (debug.messageEnabled()) {
                        debug.message("ISPermission::Actions equals:" + this.actionEquals((String)object2, this.actions));
                    }
                } else if (this.actions != null) {
                    bl = false;
                }
            }
            if (bl) {
                object2 = iSPermission.getEnvParams();
                if (object2 != null && !object2.isEmpty()) {
                    bl = object2.equals(this.envParams);
                    if (debug.messageEnabled()) {
                        debug.message("ISPermission::equals::envMap" + object2.equals(this.envParams));
                    }
                } else if (this.envParams != null && !this.envParams.isEmpty()) {
                    bl = false;
                }
            }
        }
        if (debug.messageEnabled()) {
            debug.message("ISPermission::equals::returning " + bl);
        }
        return bl;
    }

    public int hashCode() {
        int n = 0;
        if (this.subject != null) {
            n += this.subject.hashCode();
        }
        if (this.codesource != null) {
            n += this.codesource.hashCode();
        }
        if (this.serviceName != null) {
            n += this.serviceName.hashCode();
        }
        if (this.resourceName != null) {
            n += this.resourceName.hashCode();
        }
        if (this.actions != null) {
            Set set = this.actionSet(this.actions);
            n += set.hashCode();
        }
        if (this.envParams != null) {
            n += this.envParams.hashCode();
        }
        if (debug.messageEnabled()) {
            debug.message("ISPermission::hashCode::" + n);
        }
        return n;
    }

    public boolean implies(Permission permission) {
        boolean bl;
        block21: {
            debug.message("ISPermission: implies called");
            bl = false;
            if (permission instanceof ISPermission) {
                debug.message("ISPermission:passed perm is of type ISPermission");
                if (this.subject != null) {
                    debug.message("ISPermission:implies:subj not null");
                    if (debug.messageEnabled()) {
                        debug.message("ISPermission::implies: subject:" + this.subject.toString());
                    }
                    String string = ((ISPermission)permission).getServiceName();
                    String string2 = ((ISPermission)permission).getResourceName();
                    String string3 = ((ISPermission)permission).getActions();
                    Map map = ((ISPermission)permission).getEnvParams();
                    if (debug.messageEnabled()) {
                        debug.message("ISPermission: resourceName=" + string2);
                        debug.message("ISPermission: serviceName=" + string);
                        debug.message("ISPermission: actions=" + string3);
                    }
                    try {
                        SSOTokenPrincipal sSOTokenPrincipal;
                        Set set = this.subject.getPrincipals(class$com$sun$identity$authentication$service$SSOTokenPrincipal == null ? (class$com$sun$identity$authentication$service$SSOTokenPrincipal = ISPermission.class$("com.sun.identity.authentication.service.SSOTokenPrincipal")) : class$com$sun$identity$authentication$service$SSOTokenPrincipal);
                        if (debug.messageEnabled()) {
                            debug.message("ISPermission::implies:principals:" + set.toString());
                        }
                        if ((sSOTokenPrincipal = (SSOTokenPrincipal)set.iterator().next()) == null) {
                            if (debug.messageEnabled()) {
                                debug.error("ISPermission::implies: Principal is null");
                            }
                        } else {
                            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
                            SSOToken sSOToken = sSOTokenManager.createSSOToken(sSOTokenPrincipal.getName());
                            if (this.policyEvalFactory == null) {
                                this.policyEvalFactory = PolicyEvaluatorFactory.getInstance();
                            }
                            PolicyEvaluator policyEvaluator = this.policyEvalFactory.getPolicyEvaluator(string);
                            if (debug.messageEnabled()) {
                                debug.message("ISPermission::implies::created PolicyEvaluator for " + string);
                            }
                            if (string3 != null) {
                                StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
                                while (stringTokenizer.hasMoreTokens()) {
                                    String string4 = stringTokenizer.nextToken();
                                    bl = policyEvaluator.isAllowed(sSOToken, string2, string4, map);
                                    if (!bl) break;
                                    if (!debug.messageEnabled()) continue;
                                    debug.message("ISPermission::result for " + string4 + " is :" + bl);
                                }
                                if (debug.messageEnabled()) {
                                    debug.message("ISPermission::result for " + string3 + " is :" + bl);
                                }
                            } else if (debug.messageEnabled()) {
                                debug.message("ISPermission:: actions is null");
                            }
                        }
                        break block21;
                    }
                    catch (SSOException sSOException) {
                        if (debug.messageEnabled()) {
                            debug.error("ISPermission::SSOException:" + sSOException.getMessage());
                            sSOException.printStackTrace();
                        }
                        break block21;
                    }
                    catch (Exception exception) {
                        if (debug.messageEnabled()) {
                            debug.error("ISPermission::Exception:" + exception.getMessage());
                            exception.printStackTrace();
                        }
                        break block21;
                    }
                }
                debug.message("ISPermission:: subject was null");
            }
        }
        if (debug.messageEnabled()) {
            debug.message("ISPermission: allowed::" + bl);
        }
        return bl;
    }

    public PermissionCollection newPermissionCollection() {
        debug.message("ISPermission:: newISPermissionCollection() called");
        return new ISPermissionCollection();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer = stringBuffer.append("(").append(this.getClass().getName()).append("\n");
        String string = this.getActions();
        if (this.subject != null) {
            stringBuffer = stringBuffer.append(this.subject.toString()).append("\n");
        }
        if (this.codesource != null) {
            stringBuffer = stringBuffer.append(this.codesource.toString()).append("\n");
        }
        if (this.serviceName != null && this.serviceName.length() != 0) {
            stringBuffer = stringBuffer.append("serviceName=").append(this.serviceName).append("\n");
        }
        if (this.resourceName != null && this.resourceName.length() != 0) {
            stringBuffer = stringBuffer.append("resourceName=").append(this.resourceName).append("\n");
        }
        if (string != null && string.length() != 0) {
            stringBuffer = stringBuffer.append("actions=").append(string).append("\n");
        }
        if (this.envParams != null && !this.envParams.isEmpty()) {
            stringBuffer = stringBuffer.append("envParams=").append(this.envParams.values()).append("\n");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

