/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.client;

import com.iplanet.am.util.Debug;
import com.iplanet.dpro.session.Session;
import com.iplanet.dpro.session.SessionException;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.services.comm.client.AlreadyRegisteredException;
import com.iplanet.services.comm.client.NotificationHandler;
import com.iplanet.services.comm.client.PLLClient;
import com.iplanet.services.comm.client.SendRequestException;
import com.iplanet.services.comm.share.Request;
import com.iplanet.services.comm.share.RequestSet;
import com.iplanet.services.comm.share.Response;
import com.iplanet.services.naming.URLNotFoundException;
import com.iplanet.services.naming.WebtopNaming;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenEvent;
import com.iplanet.sso.SSOTokenListener;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.policy.ActionDecision;
import com.sun.identity.policy.PolicyDecision;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyUtils;
import com.sun.identity.policy.ResBundleUtils;
import com.sun.identity.policy.ResourceMatch;
import com.sun.identity.policy.ResourceResult;
import com.sun.identity.policy.client.InvalidAppSSOTokenException;
import com.sun.identity.policy.client.PolicyEvaluator;
import com.sun.identity.policy.client.PolicyNotificationHandler;
import com.sun.identity.policy.client.PolicyProperties;
import com.sun.identity.policy.interfaces.ResourceName;
import com.sun.identity.policy.remote.AdvicesHandleableByAMRequest;
import com.sun.identity.policy.remote.AdvicesHandleableByAMResponse;
import com.sun.identity.policy.remote.PolicyChangeNotification;
import com.sun.identity.policy.remote.PolicyEvaluationException;
import com.sun.identity.policy.remote.PolicyListenerRequest;
import com.sun.identity.policy.remote.PolicyNotification;
import com.sun.identity.policy.remote.PolicyRequest;
import com.sun.identity.policy.remote.PolicyResponse;
import com.sun.identity.policy.remote.PolicyService;
import com.sun.identity.policy.remote.RemoveListenerRequest;
import com.sun.identity.policy.remote.ResourceResultRequest;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

class ResourceResultCache
implements SSOTokenListener {
    private static ResourceResultCache resourceResultCache;
    private PolicyProperties policyProperties;
    private Set remotePolicyListeners = Collections.synchronizedSet(new HashSet(10));
    private Map resultCache = new HashMap(10);
    private PolicyNotificationHandler notificationHandler;
    private Set tokenRegistry = Collections.synchronizedSet(new HashSet(10000));
    private Set tokensToBeCleared = Collections.synchronizedSet(new HashSet(100));
    private int cacheTtl;
    private Set advicesHandleableByAM;
    private static Debug debug;
    private static final String POLICY_SERVICE_ID_FOR_NAMING = "policy";
    private static final String GET_RESPONSE_ATTRIBUTES = "Get_Response_Attributes";
    private static long requestID;
    private static String REQUEST_ID_LOCK;
    private static String SECRET_MASK;
    private static String cacheMode;

    private ResourceResultCache(PolicyProperties policyProperties) throws PolicyException {
        this.policyProperties = policyProperties;
        this.notificationHandler = new PolicyNotificationHandler(this);
        this.cacheTtl = policyProperties.getCacheTtl();
        cacheMode = policyProperties.getCacheMode();
        if (policyProperties.notificationEnabled()) {
            this.registerHandlerWithPLLClient(this.notificationHandler);
            if (debug.messageEnabled() && debug.messageEnabled()) {
                debug.message("RsourceResultCache():added policyNotificationHandler with PLLClient");
            }
        }
        if (debug.messageEnabled()) {
            debug.message("RsourceResultCache():singleton instance created");
        }
    }

    static synchronized ResourceResultCache getInstance(PolicyProperties policyProperties) throws PolicyException {
        if (resourceResultCache == null) {
            resourceResultCache = new ResourceResultCache(policyProperties);
        }
        return resourceResultCache;
    }

    private static synchronized ResourceResultCache getInstance() {
        if (resourceResultCache == null && debug.warningEnabled()) {
            debug.warning("ResourceResultCache.getInstance():ResourceResultCache has not been created:returning null");
        }
        return resourceResultCache;
    }

    PolicyDecision getPolicyDecision(SSOToken sSOToken, String string, SSOToken sSOToken2, String string2, Set set, Map map, int n) throws InvalidAppSSOTokenException, PolicyException, SSOException {
        int n2 = 0;
        boolean bl = false;
        PolicyDecision policyDecision = this.getPolicyDecision(sSOToken, string, sSOToken2, string2, set, map, true);
        if (policyDecision.getTimeToLive() > System.currentTimeMillis()) {
            bl = true;
        }
        while (!bl && n2 < n) {
            ++n2;
            if (debug.messageEnabled()) {
                debug.message("ResourceResultCache.getPolicyDecision():Received expired decision, Getting decision again, repeat attempt=" + n2);
            }
            if ((policyDecision = this.getPolicyDecision(sSOToken, string, sSOToken2, string2, set, map, false)).getTimeToLive() <= System.currentTimeMillis()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            if (debug.warningEnabled()) {
                debug.warning("ResourceResultCache.getPolicyDecision():Received expired decision from server");
            }
            Object[] objectArray = new Object[]{string2};
            throw new PolicyEvaluationException("amPolicy", "received_expired_decision", objectArray, null);
        }
        if (set != null) {
            Object object;
            PolicyDecision policyDecision2 = new PolicyDecision();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                Map map2 = policyDecision.getActionDecisions();
                ActionDecision actionDecision = (ActionDecision)map2.get(object);
                if (actionDecision == null) continue;
                policyDecision2.addActionDecision(actionDecision);
            }
            object = new HashMap();
            PolicyUtils.appendMapToMap(policyDecision.getResponseAttributes(), (Map)object);
            policyDecision2.setResponseAttributes((Map)object);
            policyDecision = policyDecision2;
        } else {
            policyDecision = (PolicyDecision)policyDecision.clone();
        }
        return policyDecision;
    }

    private PolicyDecision getPolicyDecision(SSOToken sSOToken, String string, SSOToken sSOToken2, String string2, Set set, Map map, boolean bl) throws InvalidAppSSOTokenException, PolicyException, SSOException {
        String string3 = string2;
        String string4 = cacheMode;
        if ("subtree".equals(cacheMode)) {
            string3 = this.getRootResourceName(string2, string);
            if (debug.messageEnabled()) {
                debug.message("ResourceResultCache.getPolicyDecision():resourceName=" + string2 + ":cacheMode=" + cacheMode + ":would get resource results for root resource=" + string3 + ":scope=" + string4);
            }
        }
        Set set2 = this.getResourceResults(sSOToken, string, sSOToken2, string3, set, map, string4, bl);
        ResourceName resourceName = this.policyProperties.getResourceComparator(string);
        PolicyDecision policyDecision = this.getPolicyDecisionFromResourceResults(set2, string2, resourceName, string);
        if (debug.messageEnabled()) {
            debug.message("ResourceResultCache.getPolicyDecision():appToken=" + sSOToken.getPrincipal().getName() + ":serviceName=" + string + ":token=" + sSOToken2.getPrincipal().getName() + ":resourceName=" + string2 + ":actionNames=" + set + ":env" + ":scope=" + string4 + ":useCache=" + bl + ":returning policyDecision:" + policyDecision);
        }
        return policyDecision;
    }

    private Set getResourceResults(SSOToken sSOToken, String string, SSOToken sSOToken2, String string2, Set set, Map map, String string3) throws InvalidAppSSOTokenException, PolicyException, SSOException {
        return this.getResourceResults(sSOToken, string, sSOToken2, string2, set, map, string3, true);
    }

    private Set getResourceResults(SSOToken sSOToken, String string, SSOToken sSOToken2, String string2, Set hashSet, Map map, String string3, boolean bl) throws InvalidAppSSOTokenException, PolicyException, SSOException {
        SSOTokenManager.getInstance().validateToken(sSOToken2);
        Set set = null;
        Object var10_10 = null;
        if (debug.messageEnabled()) {
            debug.message("ResourceResultCache.getResourceResults():appToken=" + sSOToken.getPrincipal().getName() + ":serviceName=" + string + ":token=" + sSOToken2.getPrincipal().getName() + ":resourceName=" + string2 + ":actionNames=" + hashSet + ":env" + ":useCache=" + bl + ":entering ");
        }
        HashMap hashMap = null;
        Map map2 = this.resultCache;
        synchronized (map2) {
            hashMap = (HashMap)this.resultCache.get(string);
            if (hashMap == null) {
                hashMap = new HashMap();
                this.resultCache.put(string, hashMap);
            }
        }
        HashMap hashMap2 = null;
        HashMap hashMap3 = hashMap;
        synchronized (hashMap3) {
            hashMap2 = (HashMap)hashMap.get(string2);
            if (hashMap2 == null) {
                hashMap2 = new HashMap();
                hashMap.put(string2, hashMap2);
            }
        }
        HashMap<String, Object[]> hashMap4 = null;
        String string4 = sSOToken2.getTokenID().toString();
        HashMap hashMap5 = hashMap2;
        synchronized (hashMap5) {
            hashMap4 = (HashMap<String, Object[]>)hashMap2.get(string4);
            if (hashMap4 == null) {
                hashMap4 = new HashMap<String, Object[]>();
                hashMap2.put(string4, hashMap4);
                if (!this.tokenRegistry.contains(string4)) {
                    sSOToken2.addSSOTokenListener((SSOTokenListener)this);
                    this.tokenRegistry.add(string4);
                }
            }
        }
        Object[] objectArray = null;
        HashMap<String, Object[]> hashMap6 = hashMap4;
        synchronized (hashMap6) {
            objectArray = (Object[])hashMap4.get(string3);
            if (objectArray == null) {
                objectArray = new Object[4];
                hashMap4.put(string3, objectArray);
            }
            boolean bl2 = false;
            if (!bl) {
                if (debug.messageEnabled()) {
                    debug.message("ResourceResultCache.getResourceResults():would contact server since useCache is false");
                }
                bl2 = true;
            } else if (objectArray[0] == null) {
                if (debug.messageEnabled()) {
                    debug.message("ResourceResultCache.getResourceResults():would contact server since results not in cache");
                }
                bl2 = true;
            } else if (map == null && objectArray[1] != null) {
                if (debug.messageEnabled()) {
                    debug.message("ResourceResultCache.getResourceResults():would contact server since env does not match");
                }
                bl2 = true;
            } else if (map != null && !map.equals(objectArray[1])) {
                if (debug.messageEnabled()) {
                    debug.message("ResourceResultCache.getResourceResults():would contact server since env does not Match");
                }
                bl2 = true;
            } else if ((Long)objectArray[2] < System.currentTimeMillis()) {
                if (debug.messageEnabled()) {
                    debug.message("ResourceResultCache.getResourceResults():would contact server since results ttl has  expired");
                }
                bl2 = true;
            } else if (hashSet == null && objectArray[3] != null) {
                if (debug.messageEnabled()) {
                    debug.message("ResourceResultCache.getResourceResults():would contact server since action names do not  match");
                }
                bl2 = true;
            } else if (hashSet != null && objectArray[3] == null) {
                if (debug.messageEnabled()) {
                    debug.message("ResourceResultCache.getResourceResults():would contact server since action names do not  Match");
                }
                bl2 = true;
            } else if (objectArray[3] != null && !((Set)objectArray[3]).containsAll(hashSet)) {
                if (debug.messageEnabled()) {
                    debug.message("ResourceResultCache.getResourceResults():would contact server since cached action names  do not cover request action names");
                }
                bl2 = true;
            }
            if (bl2) {
                set = this.getResultsFromServer(sSOToken, string, sSOToken2, string2, string3, hashSet, map);
                objectArray[0] = set;
                if (map != null) {
                    map = ResourceResultCache.cloneEnvMap(map);
                }
                objectArray[1] = map;
                objectArray[2] = new Long(System.currentTimeMillis() + (long)this.cacheTtl);
                if (hashSet != null) {
                    HashSet hashSet2 = hashSet;
                    hashSet = new HashSet();
                    hashSet.addAll(hashSet2);
                }
                objectArray[3] = hashSet;
            } else if (debug.messageEnabled()) {
                debug.message("ResourceResultCache.getResourceResults():would not contact server,  would use results from  cache ");
            }
        }
        set = (Set)objectArray[0];
        if (debug.messageEnabled()) {
            debug.message("ResourceResultCache.getResourceResults(" + sSOToken.getPrincipal().getName() + "," + string + "," + sSOToken2.getPrincipal().getName() + "," + string2 + "," + hashSet + ",env)" + ": returning resourceResults");
        }
        return set;
    }

    private Set getResultsFromServer(SSOToken sSOToken, String string, SSOToken sSOToken2, String string2, String string3, Set set, Map map) throws InvalidAppSSOTokenException, SSOException, PolicyException {
        Set set2 = null;
        Response response = null;
        try {
            URL uRL = ResourceResultCache.getPolicyServiceURL(sSOToken2);
            if (debug.messageEnabled()) {
                debug.message("ResourceResultCache.getResultsFromServer():appToken=" + sSOToken.getPrincipal().getName() + ":serviceName=" + string + ":token=" + sSOToken2.getPrincipal().getName() + ":resourceName=" + string2 + ":scope=" + string3 + ":actionNames=" + set + ":env" + ":policyServiceURL=" + uRL + ":entering");
            }
            ResourceResultRequest resourceResultRequest = new ResourceResultRequest();
            resourceResultRequest.setServiceName(string);
            resourceResultRequest.setResourceName(string2);
            resourceResultRequest.setResourceScope(string3);
            resourceResultRequest.setUserSSOToken(sSOToken2.getTokenID().toString());
            Set set3 = null;
            if (map != null) {
                resourceResultRequest.setEnvParms(map);
                set3 = this.getResponseAttributes(map);
                if (debug.messageEnabled()) {
                    debug.message("ResourceResultCache.getResultsFromServer():responseAttributes to get=" + set3);
                }
                if (set3 != null) {
                    resourceResultRequest.setResponseAttributes(set3);
                }
            }
            PolicyRequest policyRequest = new PolicyRequest();
            policyRequest.setAppSSOToken(sSOToken.getTokenID().toString());
            policyRequest.setMethodID(1);
            policyRequest.setRequestId(this.newRequestID());
            policyRequest.setResourceResultRequest(resourceResultRequest);
            PolicyService policyService = new PolicyService();
            policyService.setMethodID(1);
            policyService.setPolicyRequest(policyRequest);
            String string4 = policyService.toXMLString();
            Request request = new Request(string4);
            RequestSet requestSet = new RequestSet(POLICY_SERVICE_ID_FOR_NAMING);
            if (debug.messageEnabled()) {
                debug.message("ResourceResultCache.getResultsFromServer():sending PLL request to URL=" + uRL + ":\nPLL message=" + string4);
            }
            requestSet.addRequest(request);
            Vector vector = PLLClient.send((URL)uRL, (RequestSet)requestSet);
            response = (Response)vector.elementAt(0);
            PolicyService policyService2 = PolicyService.parseXML(response.getContent());
            if (debug.messageEnabled()) {
                debug.message("ResourceResultCache.getResultsFromServer():got PLL response:" + policyService2.toXMLString());
            }
            if (policyService2 != null) {
                PolicyResponse policyResponse = policyService2.getPolicyResponse();
                String string5 = policyResponse.getExceptionMsg();
                if (string5 != null) {
                    if (string5.indexOf(ResBundleUtils.getString("app_sso_token_invalid")) >= 0) {
                        if (debug.warningEnabled()) {
                            debug.warning("ResourceResultCache.getResultsFromServer(): response exception " + string5);
                            debug.warning("ResourceResultCache.getResultsFromServer(): appSSOToken is invalid");
                            debug.warning("ResourceResultCache.throwing InvalidAppSSOTokenException");
                        }
                        Object[] objectArray = new String[]{string5};
                        throw new InvalidAppSSOTokenException("amPolicy", "server_reported_invalid_app_sso_token", objectArray, null);
                    }
                    debug.warning("ResourceResultCache.getResultsFromServer():response exception message=" + string5);
                    Object[] objectArray = new String[]{string5};
                    throw new PolicyEvaluationException("amPolicy", "server_reported_exception", objectArray, null);
                }
                set2 = policyResponse.getResourceResults();
            }
        }
        catch (SendRequestException sendRequestException) {
            Object[] objectArray = new String[]{sendRequestException.getMessage()};
            throw new PolicyEvaluationException("amPolicy", "pll_send_request_exception", objectArray, sendRequestException);
        }
        if (debug.messageEnabled()) {
            debug.message("ResourceResultCache.getResultsFromServer():returning");
        }
        return set2;
    }

    private PolicyDecision getPolicyDecisionFromResourceResults(Set set, String string, ResourceName resourceName, String string2) throws PolicyException {
        PolicyDecision policyDecision = new PolicyDecision();
        string = resourceName.canonicalize(string);
        Iterator iterator = set.iterator();
        boolean bl = false;
        while (!bl && iterator.hasNext()) {
            ResourceResult resourceResult = (ResourceResult)iterator.next();
            bl = this.mergePolicyDecisions(policyDecision, resourceResult, string, resourceName, string2);
        }
        return policyDecision;
    }

    private boolean mergePolicyDecisions(PolicyDecision policyDecision, ResourceResult resourceResult, String string, ResourceName resourceName, String string2) throws PolicyException {
        boolean bl;
        block6: {
            ResourceMatch resourceMatch;
            block7: {
                block5: {
                    bl = false;
                    if (debug.messageEnabled()) {
                        debug.message("ResourceResultCache.mergePolicyDecisions():resourceName=" + string + ":resourceResultResourceName=" + resourceResult.getResourceName());
                    }
                    if (!(resourceMatch = resourceName.compare(string, resourceResult.getResourceName(), true)).equals(ResourceMatch.EXACT_MATCH)) break block5;
                    this.resetPolicyDecision(resourceResult.getPolicyDecision(), policyDecision, string2);
                    bl = true;
                    break block6;
                }
                if (!resourceMatch.equals(ResourceMatch.WILDCARD_MATCH)) break block7;
                this.mergePolicyDecisions(resourceResult.getPolicyDecision(), policyDecision, string2);
                if (policyDecision.getTimeToLive() < System.currentTimeMillis()) {
                    bl = true;
                }
                if (bl) break block6;
                Set set = resourceResult.getResourceResults();
                Iterator iterator = set.iterator();
                while (!bl && iterator.hasNext()) {
                    ResourceResult resourceResult2 = (ResourceResult)iterator.next();
                    bl = this.mergePolicyDecisions(policyDecision, resourceResult2, string, resourceName, string2);
                }
                break block6;
            }
            if (resourceMatch.equals(ResourceMatch.SUPER_RESOURCE_MATCH)) {
                Set set = resourceResult.getResourceResults();
                Iterator iterator = set.iterator();
                while (!bl && iterator.hasNext()) {
                    ResourceResult resourceResult3 = (ResourceResult)iterator.next();
                    bl = this.mergePolicyDecisions(policyDecision, resourceResult3, string, resourceName, string2);
                }
            }
        }
        return bl;
    }

    private PolicyDecision mergePolicyDecisions(PolicyDecision policyDecision, PolicyDecision policyDecision2, String string) {
        Object object;
        Map map = policyDecision.getActionDecisions();
        Map map2 = policyDecision2.getActionDecisions();
        HashSet hashSet = new HashSet();
        hashSet.addAll(map.keySet());
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            ActionDecision actionDecision = (ActionDecision)map.get(object);
            policyDecision2.addActionDecision(actionDecision, this.policyProperties.getTrueValue(string, (String)object), this.policyProperties.getFalseValue(string, (String)object));
        }
        object = new HashMap();
        PolicyUtils.appendMapToMap(policyDecision.getResponseAttributes(), (Map)object);
        PolicyUtils.appendMapToMap(policyDecision2.getResponseAttributes(), (Map)object);
        policyDecision2.setResponseAttributes((Map)object);
        return policyDecision2;
    }

    private PolicyDecision resetPolicyDecision(PolicyDecision policyDecision, PolicyDecision policyDecision2, String string) {
        Object object;
        Map map = policyDecision.getActionDecisions();
        Map map2 = policyDecision2.getActionDecisions();
        map2.clear();
        HashSet hashSet = new HashSet();
        hashSet.addAll(map.keySet());
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            ActionDecision actionDecision = (ActionDecision)map.get(object);
            policyDecision2.addActionDecision(actionDecision, this.policyProperties.getTrueValue(string, (String)object), this.policyProperties.getFalseValue(string, (String)object));
        }
        object = new HashMap();
        PolicyUtils.appendMapToMap(policyDecision.getResponseAttributes(), (Map)object);
        PolicyUtils.appendMapToMap(policyDecision2.getResponseAttributes(), (Map)object);
        policyDecision2.setResponseAttributes((Map)object);
        return policyDecision2;
    }

    void addRemotePolicyListener(SSOToken sSOToken, String string, String string2) {
        this.addRemotePolicyListener(sSOToken, string, string2, false);
    }

    void addRemotePolicyListener(SSOToken sSOToken, String string, String string2, boolean bl) {
        if (debug.messageEnabled()) {
            debug.message("ResourceResultCache.addRemotePolicyListener():serviceName=" + string + ":notificationURL=" + string2);
        }
        if (this.remotePolicyListeners.contains(string) && !bl) {
            if (debug.messageEnabled()) {
                debug.message("ResourceResultCache.addRemotePolicyListener():serviceName=" + string + ":notificationURL=" + string2 + ":is already registered");
            }
            return;
        }
        boolean bl2 = false;
        URL uRL = null;
        if (sSOToken != null) {
            try {
                uRL = ResourceResultCache.getPolicyServiceURL(sSOToken);
            }
            catch (PolicyException policyException) {
                debug.error("ResourceResultCache.addRemotePolicyListener():Can not add policy listner", (Throwable)policyException);
            }
        }
        if (sSOToken != null && uRL != null) {
            PolicyListenerRequest policyListenerRequest = new PolicyListenerRequest();
            policyListenerRequest.setServiceName(string);
            policyListenerRequest.setNotificationURL(string2);
            PolicyRequest policyRequest = new PolicyRequest();
            policyRequest.setAppSSOToken(sSOToken.getTokenID().toString());
            policyRequest.setMethodID(2);
            policyRequest.setPolicyListenerRequest(policyListenerRequest);
            PolicyService policyService = new PolicyService();
            policyService.setMethodID(1);
            policyService.setPolicyRequest(policyRequest);
            String string3 = policyService.toXMLString();
            try {
                Request request = new Request(string3);
                RequestSet requestSet = new RequestSet(POLICY_SERVICE_ID_FOR_NAMING);
                requestSet.addRequest(request);
                Vector vector = PLLClient.send((URL)uRL, (RequestSet)requestSet);
                Response response = (Response)vector.elementAt(0);
                PolicyService policyService2 = PolicyService.parseXML(response.getContent());
                if (policyService2 != null) {
                    PolicyResponse policyResponse;
                    if (debug.messageEnabled()) {
                        debug.message("ResourceResultCache.addRemotePolicyListener():result=" + policyService2.toXMLString());
                    }
                    if ((policyResponse = policyService2.getPolicyResponse()).getMethodID() == 2) {
                        bl2 = true;
                        this.remotePolicyListeners.add(string);
                        if (debug.messageEnabled()) {
                            debug.message("ResourceResultCache.addRemotePolicyListener():serviceName=" + string + ":notificationURL=" + string2 + ":policyServiceURL=" + uRL + ":add succeeded");
                        }
                    }
                } else {
                    debug.error("ResourceResultCache.addRemotePolicyListener(): no result");
                }
            }
            catch (Exception exception) {
                debug.error("ResourceResultCache.addRemotePolicyListener():", (Throwable)exception);
            }
        }
    }

    private boolean removeRemotePolicyListener(SSOToken sSOToken, String string, String string2) {
        boolean bl = false;
        URL uRL = null;
        if (sSOToken != null) {
            try {
                uRL = ResourceResultCache.getPolicyServiceURL(sSOToken);
            }
            catch (PolicyException policyException) {
                debug.error("ResourceResultCache.removeRemotePolicyListener():Can not remove policy listner:", (Throwable)policyException);
            }
        }
        if (sSOToken != null && uRL != null) {
            RemoveListenerRequest removeListenerRequest = new RemoveListenerRequest();
            removeListenerRequest.setServiceName(string);
            removeListenerRequest.setNotificationURL(string2);
            PolicyRequest policyRequest = new PolicyRequest();
            policyRequest.setAppSSOToken(sSOToken.getTokenID().toString());
            policyRequest.setMethodID(3);
            policyRequest.setRemoveListenerRequest(removeListenerRequest);
            PolicyService policyService = new PolicyService();
            policyService.setMethodID(1);
            policyService.setPolicyRequest(policyRequest);
            String string3 = policyService.toXMLString();
            try {
                Request request = new Request(string3);
                RequestSet requestSet = new RequestSet(POLICY_SERVICE_ID_FOR_NAMING);
                requestSet.addRequest(request);
                Vector vector = PLLClient.send((URL)uRL, (RequestSet)requestSet);
                Response response = (Response)vector.elementAt(0);
                PolicyService policyService2 = PolicyService.parseXML(response.getContent());
                if (policyService2 != null) {
                    PolicyResponse policyResponse;
                    if (debug.messageEnabled()) {
                        debug.message("ResourceResultCache.removeRemotePolicyListener():result=" + policyService2.toXMLString());
                    }
                    if ((policyResponse = policyService2.getPolicyResponse()).getMethodID() == 3) {
                        bl = true;
                    }
                } else {
                    debug.message("ResourceResultCache.removeRemotePolicyListener():no result");
                }
            }
            catch (Exception exception) {
                debug.error("ResourceResultCache.removeRemotePolicyListener():", (Throwable)exception);
            }
        }
        return bl;
    }

    static void processPolicyNotification(PolicyNotification policyNotification) throws PolicyEvaluationException {
        if (policyNotification != null) {
            if (debug.messageEnabled()) {
                debug.message("ResourceResultCache:processPolicyNotification():" + policyNotification);
            }
            ResourceResultCache resourceResultCache = ResourceResultCache.getInstance();
            PolicyChangeNotification policyChangeNotification = policyNotification.getPolicyChangeNotification();
            String string = policyChangeNotification.getServiceName();
            if (string != null) {
                if (resourceResultCache.remotePolicyListeners.contains(string)) {
                    Set set = policyChangeNotification.getResourceNames();
                    if (debug.messageEnabled()) {
                        debug.message("ResourceResultCache:processPolicyNotification():serviceName=" + string + ":affectedResourceNames=" + set + ":clearing cache for affected " + "resource names");
                    }
                    ResourceResultCache.clearCacheForResourceNames(string, set);
                } else if (debug.messageEnabled()) {
                    debug.message("ResourceResultCache:processPolicyNotification():serviceName not registered:no resource names cleared from cache");
                }
            } else if (debug.messageEnabled()) {
                debug.message("ResourceResultCache:processPolicyNotification():serviceName is null:no resource names cleared from cache");
            }
        } else {
            debug.error("ResourceResultCache.processPolicyNotification()PolicyNotification is null");
        }
    }

    private void registerHandlerWithPLLClient(PolicyNotificationHandler policyNotificationHandler) {
        block3: {
            try {
                PLLClient.addNotificationHandler((String)POLICY_SERVICE_ID_FOR_NAMING, (NotificationHandler)policyNotificationHandler);
                if (debug.messageEnabled()) {
                    debug.message("ResourceResultCache.registerHandlerWithPLLClient():registered notification handler");
                }
            }
            catch (AlreadyRegisteredException alreadyRegisteredException) {
                if (!debug.warningEnabled()) break block3;
                debug.message("ResourceResultCache.registerHandlerWithPLLClient():AlreadyRegisteredException", (Throwable)alreadyRegisteredException);
            }
        }
    }

    static URL getPolicyServiceURL(SSOToken sSOToken) throws PolicyException {
        URL uRL = null;
        try {
            String string = sSOToken.getTokenID().toString();
            SessionID sessionID = new SessionID(string);
            Session session = Session.getSession((SessionID)sessionID);
            URL uRL2 = session.getSessionServiceURL();
            String string2 = uRL2.getProtocol();
            String string3 = uRL2.getHost();
            int n = uRL2.getPort();
            String string4 = null;
            string4 = n == -1 ? "" : Integer.toString(n);
            uRL = WebtopNaming.getServiceURL((String)POLICY_SERVICE_ID_FOR_NAMING, (String)string2, (String)string3, (String)string4);
        }
        catch (SessionException sessionException) {
            debug.error("ResourceResultCache.getPolicyServiceURL():Can not find policy service URL", (Throwable)sessionException);
            throw new PolicyEvaluationException("amPolicy", "policy_service_url_not_found", null, sessionException);
        }
        catch (URLNotFoundException uRLNotFoundException) {
            debug.error("ResourceResultCache.getPolicyServiceURL():Can not find policy service URL", (Throwable)uRLNotFoundException);
            throw new PolicyEvaluationException("amPolicy", "policy_service_url_not_found", null, uRLNotFoundException);
        }
        return uRL;
    }

    public void ssoTokenChanged(SSOTokenEvent sSOTokenEvent) {
        block12: {
            String string = sSOTokenEvent.getToken().getTokenID().toString();
            if (debug.messageEnabled()) {
                debug.message("ResourceResultCache.ssoTokenChanged():for tokenID=" + SECRET_MASK);
            }
            try {
                Map map = this.resultCache;
                synchronized (map) {
                    Set set = this.resultCache.keySet();
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        Map map2;
                        String string2 = (String)iterator.next();
                        Map map3 = map2 = (Map)this.resultCache.get(string2);
                        synchronized (map3) {
                            Set set2 = map2.keySet();
                            Iterator iterator2 = set2.iterator();
                            while (iterator2.hasNext()) {
                                String string3 = (String)iterator2.next();
                                Map map4 = (Map)map2.get(string3);
                                if (map4 != null) {
                                    map4.remove(string);
                                }
                                if (!debug.messageEnabled()) continue;
                                debug.message("ResourceResultCache.ssoTokenChanged():removing cache results for tokenID=" + SECRET_MASK + ":serviceName=" + string2 + ":resource=" + string3);
                            }
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                if (!debug.warningEnabled()) break block12;
                debug.warning("ResourceResultCache.ssoTokenChanged():Exception caught", throwable);
            }
        }
    }

    private static void clearCacheForResourceNames(String string, Set set) {
        if (set == null || set.isEmpty()) {
            return;
        }
        Map map = (Map)ResourceResultCache.resourceResultCache.resultCache.get(string);
        if (map == null || map.isEmpty()) {
            return;
        }
        ResourceName resourceName = ResourceResultCache.resourceResultCache.policyProperties.getResourceComparator(string);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (debug.messageEnabled()) {
                debug.message("ResourceResultCache.clearCacheForResourceNames():affectedResourceName=" + string2);
            }
            Map map2 = map;
            synchronized (map2) {
                Set set2 = map.keySet();
                Iterator iterator2 = set2.iterator();
                while (iterator2.hasNext()) {
                    String string3 = (String)iterator2.next();
                    if (debug.messageEnabled()) {
                        debug.message("ResourceResultCache.clearCacheForResourceNames():affectedResourceName=" + string2 + ":cachedResourceName=" + string3);
                    }
                    if (string2.equals(string3)) {
                        iterator2.remove();
                        if (!debug.messageEnabled()) continue;
                        debug.message("ResourceResultCache.clearCacheForResourceNames():cleared cached results for resourceName=" + string3 + ":affectedResourceName=" + string2 + ":match=SAME RESOURCE NAME");
                        continue;
                    }
                    ResourceMatch resourceMatch = resourceName.compare(string3, string2, true);
                    if (resourceMatch.equals(ResourceMatch.EXACT_MATCH)) {
                        iterator2.remove();
                        if (!debug.messageEnabled()) continue;
                        debug.message("ResourceResultCache.clearCacheForResourceNames():cleared cached results for resourceName=" + string3 + ":affectedResourceName=" + string2 + ":match=EXACT_MATCH");
                        continue;
                    }
                    if (resourceMatch.equals(ResourceMatch.WILDCARD_MATCH)) {
                        iterator2.remove();
                        if (!debug.messageEnabled()) continue;
                        debug.message("ResourceResultCache.clearCacheForResourceNames():cleared cached results for resourceName=" + string3 + ":affectedResourceName=" + string2 + ":match=WILD_CARD_MATCH");
                        continue;
                    }
                    if (!cacheMode.equals("subtree") || !resourceMatch.equals(ResourceMatch.SUB_RESOURCE_MATCH)) continue;
                    iterator2.remove();
                    if (!debug.messageEnabled()) continue;
                    debug.message("ResourceResultCache.clearCacheForResourceNames():cleared cached results for resourceName=" + string3 + ":affectedResourceName=" + string2 + "cacheMode=" + cacheMode + ":match=SUB_RESOURCE_MACTH");
                }
            }
        }
    }

    private static Map cloneEnvMap(Map map) {
        HashMap hashMap = null;
        if (map != null) {
            hashMap = new HashMap();
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                Object v = map.get(k);
                if (v instanceof Set) {
                    HashSet hashSet = new HashSet();
                    hashSet.addAll((Set)v);
                    hashMap.put(k, hashSet);
                    continue;
                }
                hashMap.put(k, (HashSet<Object>)v);
            }
        }
        return hashMap;
    }

    private Set getResponseAttributes(Map map) {
        Set set = null;
        if (map != null) {
            set = (Set)map.get(GET_RESPONSE_ATTRIBUTES);
        }
        return set;
    }

    private String newRequestID() {
        String string = null;
        String string2 = REQUEST_ID_LOCK;
        synchronized (string2) {
            string = String.valueOf(requestID++);
        }
        return string;
    }

    private String getRootResourceName(String string, String string2) {
        String[] stringArray;
        int n;
        ResourceName resourceName = this.policyProperties.getResourceComparator(string2);
        String string3 = "";
        if (string != null && !string.equals("") && (n = string.indexOf(string3 = (stringArray = resourceName.split(string))[0])) > 0) {
            string3 = string.substring(0, n) + string3;
        }
        return string3;
    }

    Set getAdvicesHandleableByAM(SSOToken sSOToken, boolean bl) throws InvalidAppSSOTokenException, PolicyException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("ResourceResultCache.getAdvicesHandleableByAM()::entering");
        }
        if (this.advicesHandleableByAM != null && !bl) {
            if (debug.messageEnabled()) {
                debug.message("ResourceResultCache.getAdvicesHandleableByAM()::returning cached advices" + this.advicesHandleableByAM);
            }
            return this.advicesHandleableByAM;
        }
        URL uRL = null;
        if (sSOToken != null) {
            try {
                uRL = ResourceResultCache.getPolicyServiceURL(sSOToken);
            }
            catch (PolicyException policyException) {
                debug.error("ResourceResultCache.getAdvicesHandleableByAM():", (Throwable)policyException);
                throw policyException;
            }
        }
        if (sSOToken != null && uRL != null) {
            PolicyRequest policyRequest = new PolicyRequest();
            policyRequest.setAppSSOToken(sSOToken.getTokenID().toString());
            policyRequest.setAdvicesHandleableByAMRequest(new AdvicesHandleableByAMRequest());
            policyRequest.setMethodID(4);
            PolicyService policyService = new PolicyService();
            policyService.setMethodID(1);
            policyService.setPolicyRequest(policyRequest);
            String string = policyService.toXMLString();
            try {
                Request request = new Request(string);
                RequestSet requestSet = new RequestSet(POLICY_SERVICE_ID_FOR_NAMING);
                requestSet.addRequest(request);
                Vector vector = PLLClient.send((URL)uRL, (RequestSet)requestSet);
                Response response = (Response)vector.elementAt(0);
                PolicyService policyService2 = PolicyService.parseXML(response.getContent());
                if (policyService2 != null) {
                    PolicyResponse policyResponse;
                    String string2;
                    if (debug.messageEnabled()) {
                        debug.message("ResourceResultCache.getAdvicesHandleableByAM():result=" + policyService2.toXMLString());
                    }
                    if ((string2 = (policyResponse = policyService2.getPolicyResponse()).getExceptionMsg()) != null) {
                        if (string2.indexOf(ResBundleUtils.getString("app_sso_token_invalid")) >= 0) {
                            if (debug.warningEnabled()) {
                                debug.warning("ResourceResultCache.getAdvicesHandleableByAM(): response exception " + string2);
                                debug.warning("ResourceResultCache.AdvicesHandleableByAM(): appSSOToken is invalid");
                                debug.warning("ResourceResultCache.throwing InvalidAppSSOTokenException");
                            }
                            Object[] objectArray = new String[]{string2};
                            throw new InvalidAppSSOTokenException("amPolicy", "server_reported_invalid_app_sso_token", objectArray, null);
                        }
                        if (debug.warningEnabled()) {
                            debug.warning("ResourceResultCache.AdvicesHandleableByAM():response exception message=" + string2);
                        }
                        Object[] objectArray = new String[]{string2};
                        throw new PolicyEvaluationException("amPolicy", "server_reported_exception", objectArray, null);
                    }
                    if (policyResponse.getMethodID() == 5) {
                        AdvicesHandleableByAMResponse advicesHandleableByAMResponse = policyResponse.getAdvicesHandleableByAMResponse();
                        if (debug.messageEnabled()) {
                            debug.message("ResourceResultCache.getAdvicesHandleableByAM():" + advicesHandleableByAMResponse);
                        }
                        if (advicesHandleableByAMResponse != null) {
                            this.advicesHandleableByAM = advicesHandleableByAMResponse.getAdvicesHandleableByAM();
                        }
                    }
                } else {
                    debug.error("ResourceResultCache.getAdvicesHandleableByAM(): no result");
                }
            }
            catch (SendRequestException sendRequestException) {
                debug.error("ResourceResultCache.getAdvicesHandleableByAM():", (Throwable)sendRequestException);
                throw new PolicyException(sendRequestException);
            }
        }
        if (this.advicesHandleableByAM == null) {
            this.advicesHandleableByAM = Collections.EMPTY_SET;
        }
        if (debug.messageEnabled()) {
            debug.message("ResourceResultCache.getAdvicesHandleableByAM()::returning advicesHandleableByAM" + this.advicesHandleableByAM);
        }
        return this.advicesHandleableByAM;
    }

    void clearCachedDecisionsForService(String string) {
        if (debug.messageEnabled()) {
            debug.message("ResourceResultCache.clearCachedDecisionsForService():serviceName=" + string);
        }
        Map map = this.resultCache;
        synchronized (map) {
            this.resultCache.remove(string);
        }
    }

    static {
        debug = PolicyEvaluator.debug;
        requestID = 0L;
        REQUEST_ID_LOCK = "REQUEST_ID_LOCK";
        SECRET_MASK = "*********";
    }
}

