/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.client;

import com.iplanet.am.util.Debug;
import com.iplanet.dpro.session.SessionException;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.log.LogRecord;
import com.sun.identity.log.Logger;
import com.sun.identity.policy.ActionDecision;
import com.sun.identity.policy.PolicyDecision;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyUtils;
import com.sun.identity.policy.ResBundleUtils;
import com.sun.identity.policy.client.InvalidAppSSOTokenException;
import com.sun.identity.policy.client.PolicyProperties;
import com.sun.identity.policy.client.ResourceResultCache;
import com.sun.identity.policy.remote.PolicyEvaluationException;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.security.AppSSOTokenProvider;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class PolicyEvaluator {
    static Debug debug = Debug.getInstance((String)"amRemotePolicy");
    private PolicyProperties policyProperties;
    private String serviceName;
    private SSOTokenManager ssoTokenManager;
    private ResourceResultCache resourceResultCache;
    AppSSOTokenProvider appSSOTokenProvider;
    static Logger accessLogger;
    static Logger errorLogger;
    private static final String GET_RESPONSE_ATTRIBUTES = "Get_Response_Attributes";
    private static final String EMPTY_RESOURCE = "";
    private SSOToken appSSOToken;
    private static final int RETRY_COUNT = 3;
    private String logActions;

    public PolicyEvaluator(String string) throws PolicyException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("PolicyEvaluator():Creating PolicyEvaluator:serviceName=" + string);
        }
        this.init(string, null);
    }

    PolicyEvaluator(String string, AppSSOTokenProvider appSSOTokenProvider) throws PolicyException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("PolicyEvaluator():Creating PolicyEvaluator:serviceName=" + string + ":appSSOTokenProvider=" + appSSOTokenProvider);
        }
        if (string == null) {
            if (debug.warningEnabled()) {
                debug.warning("PolicyEvaluator():serviceName is null");
            }
            return;
        }
        this.init(string, appSSOTokenProvider);
    }

    private void init(String string, AppSSOTokenProvider appSSOTokenProvider) throws PolicyException, SSOException {
        this.ssoTokenManager = SSOTokenManager.getInstance();
        this.serviceName = string;
        this.appSSOTokenProvider = appSSOTokenProvider;
        this.policyProperties = new PolicyProperties();
        this.logActions = this.policyProperties.getLogActions();
        this.resourceResultCache = ResourceResultCache.getInstance(this.policyProperties);
        this.appSSOToken = this.getNewAppSSOToken();
        if (this.policyProperties.notificationEnabled()) {
            if (debug.messageEnabled() && debug.messageEnabled()) {
                debug.message("PolicyEvaluator.init():adding remote policy listener with policy service");
            }
            this.resourceResultCache.addRemotePolicyListener(this.appSSOToken, string, this.policyProperties.getNotificationURL());
        }
        if (debug.messageEnabled()) {
            debug.message("PolicyEvaluator:initialized PolicyEvaluator");
        }
    }

    public boolean isAllowed(SSOToken sSOToken, String string, String string2) throws PolicyException, SSOException {
        return this.isAllowed(sSOToken, string, string2, null);
    }

    public boolean isAllowed(SSOToken sSOToken, String string, String string2, Map map) throws PolicyException, SSOException {
        Object object;
        if (debug.messageEnabled()) {
            debug.message("PolicyEvaluator:isAllowed():token=" + sSOToken.getPrincipal().getName() + ":resourceName=" + string + ":actionName=" + string2 + ":envParameters) : entering");
        }
        boolean bl = false;
        HashSet<String> hashSet = new HashSet<String>(1);
        hashSet.add(string2);
        PolicyDecision policyDecision = this.getPolicyDecision(sSOToken, string, hashSet, map);
        ActionDecision actionDecision = (ActionDecision)policyDecision.getActionDecisions().get(string2);
        String string3 = this.policyProperties.getTrueValue(this.serviceName, string2);
        String string4 = this.policyProperties.getFalseValue(this.serviceName, string2);
        if (actionDecision != null && string3 != null && string4 != null && (object = actionDecision.getValues()) != null) {
            if (object.contains(string4)) {
                bl = false;
            } else if (object.contains(string3)) {
                bl = true;
            }
        }
        object = bl ? "ALLOW" : "DENY";
        Object[] objectArray = new String[]{string, string2, object};
        if ("ALLOW".equals(this.logActions) && bl) {
            this.logAccessMessage(Level.INFO, ResBundleUtils.getString("policy_eval_allow", objectArray), sSOToken);
        } else if ("DENY".equals(this.logActions) && !bl) {
            this.logAccessMessage(Level.INFO, ResBundleUtils.getString("policy_eval_deny", objectArray), sSOToken);
        } else if ("BOTH".equals(this.logActions) || "DECISION".equals(this.logActions)) {
            this.logAccessMessage(Level.INFO, ResBundleUtils.getString("policy_eval_result", objectArray), sSOToken);
        }
        if (debug.messageEnabled()) {
            debug.message("PolicyEvaluator.isAllowed():token=" + sSOToken.getPrincipal().getName() + ":resourceName=" + string + ":actionName=" + string2 + ":returning: " + bl);
        }
        return bl;
    }

    public PolicyDecision getPolicyDecision(SSOToken sSOToken, String string, Set set) throws PolicyException, SSOException {
        return this.getPolicyDecision(sSOToken, string, set, null);
    }

    public PolicyDecision getPolicyDecision(SSOToken sSOToken, String string, Set set, Map map) throws PolicyException, SSOException {
        this.ssoTokenManager.validateToken(sSOToken);
        if (debug.messageEnabled()) {
            debug.message("PolicyEvaluator:getPolicyDecision():token=" + sSOToken.getPrincipal().getName() + ":resourceName=" + string + ":actionName=" + set + ":entering");
        }
        PolicyDecision policyDecision = null;
        try {
            policyDecision = this.resourceResultCache.getPolicyDecision(this.appSSOToken, this.serviceName, sSOToken, string, set, map, 3);
        }
        catch (InvalidAppSSOTokenException invalidAppSSOTokenException) {
            if (debug.warningEnabled()) {
                debug.warning("PolicyEvaluator.getPolicyDecision():InvalidAppSSOTokenException occured:getting new appssotoken");
            }
            this.appSSOToken = this.getNewAppSSOToken();
            if (this.policyProperties.notificationEnabled()) {
                if (debug.warningEnabled()) {
                    debug.warning("PolicyEvaluator.getPolicyDecision():InvalidAppSSOTokenException occured:reRegistering remote policy listener");
                }
                this.reRegisterRemotePolicyListener(this.appSSOToken);
            }
            policyDecision = this.resourceResultCache.getPolicyDecision(this.appSSOToken, this.serviceName, sSOToken, string, set, map, 3);
        }
        if (debug.messageEnabled()) {
            debug.message("PolicyEvaluator:getPolicyDecision():token=" + sSOToken.getPrincipal().getName() + ":resourceName=" + string + ":actionNames=" + set + ":returning policyDecision:" + policyDecision.toXML());
        }
        Object[] objectArray = new Object[]{string, set, policyDecision.toXML()};
        if ("DECISION".equals(this.logActions)) {
            this.logAccessMessage(Level.INFO, ResBundleUtils.getString("policy_eval_decision", objectArray), sSOToken);
        }
        return policyDecision;
    }

    private SSOToken getNewAppSSOToken() throws PolicyException {
        SSOToken sSOToken = null;
        if (debug.messageEnabled()) {
            debug.message("PolicyEvaluator.getNewAppSSOToken():entering");
        }
        if (this.appSSOTokenProvider != null) {
            sSOToken = this.appSSOTokenProvider.getAppSSOToken();
            try {
                this.ssoTokenManager.refreshSession(sSOToken);
                if (!this.ssoTokenManager.isValidToken(sSOToken)) {
                    if (debug.messageEnabled()) {
                        debug.message("PolicyEvaluator.getNewAppSSOToken():AdminTokenAction returned  expired token, trying again");
                    }
                    sSOToken = this.appSSOTokenProvider.getAppSSOToken();
                }
            }
            catch (SSOException sSOException) {
                if (debug.warningEnabled()) {
                    debug.warning("PolicyEvaluator.getNewAppSSOToken():could not refresh session:", (Throwable)sSOException);
                }
                sSOToken = this.appSSOTokenProvider.getAppSSOToken();
            }
        } else {
            sSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            try {
                this.ssoTokenManager.refreshSession(sSOToken);
                if (!this.ssoTokenManager.isValidToken(sSOToken)) {
                    if (debug.messageEnabled()) {
                        debug.message("PolicyEvaluator.getNewAppSSOToken():AdminTokenAction returned  expired token, trying again");
                    }
                    sSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
                }
            }
            catch (SSOException sSOException) {
                if (debug.warningEnabled()) {
                    debug.warning("PolicyEvaluator.getNewAppSSOToken():could not refresh session:", (Throwable)sSOException);
                }
                sSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            }
        }
        if (sSOToken == null) {
            debug.error("PolicyEvaluator.getNewAppSSOToken():, cannot obtain application SSO token");
            throw new PolicyException("amPolicy", "can_not_create_app_sso_token", null, null);
        }
        if (debug.messageEnabled()) {
            debug.message("PolicyEvaluator.getNewAppSSOToken():returning token");
        }
        return sSOToken;
    }

    private void logAccessMessage(Level level, String string, SSOToken sSOToken) {
        block4: {
            try {
                if (accessLogger == null && (accessLogger = (Logger)Logger.getLogger("amRemotePolicy.access")) == null) {
                    if (debug.warningEnabled()) {
                        debug.warning("PolicyEvaluator.logAccessMessage:Failed to create Logger");
                    }
                    return;
                }
                LogRecord logRecord = new LogRecord(level, string, sSOToken);
                accessLogger.log(logRecord, this.appSSOToken);
            }
            catch (Throwable throwable) {
                if (!debug.warningEnabled()) break block4;
                debug.warning("PolicyEvaluator.logAccessMessage:Error writing access logs");
            }
        }
    }

    private void logErrorMessage(Level level, String string, SSOToken sSOToken) {
        block4: {
            try {
                if (errorLogger == null && (errorLogger = (Logger)Logger.getLogger("amRemotePolicy.error")) == null) {
                    if (debug.warningEnabled()) {
                        debug.warning("PolicyEvaluator.logAccessMessage: Failed to create Logger");
                    }
                    return;
                }
                LogRecord logRecord = new LogRecord(level, string, sSOToken);
                errorLogger.log(logRecord, this.appSSOToken);
            }
            catch (Throwable throwable) {
                if (!debug.warningEnabled()) break block4;
                debug.warning("PolicyEvaluator.logAccessMessage: Error writing error logs");
            }
        }
    }

    AppSSOTokenProvider getAppSSOTokenProvider() {
        return this.appSSOTokenProvider;
    }

    public Set getAdvicesHandleableByAM(boolean bl) throws InvalidAppSSOTokenException, PolicyEvaluationException, PolicyException, SSOException {
        Set set = null;
        if (debug.messageEnabled()) {
            debug.message("PolicyEvaluator.getAdvicesHandleableByAM(): EnteringrefetchFromServer=" + bl);
        }
        try {
            set = this.resourceResultCache.getAdvicesHandleableByAM(this.appSSOToken, bl);
        }
        catch (InvalidAppSSOTokenException invalidAppSSOTokenException) {
            if (debug.warningEnabled()) {
                debug.warning("PolicyEvaluator.getAdvicesHandleableByAM():got InvalidAppSSOTokenException,  retrying with new app token");
            }
            set = this.resourceResultCache.getAdvicesHandleableByAM(this.getNewAppSSOToken(), bl);
        }
        catch (PolicyException policyException) {
            Throwable throwable = policyException.getNestedException();
            if (throwable != null && throwable instanceof SessionException) {
                if (debug.warningEnabled()) {
                    debug.warning("PolicyEvaluator.getAdvicesHandleableByAM():got SessionException,  retrying with new app token");
                }
                set = this.resourceResultCache.getAdvicesHandleableByAM(this.getNewAppSSOToken(), bl);
            }
            throw policyException;
        }
        if (debug.messageEnabled()) {
            debug.message("PolicyEvaluator.getAdvicesHandleableByAM(): Returning advicesHandleableByAM=" + set);
        }
        return set;
    }

    public String getCompositeAdvice(ActionDecision actionDecision) throws PolicyException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("PolicyEvaluator.getCompositeAdvice(): entering, actionDecision = " + actionDecision.toXML());
        }
        String string = null;
        boolean bl = false;
        Map map = null;
        if (actionDecision != null) {
            map = actionDecision.getAdvices();
        }
        Set set = this.getAdvicesHandleableByAM(false);
        if (debug.messageEnabled()) {
            debug.message("PolicyEvaluator.getCompositeAdvice(): handleableAdvices = " + set);
        }
        if (map != null && !map.isEmpty() && set != null && !set.isEmpty()) {
            Set set2 = map.keySet();
            if (debug.messageEnabled()) {
                debug.message("PolicyEvaluator.getCompositeAdvice(): adviceKeys = " + set2);
            }
            Iterator iterator = set2.iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                if (!set.contains(k)) continue;
                bl = true;
                if (!debug.messageEnabled()) break;
                debug.message("PolicyEvaluator.getCompositeAdvice(): matchFound = " + bl);
                debug.message("PolicyEvaluator.getCompositeAdvice(): common key = " + k);
                break;
            }
        }
        if (bl) {
            string = PolicyUtils.advicesToXMLString(map);
        }
        if (debug.messageEnabled()) {
            debug.message("PolicyEvaluator.getCompositeAdvice(): returning, compositeAdvcie = " + string);
        }
        return string;
    }

    void reRegisterRemotePolicyListener(SSOToken sSOToken) throws PolicyException {
        if (debug.messageEnabled()) {
            debug.message("PolicyEvaluator.reRegisterRemotePolicyListener():entering");
        }
        this.resourceResultCache.addRemotePolicyListener(this.appSSOToken, this.serviceName, this.policyProperties.getNotificationURL(), true);
        this.resourceResultCache.clearCachedDecisionsForService(this.serviceName);
        if (debug.messageEnabled()) {
            debug.message("PolicyEvaluator.reRegisterRemotePolicyListener():returning");
        }
    }
}

