/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.PolicyCache;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.SubjectTypeManager;
import com.sun.identity.policy.Syntax;
import com.sun.identity.policy.ValidValues;
import com.sun.identity.policy.interfaces.Subject;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

class SharedSubject
implements Subject,
Cloneable {
    String subjectName;
    SubjectTypeManager stm;
    SubjectTypeManager mstm;
    private static final Debug debug = PolicyManager.debug;

    SharedSubject(String string, SubjectTypeManager subjectTypeManager) {
        this.subjectName = string;
        this.stm = subjectTypeManager;
    }

    public Syntax getValueSyntax(SSOToken sSOToken) throws SSOException, PolicyException {
        return this.stm.getSubjectByName(this.subjectName).getValueSyntax(sSOToken);
    }

    public ValidValues getValidValues(SSOToken sSOToken) throws SSOException, PolicyException {
        return this.stm.getSubjectByName(this.subjectName).getValidValues(sSOToken);
    }

    public ValidValues getValidValues(SSOToken sSOToken, String string) throws SSOException, PolicyException {
        return this.stm.getSubjectByName(this.subjectName).getValidValues(sSOToken, string);
    }

    public String getDisplayNameForValue(String string, Locale locale) throws NameNotFoundException {
        Subject subject = null;
        try {
            subject = this.stm.getSubjectByName(this.subjectName);
        }
        catch (PolicyException policyException) {
            Object[] objectArray = new String[]{this.subjectName};
            throw new NameNotFoundException("amPolicy", "realm_subject_not_found", objectArray, this.subjectName, 5);
        }
        if (subject != null) {
            return subject.getDisplayNameForValue(string, locale);
        }
        Object[] objectArray = new String[]{this.subjectName};
        throw new NameNotFoundException("amPolicy", "realm_subject_not_found", objectArray, this.subjectName, 5);
    }

    public Set getValues() {
        Subject subject;
        block3: {
            subject = null;
            try {
                subject = this.stm.getSubjectByName(this.subjectName);
            }
            catch (PolicyException policyException) {
                if (!debug.warningEnabled()) break block3;
                debug.warning("Could not find realm subject :" + this.subjectName + " could not getValues()", (Throwable)policyException);
            }
        }
        if (subject != null) {
            return subject.getValues();
        }
        return Collections.EMPTY_SET;
    }

    public void initialize(Map map) throws PolicyException {
    }

    public void setValues(Set set) throws InvalidNameException {
        throw new InvalidNameException("amPolicy", "can_not_set_values_in_shared_subject", null, "ALL", 6);
    }

    public boolean isMember(SSOToken sSOToken) throws SSOException, PolicyException {
        Object object;
        boolean bl = false;
        if (this.mstm == null) {
            object = this.stm.getPolicyManager().getOrganizationDN();
            this.mstm = PolicyCache.getInstance().getPolicyManager((String)object).getSubjectTypeManager();
        }
        if ((object = this.mstm.getCachedSubjectByName(this.subjectName)) != null) {
            bl = object.isMember(sSOToken);
        } else if (debug.warningEnabled()) {
            debug.warning("Realm subject: " + this.subjectName + " not found");
        }
        return bl;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return object;
    }
}

