/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.am.util.XMLUtils;
import com.sun.identity.policy.ActionSchema;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.PolicyConfig;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.ResourceMatch;
import com.sun.identity.policy.StringComparator;
import com.sun.identity.policy.interfaces.ResourceName;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServiceType {
    private String serviceTypeName;
    private ServiceSchemaManager schemaManager;
    private ServiceSchema policySchema;
    private Node policySchemaNode;
    private ResourceName resourceNameUtil = null;
    private Set actionNames;
    private Map actionSchemas;
    private static final String HAS_RESOURCE_NAMES = "HasResourceNames";
    private static final String resourceClass = "com.sun.identity.policy.plugins.PrefixResourceName";
    private static final String resourceWildcard = "*";
    private static final String resourceDelimiter = "/";
    private static final String resourceCase = "false";

    private ServiceType() {
    }

    protected ServiceType(String string, ServiceSchemaManager serviceSchemaManager, ServiceSchema serviceSchema) {
        String string2;
        this.serviceTypeName = string;
        this.schemaManager = serviceSchemaManager;
        this.policySchema = serviceSchema;
        this.policySchemaNode = this.policySchema.getSchemaNode();
        this.actionNames = Collections.unmodifiableSet(this.getActionNamesInternal());
        this.actionSchemas = new HashMap();
        Iterator iterator = this.actionNames.iterator();
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            this.actionSchemas.put(string2, this.getActionSchemaInternal(string2));
        }
        this.actionSchemas = Collections.unmodifiableMap(this.actionSchemas);
        string2 = resourceClass;
        HashMap<String, String> hashMap = null;
        try {
            hashMap = PolicyConfig.getResourceCompareConfig(this.serviceTypeName);
            if (hashMap != null) {
                string2 = (String)hashMap.get("class");
            } else {
                hashMap = new HashMap<String, String>();
                hashMap.put("delimiter", resourceDelimiter);
                hashMap.put("wildcard", resourceWildcard);
                hashMap.put("caseSensitive", resourceCase);
            }
            if (string2 != null) {
                Class<?> clazz = Class.forName(string2);
                this.resourceNameUtil = (ResourceName)clazz.newInstance();
                this.resourceNameUtil.initialize(hashMap);
            }
        }
        catch (PolicyException policyException) {
            PolicyManager.debug.error("Failed to get resource comparator For service: " + string, (Throwable)policyException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            PolicyManager.debug.error("ServiceType: Illegal exception ", (Throwable)classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            PolicyManager.debug.error("ServiceType: Illegal exception ", (Throwable)illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            PolicyManager.debug.error("ServiceType: InstantiationException  exception ", (Throwable)instantiationException);
        }
        if (PolicyManager.debug.messageEnabled()) {
            PolicyManager.debug.message("class name is : " + string2 + " service name is: " + string);
        }
    }

    public ResourceName getResourceNameComparator() {
        return this.resourceNameUtil;
    }

    public String getName() {
        return this.serviceTypeName;
    }

    public String getI18NPropertiesFileName() {
        return this.schemaManager.getI18NFileName();
    }

    public String getI18NKey() {
        try {
            return this.schemaManager.getGlobalSchema().getI18NKey();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Set getActionNames() {
        return this.actionNames;
    }

    private Set getActionNamesInternal() {
        if (this.policySchemaNode != null) {
            TreeSet<String> treeSet = new TreeSet<String>(StringComparator.getInstance());
            NodeList nodeList = this.policySchemaNode.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node = nodeList.item(n);
                if (node.getNodeName().equalsIgnoreCase("AttributeSchema")) {
                    treeSet.add(XMLUtils.getNodeAttributeValue((Node)node, (String)"name"));
                }
                ++n;
            }
            return treeSet;
        }
        return Collections.EMPTY_SET;
    }

    public ActionSchema getActionSchema(String string) throws InvalidNameException {
        ActionSchema actionSchema = (ActionSchema)this.actionSchemas.get(string);
        if (actionSchema == null) {
            if (PolicyManager.debug.warningEnabled()) {
                PolicyManager.debug.warning("Action name: " + string + " not valid for service: " + this.serviceTypeName);
            }
            Object[] objectArray = new String[]{this.serviceTypeName, string};
            throw new InvalidNameException("amPolicy", "invalid_action_name", objectArray, string, 3);
        }
        return actionSchema;
    }

    private ActionSchema getActionSchemaInternal(String string) {
        ActionSchema actionSchema = null;
        Node node = XMLUtils.getNamedChildNode((Node)this.policySchemaNode, (String)"AttributeSchema", (String)"name", (String)string);
        if (node != null) {
            actionSchema = new ActionSchema(node);
        }
        return actionSchema;
    }

    public Map getActionSchemas() {
        return this.actionSchemas;
    }

    public boolean validateActionValues(Map map) throws InvalidNameException {
        if (map == null || map.size() == 0) {
            return true;
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            try {
                String string = (String)iterator.next();
                ActionSchema actionSchema = this.getActionSchema(string);
                HashSet hashSet = null;
                Object v = map.get(string);
                if (v instanceof String) {
                    hashSet = new HashSet();
                    hashSet.add(v);
                } else {
                    hashSet = (HashSet)v;
                }
                ActionSchema.validate(actionSchema, hashSet);
            }
            catch (ClassCastException classCastException) {
                PolicyManager.debug.error("In validate action name and values invalid class name: " + classCastException.getMessage());
                throw new InvalidNameException("amPolicy", "invalid_class_name", null, this.serviceTypeName, 1);
            }
        }
        return true;
    }

    public boolean containsActionName(String string) {
        return this.getActionNames().contains(string);
    }

    protected ResourceMatch compare(String string, String string2) {
        if (this.resourceNameUtil == null) {
            return ResourceMatch.NO_MATCH;
        }
        return this.resourceNameUtil.compare(string, string2, true);
    }

    protected ResourceMatch compare(String string, String string2, boolean bl) {
        if (this.resourceNameUtil == null) {
            return ResourceMatch.NO_MATCH;
        }
        return this.resourceNameUtil.compare(string, string2, bl);
    }

    public String append(String string, String string2) {
        if (this.resourceNameUtil == null) {
            PolicyManager.debug.error("Append: Don't have resource comparator");
            return string;
        }
        return this.resourceNameUtil.append(string, string2);
    }

    public String getSubResource(String string, String string2) {
        if (this.resourceNameUtil == null) {
            PolicyManager.debug.error("getSubRes: Don't have resource comparator");
            return string;
        }
        return this.resourceNameUtil.getSubResource(string, string2);
    }

    public String[] split(String string) {
        if (this.resourceNameUtil == null) {
            PolicyManager.debug.error("split: Don't have resource comparator");
            String[] stringArray = new String[]{string};
            return stringArray;
        }
        return this.resourceNameUtil.split(string);
    }

    protected Set getPoliciesForExactResourceMatch(String string) {
        return null;
    }

    protected Set getPolicyForResource(String string) {
        return null;
    }

    public boolean hasResourceNames() {
        boolean bl = false;
        Collection collection = this.getActionSchemas().values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ActionSchema actionSchema = (ActionSchema)iterator.next();
            if (!actionSchema.requiresResourceName()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    String canonicalize(String string) throws PolicyException {
        if (this.resourceNameUtil == null) {
            return string;
        }
        return this.resourceNameUtil.canonicalize(string);
    }
}

