/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.am.util.XMLUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.InvalidFormatException;
import com.sun.identity.policy.NameAlreadyExistsException;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.PolicyUtils;
import com.sun.identity.policy.ResponseProviderTypeManager;
import com.sun.identity.policy.ServiceTypeManager;
import com.sun.identity.policy.interfaces.ResponseProvider;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResponseProviders {
    private String name;
    private String description;
    private Map providers = new HashMap();
    private static String RESPONSE_PROVIDERS_ELEMENT_BEGIN = "<ResponseProviders name=\"";
    private static String RESPONSE_PROVIDERS_DESCRIPTION = "\" description=\"";
    private static String RESPONSE_PROVIDERS_ELEMENT_END = "</ResponseProviders>";
    private static String RESPONSE_PROVIDER_ELEMENT = "<ResponseProvider name=\"";
    private static String RESPONSE_PROVIDER_TYPE = "\" type=\"";
    private static String RESPONSE_PROVIDER_ELEMENT_END = "</ResponseProvider>";

    ResponseProviders() {
    }

    protected ResponseProviders(ResponseProviderTypeManager responseProviderTypeManager, Node node) throws InvalidFormatException, NameNotFoundException, PolicyException {
        if (!node.getNodeName().equalsIgnoreCase("ResponseProviders")) {
            if (PolicyManager.debug.warningEnabled()) {
                PolicyManager.debug.warning("invalid response providers xml blob given to construct response providers");
            }
            throw new InvalidFormatException("amPolicy", "invalid_xml_resp_providers_root_node", null, "", 7);
        }
        this.name = XMLUtils.getNodeAttributeValue((Node)node, (String)"name");
        if (this.name == null) {
            this.name = "ResponseProviders:" + ServiceTypeManager.generateRandomName();
        }
        if ((this.description = XMLUtils.getNodeAttributeValue((Node)node, (String)"description")) == null) {
            this.description = "";
        }
        Iterator iterator = XMLUtils.getChildNodes((Node)node, (String)"ResponseProvider").iterator();
        while (iterator.hasNext()) {
            Node node2 = (Node)iterator.next();
            String string = XMLUtils.getNodeAttributeValue((Node)node2, (String)"type");
            if (string == null) {
                if (PolicyManager.debug.warningEnabled()) {
                    PolicyManager.debug.warning("provider type is null");
                }
                throw new InvalidFormatException("amPolicy", "invalid_xml_resp_provider_root_node", null, "", 7);
            }
            String string2 = XMLUtils.getNodeAttributeValue((Node)node2, (String)"name");
            ResponseProvider responseProvider = responseProviderTypeManager.getResponseProvider(string);
            HashMap<String, Set> hashMap = new HashMap<String, Set>();
            NodeList nodeList = node2.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Node node3 = nodeList.item(n2);
                Node node4 = XMLUtils.getChildNode((Node)node3, (String)"Attribute");
                if (node4 != null) {
                    String string3 = XMLUtils.getNodeAttributeValue((Node)node4, (String)"name");
                    Set set = XMLUtils.getAttributeValuePair((Node)node3);
                    if (string3 != null && set != null) {
                        hashMap.put(string3, set);
                    }
                }
                ++n2;
            }
            responseProvider.setProperties(hashMap);
            this.addResponseProvider(string2, responseProvider);
        }
    }

    public ResponseProviders(String string, String string2) {
        this.name = string == null ? "ResponseProviders:" + ServiceTypeManager.generateRandomName() : string;
        this.description = string2 == null ? "" : string2;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setName(String string) {
        this.name = string == null ? "ResponseProviders:" + ServiceTypeManager.generateRandomName() : string;
    }

    public void setDescription(String string) {
        this.description = string == null ? "" : string;
    }

    public Set getResponseProviderNames() {
        return this.providers.keySet();
    }

    public ResponseProvider getResponseProvider(String string) throws NameNotFoundException {
        ResponseProvider responseProvider = (ResponseProvider)this.providers.get(string);
        if (responseProvider == null) {
            Object[] objectArray = new String[]{string};
            throw new NameNotFoundException("amPolicy", "name_not_present", objectArray, string, 7);
        }
        return responseProvider;
    }

    public void addResponseProvider(ResponseProvider responseProvider) throws NameAlreadyExistsException {
        this.addResponseProvider(null, responseProvider);
    }

    public void addResponseProvider(String string, ResponseProvider responseProvider) throws NameAlreadyExistsException {
        if (string == null) {
            string = "ResponseProvider:" + ServiceTypeManager.generateRandomName();
        }
        if (this.providers.containsKey(string)) {
            Object[] objectArray = new String[]{string};
            throw new NameAlreadyExistsException("amPolicy", "name_already_present", objectArray, string, 7);
        }
        this.providers.put(string, responseProvider);
    }

    public void replaceResponseProvider(String string, ResponseProvider responseProvider) throws NameNotFoundException {
        if (!this.providers.containsKey(string)) {
            Object[] objectArray = new String[]{string};
            throw new NameNotFoundException("amPolicy", "name_not_present", objectArray, string, 7);
        }
        this.providers.put(string, responseProvider);
    }

    public ResponseProvider removeResponseProvider(String string) {
        return (ResponseProvider)this.providers.remove(string);
    }

    public ResponseProvider removeResponseProvider(ResponseProvider responseProvider) {
        String string = this.getResponseProviderName(responseProvider);
        if (string != null) {
            return this.removeResponseProvider(string);
        }
        return null;
    }

    public String getResponseProviderName(ResponseProvider responseProvider) {
        String string = null;
        Iterator iterator = this.providers.keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (responseProvider.equals(this.providers.get(string))) break;
        }
        return string;
    }

    public boolean equals(Object object) {
        if (object instanceof ResponseProviders) {
            ResponseProviders responseProviders = (ResponseProviders)object;
            Iterator iterator = this.providers.entrySet().iterator();
            while (iterator.hasNext()) {
                Object v = iterator.next().getValue();
                if (responseProviders.providers.containsValue(v)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Object clone() {
        ResponseProviders responseProviders = null;
        try {
            responseProviders = (ResponseProviders)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            responseProviders = new ResponseProviders();
        }
        responseProviders.name = this.name;
        responseProviders.description = this.description;
        responseProviders.providers = new HashMap();
        Iterator iterator = this.providers.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            ResponseProvider responseProvider = (ResponseProvider)this.providers.get(k);
            responseProviders.providers.put(k, responseProvider.clone());
        }
        return responseProviders;
    }

    Map getResponseProviderDecision(SSOToken sSOToken, Map map) throws PolicyException, SSOException {
        HashMap hashMap = new HashMap();
        Iterator iterator = this.providers.entrySet().iterator();
        while (iterator.hasNext()) {
            ResponseProvider responseProvider = (ResponseProvider)iterator.next().getValue();
            Map map2 = responseProvider.getResponseDecision(sSOToken, map);
            PolicyUtils.appendMapToMap(map2, hashMap);
        }
        return hashMap;
    }

    public String toString() {
        return this.toXML();
    }

    protected String toXML() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("\n").append(RESPONSE_PROVIDERS_ELEMENT_BEGIN).append(XMLUtils.escapeSpecialCharacters((String)this.name)).append(RESPONSE_PROVIDERS_DESCRIPTION).append(XMLUtils.escapeSpecialCharacters((String)this.description)).append("\">");
        Iterator iterator = this.providers.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ResponseProvider responseProvider = (ResponseProvider)this.providers.get(string);
            stringBuffer.append("\n").append(RESPONSE_PROVIDER_ELEMENT).append(XMLUtils.escapeSpecialCharacters((String)string)).append(RESPONSE_PROVIDER_TYPE).append(XMLUtils.escapeSpecialCharacters((String)ResponseProviderTypeManager.responseProviderTypeName(responseProvider))).append("\">\n");
            Map map = responseProvider.getProperties();
            if (map != null) {
                stringBuffer.append(PolicyUtils.mapToXMLString(map));
            }
            stringBuffer.append(RESPONSE_PROVIDER_ELEMENT_END);
        }
        stringBuffer.append("\n").append(RESPONSE_PROVIDERS_ELEMENT_END);
        return stringBuffer.toString();
    }

    int size() {
        return this.providers.size();
    }
}

