/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.XMLUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.Policy;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.Referrals;
import com.sun.identity.policy.ResourceManager;
import com.sun.identity.policy.ResourceMatch;
import com.sun.identity.policy.Rule;
import com.sun.identity.policy.ServiceType;
import com.sun.identity.policy.ServiceTypeManager;
import com.sun.identity.policy.interfaces.Referral;
import com.sun.identity.policy.plugins.OrgReferral;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;

class ResourceIndexManager {
    static final Debug DEBUG = PolicyManager.debug;
    static final String LTS = "<";
    static final String LTSS = "</";
    static final String GTS = ">";
    static final String SGTS = "/>";
    static final String SPACE = " ";
    static final String QUOTE = "\"";
    static final String EQUALS = "=";
    static final String NEW_LINE = "\n";
    static final String POLICY_CROSS_REFERENCES = "PolicyCrossReferences";
    static final String NAME = "name";
    static final String TYPE = "type";
    static final String RESOURCES = "Resources";
    static final String REFERENCE = "Reference";
    static final String POLICY_NAME = "PolicyName";
    private Map resourceIndices = Collections.synchronizedMap(new HashMap());
    private ResourceManager resourceManager;
    private ServiceTypeManager svtm = null;

    ResourceIndexManager(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    Set getPolicyNames(ServiceType serviceType, String string, boolean bl) throws PolicyException {
        Set set = null;
        ResourceIndex resourceIndex = (ResourceIndex)this.resourceIndices.get(serviceType.getName());
        if (resourceIndex == null) {
            resourceIndex = this.refreshResourceIndexFromDataStore(serviceType);
        }
        set = resourceIndex.getPolicyNames(string, bl);
        if (DEBUG.messageEnabled()) {
            DEBUG.message("ResourceIndexManager.getPolicyNames - resourceName, policyNames=" + string + ":" + set);
        }
        return set;
    }

    Set getSuperResourcePolicyNames(ServiceType serviceType, String string) throws PolicyException {
        Set set = null;
        ResourceIndex resourceIndex = (ResourceIndex)this.resourceIndices.get(serviceType.getName());
        if (resourceIndex == null) {
            resourceIndex = this.refreshResourceIndexFromDataStore(serviceType);
        }
        set = resourceIndex.getSuperResourcePolicyNames(string);
        if (DEBUG.messageEnabled()) {
            DEBUG.message("ResourceIndexManager.getPolicyNames - resourceName, policyNames=" + string + ":" + set);
        }
        return set;
    }

    Set getTopLevelResourceNames(ServiceType serviceType) throws PolicyException {
        ResourceIndex resourceIndex = (ResourceIndex)this.resourceIndices.get(serviceType.getName());
        if (resourceIndex == null) {
            resourceIndex = this.refreshResourceIndexFromDataStore(serviceType);
        }
        return resourceIndex.getTopLevelResourceNames();
    }

    Set getSubResourcePolicyNames(ServiceType serviceType, String string) throws PolicyException {
        Object var3_3 = null;
        ResourceIndex resourceIndex = (ResourceIndex)this.resourceIndices.get(serviceType.getName());
        if (resourceIndex == null) {
            resourceIndex = this.refreshResourceIndexFromDataStore(serviceType);
        }
        return resourceIndex.getSubResourcePolicyNames(string);
    }

    Set getWildSubResourcePolicyNames(ServiceType serviceType, String string) throws PolicyException {
        ResourceIndex resourceIndex = (ResourceIndex)this.resourceIndices.get(serviceType.getName());
        if (resourceIndex == null) {
            resourceIndex = this.refreshResourceIndexFromDataStore(serviceType);
        }
        return resourceIndex.getWildSubResourcePolicyNames(serviceType, string);
    }

    void clearResourceIndex(String string) {
        HashSet hashSet = new HashSet();
        hashSet.addAll(this.resourceIndices.keySet());
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string2.equalsIgnoreCase(string)) continue;
            this.resourceIndices.remove(string2);
            break;
        }
    }

    ResourceIndex getResourceIndex(ServiceType serviceType) throws PolicyException {
        ResourceIndex resourceIndex = (ResourceIndex)this.resourceIndices.get(serviceType.getName());
        if (resourceIndex == null) {
            resourceIndex = this.refreshResourceIndexFromDataStore(serviceType);
        }
        return resourceIndex;
    }

    ResourceIndex getResourceIndexFromDataStore(ServiceType serviceType) throws PolicyException {
        ResourceIndex resourceIndex = new ResourceIndex(serviceType, this.resourceManager);
        resourceIndex.refreshFromDataStore();
        return resourceIndex;
    }

    private ResourceIndex refreshResourceIndexFromDataStore(ServiceType serviceType) throws PolicyException {
        ResourceIndex resourceIndex = this.getResourceIndexFromDataStore(serviceType);
        this.resourceIndices.put(serviceType.getName(), resourceIndex);
        return resourceIndex;
    }

    private boolean addIndexEntry(ServiceType serviceType, String string, String string2) throws PolicyException {
        ResourceIndex resourceIndex = (ResourceIndex)this.resourceIndices.get(serviceType.getName());
        if (resourceIndex == null) {
            resourceIndex = this.refreshResourceIndexFromDataStore(serviceType);
        }
        return resourceIndex.addIndexEntry(string, string2);
    }

    private boolean removeIndexEntry(ServiceType serviceType, String string, String string2) throws PolicyException {
        ResourceIndex resourceIndex = (ResourceIndex)this.resourceIndices.get(serviceType.getName());
        if (resourceIndex == null) {
            resourceIndex = this.refreshResourceIndexFromDataStore(serviceType);
        }
        return resourceIndex.removeIndexEntry(string, string2);
    }

    Set getChildResourceNames(ServiceType serviceType, String string, boolean bl) throws PolicyException {
        Set set = null;
        ResourceIndex resourceIndex = (ResourceIndex)this.resourceIndices.get(serviceType.getName());
        if (resourceIndex == null) {
            resourceIndex = this.refreshResourceIndexFromDataStore(serviceType);
        }
        set = resourceIndex.getChildResourceNames(string, bl);
        return set;
    }

    void saveResourceIndex(String string) throws PolicyException, SSOException {
        ResourceIndex resourceIndex = (ResourceIndex)this.resourceIndices.get(string);
        if (resourceIndex != null) {
            String string2 = resourceIndex.toXML();
            this.resourceManager.saveResourceIndex(string, string2);
        }
    }

    void addPolicyToResourceTree(ServiceTypeManager serviceTypeManager, SSOToken sSOToken, Policy policy) throws PolicyException, SSOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Set set = policy.getRuleNames();
        Iterator iterator = set.iterator();
        HashSet<String> hashSet = new HashSet<String>();
        while (iterator.hasNext()) {
            object4 = (String)iterator.next();
            object3 = policy.getRule((String)object4);
            object2 = ((Rule)object3).getServiceTypeName();
            hashSet.add((String)object2);
            object = serviceTypeManager.getServiceType((String)object2);
            this.addIndexEntry((ServiceType)object, ((Rule)object3).getResourceName(), policy.getName());
        }
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            object4 = (String)iterator.next();
            this.saveResourceIndex((String)object4);
        }
        object4 = policy.getReferrals();
        if (object4 != null && (object3 = ((Referrals)object4).getReferralNames()) != null && !object3.isEmpty()) {
            object2 = object3.iterator();
            while (object2.hasNext()) {
                Set set2;
                object = (String)object2.next();
                Referral referral = ((Referrals)object4).getReferral((String)object);
                if (!(referral instanceof OrgReferral) || (set2 = referral.getValues()) == null || set2.isEmpty()) continue;
                Iterator iterator2 = set2.iterator();
                while (iterator2.hasNext()) {
                    Object object5;
                    Object object6;
                    Object object7;
                    HashMap<String, HashSet<Object>> hashMap = new HashMap<String, HashSet<Object>>();
                    String string = (String)iterator2.next();
                    PolicyManager policyManager = new PolicyManager(sSOToken, string);
                    ResourceManager resourceManager = policyManager.getResourceManager();
                    Set set3 = policy.getRuleNames();
                    Iterator iterator3 = set3.iterator();
                    while (iterator3.hasNext()) {
                        object7 = (String)iterator3.next();
                        object6 = policy.getRule((String)object7);
                        object5 = ((Rule)object6).getResourceName();
                        if (object5 == null) continue;
                        String string2 = ((Rule)object6).getServiceTypeName();
                        HashSet<Object> hashSet2 = (HashSet<Object>)hashMap.get(string2);
                        if (hashSet2 == null) {
                            hashSet2 = new HashSet<Object>();
                            hashMap.put(string2, hashSet2);
                        }
                        hashSet2.add(object5);
                    }
                    object7 = hashMap.keySet().iterator();
                    while (object7.hasNext()) {
                        object6 = (String)object7.next();
                        object5 = (Set)hashMap.get(object6);
                        resourceManager.addResourcePrefixes((String)object6, (Set)object5);
                    }
                }
            }
        }
    }

    void removePolicyFromResourceTree(ServiceTypeManager serviceTypeManager, SSOToken sSOToken, Policy policy) throws PolicyException, SSOException {
        Object object;
        Object object2;
        Set set = policy.getRuleNames();
        Iterator iterator = set.iterator();
        String string = null;
        Rule rule = null;
        HashSet<Object> hashSet = new HashSet<Object>();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            rule = policy.getRule(string);
            object2 = rule.getServiceTypeName();
            hashSet.add(object2);
            object = serviceTypeManager.getServiceType((String)object2);
            this.removeIndexEntry((ServiceType)object, rule.getResourceName(), policy.getName());
        }
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            this.saveResourceIndex((String)object2);
        }
        object2 = policy.getReferrals();
        if (object2 != null && (object = ((Referrals)object2).getReferralNames()) != null && !object.isEmpty()) {
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                Set set2;
                String string2 = (String)iterator2.next();
                Referral referral = ((Referrals)object2).getReferral(string2);
                if (!(referral instanceof OrgReferral) || (set2 = referral.getValues()) == null || set2.isEmpty()) continue;
                Iterator iterator3 = set2.iterator();
                while (iterator3.hasNext()) {
                    HashMap<String, HashSet<Object>> hashMap = new HashMap<String, HashSet<Object>>();
                    String string3 = (String)iterator3.next();
                    try {
                        Object object3;
                        Object object4;
                        Object object5;
                        PolicyManager policyManager = new PolicyManager(sSOToken, string3);
                        ResourceManager resourceManager = policyManager.getResourceManager();
                        Iterator iterator4 = policy.getRuleNames().iterator();
                        while (iterator4.hasNext()) {
                            object5 = (String)iterator4.next();
                            object4 = policy.getRule((String)object5);
                            object3 = ((Rule)object4).getResourceName();
                            if (object3 == null) continue;
                            String string4 = ((Rule)object4).getServiceTypeName();
                            HashSet<Object> hashSet2 = (HashSet<Object>)hashMap.get(string4);
                            if (hashSet2 == null) {
                                hashSet2 = new HashSet<Object>();
                                hashMap.put(string4, hashSet2);
                            }
                            hashSet2.add(object3);
                        }
                        object5 = hashMap.keySet().iterator();
                        while (object5.hasNext()) {
                            object4 = (String)object5.next();
                            object3 = (Set)hashMap.get(object4);
                            resourceManager.removeResourcePrefixes((String)object4, (Set)object3);
                        }
                    }
                    catch (PolicyException policyException) {
                        if (!DEBUG.warningEnabled()) continue;
                        DEBUG.warning("Could not clean up resource  prefixes in referrred to org : " + string3 + "-" + policyException.getMessage());
                    }
                }
            }
        }
    }

    void replacePolicyInResourceTree(ServiceTypeManager serviceTypeManager, SSOToken sSOToken, Policy policy, Policy policy2) throws PolicyException, SSOException {
        this.removePolicyFromResourceTree(serviceTypeManager, sSOToken, policy);
        this.addPolicyToResourceTree(serviceTypeManager, sSOToken, policy2);
    }

    private static class ResourceIndexEntry {
        private String resourceName;
        private Set policyNames = new HashSet();
        private Set childEntries = new HashSet();
        private ResourceIndexEntry parent;

        private ResourceIndexEntry(String string, String string2) {
            this.resourceName = string;
            this.policyNames.add(string2);
        }

        ResourceIndexEntry(String string, Set set) {
            this.resourceName = string;
            if (set != null) {
                this.policyNames = set;
            }
        }

        String getResourceName() {
            return this.resourceName;
        }

        void setParent(ResourceIndexEntry resourceIndexEntry) {
            if (this.parent != null) {
                this.parent.childEntries.remove(this);
            }
            this.parent = resourceIndexEntry;
            resourceIndexEntry.childEntries.add(this);
        }

        ResourceIndexEntry getParent() {
            return this.parent;
        }

        boolean addIndexEntry(ServiceType serviceType, String string, String string2) {
            boolean bl = false;
            ResourceMatch resourceMatch = serviceType.compare(this.resourceName, string, false);
            if (resourceMatch.equals(ResourceMatch.EXACT_MATCH)) {
                this.policyNames.add(string2);
                bl = true;
            } else if (resourceMatch.equals(ResourceMatch.SUB_RESOURCE_MATCH)) {
                ResourceIndexEntry resourceIndexEntry;
                Iterator iterator = this.childEntries.iterator();
                while (!bl && iterator.hasNext()) {
                    resourceIndexEntry = (ResourceIndexEntry)iterator.next();
                    if (!resourceIndexEntry.addIndexEntry(serviceType, string, string2)) continue;
                    bl = true;
                }
                if (!bl) {
                    resourceIndexEntry = new ResourceIndexEntry(string, string2);
                    HashSet hashSet = new HashSet();
                    hashSet.addAll(this.childEntries);
                    Iterator iterator2 = hashSet.iterator();
                    while (iterator2.hasNext()) {
                        ResourceIndexEntry resourceIndexEntry2 = (ResourceIndexEntry)iterator2.next();
                        ResourceMatch resourceMatch2 = serviceType.compare(string, resourceIndexEntry2.resourceName, false);
                        if (!resourceMatch2.equals(ResourceMatch.SUB_RESOURCE_MATCH)) continue;
                        resourceIndexEntry2.setParent(resourceIndexEntry);
                    }
                    this.childEntries.add(resourceIndexEntry);
                    bl = true;
                }
            }
            return bl;
        }

        boolean removeIndexEntry(ServiceType serviceType, String string, String string2) {
            boolean bl = false;
            ResourceMatch resourceMatch = serviceType.compare(this.resourceName, string, false);
            if (resourceMatch.equals(ResourceMatch.EXACT_MATCH)) {
                this.policyNames.remove(string2);
                bl = true;
                if (this.childEntries.isEmpty() && this.policyNames.isEmpty() && this.parent != null) {
                    this.parent.childEntries.remove(this);
                }
            } else if (resourceMatch.equals(ResourceMatch.SUB_RESOURCE_MATCH)) {
                Iterator iterator = this.childEntries.iterator();
                while (!bl && iterator.hasNext()) {
                    ResourceIndexEntry resourceIndexEntry = (ResourceIndexEntry)iterator.next();
                    if (!resourceIndexEntry.removeIndexEntry(serviceType, string, string2)) continue;
                    bl = true;
                }
                bl = true;
            }
            return bl;
        }

        ResourceIndexEntry findClosestMatch(ServiceType serviceType, String string) {
            ResourceIndexEntry resourceIndexEntry = null;
            ResourceMatch resourceMatch = serviceType.compare(string, this.resourceName, false);
            if (resourceMatch.equals(ResourceMatch.EXACT_MATCH) || resourceMatch.equals(ResourceMatch.SUB_RESOURCE_MATCH)) {
                resourceIndexEntry = this;
            } else if (resourceMatch.equals(ResourceMatch.SUPER_RESOURCE_MATCH)) {
                Iterator iterator = this.childEntries.iterator();
                boolean bl = false;
                while (!bl && iterator.hasNext()) {
                    ResourceIndexEntry resourceIndexEntry2 = (ResourceIndexEntry)iterator.next();
                    resourceIndexEntry = resourceIndexEntry2.findClosestMatch(serviceType, string);
                    if (resourceIndexEntry == null) continue;
                    bl = true;
                }
                if (resourceIndexEntry == null) {
                    resourceIndexEntry = this;
                }
            }
            return resourceIndexEntry;
        }

        Set getPolicyNames(boolean bl) {
            HashSet hashSet = new HashSet();
            if (bl) {
                ResourceIndexEntry resourceIndexEntry = this;
                while (resourceIndexEntry != null) {
                    hashSet.addAll(resourceIndexEntry.policyNames);
                    resourceIndexEntry = resourceIndexEntry.getParent();
                }
            } else {
                hashSet.addAll(this.policyNames);
            }
            return hashSet;
        }

        Set getSubResourcePolicyNames() {
            HashSet hashSet = new HashSet();
            hashSet.addAll(this.policyNames);
            Iterator iterator = this.childEntries.iterator();
            while (iterator.hasNext()) {
                ResourceIndexEntry resourceIndexEntry = (ResourceIndexEntry)iterator.next();
                hashSet.addAll(resourceIndexEntry.getSubResourcePolicyNames());
            }
            return hashSet;
        }

        Set getWildSubResourcePolicyNames(ServiceType serviceType, String string) {
            HashSet hashSet = new HashSet();
            ResourceMatch resourceMatch = serviceType.compare(string, this.resourceName, true);
            if (resourceMatch != ResourceMatch.NO_MATCH) {
                hashSet.addAll(this.getSubResourcePolicyNames());
            }
            HashSet<String> hashSet2 = new HashSet<String>();
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                resourceMatch = serviceType.compare(string, this.resourceName, true);
                if (resourceMatch != ResourceMatch.NO_MATCH) continue;
                hashSet2.add(string2);
            }
            hashSet.removeAll(hashSet2);
            return hashSet;
        }

        Set getPolicyNames(String string, boolean bl, ServiceType serviceType) {
            HashSet hashSet = new HashSet();
            ResourceMatch resourceMatch = serviceType.compare(string, this.resourceName);
            if (resourceMatch.equals(ResourceMatch.EXACT_MATCH) || resourceMatch.equals(ResourceMatch.WILDCARD_MATCH)) {
                hashSet.addAll(this.policyNames);
                Iterator iterator = this.childEntries.iterator();
                while (iterator.hasNext()) {
                    ResourceIndexEntry resourceIndexEntry = (ResourceIndexEntry)iterator.next();
                    hashSet.addAll(resourceIndexEntry.getPolicyNames(string, bl, serviceType));
                }
            } else if (resourceMatch.equals(ResourceMatch.SUPER_RESOURCE_MATCH)) {
                if (bl) {
                    hashSet.addAll(this.policyNames);
                }
                Iterator iterator = this.childEntries.iterator();
                while (iterator.hasNext()) {
                    ResourceIndexEntry resourceIndexEntry = (ResourceIndexEntry)iterator.next();
                    hashSet.addAll(resourceIndexEntry.getPolicyNames(string, bl, serviceType));
                }
            }
            if (DEBUG.messageEnabled()) {
                DEBUG.message("ResourceIndexEntry.getPolicyNames - resourceName, this.resourceName, resourceMach,  policyNames=" + string + ":" + this.resourceName + ":" + resourceMatch + ":" + this.policyNames);
            }
            return hashSet;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(120);
            stringBuffer.append("ResourceName:").append(this.resourceName).append(";");
            stringBuffer.append("PolicyNames:").append(this.policyNames.toString());
            return stringBuffer.toString();
        }

        Set getChildResourceNames(boolean bl) {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(this.getResourceName());
            if (bl) {
                Iterator iterator = this.childEntries.iterator();
                while (iterator.hasNext()) {
                    ResourceIndexEntry resourceIndexEntry = (ResourceIndexEntry)iterator.next();
                    hashSet.addAll(resourceIndexEntry.getChildResourceNames(bl));
                }
            }
            return hashSet;
        }

        String toXML() {
            String string = null;
            if (this.policyNames.isEmpty() && this.childEntries.isEmpty()) {
                string = "";
            } else {
                Object object;
                StringBuffer stringBuffer = new StringBuffer(256);
                stringBuffer.append(ResourceIndexManager.LTS).append(ResourceIndexManager.REFERENCE).append(ResourceIndexManager.SPACE).append(ResourceIndexManager.NAME).append(ResourceIndexManager.EQUALS).append(ResourceIndexManager.QUOTE).append(XMLUtils.escapeSpecialCharacters((String)this.getResourceName())).append(ResourceIndexManager.QUOTE).append(ResourceIndexManager.GTS).append(ResourceIndexManager.NEW_LINE);
                Iterator iterator = this.policyNames.iterator();
                while (iterator.hasNext()) {
                    object = (String)iterator.next();
                    stringBuffer.append(ResourceIndexManager.LTS).append(ResourceIndexManager.POLICY_NAME).append(ResourceIndexManager.SPACE).append(ResourceIndexManager.NAME).append(ResourceIndexManager.EQUALS).append(ResourceIndexManager.QUOTE).append(XMLUtils.escapeSpecialCharacters((String)object)).append(ResourceIndexManager.QUOTE).append(ResourceIndexManager.SGTS).append(ResourceIndexManager.NEW_LINE);
                }
                iterator = this.childEntries.iterator();
                while (iterator.hasNext()) {
                    object = (ResourceIndexEntry)iterator.next();
                    stringBuffer.append(((ResourceIndexEntry)object).toXML());
                }
                stringBuffer.append(ResourceIndexManager.LTSS).append(ResourceIndexManager.REFERENCE).append(ResourceIndexManager.GTS).append(ResourceIndexManager.NEW_LINE);
                string = stringBuffer.toString();
            }
            return string;
        }
    }

    static class ResourceIndex {
        private ServiceType resourceType;
        private ResourceManager resourceManager;
        private Set topLevelEntries = new HashSet();
        private Map policyNamesCache = Collections.synchronizedMap(new HashMap());
        private Map policyNamesCacheFp = Collections.synchronizedMap(new HashMap());

        ResourceIndex(ServiceType serviceType, ResourceManager resourceManager) {
            this.resourceType = serviceType;
            this.resourceManager = resourceManager;
        }

        Set getPolicyNamesOld(String string, boolean bl) {
            Set set = null;
            if (bl) {
                set = (Set)this.policyNamesCacheFp.get(string);
                if (set == null) {
                    ResourceIndexEntry resourceIndexEntry = this.findClosestMatch(string);
                    set = resourceIndexEntry != null ? resourceIndexEntry.getPolicyNames(bl) : Collections.EMPTY_SET;
                    this.policyNamesCacheFp.put(string, set);
                }
            } else {
                set = (Set)this.policyNamesCache.get(string);
                if (set == null) {
                    ResourceIndexEntry resourceIndexEntry = this.findClosestMatch(string);
                    set = resourceIndexEntry != null ? resourceIndexEntry.getPolicyNames(bl) : Collections.EMPTY_SET;
                    this.policyNamesCache.put(string, set);
                }
            }
            return set;
        }

        Set getPolicyNames(String string, boolean bl) {
            Set set = null;
            if (bl) {
                set = (HashSet)this.policyNamesCacheFp.get(string);
                if (set == null) {
                    set = new HashSet();
                    Iterator iterator = this.topLevelEntries.iterator();
                    while (iterator.hasNext()) {
                        ResourceIndexEntry resourceIndexEntry = (ResourceIndexEntry)iterator.next();
                        set.addAll(resourceIndexEntry.getPolicyNames(string, bl, this.resourceType));
                    }
                    this.policyNamesCacheFp.put(string, set);
                }
            } else {
                set = (Set)this.policyNamesCache.get(string);
                if (set == null) {
                    set = new HashSet();
                    Iterator iterator = this.topLevelEntries.iterator();
                    while (iterator.hasNext()) {
                        ResourceIndexEntry resourceIndexEntry = (ResourceIndexEntry)iterator.next();
                        set.addAll(resourceIndexEntry.getPolicyNames(string, bl, this.resourceType));
                    }
                }
                this.policyNamesCache.put(string, set);
            }
            if (DEBUG.messageEnabled()) {
                DEBUG.message("ResourceIndex.getPolicyNames - resourceName, policyNames=" + string + ":" + set);
            }
            return set;
        }

        Set getSuperResourcePolicyNames(String string) {
            Set set = Collections.EMPTY_SET;
            ResourceIndexEntry resourceIndexEntry = this.findClosestMatch(string);
            if (resourceIndexEntry != null) {
                set = resourceIndexEntry.getPolicyNames(true);
            }
            return set;
        }

        void refreshFromDataStore() throws PolicyException {
            Node node = null;
            try {
                node = this.resourceManager.getXMLRootNode(this.resourceType.getName());
            }
            catch (Exception exception) {
                DEBUG.error("Error reading resource index from data store ", (Throwable)exception);
                throw new PolicyException("amPolicy", "error_reading_resource_index_from_data_store", null, exception);
            }
            if (node != null) {
                Set set = XMLUtils.getChildNodes((Node)node, (String)ResourceIndexManager.REFERENCE);
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Node node2 = (Node)iterator.next();
                    String string = XMLUtils.getNodeAttributeValue((Node)node2, (String)ResourceIndexManager.NAME);
                    Set set2 = this.getPolicyNames(node2);
                    ResourceIndexEntry resourceIndexEntry = new ResourceIndexEntry(string, set2);
                    this.topLevelEntries.add(resourceIndexEntry);
                    Set set3 = XMLUtils.getChildNodes((Node)node2, (String)ResourceIndexManager.REFERENCE);
                    Iterator iterator2 = set3.iterator();
                    while (iterator2.hasNext()) {
                        Node node3 = (Node)iterator2.next();
                        this.processIndexEntryNode(resourceIndexEntry, node3);
                    }
                }
            }
        }

        boolean addIndexEntry(String string, String string2) {
            ResourceIndexEntry resourceIndexEntry;
            Iterator iterator = this.topLevelEntries.iterator();
            boolean bl = false;
            while (!bl && iterator.hasNext()) {
                resourceIndexEntry = (ResourceIndexEntry)iterator.next();
                if (!resourceIndexEntry.addIndexEntry(this.resourceType, string, string2)) continue;
                bl = true;
            }
            if (!bl) {
                resourceIndexEntry = new ResourceIndexEntry(string, string2);
                HashSet hashSet = new HashSet();
                hashSet.addAll(this.topLevelEntries);
                Iterator iterator2 = hashSet.iterator();
                while (iterator2.hasNext()) {
                    ResourceIndexEntry resourceIndexEntry2 = (ResourceIndexEntry)iterator2.next();
                    ResourceMatch resourceMatch = this.resourceType.compare(string, resourceIndexEntry2.getResourceName(), false);
                    if (!resourceMatch.equals(ResourceMatch.SUB_RESOURCE_MATCH)) continue;
                    resourceIndexEntry2.setParent(resourceIndexEntry);
                    this.topLevelEntries.remove(resourceIndexEntry2);
                }
                this.topLevelEntries.add(resourceIndexEntry);
                bl = true;
            }
            return bl;
        }

        boolean removeIndexEntry(String string, String string2) {
            Iterator iterator = this.topLevelEntries.iterator();
            boolean bl = false;
            while (!bl && iterator.hasNext()) {
                ResourceIndexEntry resourceIndexEntry = (ResourceIndexEntry)iterator.next();
                if (!resourceIndexEntry.removeIndexEntry(this.resourceType, string, string2)) continue;
                bl = true;
            }
            return bl;
        }

        private ResourceIndexEntry findClosestMatch(String string) {
            ResourceIndexEntry resourceIndexEntry = null;
            Iterator iterator = this.topLevelEntries.iterator();
            boolean bl = false;
            while (!bl && iterator.hasNext()) {
                ResourceIndexEntry resourceIndexEntry2 = (ResourceIndexEntry)iterator.next();
                resourceIndexEntry = resourceIndexEntry2.findClosestMatch(this.resourceType, string);
                if (resourceIndexEntry == null) continue;
                bl = true;
            }
            return resourceIndexEntry;
        }

        private Set getSubResourcePolicyNames(String string) {
            HashSet hashSet = new HashSet();
            Iterator iterator = this.topLevelEntries.iterator();
            while (iterator.hasNext()) {
                ResourceIndexEntry resourceIndexEntry = (ResourceIndexEntry)iterator.next();
                ResourceIndexEntry resourceIndexEntry2 = resourceIndexEntry.findClosestMatch(this.resourceType, string);
                if (resourceIndexEntry2 == null) continue;
                hashSet.addAll(resourceIndexEntry2.getSubResourcePolicyNames());
            }
            return hashSet;
        }

        private Set getWildSubResourcePolicyNames(ServiceType serviceType, String string) {
            HashSet hashSet = new HashSet();
            Iterator iterator = this.topLevelEntries.iterator();
            while (iterator.hasNext()) {
                ResourceIndexEntry resourceIndexEntry = (ResourceIndexEntry)iterator.next();
                hashSet.addAll(resourceIndexEntry.getWildSubResourcePolicyNames(serviceType, string));
            }
            return hashSet;
        }

        private void processIndexEntryNode(ResourceIndexEntry resourceIndexEntry, Node node) {
            String string = XMLUtils.getNodeAttributeValue((Node)node, (String)ResourceIndexManager.NAME);
            Set set = this.getPolicyNames(node);
            ResourceIndexEntry resourceIndexEntry2 = new ResourceIndexEntry(string, set);
            resourceIndexEntry.childEntries.add(resourceIndexEntry2);
            resourceIndexEntry2.parent = resourceIndexEntry;
            Set set2 = XMLUtils.getChildNodes((Node)node, (String)ResourceIndexManager.REFERENCE);
            Iterator iterator = set2.iterator();
            while (iterator.hasNext()) {
                Node node2 = (Node)iterator.next();
                this.processIndexEntryNode(resourceIndexEntry2, node2);
            }
        }

        private Set getPolicyNames(Node node) {
            Set set = XMLUtils.getChildNodes((Node)node, (String)ResourceIndexManager.POLICY_NAME);
            Iterator iterator = set.iterator();
            Node node2 = null;
            String string = null;
            HashSet<String> hashSet = new HashSet<String>();
            while (iterator.hasNext()) {
                node2 = (Node)iterator.next();
                string = XMLUtils.getNodeAttributeValue((Node)node2, (String)ResourceIndexManager.NAME);
                hashSet.add(string);
            }
            return hashSet;
        }

        Set getChildResourceNames(String string, boolean bl) {
            Set set = null;
            ResourceIndexEntry resourceIndexEntry = this.findClosestMatch(string);
            set = resourceIndexEntry != null ? resourceIndexEntry.getChildResourceNames(bl) : Collections.EMPTY_SET;
            return set;
        }

        Set getTopLevelResourceNames() {
            HashSet<String> hashSet = new HashSet<String>();
            Iterator iterator = this.topLevelEntries.iterator();
            while (iterator.hasNext()) {
                ResourceIndexEntry resourceIndexEntry = (ResourceIndexEntry)iterator.next();
                hashSet.add(resourceIndexEntry.getResourceName());
            }
            return hashSet;
        }

        String toXML() {
            StringBuffer stringBuffer = new StringBuffer(256);
            stringBuffer.append(ResourceIndexManager.LTS).append(ResourceIndexManager.POLICY_CROSS_REFERENCES).append(ResourceIndexManager.SPACE).append(ResourceIndexManager.NAME).append(ResourceIndexManager.EQUALS).append(ResourceIndexManager.QUOTE).append(XMLUtils.escapeSpecialCharacters((String)this.resourceType.getName())).append(ResourceIndexManager.QUOTE).append(ResourceIndexManager.SPACE).append(ResourceIndexManager.TYPE).append(ResourceIndexManager.EQUALS).append(ResourceIndexManager.QUOTE).append(ResourceIndexManager.RESOURCES).append(ResourceIndexManager.QUOTE).append(ResourceIndexManager.GTS).append(ResourceIndexManager.NEW_LINE);
            Iterator iterator = this.topLevelEntries.iterator();
            while (iterator.hasNext()) {
                ResourceIndexEntry resourceIndexEntry = (ResourceIndexEntry)iterator.next();
                stringBuffer.append(resourceIndexEntry.toXML());
            }
            stringBuffer.append(ResourceIndexManager.LTSS).append(ResourceIndexManager.POLICY_CROSS_REFERENCES).append(ResourceIndexManager.GTS).append(ResourceIndexManager.NEW_LINE);
            return stringBuffer.toString();
        }
    }
}

