/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.am.util.Cache;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.XMLUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.policy.ConditionTypeManager;
import com.sun.identity.policy.InvalidFormatException;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.NameAlreadyExistsException;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.NoPermissionException;
import com.sun.identity.policy.Policy;
import com.sun.identity.policy.PolicyCache;
import com.sun.identity.policy.PolicyConfig;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyUtils;
import com.sun.identity.policy.ReferralTypeManager;
import com.sun.identity.policy.ResourceIndexManager;
import com.sun.identity.policy.ResourceManager;
import com.sun.identity.policy.ResourceMatch;
import com.sun.identity.policy.ResponseProviderTypeManager;
import com.sun.identity.policy.Rule;
import com.sun.identity.policy.ServiceType;
import com.sun.identity.policy.ServiceTypeManager;
import com.sun.identity.policy.SharedSubject;
import com.sun.identity.policy.SubjectTypeManager;
import com.sun.identity.policy.Subjects;
import com.sun.identity.policy.interfaces.Subject;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.PluginSchema;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceAlreadyExistsException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceNotFoundException;
import com.sun.identity.sm.ServiceSchemaManager;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import netscape.ldap.util.DN;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class PolicyManager {
    public static final String POLICY_SERVICE_NAME = "iPlanetAMPolicyService";
    public static final String POLICY_DEBUG_NAME = "amPolicy";
    public static final String ORGANIZATION_NAME = "OrganizationName";
    public static final String DELEGATION_REALM = "/sunamhiddenrealmdelegationservicepermissions";
    static final String NAMED_POLICY = "Policies";
    static final String REALM_SUBJECTS = "RealmSubjects";
    static final String XML_REALM_SUBJECTS = "xmlRealmSubjects";
    private static final String NAMED_POLICY_ID = "NamedPolicy";
    static final String RESOURCES_POLICY = "Resources";
    static final String RESOURCES_POLICY_ID = "ServiceType";
    private static final String SUBJECTS_POLICY = "Subjects";
    private static final String SUBJECTS_POLICY_ID = "UserCollections";
    static final String SUBJECT_POLICY = "Subject";
    static final String REALM_SUBJECT_POLICY = "RealmSubject";
    static final String CONDITION_POLICY = "Condition";
    static final String RESP_PROVIDER_POLICY = "ResponseProvider";
    static final String REFERRAL_POLICY = "Referral";
    static final String REFERRALS_POLICY = "Referrals";
    private static final String POLICY_XML = "xmlpolicy";
    static final String POLICY_VERSION = "1.0";
    static final String POLICY_ROOT_NODE = "Policy";
    static final String POLICY_RULE_NODE = "Rule";
    static final String POLICY_SUBJECTS_NODE = "Subjects";
    static final String POLICY_CONDITIONS_NODE = "Conditions";
    static final String POLICY_RESP_PROVIDERS_NODE = "ResponseProviders";
    static final String POLICY_REFERRALS_NODE = "Referrals";
    static final String POLICY_RULE_SERVICE_NODE = "ServiceName";
    static final String POLICY_RULE_RESOURCE_NODE = "ResourceName";
    static final String ATTR_VALUE_PAIR_NODE = "AttributeValuePair";
    static final String ATTR_NODE = "Attribute";
    static final String ATTR_VALUE_NODE = "Value";
    static final String NAME_ATTRIBUTE = "name";
    static final String TYPE_ATTRIBUTE = "type";
    static final String DESCRIPTION_ATTRIBUTE = "description";
    static final String PRIORITY_ATTRIBUTE = "priority";
    static final String STATUS_ATTRIBUTE = "priority";
    static final String STATUS_ACTIVE = "active";
    static final String STATUS_INACTIVE = "inactive";
    static final String SERVICE_TYPE_NAME_ATTRIBUTE = "serviceName";
    static final String POLICY_INDEX_ROOT_NODE = "PolicyCrossReferences";
    static final String POLICY_INDEX_ROOT_NODE_NAME_ATTR = "name";
    static final String POLICY_INDEX_ROOT_NODE_TYPE_ATTR = "type";
    static final String POLICY_INDEX_ROOT_NODE_TYPE_ATTR_RESOURCES_VALUE = "Resources";
    static final String POLICY_INDEX_REFERENCE_NODE = "Reference";
    static final String POLICY_INDEX_REFERENCE_NODE_NAME_ATTR = "name";
    static final String POLICY_INDEX_POLICYNAME_NODE = "PolicyName";
    static final String POLICY_INDEX_POLICYNAME_NODE_NAME_ATTR = "name";
    static final long DEFAULT_SUBJECTS_RESULT_TTL = 600000L;
    private String org = "/";
    private String givenOrgName = "";
    private ServiceConfigManager scm;
    private ResourceManager rm;
    private ServiceTypeManager svtm;
    private SubjectTypeManager stm;
    private ConditionTypeManager ctm;
    private ResponseProviderTypeManager rpm;
    private Cache cachedPolicies = new Cache(200);
    private ReferralTypeManager rtm;
    private PolicyCache policyCache;
    private ResourceIndexManager rim;
    private static ServiceSchemaManager ssm;
    SSOToken token;
    static Debug debug;
    static DN delegationRealm;

    public PolicyManager(SSOToken sSOToken) throws SSOException, PolicyException {
        this(sSOToken, "");
        if (debug.messageEnabled()) {
            debug.message("Policy Manager constructed using SSO token");
        }
    }

    public PolicyManager(SSOToken sSOToken, String string) throws SSOException, NameNotFoundException, PolicyException {
        SSOTokenManager.getInstance().validateToken(sSOToken);
        this.token = sSOToken;
        try {
            this.scm = new ServiceConfigManager(POLICY_SERVICE_NAME, sSOToken);
        }
        catch (SMSException sMSException) {
            debug.error("In constructor for PolicyManager with orgNameUnable to get service config manager", (Throwable)sMSException);
            throw new PolicyException(sMSException);
        }
        this.org = this.verifyOrgName(string);
        this.givenOrgName = string;
        this.rm = new ResourceManager(sSOToken, this.org, this.scm);
        if (debug.messageEnabled()) {
            debug.message("Policy Manager constructed with SSO token  for organization: " + this.org);
        }
        this.policyCache = PolicyCache.getInstance();
        this.svtm = ServiceTypeManager.getServiceTypeManager();
        this.rim = new ResourceIndexManager(this.rm);
    }

    public String getOrganizationName() {
        return this.givenOrgName;
    }

    public Map getPolicyConfig() {
        Map map = null;
        try {
            map = PolicyConfig.getPolicyConfig(this.org);
        }
        catch (PolicyException policyException) {
            debug.error("PolicyManager:can not get policy config  for org : " + this.org, (Throwable)policyException);
        }
        if (map != null) {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(this.org);
            map.put(ORGANIZATION_NAME, hashSet);
        } else {
            debug.error("PolicyManager: policy config is null for org:" + this.org + ". Most likely it has been unregistered." + " It is not recommended to unregister the policy" + " configuration serivce. If you do so, the result" + " is undefined.");
        }
        return map;
    }

    String getOrganizationDN() {
        return this.org;
    }

    public Set getPolicyNames() throws SSOException, NoPermissionException, PolicyException {
        return this.getPolicyNames("*");
    }

    public Set getPolicyNames(String string) throws SSOException, NoPermissionException, PolicyException {
        try {
            ServiceConfig serviceConfig;
            ServiceConfig serviceConfig2 = this.scm.getOrganizationConfig(this.org, null);
            ServiceConfig serviceConfig3 = serviceConfig = serviceConfig2 == null ? null : serviceConfig2.getSubConfig(NAMED_POLICY);
            if (serviceConfig == null) {
                return Collections.EMPTY_SET;
            }
            if (string.equals("*")) {
                return serviceConfig.getSubConfigNames();
            }
            return serviceConfig.getSubConfigNames(string);
        }
        catch (SMSException sMSException) {
            debug.error("Unable to get named policies for organization: " + this.org);
            Object[] objectArray = new String[]{this.org};
            if (sMSException.getExceptionCode() == SMSException.STATUS_NO_PERMISSION) {
                throw new NoPermissionException(POLICY_DEBUG_NAME, "insufficient_access_rights", null);
            }
            throw new PolicyException(POLICY_DEBUG_NAME, "unable_to_get_policies_for_organization", objectArray, sMSException);
        }
    }

    public String getPolicyDN(String string) throws SSOException, NoPermissionException, NameNotFoundException, PolicyException {
        this.getPolicy(string);
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("ou=");
        stringBuffer.append(string);
        stringBuffer.append(",ou=");
        stringBuffer.append(NAMED_POLICY);
        stringBuffer.append(",ou=default,ou=organizationConfig,ou=");
        stringBuffer.append(POLICY_VERSION);
        stringBuffer.append(",ou=");
        stringBuffer.append(POLICY_SERVICE_NAME);
        stringBuffer.append(",ou=services,");
        stringBuffer.append(this.org);
        return stringBuffer.toString();
    }

    public Policy getPolicy(String string) throws SSOException, NoPermissionException, InvalidFormatException, NameNotFoundException, InvalidNameException, PolicyException {
        if (string == null) {
            throw new InvalidNameException(POLICY_DEBUG_NAME, "null_name", null, "null", 1);
        }
        if (debug.messageEnabled()) {
            debug.message("searching for named policy: " + string + " in organization: " + this.org);
        }
        Policy policy = null;
        try {
            ServiceConfig serviceConfig = this.scm.getOrganizationConfig(this.org, null);
            ServiceConfig serviceConfig2 = serviceConfig == null ? null : serviceConfig.getSubConfig(NAMED_POLICY);
            ServiceConfig serviceConfig3 = null;
            Map map = null;
            Set set = null;
            if (serviceConfig2 == null || (serviceConfig3 = serviceConfig2.getSubConfig(string)) == null || (map = serviceConfig3.getAttributes()) == null || (set = (Set)map.get(POLICY_XML)) == null || set.size() <= 0) {
                if (debug.warningEnabled()) {
                    debug.warning("Unable to find named policy: " + string + " in organization: " + this.org);
                }
                Object[] objectArray = new String[]{string, this.org};
                throw new NameNotFoundException(POLICY_DEBUG_NAME, "policy_not_found_in_organization", objectArray, string, 1);
            }
            Iterator iterator = set.iterator();
            String string2 = (String)iterator.next();
            Document document = null;
            try {
                document = XMLUtils.getXMLDocument((InputStream)new ByteArrayInputStream(string2.getBytes("UTF8")));
            }
            catch (Exception exception) {
                debug.error("XML parsing error for policy: " + string + " in organization: " + this.org);
                throw new PolicyException(exception);
            }
            Node node = XMLUtils.getRootNode((Document)document, (String)POLICY_ROOT_NODE);
            if (node == null) {
                debug.error("invalid xml policy blob for named policy: " + string + " in organization: " + this.org);
                throw new InvalidFormatException(POLICY_DEBUG_NAME, "invalid_xml_policy_root_node", null, string, 1);
            }
            if (debug.messageEnabled()) {
                debug.message("returning named policy: " + string + " for organization: " + this.org);
            }
            policy = new Policy(this, node);
            Map map2 = this.getPolicyConfig();
            if (map2 != null) {
                policy.setSubjectsResultTtl(PolicyConfig.getSubjectsResultTtl(map2));
            }
            return policy;
        }
        catch (SMSException sMSException) {
            debug.error("SMS error in finding named policy: " + string + " in organization: " + this.org);
            Object[] objectArray = new String[]{string, this.org};
            if (sMSException.getExceptionCode() == SMSException.STATUS_NO_PERMISSION) {
                throw new NoPermissionException(POLICY_DEBUG_NAME, "insufficient_access_rights", null);
            }
            throw new PolicyException(POLICY_DEBUG_NAME, "unable_to_get_policy", objectArray, sMSException);
        }
    }

    public void addPolicy(Policy policy) throws SSOException, NameAlreadyExistsException, NoPermissionException, InvalidFormatException, PolicyException {
        String string = this.getOrganizationDN();
        string = new DN(string).toRFCString().toLowerCase();
        String string2 = policy.getSubjectRealm();
        Object[] objectArray = new String[]{string, string2};
        if (string2 != null && !string2.equals(string)) {
            if (debug.messageEnabled()) {
                debug.message("Can not add policy in realm :" + string + ", policy has realm subjects " + " from realm : " + string2);
            }
            throw new InvalidFormatException(POLICY_DEBUG_NAME, "policy_realm_does_not_match", objectArray, null, string, 1);
        }
        this.validateForResourcePrefix(policy);
        this.validateReferrals(policy);
        String string3 = policy.toXML();
        HashMap hashMap = new HashMap();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string3);
        hashMap.put(POLICY_XML, hashSet);
        ServiceConfig serviceConfig = PolicyManager.createOrGetPolicyConfig(NAMED_POLICY, NAMED_POLICY, this.scm, this.org);
        try {
            serviceConfig.addSubConfig(policy.getName(), NAMED_POLICY_ID, 0, hashMap);
            this.rim.addPolicyToResourceTree(this.svtm, this.token, policy);
        }
        catch (ServiceAlreadyExistsException serviceAlreadyExistsException) {
            Object[] objectArray2 = new String[]{policy.getName(), this.org};
            if (PolicyUtils.logStatus) {
                PolicyUtils.logErrorMessage("POLICY_ALREADY_EXISTS_IN_REALM", (String[])objectArray2, this.token);
            }
            throw new NameAlreadyExistsException(POLICY_DEBUG_NAME, "policy_already_exists_in_org", objectArray2, policy.getName(), 1);
        }
        catch (SMSException sMSException) {
            Object[] objectArray3 = new String[]{policy.getName(), this.org};
            if (PolicyUtils.logStatus) {
                PolicyUtils.logErrorMessage("UNABLE_TO_ADD_POLICY", (String[])objectArray3, this.token);
            }
            debug.error("SMS error in add policy: " + policy.getName() + " for org: " + this.org, (Throwable)sMSException);
            if (sMSException.getExceptionCode() == SMSException.STATUS_NO_PERMISSION) {
                throw new NoPermissionException(POLICY_DEBUG_NAME, "insufficient_access_rights", null);
            }
            throw new PolicyException(POLICY_DEBUG_NAME, "unable_to_add_policy", objectArray3, sMSException);
        }
        if (PolicyUtils.logStatus) {
            String[] stringArray = new String[]{policy.getName(), this.org};
            PolicyUtils.logAccessMessage("POLICY_CREATE_SUCCESS", stringArray, this.token);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void replacePolicy(Policy policy) throws SSOException, NameNotFoundException, NoPermissionException, InvalidFormatException, PolicyException {
        String[] stringArray;
        String string;
        block14: {
            String string2 = this.getOrganizationDN();
            String string3 = policy.getSubjectRealm();
            Object[] objectArray = new String[]{string2, string3};
            if (string3 != null && !string3.equals(string2)) {
                if (debug.messageEnabled()) {
                    debug.message("Can not replace policy in realm :" + string2 + ", policy has realm subjects " + " from realm : " + string3);
                }
                throw new InvalidFormatException(POLICY_DEBUG_NAME, "policy_realm_does_not_match", objectArray, null, string2, 1);
            }
            String string4 = policy.toXML();
            HashMap hashMap = new HashMap();
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(string4);
            hashMap.put(POLICY_XML, hashSet);
            string = null;
            ServiceConfig serviceConfig = PolicyManager.createOrGetPolicyConfig(NAMED_POLICY, NAMED_POLICY, this.scm, this.org);
            try {
                stringArray = policy.getName();
                String string5 = policy.getOriginalName();
                ServiceConfig serviceConfig2 = serviceConfig.getSubConfig((String)stringArray);
                ServiceConfig serviceConfig3 = null;
                if (string5 != null) {
                    serviceConfig3 = serviceConfig.getSubConfig(string5);
                    string = string5;
                } else {
                    string = policy.getName();
                }
                if (serviceConfig2 == null) {
                    if (serviceConfig3 == null) {
                        Object[] objectArray2 = new String[]{policy.getName(), this.org};
                        throw new NameNotFoundException(POLICY_DEBUG_NAME, "policy_not_found_in_organization", objectArray2, policy.getName(), 1);
                    }
                    this.removePolicy(string5);
                    this.addPolicy(policy);
                    policy.resetOriginalName();
                    break block14;
                }
                Object[] objectArray3 = new String[]{policy.getName(), this.org};
                if (string5 != null && !policy.getName().equalsIgnoreCase(string5)) {
                    if (PolicyUtils.logStatus) {
                        PolicyUtils.logErrorMessage("DID_NOT_REPLACE_POLICY", (String[])objectArray3, this.token);
                    }
                    throw new NameAlreadyExistsException(POLICY_DEBUG_NAME, "policy_already_exists_in_org", objectArray3, policy.getName(), 1);
                }
                Policy policy2 = this.getPolicy(policy.getName());
                this.validateForResourcePrefix(policy);
                this.validateReferrals(policy);
                serviceConfig2.setAttributes(hashMap);
                if (policy2 != null) {
                    this.rim.replacePolicyInResourceTree(this.svtm, this.token, policy2, policy);
                }
            }
            catch (SMSException sMSException) {
                Object[] objectArray4 = new String[]{string, this.org};
                if (PolicyUtils.logStatus) {
                    PolicyUtils.logErrorMessage("UNABLE_TO_REPLACE_POLICY", (String[])objectArray4, this.token);
                }
                debug.error("SMS error in replacing policy: " + policy.getOriginalName() + " for org: " + this.org, (Throwable)sMSException);
                if (sMSException.getExceptionCode() == SMSException.STATUS_NO_PERMISSION) {
                    throw new NoPermissionException(POLICY_DEBUG_NAME, "insufficient_access_rights", null);
                }
                throw new PolicyException(POLICY_DEBUG_NAME, "unable_to_replace_policy", objectArray4, sMSException);
            }
        }
        if (PolicyUtils.logStatus) {
            stringArray = new String[]{string, this.org};
            PolicyUtils.logAccessMessage("POLICY_MODIFY_SUCCESS", stringArray, this.token);
        }
    }

    public void removePolicy(String string) throws SSOException, NoPermissionException, PolicyException {
        String[] stringArray;
        String string2 = this.getOrganizationDN();
        if (string == null) {
            if (debug.warningEnabled()) {
                debug.warning("In PolicyManager::removePolicy(), name is null");
            }
            throw new InvalidNameException(POLICY_DEBUG_NAME, "null_name", null, "null", 1);
        }
        try {
            ServiceConfig serviceConfig;
            stringArray = this.scm.getOrganizationConfig(this.org, null);
            ServiceConfig serviceConfig2 = serviceConfig = stringArray == null ? null : stringArray.getSubConfig(NAMED_POLICY);
            if (serviceConfig != null) {
                ServiceConfig serviceConfig3 = serviceConfig.getSubConfig(string);
                Policy policy = this.getPolicy(string);
                serviceConfig.removeSubConfig(string);
                if (policy != null) {
                    this.rim.removePolicyFromResourceTree(this.svtm, this.token, policy);
                }
            }
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            debug.error("Error while removing policy : " + serviceNotFoundException.getMessage());
        }
        catch (SMSException sMSException) {
            Object[] objectArray = new String[]{string, this.org};
            if (PolicyUtils.logStatus) {
                PolicyUtils.logErrorMessage("UNABLE_TO_REMOVE_POLICY", (String[])objectArray, this.token);
            }
            debug.error("SMS error in deleting policy: " + string + " for org: " + this.org, (Throwable)sMSException);
            if (sMSException.getExceptionCode() == SMSException.STATUS_NO_PERMISSION) {
                throw new NoPermissionException(POLICY_DEBUG_NAME, "insufficient_access_rights", null);
            }
            throw new PolicyException(POLICY_DEBUG_NAME, "unable_to_remove_policy", objectArray, sMSException);
        }
        stringArray = new String[]{string, this.org};
        if (PolicyUtils.logStatus) {
            PolicyUtils.logAccessMessage("POLICY_REMOVE_SUCCESS", stringArray, this.token);
        }
    }

    public ResourceManager getResourceManager() {
        return this.rm;
    }

    public SubjectTypeManager getSubjectTypeManager() {
        if (this.stm == null) {
            this.stm = new SubjectTypeManager(this);
        }
        return this.stm;
    }

    public ConditionTypeManager getConditionTypeManager() {
        if (this.ctm == null) {
            this.ctm = new ConditionTypeManager(this);
        }
        return this.ctm;
    }

    public ResponseProviderTypeManager getResponseProviderTypeManager() {
        if (this.rpm == null) {
            this.rpm = new ResponseProviderTypeManager(this);
        }
        return this.rpm;
    }

    static ServiceConfig createOrGetPolicyConfig(String string, String string2, ServiceConfigManager serviceConfigManager, String string3) throws NoPermissionException, PolicyException, SSOException {
        ServiceConfig serviceConfig = null;
        try {
            ServiceConfig serviceConfig2 = serviceConfigManager.getOrganizationConfig(string3, null);
            ServiceConfig serviceConfig3 = serviceConfig = serviceConfig2 == null ? null : serviceConfig2.getSubConfig(string);
            if (serviceConfig == null) {
                if (debug.messageEnabled()) {
                    debug.message("Creating the " + string + " tree for org: " + string3);
                }
                PolicyManager.createPolicyTree(string, string2, serviceConfigManager, string3);
                if (serviceConfig2 == null) {
                    serviceConfig2 = serviceConfigManager.getOrganizationConfig(string3, null);
                }
                if (serviceConfig2 == null || (serviceConfig = serviceConfig2.getSubConfig(string)) == null) {
                    Object[] objectArray = new String[]{string};
                    throw new PolicyException(POLICY_DEBUG_NAME, "unable_to_get_policy_node", objectArray, null);
                }
            }
        }
        catch (SMSException sMSException) {
            debug.error("SMS error in creating " + string + " node for org: " + string3, (Throwable)sMSException);
            if (sMSException.getExceptionCode() == SMSException.STATUS_NO_PERMISSION) {
                Object[] objectArray = new String[]{string};
                throw new NoPermissionException(POLICY_DEBUG_NAME, "insufficient_access_rights", objectArray);
            }
            Object[] objectArray = new String[]{string};
            throw new PolicyException(POLICY_DEBUG_NAME, "unable_to_get_policy_node", objectArray, sMSException);
        }
        return serviceConfig;
    }

    static void createPolicyTree(String string, String string2, ServiceConfigManager serviceConfigManager, String string3) throws NoPermissionException, PolicyException, SSOException {
        try {
            ServiceConfig serviceConfig = serviceConfigManager.getOrganizationConfig(string3, null);
            if (serviceConfig == null) {
                serviceConfigManager.createOrganizationConfig(string3, null);
                serviceConfig = serviceConfigManager.getOrganizationConfig(string3, null);
            }
            serviceConfig.addSubConfig(string, string2, 0, null);
        }
        catch (ServiceAlreadyExistsException serviceAlreadyExistsException) {
            if (debug.messageEnabled()) {
                debug.message("PolicyManager->createPolicyTree: Name: " + string + " ID: " + string2 + " Policy service already exists under org->" + string3);
            }
        }
        catch (SMSException sMSException) {
            Object[] objectArray = new String[]{string3};
            if (sMSException.getExceptionCode() == SMSException.STATUS_NO_PERMISSION) {
                throw new NoPermissionException(POLICY_DEBUG_NAME, "insufficient_access_rights", null);
            }
            throw new PolicyException(POLICY_DEBUG_NAME, "unable_to_create_policy_for_org", objectArray, sMSException);
        }
    }

    String verifyOrgName(String string) throws InvalidNameException, NameNotFoundException, SSOException {
        String string2 = null;
        if (string == null) {
            throw new InvalidNameException(POLICY_DEBUG_NAME, "null_name", null, "null", 4);
        }
        string2 = DNMapper.orgNameToDN(string);
        if (!SMSEntry.checkIfEntryExists(string2, this.token)) {
            if (debug.warningEnabled()) {
                debug.warning("Checking for organization name: " + string2 + " failed since entry does not exist");
            }
            Object[] objectArray = new String[]{string};
            throw new NameNotFoundException(POLICY_DEBUG_NAME, "org_not_found", objectArray, string2, 4);
        }
        return string2;
    }

    Set getSubOrganizationNames() throws SSOException, NoPermissionException, PolicyException {
        throw new UnsupportedOperationException();
    }

    Set getSubOrganizationNames(String string) throws SSOException, PolicyException {
        throw new UnsupportedOperationException();
    }

    PolicyManager getSubOrganizationPolicyManager(String string) throws SSOException, PolicyException {
        return new PolicyManager(this.token, this.org + "/" + string);
    }

    ServiceTypeManager getServiceTypeManager() {
        return this.svtm;
    }

    public ReferralTypeManager getReferralTypeManager() {
        if (this.rtm == null) {
            this.rtm = new ReferralTypeManager(this);
        }
        return this.rtm;
    }

    static Set getPluginSchemaNames(String string) {
        if (ssm == null) {
            try {
                ssm = new ServiceSchemaManager(POLICY_SERVICE_NAME, ServiceTypeManager.getSSOToken());
            }
            catch (Exception exception) {
                debug.error("Cannot create service schema manager for policy", (Throwable)exception);
                return Collections.EMPTY_SET;
            }
        }
        Set set = null;
        try {
            set = ssm.getPluginSchemaNames(string, null);
        }
        catch (Exception exception) {
            debug.error("Cannot get plugin schemas: " + string + " for policy", (Throwable)exception);
            return Collections.EMPTY_SET;
        }
        return set == null ? Collections.EMPTY_SET : set;
    }

    static PluginSchema getPluginSchema(String string, String string2) {
        Set set = PolicyManager.getPluginSchemaNames(string);
        if (set.contains(string2)) {
            try {
                return ssm.getPluginSchema(string2, string, null);
            }
            catch (Exception exception) {
                debug.error("Cannot get plugin schemas: " + string + " for policy", (Throwable)exception);
            }
        }
        return null;
    }

    static String getViewBeanURL(String string, String string2) {
        String string3 = null;
        if (string != null) {
            Iterator iterator = PolicyManager.getPluginSchemaNames(string).iterator();
            while (iterator.hasNext()) {
                String string4 = (String)iterator.next();
                PluginSchema pluginSchema = PolicyManager.getPluginSchema(string, string4);
                if (!string2.equals(pluginSchema.getClassName())) continue;
                string3 = pluginSchema.getPropertiesViewBeanURL();
                break;
            }
        }
        return string3;
    }

    Policy getPolicy(String string, boolean bl) throws SSOException, NoPermissionException, InvalidFormatException, NameNotFoundException, InvalidFormatException, PolicyException {
        Policy policy = null;
        policy = bl ? this.policyCache.getPolicy(this.org, string) : this.getPolicy(string);
        return policy;
    }

    ResourceIndexManager getResourceIndexManager() {
        return this.rim;
    }

    private boolean validateResourceForPrefix(ServiceType serviceType, String string) throws PolicyException {
        boolean bl = false;
        Set set = this.rm.getManagedResourceNames(serviceType.getName());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            boolean bl2;
            String string2 = (String)iterator.next();
            ResourceMatch resourceMatch = serviceType.compare(string, string2, bl2 = true);
            if (!resourceMatch.equals(ResourceMatch.SUPER_RESOURCE_MATCH) && !resourceMatch.equals(ResourceMatch.WILDCARD_MATCH) && !resourceMatch.equals(ResourceMatch.EXACT_MATCH)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private void validateForResourcePrefix(Policy policy) throws SSOException, PolicyException {
        DN dN = new DN(this.org);
        DN dN2 = new DN(ServiceManager.getBaseDN());
        Set set = this.rm.getManagedResourceNames();
        if (!(dN.equals(dN2) || dN.equals(delegationRealm) || set != null && !set.isEmpty())) {
            Object[] objectArray = new String[]{this.org};
            throw new PolicyException(POLICY_DEBUG_NAME, "no_referral_can_not_create_policy", objectArray, null);
        }
        Iterator iterator = policy.getRuleNames().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Rule rule = policy.getRule(string);
            String string2 = rule.getServiceTypeName();
            ServiceType serviceType = this.getServiceTypeManager().getServiceType(string2);
            String string3 = rule.getResourceName();
            boolean bl = true;
            if (!dN.equals(dN2) && !dN.equals(delegationRealm)) {
                bl = this.validateResourceForPrefix(serviceType, string3);
            }
            if (bl) continue;
            Object[] objectArray = new String[]{string3, serviceType.getName()};
            throw new PolicyException(POLICY_DEBUG_NAME, "resource_name_not_permitted_by_prefix_names", objectArray, null);
        }
    }

    private void validateReferrals(Policy policy) throws SSOException, PolicyException {
        Set set = policy.getReferredToOrganizations();
        if (set.contains(this.org.toLowerCase())) {
            Object[] objectArray = new String[]{this.org};
            throw new PolicyException(POLICY_DEBUG_NAME, "invalid_referral_pointing_to_self", objectArray, null);
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.verifyOrgName(string);
        }
    }

    void saveRealmSubjects(Subjects subjects) throws PolicyException, SSOException {
        ServiceConfig serviceConfig = PolicyManager.createOrGetPolicyConfig(REALM_SUBJECTS, REALM_SUBJECTS, this.scm, this.org);
        HashMap hashMap = new HashMap(1);
        HashSet<String> hashSet = new HashSet<String>(1);
        String string = subjects.toXML();
        hashSet.add(string);
        hashMap.put(XML_REALM_SUBJECTS, hashSet);
        try {
            serviceConfig.setAttributes(hashMap);
        }
        catch (SMSException sMSException) {
            debug.error("SMS error in saving realm subjects  in organization: " + this.org);
            Object[] objectArray = new String[]{this.org};
            if (sMSException.getExceptionCode() == SMSException.STATUS_NO_PERMISSION) {
                throw new PolicyException(POLICY_DEBUG_NAME, "insufficient_access_rights", null, sMSException);
            }
            throw new PolicyException(POLICY_DEBUG_NAME, "unable_to_save_realm_subjects", objectArray, sMSException);
        }
        if (debug.messageEnabled()) {
            debug.message("saved realm subjects:" + string);
        }
    }

    Subjects readRealmSubjects() throws PolicyException, SSOException {
        Subjects subjects = null;
        ServiceConfig serviceConfig = PolicyManager.createOrGetPolicyConfig(REALM_SUBJECTS, REALM_SUBJECTS, this.scm, this.org);
        Set set = null;
        set = (Set)serviceConfig.getAttributes().get(XML_REALM_SUBJECTS);
        if (set != null && !set.isEmpty()) {
            String string = (String)set.iterator().next();
            Object var5_5 = null;
            Document document = null;
            try {
                document = XMLUtils.getXMLDocument((InputStream)new ByteArrayInputStream(string.getBytes("UTF8")));
            }
            catch (Exception exception) {
                debug.error("XML parsing error for realmSubjects:  in organization: " + this.org);
                throw new PolicyException(exception);
            }
            Node node = XMLUtils.getRootNode((Document)document, (String)"Subjects");
            if (node == null) {
                debug.error("invalid xmlRealmSubjects blob  in organization: " + this.org);
                throw new InvalidFormatException(POLICY_DEBUG_NAME, "invalid_xml_realmsubjects_root_node", null, this.org, 1);
            }
            subjects = new Subjects(this, node);
        } else {
            subjects = new Subjects();
        }
        if (debug.messageEnabled()) {
            debug.message("read realm subjects:" + subjects.toXML());
        }
        subjects.setPolicyConfig(this.getPolicyConfig());
        return subjects;
    }

    public Set getPoliciesUsingRealmSubject(String string) throws PolicyException, SSOException {
        HashSet<Policy> hashSet = new HashSet<Policy>();
        Set set = this.getPolicyNames();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Subject subject;
            String string2 = (String)iterator.next();
            Policy policy = this.getPolicy(string2);
            Set set2 = policy.getSubjectNames();
            if (!set2.contains(string) || !((subject = policy.getSubject(string)) instanceof SharedSubject)) continue;
            hashSet.add(policy);
        }
        return hashSet;
    }

    Policy getPolicyUsingRealmSubject(String string) throws PolicyException, SSOException {
        Policy policy = null;
        Set set = this.getPolicyNames();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Subject subject;
            String string2 = (String)iterator.next();
            Policy policy2 = this.getPolicy(string2);
            Set set2 = policy2.getSubjectNames();
            if (!set2.contains(string) || !((subject = policy2.getSubject(string)) instanceof SharedSubject)) continue;
            policy = policy2;
            break;
        }
        return policy;
    }

    static {
        debug = Debug.getInstance((String)POLICY_DEBUG_NAME);
        delegationRealm = new DN(DNMapper.orgNameToDN(DELEGATION_REALM));
    }
}

