/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.am.util.XMLUtils;
import com.iplanet.ums.validation.BooleanValidator;
import com.iplanet.ums.validation.DNValidator;
import com.iplanet.ums.validation.FloatValidator;
import com.iplanet.ums.validation.MailAddressValidator;
import com.iplanet.ums.validation.NumberValidator;
import com.iplanet.ums.validation.URLValidator;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.AttributeSchemaImpl;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ActionSchema
extends AttributeSchemaImpl {
    protected static final String ACTION_SCHEMA = "AttributeSchema";
    protected static final String ACTION_VALUE = "AttributeValue";
    protected static final String VALUE = "Value";
    protected static final String I18N_KEY = "i18nKey";
    protected static final String RESOURCE_NAME = "ResourceName";
    private Node actionNode = null;
    static final MailAddressValidator mailValidator = new MailAddressValidator();
    static final BooleanValidator boolValidator = new BooleanValidator();
    static final NumberValidator numberValidator = new NumberValidator();
    static final URLValidator urlValidator = new URLValidator();
    static final FloatValidator floatValidator = new FloatValidator();
    static final DNValidator dnValidator = new DNValidator();

    protected ActionSchema(Node node) {
        super(node);
        this.actionNode = node;
    }

    public Set getActionValues() {
        return this.getChoiceValuesSet();
    }

    public String getActionValueI18NKey(String string) {
        return this.getChoiceValueI18NKey(string);
    }

    public boolean requiresResourceName() {
        return this.isResourceNameAllowed();
    }

    public Set getResourceNames(String string) {
        NodeList nodeList = this.actionNode.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node.getNodeName().equalsIgnoreCase(ACTION_VALUE)) {
                NodeList nodeList2 = node.getChildNodes();
                int n2 = 0;
                while (n2 < nodeList2.getLength()) {
                    String string2;
                    Node node2 = nodeList2.item(n2);
                    if (node2.getNodeName().equalsIgnoreCase(VALUE) && string.equalsIgnoreCase((string2 = XMLUtils.getValueOfValueNode((Node)node2)).toString())) {
                        HashSet<String> hashSet = new HashSet<String>();
                        NodeList nodeList3 = node.getChildNodes();
                        int n3 = 0;
                        while (n3 < nodeList3.getLength()) {
                            Node node3 = nodeList3.item(n3);
                            if (node3.getNodeName().equalsIgnoreCase(RESOURCE_NAME)) {
                                hashSet.add(XMLUtils.getValueOfValueNode((Node)node3));
                            }
                            ++n3;
                        }
                        return hashSet;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return Collections.EMPTY_SET;
    }

    public String getResourceNameI18NKey(String string) {
        NodeList nodeList = this.actionNode.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node.getNodeName().equalsIgnoreCase(ACTION_VALUE)) {
                NodeList nodeList2 = node.getChildNodes();
                int n3 = nodeList2.getLength();
                int n4 = 0;
                while (n4 < n3) {
                    String string2;
                    Node node2 = nodeList2.item(n4);
                    if (node2.getNodeName().equalsIgnoreCase(VALUE) && string.equalsIgnoreCase(string2 = XMLUtils.getValueOfValueNode((Node)node2))) {
                        NodeList nodeList3 = node.getChildNodes();
                        int n5 = nodeList3.getLength();
                        int n6 = 0;
                        while (n6 < n5) {
                            String string3;
                            Node node3 = nodeList3.item(n6);
                            if (node3.getNodeName().equalsIgnoreCase(RESOURCE_NAME) && (string3 = XMLUtils.getNodeAttributeValue((Node)node3, (String)I18N_KEY)) != null) {
                                return string3;
                            }
                            ++n6;
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return null;
    }

    static void validate(ActionSchema actionSchema, Set set) throws InvalidNameException {
        if (!ActionSchema.validateType(actionSchema, set) || !ActionSchema.validateSyntax(actionSchema, set)) {
            PolicyManager.debug.error("In validate action name: invalid values");
            throw new InvalidNameException("amPolicy", "invalid_action_value", null, actionSchema.getName(), 1);
        }
    }

    static boolean validateType(ActionSchema actionSchema, Set set) {
        if (set == null || set.isEmpty()) {
            return true;
        }
        AttributeSchema.Type type = actionSchema.getType();
        boolean bl = false;
        if (type.equals(AttributeSchema.Type.SINGLE) || type.equals(AttributeSchema.Type.SINGLE_CHOICE)) {
            bl = true;
            if (set.size() > 1) {
                return false;
            }
        }
        if (type.equals(AttributeSchema.Type.SINGLE_CHOICE) || type.equals(AttributeSchema.Type.MULTIPLE_CHOICE)) {
            bl = true;
            Set set2 = actionSchema.getActionValues();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                if (set2.contains(iterator.next())) continue;
                return false;
            }
        }
        return bl || type.equals(AttributeSchema.Type.LIST);
    }

    static boolean validateSyntax(ActionSchema actionSchema, Set set) {
        String string;
        Iterator iterator;
        AttributeSchema.Syntax syntax = actionSchema.getSyntax();
        boolean bl = false;
        if (syntax.equals(AttributeSchema.Syntax.STRING) || syntax.equals(AttributeSchema.Syntax.PASSWORD)) {
            bl = true;
        }
        if (syntax.equals(AttributeSchema.Syntax.BOOLEAN) && set.size() == 1) {
            iterator = set.iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                if (!actionSchema.getTrueValue().equals(string) && !actionSchema.getFalseValue().equals(string)) continue;
                bl = true;
            }
        }
        if (syntax.equals(AttributeSchema.Syntax.EMAIL)) {
            iterator = set.iterator();
            while (iterator.hasNext()) {
                bl = true;
                if (mailValidator.validate((String)iterator.next())) continue;
                bl = false;
                break;
            }
        }
        if (syntax.equals(AttributeSchema.Syntax.URL)) {
            iterator = set.iterator();
            while (iterator.hasNext()) {
                bl = true;
                if (urlValidator.validate((String)iterator.next())) continue;
                bl = false;
                break;
            }
        }
        if (syntax.equals(AttributeSchema.Syntax.NUMERIC) || syntax.equals(AttributeSchema.Syntax.NUMBER)) {
            iterator = set.iterator();
            while (iterator.hasNext()) {
                bl = true;
                if (numberValidator.validate((String)iterator.next())) continue;
                bl = false;
                break;
            }
        }
        if (syntax.equals(AttributeSchema.Syntax.PERCENT) || syntax.equals(AttributeSchema.Syntax.DECIMAL_NUMBER)) {
            iterator = set.iterator();
            while (iterator.hasNext()) {
                bl = true;
                if (floatValidator.validate((String)iterator.next())) continue;
                bl = false;
                break;
            }
        }
        if (syntax.equals(AttributeSchema.Syntax.NUMBER_RANGE)) {
            iterator = set.iterator();
            while (iterator.hasNext()) {
                bl = true;
                string = (String)iterator.next();
                Integer n = Integer.valueOf(string);
                Integer n2 = Integer.valueOf(actionSchema.getStartRange());
                Integer n3 = Integer.valueOf(actionSchema.getEndRange());
                if (n == null || n2 == null || n3 == null) {
                    bl = false;
                    break;
                }
                if (n >= n2 && n <= n3) continue;
                bl = false;
                break;
            }
        }
        if (syntax.equals(AttributeSchema.Syntax.DN)) {
            iterator = set.iterator();
            while (iterator.hasNext()) {
                bl = true;
                if (dnValidator.validate((String)iterator.next())) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }
}

