/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.soapbinding;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.am.util.XMLUtils;
import com.sun.identity.federation.alliance.FSAffiliationDescriptor;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import com.sun.identity.liberty.ws.soapbinding.ConsentHeader;
import com.sun.identity.liberty.ws.soapbinding.CorrelationHeader;
import com.sun.identity.liberty.ws.soapbinding.Message;
import com.sun.identity.liberty.ws.soapbinding.NamespacePrefixMapperImpl;
import com.sun.identity.liberty.ws.soapbinding.ProcessingContextHeader;
import com.sun.identity.liberty.ws.soapbinding.ProviderHeader;
import com.sun.identity.liberty.ws.soapbinding.SOAPBindingException;
import com.sun.identity.liberty.ws.soapbinding.SOAPBindingService;
import com.sun.identity.liberty.ws.soapbinding.SOAPFault;
import com.sun.identity.liberty.ws.soapbinding.SOAPFaultDetail;
import com.sun.identity.liberty.ws.soapbinding.SOAPFaultException;
import com.sun.identity.liberty.ws.soapbinding.UsageDirectiveHeader;
import com.sun.identity.liberty.ws.soapbinding.jaxb.ObjectFactory;
import com.sun.org.apache.xml.internal.utils.PrefixResolverDefault;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.NotIdentifiableEvent;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Utils {
    static final String NAMESPACE_PREFIX_MAPPING_LIST_PROP = "com.sun.identity.liberty.ws.jaxb.namespacePrefixMappingList";
    static final String JAXB_PACKAGE_LIST_PROP = "com.sun.identity.liberty.ws.jaxb.packageList";
    static final String DEFAULT_JAXB_PACKAGES = "com.sun.identity.liberty.ws.common.jaxb.soap:com.sun.identity.liberty.ws.common.jaxb.assertion:com.sun.identity.liberty.ws.common.jaxb.protocol:com.sun.identity.liberty.ws.common.jaxb.ac:com.sun.identity.liberty.ws.disco.jaxb:com.sun.identity.liberty.ws.disco.jaxb11:com.sun.identity.liberty.ws.disco.plugins.jaxb:com.sun.identity.liberty.ws.interaction.jaxb:com.sun.identity.liberty.ws.meta.jaxb:com.sun.identity.liberty.ws.paos.jaxb:com.sun.identity.liberty.ws.common.jaxb.ps:com.sun.identity.liberty.ws.common.jaxb.security:com.sun.identity.liberty.ws.soapbinding.jaxb:com.sun.identity.liberty.ws.soapbinding.jaxb11:com.sun.identity.liberty.ws.idpp.jaxb:com.sun.identity.liberty.ws.idpp.plugin.jaxb:com.sun.identity.liberty.ws.common.jaxb.secext:com.sun.identity.liberty.ws.common.jaxb.utility:com.sun.identity.liberty.ws.common.jaxb.xmlenc:com.sun.identity.liberty.ws.common.jaxb.xmlsig";
    static com.sun.identity.liberty.ws.common.jaxb.soap.ObjectFactory soapOF;
    static ObjectFactory soapBOF;
    static com.sun.identity.liberty.ws.common.jaxb.secext.ObjectFactory secOF;
    static final QName FAULT_CODE_SERVER;
    static String faultStringServerError;
    static Debug debug;
    public static ResourceBundle bundle;
    static MessageFactory messageFactory;
    static HashMap nsPrefix;
    static String jaxbPackages;
    static JAXBContext jc;
    static final String STALE_TIME_LIMIT_PROP = "com.sun.identity.liberty.ws.soap.staleTimeLimit";
    static int stale_time_limit;
    static final String SUPPORTED_ACTORS_PROP = "com.sun.identity.liberty.ws.soap.supportedActors";
    static Set supportedActors;
    private static Map messageIDMap;
    private static Thread cThread;

    public static Map getNamespacePrefixMapping() {
        return nsPrefix;
    }

    public static String getJAXBPackages() {
        return jaxbPackages;
    }

    public static SOAPMessage DocumentToSOAPMessage(Document document) throws SOAPBindingException {
        SOAPMessage sOAPMessage = null;
        try {
            MimeHeaders mimeHeaders = new MimeHeaders();
            mimeHeaders.addHeader("Content-Type", "text/xml");
            String string = XMLUtils.print((Node)document);
            if (debug.messageEnabled()) {
                debug.message("Utils.DocumentToSOAPMessage: xmlstr = " + string);
            }
            sOAPMessage = messageFactory.createMessage(mimeHeaders, (InputStream)new ByteArrayInputStream(string.getBytes("UTF-8")));
        }
        catch (Exception exception) {
            debug.error("Utils.DocumentToSOAPMessage", (Throwable)exception);
            throw new SOAPBindingException(exception.getMessage());
        }
        return sOAPMessage;
    }

    public static List convertJAXBToElement(List list) throws JAXBException {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        if (list != null && !list.isEmpty()) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                arrayList.add(Utils.convertJAXBToElement(iterator.next()));
            }
        }
        return arrayList;
    }

    public static Element convertJAXBToElement(Object object) throws JAXBException {
        Marshaller marshaller = jc.createMarshaller();
        try {
            marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)new NamespacePrefixMapperImpl());
        }
        catch (PropertyException propertyException) {
            debug.error("Utils.convertJAXBToElement", (Throwable)propertyException);
        }
        Document document = null;
        try {
            document = XMLUtils.newDocument();
        }
        catch (Exception exception) {
            debug.error("Utils.convertJAXBToElement:", (Throwable)exception);
        }
        marshaller.marshal(object, (Node)document);
        return document.getDocumentElement();
    }

    public static Element convertJAXBToElement(Object object, boolean bl) throws JAXBException {
        Marshaller marshaller = jc.createMarshaller();
        try {
            marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)new NamespacePrefixMapperImpl());
        }
        catch (PropertyException propertyException) {
            debug.error("Utils.convertJAXBToElement", (Throwable)propertyException);
        }
        if (!bl) {
            marshaller.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler(){

                public boolean handleEvent(ValidationEvent validationEvent) {
                    if (validationEvent instanceof NotIdentifiableEvent) {
                        return true;
                    }
                    return super.handleEvent(validationEvent);
                }
            });
        }
        Document document = null;
        try {
            document = XMLUtils.newDocument();
        }
        catch (Exception exception) {
            debug.error("Utils.convertJAXBToElement:", (Throwable)exception);
        }
        marshaller.marshal(object, (Node)document);
        return document.getDocumentElement();
    }

    public static List convertElementToJAXB(List list) throws JAXBException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (list != null && !list.isEmpty()) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                arrayList.add(Utils.convertElementToJAXB((Element)iterator.next()));
            }
        }
        return arrayList;
    }

    public static Object convertElementToJAXB(Element element) throws JAXBException {
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        return unmarshaller.unmarshal((Node)element);
    }

    public static Boolean StringToBoolean(String string) throws Exception {
        if (string == null) {
            return null;
        }
        if (string.equals("true") || string.equals("1")) {
            return Boolean.TRUE;
        }
        if (string.equals("false") || string.equals("0")) {
            return Boolean.FALSE;
        }
        throw new Exception();
    }

    public static String BooleanToString(Boolean bl) {
        if (bl == null) {
            return "";
        }
        return bl != false ? "1" : "0";
    }

    public static QName convertStringToQName(String string, Element element) {
        String string2;
        if (string == null) {
            return null;
        }
        String string3 = "";
        int n = string.indexOf(":");
        if (n == -1) {
            string2 = string;
        } else {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
        }
        PrefixResolverDefault prefixResolverDefault = new PrefixResolverDefault(element.getOwnerDocument());
        String string4 = prefixResolverDefault.getNamespaceForPrefix(string3, element);
        return new QName(string4, string2);
    }

    static void enforceProcessingRules(Message message, String string, boolean bl) throws SOAPBindingException, SOAPFaultException {
        CorrelationHeader correlationHeader = message.getCorrelationHeader();
        String string2 = correlationHeader.getMessageID();
        Utils.checkCorrelationHeader(correlationHeader, string, bl);
        Utils.checkProviderHeader(message.getProviderHeader(), string2, bl);
        Utils.checkProcessingContextHeader(message.getProcessingContextHeader(), string2, bl);
        Utils.checkConsentHeader(message.getConsentHeader(), string2, bl);
        List list = message.getUsageDirectiveHeaders();
        if (list != null && !list.isEmpty()) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                UsageDirectiveHeader usageDirectiveHeader = (UsageDirectiveHeader)iterator.next();
                Utils.checkUsageDirectiveHeader(usageDirectiveHeader, string2, bl);
            }
        }
    }

    static void checkCorrelationHeader(CorrelationHeader correlationHeader, String string, boolean bl) throws SOAPBindingException, SOAPFaultException {
        if (correlationHeader == null) {
            if (bl) {
                SOAPFault sOAPFault = new SOAPFault(FAULT_CODE_SERVER, faultStringServerError, null, new SOAPFaultDetail(SOAPFaultDetail.ID_STAR_MSG_NOT_UNSTD, null, null));
                throw new SOAPFaultException(new Message(sOAPFault));
            }
            throw new SOAPBindingException(bundle.getString("CorrelationHeaderNull"));
        }
        String string2 = correlationHeader.getMessageID();
        try {
            Utils.checkActorAndMustUnderstand(correlationHeader.getActor(), correlationHeader.getMustUnderstand(), string2, bl);
        }
        catch (SOAPFaultException sOAPFaultException) {
            sOAPFaultException.getSOAPFaultMessage().getSOAPFault().getDetail().setCorrelationHeader(correlationHeader);
            throw sOAPFaultException;
        }
        Date date = correlationHeader.getTimestamp();
        Date date2 = new Date();
        if (date2.getTime() - date.getTime() > (long)stale_time_limit) {
            if (bl) {
                SOAPFaultDetail sOAPFaultDetail = new SOAPFaultDetail(SOAPFaultDetail.STALE_MSG, string2, null);
                sOAPFaultDetail.setCorrelationHeader(correlationHeader);
                SOAPFault sOAPFault = new SOAPFault(FAULT_CODE_SERVER, faultStringServerError, null, sOAPFaultDetail);
                throw new SOAPFaultException(new Message(sOAPFault));
            }
            throw new SOAPBindingException(bundle.getString("staleMsg"));
        }
        Long l = (Long)messageIDMap.get(string2);
        long l2 = System.currentTimeMillis();
        if (l != null && l2 - l < (long)stale_time_limit) {
            if (bl) {
                SOAPFaultDetail sOAPFaultDetail = new SOAPFaultDetail(SOAPFaultDetail.DUPLICATE_MSG, string2, null);
                sOAPFaultDetail.setCorrelationHeader(correlationHeader);
                SOAPFault sOAPFault = new SOAPFault(FAULT_CODE_SERVER, faultStringServerError, null, sOAPFaultDetail);
                throw new SOAPFaultException(new Message(sOAPFault));
            }
            throw new SOAPBindingException(bundle.getString("dupMsg"));
        }
        Object object = messageIDMap;
        synchronized (object) {
            if (debug.messageEnabled()) {
                debug.message("Utils.checkCorrelationHeader: adding messageID: " + string2);
            }
            messageIDMap.put(string2, new Long(l2));
        }
        object = correlationHeader.getRefToMessageID();
        if (object != null && string != null && !((String)object).equals(string)) {
            if (bl) {
                SOAPFaultDetail sOAPFaultDetail = new SOAPFaultDetail(SOAPFaultDetail.INVALID_REF_TO_MSG_ID, string2, null);
                sOAPFaultDetail.setCorrelationHeader(correlationHeader);
                SOAPFault sOAPFault = new SOAPFault(FAULT_CODE_SERVER, faultStringServerError, null, sOAPFaultDetail);
                throw new SOAPFaultException(new Message(sOAPFault));
            }
            throw new SOAPBindingException(bundle.getString("invalidRef"));
        }
    }

    static void checkProviderHeader(ProviderHeader providerHeader, String string, boolean bl) throws SOAPBindingException, SOAPFaultException {
        if (providerHeader == null) {
            return;
        }
        try {
            Utils.checkActorAndMustUnderstand(providerHeader.getActor(), providerHeader.getMustUnderstand(), string, bl);
        }
        catch (SOAPFaultException sOAPFaultException) {
            sOAPFaultException.getSOAPFaultMessage().getSOAPFault().getDetail().setProviderHeader(providerHeader);
            throw sOAPFaultException;
        }
        if (bl) {
            FSProviderDescriptor fSProviderDescriptor;
            String string2;
            block11: {
                string2 = providerHeader.getProviderID();
                fSProviderDescriptor = null;
                try {
                    fSProviderDescriptor = SOAPBindingService.fsAllianceManager.getProvider(string2);
                }
                catch (FSAllianceManagementException fSAllianceManagementException) {
                    if (!debug.messageEnabled()) break block11;
                    debug.message("Utils.checkProviderHeader:", (Throwable)((Object)fSAllianceManagementException));
                }
            }
            if (fSProviderDescriptor == null) {
                SOAPFaultDetail sOAPFaultDetail = new SOAPFaultDetail(SOAPFaultDetail.PROVIDER_ID_NOT_VALID, string, null);
                sOAPFaultDetail.setProviderHeader(providerHeader);
                SOAPFault sOAPFault = new SOAPFault(FAULT_CODE_SERVER, faultStringServerError, null, sOAPFaultDetail);
                throw new SOAPFaultException(new Message(sOAPFault));
            }
            String string3 = providerHeader.getAffiliationID();
            if (string3 != null) {
                Object object;
                Object object2;
                block12: {
                    try {
                        object2 = SOAPBindingService.fsAllianceManager.getAffiliationDescriptor(string3);
                        if (object2 != null && (object = ((FSAffiliationDescriptor)object2).getAffiliationMember()) != null && object.contains(string2)) {
                            return;
                        }
                    }
                    catch (Exception exception) {
                        if (!debug.messageEnabled()) break block12;
                        debug.message("Utils.checkProviderHeader:", (Throwable)exception);
                    }
                }
                object2 = new SOAPFaultDetail(SOAPFaultDetail.AFFILIATION_ID_NOT_VALID, string, null);
                ((SOAPFaultDetail)object2).setProviderHeader(providerHeader);
                object = new SOAPFault(FAULT_CODE_SERVER, faultStringServerError, null, (SOAPFaultDetail)object2);
                throw new SOAPFaultException(new Message((SOAPFault)object));
            }
        }
    }

    static void checkProcessingContextHeader(ProcessingContextHeader processingContextHeader, String string, boolean bl) throws SOAPBindingException, SOAPFaultException {
        if (processingContextHeader == null) {
            return;
        }
        try {
            Utils.checkActorAndMustUnderstand(processingContextHeader.getActor(), processingContextHeader.getMustUnderstand(), string, bl);
        }
        catch (SOAPFaultException sOAPFaultException) {
            sOAPFaultException.getSOAPFaultMessage().getSOAPFault().getDetail().setProcessingContextHeader(processingContextHeader);
            throw sOAPFaultException;
        }
        if (bl) {
            SOAPFaultDetail sOAPFaultDetail = new SOAPFaultDetail(SOAPFaultDetail.PROC_CTX_URI_NOT_UNSTD, string, null);
            sOAPFaultDetail.setProcessingContextHeader(processingContextHeader);
            SOAPFault sOAPFault = new SOAPFault(FAULT_CODE_SERVER, faultStringServerError, null, sOAPFaultDetail);
            throw new SOAPFaultException(new Message(sOAPFault));
        }
        throw new SOAPBindingException(bundle.getString("ProcessingContextUnsupported"));
    }

    static void checkConsentHeader(ConsentHeader consentHeader, String string, boolean bl) throws SOAPBindingException, SOAPFaultException {
        if (consentHeader == null) {
            return;
        }
        try {
            Utils.checkActorAndMustUnderstand(consentHeader.getActor(), consentHeader.getMustUnderstand(), string, bl);
        }
        catch (SOAPFaultException sOAPFaultException) {
            sOAPFaultException.getSOAPFaultMessage().getSOAPFault().getDetail().setConsentHeader(consentHeader);
            throw sOAPFaultException;
        }
    }

    static void checkUsageDirectiveHeader(UsageDirectiveHeader usageDirectiveHeader, String string, boolean bl) throws SOAPBindingException, SOAPFaultException {
        if (usageDirectiveHeader == null) {
            return;
        }
        try {
            Utils.checkActorAndMustUnderstand(usageDirectiveHeader.getActor(), usageDirectiveHeader.getMustUnderstand(), string, bl);
        }
        catch (SOAPFaultException sOAPFaultException) {
            ArrayList<UsageDirectiveHeader> arrayList = new ArrayList<UsageDirectiveHeader>();
            arrayList.add(usageDirectiveHeader);
            sOAPFaultException.getSOAPFaultMessage().getSOAPFault().getDetail().setUsageDirectiveHeaders(arrayList);
            throw sOAPFaultException;
        }
    }

    static void checkActorAndMustUnderstand(String string, Boolean bl, String string2, boolean bl2) throws SOAPBindingException, SOAPFaultException {
        if (string != null && !supportedActors.contains(string)) {
            if (bl2) {
                SOAPFaultDetail sOAPFaultDetail = new SOAPFaultDetail(SOAPFaultDetail.BOGUS_ACTOR, string2, null);
                SOAPFault sOAPFault = new SOAPFault(FAULT_CODE_SERVER, faultStringServerError, null, sOAPFaultDetail);
                throw new SOAPFaultException(new Message(sOAPFault));
            }
            throw new SOAPBindingException(bundle.getString("bogusActor"));
        }
        if (bl != null && !bl.booleanValue()) {
            if (bl2) {
                SOAPFaultDetail sOAPFaultDetail = new SOAPFaultDetail(SOAPFaultDetail.BOGUS_MUST_UNSTND, string2, null);
                SOAPFault sOAPFault = new SOAPFault(FAULT_CODE_SERVER, faultStringServerError, null, sOAPFaultDetail);
                throw new SOAPFaultException(new Message(sOAPFault));
            }
            throw new SOAPBindingException(bundle.getString("bogusMustUnderstand"));
        }
    }

    public static String getString(String string, Object[] objectArray) {
        return MessageFormat.format(bundle.getString(string), objectArray);
    }

    static {
        String string;
        String string2;
        block14: {
            Object object;
            soapOF = new com.sun.identity.liberty.ws.common.jaxb.soap.ObjectFactory();
            soapBOF = new ObjectFactory();
            secOF = new com.sun.identity.liberty.ws.common.jaxb.secext.ObjectFactory();
            FAULT_CODE_SERVER = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server");
            faultStringServerError = null;
            debug = null;
            bundle = null;
            messageFactory = null;
            nsPrefix = new HashMap();
            jaxbPackages = null;
            jc = null;
            stale_time_limit = 300000;
            supportedActors = new HashSet();
            messageIDMap = new HashMap();
            cThread = null;
            bundle = Locale.getInstallResourceBundle((String)"amSOAPBinding");
            faultStringServerError = bundle.getString("ServerError");
            debug = Debug.getInstance((String)"amSOAPBinding");
            try {
                messageFactory = MessageFactory.newInstance();
            }
            catch (Exception exception) {
                debug.error("Utils.static: Unable to create SOAP Message Factory", (Throwable)exception);
            }
            String string3 = SystemProperties.get((String)NAMESPACE_PREFIX_MAPPING_LIST_PROP);
            if (string3 != null && string3.length() > 0) {
                object = new StringTokenizer(string3, "|");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    string2 = ((StringTokenizer)object).nextToken().trim();
                    int n = string2.indexOf(61);
                    if (n != -1 && n != 0 && n != string2.length() - 1) {
                        string = string2.substring(0, n);
                        String string4 = string2.substring(n + 1);
                        if (debug.messageEnabled()) {
                            debug.message("Utils.static: add ns = " + string4 + ", prefix = " + string);
                        }
                        nsPrefix.put(string4, string);
                        continue;
                    }
                    if (!debug.warningEnabled()) continue;
                    debug.warning("Utils.static: Invalid syntax for Namespace Prefix Mapping List: " + string2);
                }
            }
            jaxbPackages = (object = SystemProperties.get((String)JAXB_PACKAGE_LIST_PROP)) != null && ((String)object).length() > 0 ? "com.sun.identity.liberty.ws.common.jaxb.soap:com.sun.identity.liberty.ws.common.jaxb.assertion:com.sun.identity.liberty.ws.common.jaxb.protocol:com.sun.identity.liberty.ws.common.jaxb.ac:com.sun.identity.liberty.ws.disco.jaxb:com.sun.identity.liberty.ws.disco.jaxb11:com.sun.identity.liberty.ws.disco.plugins.jaxb:com.sun.identity.liberty.ws.interaction.jaxb:com.sun.identity.liberty.ws.meta.jaxb:com.sun.identity.liberty.ws.paos.jaxb:com.sun.identity.liberty.ws.common.jaxb.ps:com.sun.identity.liberty.ws.common.jaxb.security:com.sun.identity.liberty.ws.soapbinding.jaxb:com.sun.identity.liberty.ws.soapbinding.jaxb11:com.sun.identity.liberty.ws.idpp.jaxb:com.sun.identity.liberty.ws.idpp.plugin.jaxb:com.sun.identity.liberty.ws.common.jaxb.secext:com.sun.identity.liberty.ws.common.jaxb.utility:com.sun.identity.liberty.ws.common.jaxb.xmlenc:com.sun.identity.liberty.ws.common.jaxb.xmlsig:" + (String)object : DEFAULT_JAXB_PACKAGES;
            if (debug.messageEnabled()) {
                debug.message("Utils.static: jaxbPackages = " + jaxbPackages);
            }
            try {
                jc = JAXBContext.newInstance((String)jaxbPackages);
            }
            catch (JAXBException jAXBException) {
                debug.error("Message.static:", (Throwable)jAXBException);
            }
            string2 = SystemProperties.get((String)STALE_TIME_LIMIT_PROP);
            if (string2 != null) {
                try {
                    stale_time_limit = Integer.parseInt(string2);
                }
                catch (Exception exception) {
                    if (!debug.warningEnabled()) break block14;
                    debug.warning("Utils.static: Unable to get stale time limit. Default value will be used");
                }
            }
        }
        if ((string2 = SystemProperties.get((String)SUPPORTED_ACTORS_PROP)) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                if (string.length() <= 0) continue;
                supportedActors.add(string);
            }
        }
        cThread = new CleanUpThread();
        cThread.start();
    }

    private static class CleanUpThread
    extends Thread {
        static final String MESSAGE_ID_CACHE_CLEANUP_INTERVAL_PROP = "com.sun.identity.liberty.ws.soap.messageIDCacheCleanupInterval";
        static int message_ID_cleanup_interval;

        private CleanUpThread() {
        }

        public void run() {
            while (true) {
                long l = System.currentTimeMillis();
                Iterator<Object> iterator = messageIDMap.keySet().iterator();
                HashSet<String> hashSet = new HashSet<String>();
                Map map = messageIDMap;
                synchronized (map) {
                    String string;
                    while (iterator.hasNext()) {
                        string = (String)iterator.next();
                        Long l2 = (Long)messageIDMap.get(string);
                        if (l - l2 <= (long)stale_time_limit) continue;
                        hashSet.add(string);
                    }
                    iterator = hashSet.iterator();
                    while (iterator.hasNext()) {
                        string = (String)iterator.next();
                        if (debug.messageEnabled()) {
                            debug.message("Utils.CleanUpThread.run: removing expired messageID: " + string);
                        }
                        messageIDMap.remove(string);
                    }
                }
                try {
                    Thread.sleep(message_ID_cleanup_interval);
                    continue;
                }
                catch (Exception exception) {
                    if (!debug.messageEnabled()) continue;
                    debug.message("Utils.CleanUpThread.run:", (Throwable)exception);
                    continue;
                }
                break;
            }
        }

        static {
            block3: {
                message_ID_cleanup_interval = 60000;
                String string = SystemProperties.get((String)MESSAGE_ID_CACHE_CLEANUP_INTERVAL_PROP);
                if (string != null) {
                    try {
                        message_ID_cleanup_interval = Integer.parseInt(string);
                    }
                    catch (Exception exception) {
                        if (!debug.warningEnabled()) break block3;
                        debug.warning("Utils.CleanUpThread.static: Unable to get stale time limit. Default value will be used");
                    }
                }
            }
        }
    }
}

