/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.soapbinding;

import com.iplanet.am.util.XMLUtils;
import com.sun.identity.liberty.ws.soapbinding.SOAPBindingException;
import com.sun.identity.liberty.ws.soapbinding.Utils;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ProviderHeader {
    private String providerID = null;
    private String affiliationID = null;
    private String id = null;
    private Boolean mustUnderstand = null;
    private String actor = null;

    public ProviderHeader(String string) throws SOAPBindingException {
        if (string == null) {
            String string2 = Utils.bundle.getString("missingProviderID");
            Utils.debug.error("ProviderHeader.setProviderID: " + string2);
            throw new SOAPBindingException(string2);
        }
        this.providerID = string;
        this.actor = "http://schemas.xmlsoap.org/soap/actor/next";
        this.mustUnderstand = Boolean.TRUE;
    }

    ProviderHeader(Element element) throws SOAPBindingException {
        this.providerID = XMLUtils.getNodeAttributeValue((Node)element, (String)"providerID");
        if (this.providerID == null) {
            String string = Utils.bundle.getString("missingProviderID");
            Utils.debug.error("ProviderHeader.setProviderID: " + string);
            throw new SOAPBindingException(string);
        }
        this.affiliationID = XMLUtils.getNodeAttributeValue((Node)element, (String)"affiliationID");
        this.id = XMLUtils.getNodeAttributeValue((Node)element, (String)"id");
        String string = XMLUtils.getNodeAttributeValueNS((Node)element, (String)"http://schemas.xmlsoap.org/soap/envelope/", (String)"mustUnderstand");
        if (string != null && string.length() > 0) {
            try {
                this.mustUnderstand = Utils.StringToBoolean(string);
            }
            catch (Exception exception) {
                String string2 = Utils.bundle.getString("invalidMustUnderstand");
                Utils.debug.error("ProviderHeader: " + string2, (Throwable)exception);
                throw new SOAPBindingException(string2);
            }
        }
        this.actor = XMLUtils.getNodeAttributeValueNS((Node)element, (String)"http://schemas.xmlsoap.org/soap/envelope/", (String)"actor");
    }

    public String getProviderID() {
        return this.providerID;
    }

    public String getAffiliationID() {
        return this.affiliationID;
    }

    public String getId() {
        return this.id;
    }

    public Boolean getMustUnderstand() {
        return this.mustUnderstand;
    }

    public String getActor() {
        return this.actor;
    }

    public void setProviderID(String string) {
        if (string != null) {
            this.providerID = string;
        }
    }

    public void setAffiliationID(String string) {
        this.affiliationID = string;
    }

    public void setMustUnderstand(Boolean bl) {
        this.mustUnderstand = bl;
    }

    public void setActor(String string) {
        this.actor = string;
    }

    public void setSignFlag(boolean bl) {
        this.id = bl ? SAMLUtilsCommon.generateID() : null;
    }

    void addToParent(Element element) {
        Document document = element.getOwnerDocument();
        Element element2 = document.createElementNS("urn:liberty:sb:2003-08", "sb:Provider");
        element.appendChild(element2);
        element2.setAttributeNS(null, "providerID", this.providerID);
        if (this.affiliationID != null) {
            element2.setAttributeNS(null, "affiliationID", this.affiliationID);
        }
        if (this.id != null) {
            element2.setAttributeNS(null, "id", this.id);
        }
        if (this.mustUnderstand != null) {
            element2.setAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "S:mustUnderstand", Utils.BooleanToString(this.mustUnderstand));
        }
        if (this.actor != null) {
            element2.setAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "S:actor", this.actor);
        }
    }
}

