/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.soapbinding;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.XMLUtils;
import com.sun.identity.liberty.ws.common.wsse.BinarySecurityToken;
import com.sun.identity.liberty.ws.security.SecurityAssertion;
import com.sun.identity.liberty.ws.security.SecurityUtils;
import com.sun.identity.liberty.ws.soapbinding.ConsentHeader;
import com.sun.identity.liberty.ws.soapbinding.CorrelationHeader;
import com.sun.identity.liberty.ws.soapbinding.ProcessingContextHeader;
import com.sun.identity.liberty.ws.soapbinding.ProviderHeader;
import com.sun.identity.liberty.ws.soapbinding.SOAPBindingException;
import com.sun.identity.liberty.ws.soapbinding.SOAPFault;
import com.sun.identity.liberty.ws.soapbinding.SOAPFaultException;
import com.sun.identity.liberty.ws.soapbinding.ServiceInstanceUpdateHeader;
import com.sun.identity.liberty.ws.soapbinding.UsageDirectiveHeader;
import com.sun.identity.liberty.ws.soapbinding.Utils;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Message {
    public static final int ANONYMOUS = 0;
    public static final int X509_TOKEN = 1;
    public static final int SAML_TOKEN = 2;
    public static final int BEARER_TOKEN = 3;
    public static final String NULL_NULL = "urn:liberty:security:2003-08:null:null";
    public static final String NULL_X509 = "urn:liberty:security:2003-08:null:X509";
    public static final String NULL_SAML = "urn:liberty:security:2003-08:null:SAML";
    public static final String NULL_BEARER = "urn:liberty:security:2004-04:null:Bearer";
    public static final String TLS_NULL = "urn:liberty:security:2003-08:TLS:null";
    public static final String TLS_X509 = "urn:liberty:security:2003-08:TLS:X509";
    public static final String TLS_SAML = "urn:liberty:security:2003-08:TLS:SAML";
    public static final String TLS_BEARER = "urn:liberty:security:2004-04:TLS:Bearer";
    public static final String CLIENT_TLS_NULL = "urn:liberty:security:2003-08:ClientTLS:null";
    public static final String CLIENT_TLS_X509 = "urn:liberty:security:2003-08:ClientTLS:X509";
    public static final String CLIENT_TLS_SAML = "urn:liberty:security:2003-08:ClientTLS:SAML";
    public static final String CLIENT_TLS_BEARER = "urn:liberty:security:2004-04:ClientTLS:Bearer";
    private int securityProfileType = 0;
    private CorrelationHeader correlationHeader = null;
    private ConsentHeader consentHeader = null;
    private List usageDirectiveHeaders = null;
    private ProviderHeader providerHeader = null;
    private ProcessingContextHeader processingContextHeader = null;
    private ServiceInstanceUpdateHeader serviceInstanceUpdateHeader = null;
    private List soapHeaders = null;
    private List soapBodies = null;
    private List securityHeaders = null;
    private List signingIds = null;
    private SOAPFault soapFault = null;
    private String ipAddress = null;
    private String protocol = "http";
    private SecurityAssertion assertion = null;
    private BinarySecurityToken binarySecurityToken = null;
    private X509Certificate certificate = null;
    private X509Certificate messageCertificate = null;
    private Object token = null;
    private String bodyId = null;
    private boolean clientAuthentication = false;
    private String authenticationMechanism = null;
    private Document doc = null;

    public Message() {
        this.correlationHeader = new CorrelationHeader();
        this.securityProfileType = 0;
    }

    public Message(ProviderHeader providerHeader) throws SOAPBindingException {
        this.correlationHeader = new CorrelationHeader();
        this.providerHeader = providerHeader;
        this.securityProfileType = 0;
    }

    public Message(ProviderHeader providerHeader, SecurityAssertion securityAssertion) throws SOAPBindingException {
        if (securityAssertion == null) {
            throw new SOAPBindingException(Utils.bundle.getString("SAMLAssertionNull"));
        }
        this.assertion = securityAssertion;
        if (securityAssertion.isBearer()) {
            this.securityProfileType = 3;
        } else {
            this.securityProfileType = 2;
            this.messageCertificate = (X509Certificate)SecurityUtils.getCertificate(securityAssertion);
        }
        this.correlationHeader = new CorrelationHeader();
        this.providerHeader = providerHeader;
    }

    public Message(ProviderHeader providerHeader, BinarySecurityToken binarySecurityToken) throws SOAPBindingException {
        if (binarySecurityToken == null) {
            throw new SOAPBindingException(Utils.bundle.getString("binarySecurityTokenNull"));
        }
        this.binarySecurityToken = binarySecurityToken;
        this.messageCertificate = (X509Certificate)SecurityUtils.getCertificate(this.binarySecurityToken);
        this.correlationHeader = new CorrelationHeader();
        this.providerHeader = providerHeader;
        this.securityProfileType = 1;
    }

    public Message(SOAPFault sOAPFault) {
        this.soapFault = sOAPFault;
        this.correlationHeader = new CorrelationHeader();
    }

    public Message(InputStream inputStream) throws SOAPBindingException {
        try {
            this.doc = XMLUtils.toDOMDocument((InputStream)inputStream, (Debug)Utils.debug);
            this.parseDocument(this.doc);
        }
        catch (Exception exception) {
            Utils.debug.error("Message:Message", (Throwable)exception);
            throw new SOAPBindingException(exception.getMessage());
        }
    }

    Message(SOAPMessage sOAPMessage) throws SOAPBindingException, SOAPFaultException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            sOAPMessage.writeTo((OutputStream)byteArrayOutputStream);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            this.doc = XMLUtils.toDOMDocument((InputStream)byteArrayInputStream, (Debug)Utils.debug);
            this.parseDocument(this.doc);
        }
        catch (Exception exception) {
            Utils.debug.error("Message:Message", (Throwable)exception);
            throw new SOAPBindingException(exception.getMessage());
        }
    }

    public int getSecurityProfileType() {
        return this.securityProfileType;
    }

    public String getAuthenticationMechanism() {
        if (this.authenticationMechanism != null) {
            return this.authenticationMechanism;
        }
        if (this.protocol.equalsIgnoreCase("https")) {
            if (this.certificate == null) {
                switch (this.securityProfileType) {
                    case 1: {
                        this.authenticationMechanism = TLS_X509;
                        return this.authenticationMechanism;
                    }
                    case 2: {
                        this.authenticationMechanism = TLS_SAML;
                        return this.authenticationMechanism;
                    }
                    case 3: {
                        this.authenticationMechanism = TLS_BEARER;
                        return this.authenticationMechanism;
                    }
                }
                this.authenticationMechanism = TLS_NULL;
                return this.authenticationMechanism;
            }
            switch (this.securityProfileType) {
                case 1: {
                    this.authenticationMechanism = CLIENT_TLS_X509;
                    return this.authenticationMechanism;
                }
                case 2: {
                    this.authenticationMechanism = CLIENT_TLS_SAML;
                    return this.authenticationMechanism;
                }
                case 3: {
                    this.authenticationMechanism = CLIENT_TLS_BEARER;
                    return this.authenticationMechanism;
                }
            }
            this.authenticationMechanism = CLIENT_TLS_NULL;
            return this.authenticationMechanism;
        }
        switch (this.securityProfileType) {
            case 1: {
                this.authenticationMechanism = NULL_X509;
                return this.authenticationMechanism;
            }
            case 2: {
                this.authenticationMechanism = NULL_SAML;
                return this.authenticationMechanism;
            }
            case 3: {
                this.authenticationMechanism = NULL_BEARER;
                return this.authenticationMechanism;
            }
        }
        this.authenticationMechanism = NULL_NULL;
        return this.authenticationMechanism;
    }

    public boolean isClientAuthentication() {
        return this.clientAuthentication;
    }

    public CorrelationHeader getCorrelationHeader() {
        return this.correlationHeader;
    }

    public ConsentHeader getConsentHeader() {
        return this.consentHeader;
    }

    public List getUsageDirectiveHeaders() {
        return this.usageDirectiveHeaders;
    }

    public ProviderHeader getProviderHeader() {
        return this.providerHeader;
    }

    public ProcessingContextHeader getProcessingContextHeader() {
        return this.processingContextHeader;
    }

    public ServiceInstanceUpdateHeader getServiceInstanceUpdateHeader() {
        return this.serviceInstanceUpdateHeader;
    }

    public List getOtherSOAPHeaders() {
        return this.soapHeaders;
    }

    public SOAPFault getSOAPFault() {
        return this.soapFault;
    }

    public List getBodies() {
        return this.soapBodies;
    }

    public List getBodies(String string, String string2) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        if (this.soapBodies != null && !this.soapBodies.isEmpty()) {
            Iterator iterator = this.soapBodies.iterator();
            while (iterator.hasNext()) {
                Element element = (Element)iterator.next();
                String string3 = element.getLocalName();
                String string4 = element.getNamespaceURI();
                if ((string4 != null || string != null) && (string4 == null || !string4.equals(string)) || !string3.equals(string2)) continue;
                arrayList.add(element);
            }
        }
        return this.soapBodies;
    }

    public List getOtherSecurityHeaders() {
        return this.securityHeaders;
    }

    public SecurityAssertion getAssertion() {
        return this.assertion;
    }

    public BinarySecurityToken getBinarySecurityToken() {
        return this.binarySecurityToken;
    }

    public X509Certificate getPeerCertificate() {
        return this.certificate;
    }

    public X509Certificate getMessageCertificate() {
        return this.messageCertificate;
    }

    public Object getToken() {
        return this.token;
    }

    public String getIPAddress() {
        return this.ipAddress;
    }

    public List getSigningIds() {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(this.correlationHeader.getId());
        if (this.consentHeader != null && (object = this.consentHeader.getId()) != null) {
            arrayList.add(object);
        }
        if (this.usageDirectiveHeaders != null && !this.usageDirectiveHeaders.isEmpty()) {
            object = this.usageDirectiveHeaders.iterator();
            while (object.hasNext()) {
                String string = ((UsageDirectiveHeader)object.next()).getId();
                if (string == null) continue;
                arrayList.add(string);
            }
        }
        if (this.providerHeader != null && (object = this.providerHeader.getId()) != null) {
            arrayList.add(object);
        }
        if (this.processingContextHeader != null && (object = this.processingContextHeader.getId()) != null) {
            arrayList.add(object);
        }
        if (this.serviceInstanceUpdateHeader != null && (object = this.serviceInstanceUpdateHeader.getId()) != null) {
            arrayList.add(object);
        }
        if (this.signingIds != null && !this.signingIds.isEmpty()) {
            arrayList.addAll(this.signingIds);
        }
        if (this.bodyId == null) {
            this.bodyId = SAMLUtilsCommon.generateID();
        }
        arrayList.add(this.bodyId);
        return arrayList;
    }

    public void setCorrelationHeader(CorrelationHeader correlationHeader) {
        if (correlationHeader != null) {
            this.correlationHeader = correlationHeader;
        }
    }

    public void setConsentHeader(ConsentHeader consentHeader) {
        this.consentHeader = consentHeader;
    }

    public void setUsageDirectiveHeaders(List list) {
        this.usageDirectiveHeaders = list;
    }

    public void setProviderHeader(ProviderHeader providerHeader) {
        this.providerHeader = providerHeader;
    }

    public void setProcessingContextHeader(ProcessingContextHeader processingContextHeader) {
        this.processingContextHeader = processingContextHeader;
    }

    public void setServiceInstanceUpdateHeader(ServiceInstanceUpdateHeader serviceInstanceUpdateHeader) {
        this.serviceInstanceUpdateHeader = serviceInstanceUpdateHeader;
    }

    public void setOtherSOAPHeaders(List list, List list2) {
        this.soapHeaders = list;
        this.signingIds = list2;
    }

    public void setOtherSOAPHeader(Element element, String string) {
        this.soapHeaders = new ArrayList(1);
        this.soapHeaders.add(element);
        if (string != null) {
            this.signingIds = new ArrayList(1);
            this.signingIds.add(string);
        }
    }

    public void setOtherSecurityHeaders(List list) {
        this.securityHeaders = list;
    }

    public void setOtherSecurityHeader(Element element) {
        this.securityHeaders = new ArrayList(1);
        this.securityHeaders.add(element);
    }

    public void setSOAPFault(SOAPFault sOAPFault) {
        this.soapFault = sOAPFault;
    }

    public void setSOAPBodies(List list) {
        this.soapBodies = list;
    }

    public void setSOAPBody(Element element) {
        this.soapBodies = new ArrayList(1);
        this.soapBodies.add(element);
    }

    void setIPAddress(String string) {
        this.ipAddress = string;
    }

    void setProtocol(String string) {
        this.protocol = string == null ? "http" : string;
    }

    void setPeerCertificate(X509Certificate x509Certificate) {
        this.certificate = x509Certificate;
        this.clientAuthentication = this.certificate != null;
    }

    public void setClientAuthentication(boolean bl) {
        this.clientAuthentication = bl;
    }

    void setToken(Object object) {
        this.token = object;
    }

    public String toString() {
        try {
            return XMLUtils.print((Node)this.toDocument(true).getDocumentElement());
        }
        catch (Exception exception) {
            Utils.debug.error("Message.toString", (Throwable)exception);
            return "";
        }
    }

    public Document toDocument() throws SOAPBindingException {
        return this.toDocument(false);
    }

    public Document toDocument(boolean bl) throws SOAPBindingException {
        Element element;
        Object object;
        boolean bl2;
        Element element2;
        Iterator iterator;
        if (!bl && this.doc != null) {
            return this.doc;
        }
        try {
            this.doc = XMLUtils.newDocument();
        }
        catch (Exception exception) {
            Utils.debug.error("Message:toDocument", (Throwable)exception);
            throw new SOAPBindingException(exception.getMessage());
        }
        Element element3 = this.doc.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "S:Envelope");
        element3.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:S", "http://schemas.xmlsoap.org/soap/envelope/");
        element3.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:sb", "urn:liberty:sb:2003-08");
        element3.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:sb-ext", "urn:liberty:sb:2004-04");
        this.doc.appendChild(element3);
        Element element4 = this.doc.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "S:Header");
        element3.appendChild(element4);
        if (this.correlationHeader != null) {
            this.correlationHeader.addToParent(element4);
        }
        if (this.consentHeader != null) {
            this.consentHeader.addToParent(element4);
        }
        if (this.usageDirectiveHeaders != null && !this.usageDirectiveHeaders.isEmpty()) {
            iterator = this.usageDirectiveHeaders.iterator();
            while (iterator.hasNext()) {
                ((UsageDirectiveHeader)iterator.next()).addToParent(element4);
            }
        }
        if (this.providerHeader != null) {
            this.providerHeader.addToParent(element4);
        }
        if (this.processingContextHeader != null) {
            this.processingContextHeader.addToParent(element4);
        }
        if (this.serviceInstanceUpdateHeader != null) {
            this.serviceInstanceUpdateHeader.addToParent(element4);
        }
        if (this.soapHeaders != null && !this.soapHeaders.isEmpty()) {
            if (Utils.debug.messageEnabled()) {
                Utils.debug.message("Message.toDocument: adding headers ");
            }
            iterator = this.soapHeaders.iterator();
            while (iterator.hasNext()) {
                element2 = (Element)iterator.next();
                element4.appendChild(this.doc.importNode(element2, true));
            }
        }
        boolean bl3 = bl2 = this.securityHeaders != null && !this.securityHeaders.isEmpty();
        if (this.securityProfileType != 0 || bl2) {
            if (Utils.debug.messageEnabled()) {
                Utils.debug.message("Message.toDocument: adding security headers ");
            }
            element2 = this.doc.createElementNS("http://schemas.xmlsoap.org/ws/2003/06/secext", "wsse:Security");
            element2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse", "http://schemas.xmlsoap.org/ws/2003/06/secext");
            element4.appendChild(element2);
            if (this.assertion != null) {
                object = XMLUtils.toDOMDocument((String)this.assertion.toString(true, true), (Debug)Utils.debug);
                if (object == null) {
                    String string = Utils.bundle.getString("cannotProcessSAMLAssertion");
                    Utils.debug.error("Message.Message: " + string);
                    throw new SOAPBindingException(string);
                }
                element = object.getDocumentElement();
                element2.appendChild(this.doc.importNode(element, true));
            } else if (this.binarySecurityToken != null) {
                object = XMLUtils.toDOMDocument((String)this.binarySecurityToken.toString(), (Debug)Utils.debug);
                if (object == null) {
                    String string = Utils.bundle.getString("cannotProcessBinarySecurityToken");
                    Utils.debug.error("Message.Message: " + string);
                    throw new SOAPBindingException(string);
                }
                element = object.getDocumentElement();
                element2.appendChild(this.doc.importNode(element, true));
            }
            if (bl2) {
                object = this.securityHeaders.iterator();
                while (object.hasNext()) {
                    element2.appendChild(this.doc.importNode((Node)object.next(), true));
                }
            }
        }
        element2 = null;
        if (this.soapFault != null) {
            if (Utils.debug.messageEnabled()) {
                Utils.debug.message("Message.toDocument: adding soapFault ");
            }
            element2 = this.doc.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "S:Body");
            element3.appendChild(element2);
            this.soapFault.addToParent(element2);
        }
        if (this.soapBodies != null && !this.soapBodies.isEmpty()) {
            if (Utils.debug.messageEnabled()) {
                Utils.debug.message("Message.toDocument: adding bodies ");
            }
            if (element2 == null) {
                element2 = this.doc.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "S:Body");
                element3.appendChild(element2);
            }
            object = this.soapBodies.iterator();
            while (object.hasNext()) {
                element = (Element)object.next();
                element2.appendChild(this.doc.importNode(element, true));
            }
            if (this.bodyId == null) {
                this.bodyId = SAMLUtilsCommon.generateID();
            }
            element2.setAttributeNS(null, "id", this.bodyId);
        }
        return this.doc;
    }

    SOAPMessage toSOAPMessage() throws SOAPBindingException {
        return Utils.DocumentToSOAPMessage(this.toDocument(true));
    }

    private void parseDocument(Document document) throws SOAPBindingException {
        String string;
        String string2;
        Object object;
        Object object2;
        Object object3;
        NodeList nodeList;
        int n;
        Element element = document.getDocumentElement();
        if (Utils.debug.messageEnabled()) {
            Utils.debug.message("Message.parseDocument: doc = " + XMLUtils.print((Node)element));
        }
        if ((n = (nodeList = element.getChildNodes()).getLength()) == 0) {
            String string3 = Utils.bundle.getString("soapEnvelopeMissingChildren");
            Utils.debug.error("Message.parseDocument: " + string3);
            throw new SOAPBindingException(string3);
        }
        Node node = null;
        Node node2 = null;
        int n2 = 0;
        while (n2 < n) {
            object3 = nodeList.item(n2);
            if (object3.getNodeType() == 1) {
                Element element2 = (Element)object3;
                object2 = element2.getLocalName();
                object = element2.getNamespaceURI();
                if ("http://schemas.xmlsoap.org/soap/envelope/".equals(object)) {
                    if ("Header".equals(object2)) {
                        node = element2;
                    } else if ("Body".equals(object2)) {
                        node2 = element2;
                    }
                }
            }
            ++n2;
        }
        object3 = null;
        this.soapHeaders = new ArrayList();
        if (node != null) {
            nodeList = node.getChildNodes();
            n = nodeList.getLength();
            int n3 = 0;
            while (n3 < n) {
                object2 = nodeList.item(n3);
                if (object2.getNodeType() == 1) {
                    object = (Element)object2;
                    string2 = object.getLocalName();
                    string = object.getNamespaceURI();
                    if ("urn:liberty:sb:2003-08".equals(string)) {
                        if ("Correlation".equals(string2)) {
                            this.correlationHeader = new CorrelationHeader((Element)object);
                        } else if ("Consent".equals(string2)) {
                            this.consentHeader = new ConsentHeader((Element)object);
                        } else if ("UsageDirective".equals(string2)) {
                            if (this.usageDirectiveHeaders == null) {
                                this.usageDirectiveHeaders = new ArrayList();
                            }
                            this.usageDirectiveHeaders.add(new UsageDirectiveHeader((Element)object));
                        } else if ("Provider".equals(string2)) {
                            this.providerHeader = new ProviderHeader((Element)object);
                        } else if ("ProcessingContext".equals(string2)) {
                            this.processingContextHeader = new ProcessingContextHeader((Element)object);
                        } else {
                            this.soapHeaders.add(object);
                        }
                    } else if ("urn:liberty:sb:2004-04".equals(string) && "ServiceInstanceUpdate".equals(string2)) {
                        this.serviceInstanceUpdateHeader = new ServiceInstanceUpdateHeader((Element)object);
                    } else if ("http://schemas.xmlsoap.org/ws/2003/06/secext".equals(string)) {
                        if ("Security".equals(string2)) {
                            object3 = object;
                        } else {
                            this.soapHeaders.add(object);
                        }
                    } else {
                        this.soapHeaders.add(object);
                    }
                }
                ++n3;
            }
        }
        if (this.soapHeaders.isEmpty()) {
            this.soapHeaders = null;
        }
        this.parseSecurityElement((Element)object3);
        if (node2 != null) {
            nodeList = node2.getChildNodes();
            n = nodeList.getLength();
            int n4 = 0;
            while (n4 < n) {
                object2 = nodeList.item(n4);
                if (object2.getNodeType() == 1) {
                    object = (Element)object2;
                    string2 = object.getLocalName();
                    string = object.getNamespaceURI();
                    if (this.soapFault == null && "http://schemas.xmlsoap.org/soap/envelope/".equals(string) && "Fault".equals(string2)) {
                        this.soapFault = new SOAPFault((Element)object);
                    } else {
                        if (this.soapBodies == null) {
                            this.soapBodies = new ArrayList();
                        }
                        this.soapBodies.add(object2);
                    }
                }
                ++n4;
            }
        }
    }

    private void parseSecurityElement(Element element) throws SOAPBindingException {
        List list;
        if (element == null) {
            this.securityProfileType = 0;
            return;
        }
        NodeList nodeList = element.getElementsByTagNameNS("http://schemas.xmlsoap.org/ws/2003/06/secext", "SecurityTokenReference");
        Element element2 = null;
        String string = null;
        if (nodeList != null && nodeList.getLength() > 0 && !(list = XMLUtils.getElementsByTagNameNS1((Element)(element2 = (Element)nodeList.item(0)), (String)"http://schemas.xmlsoap.org/ws/2003/06/secext", (String)"Reference")).isEmpty()) {
            Element element3 = (Element)list.get(0);
            string = XMLUtils.getNodeAttributeValue((Node)element3, (String)"URI");
            if (string == null || string.length() <= 1 || !string.startsWith("#")) {
                String string2 = Utils.bundle.getString("invalidReferenceURI");
                Utils.debug.error("Message.parseSecurityElement: " + string2);
                throw new SOAPBindingException(string2);
            }
            string = string.substring(1);
            if (Utils.debug.messageEnabled()) {
                Utils.debug.message("Message.parseSecurityElement: SecurityTokenReference Reference URI = " + string);
            }
        }
        this.securityProfileType = 0;
        this.securityHeaders = new ArrayList();
        nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node.getNodeType() == 1) {
                String string3;
                String string4;
                Element element4;
                String string5 = node.getLocalName();
                String string6 = node.getNamespaceURI();
                if (this.securityProfileType != 0) {
                    this.securityHeaders.add(node);
                } else if ("BinarySecurityToken".equals(string5) && "http://schemas.xmlsoap.org/ws/2003/06/secext".equals(string6)) {
                    element4 = (Element)node;
                    string4 = XMLUtils.getNodeAttributeValue((Node)element4, (String)"ValueType");
                    Utils.debug.message("ValueType: " + string4);
                    if (string4 != null && string4.endsWith("ServiceSessionContext")) {
                        this.securityHeaders.add(node);
                    } else if (string != null && !string.equals(string3 = XMLUtils.getNodeAttributeValueNS((Node)element4, (String)"http://schemas.xmlsoap.org/ws/2003/06/utility", (String)"Id"))) {
                        this.securityHeaders.add(node);
                    } else {
                        try {
                            this.binarySecurityToken = new BinarySecurityToken(element4);
                            this.messageCertificate = (X509Certificate)SecurityUtils.getCertificate(this.binarySecurityToken);
                        }
                        catch (Exception exception) {
                            String string7 = Utils.bundle.getString("cannotProcessBinarySecurityToken");
                            Utils.debug.error("Message.parseSecurityElement: " + string7);
                            throw new SOAPBindingException(string7);
                        }
                        if (Utils.debug.messageEnabled()) {
                            Utils.debug.message("Message.parseSecurityElement: found binary security token");
                        }
                        this.securityProfileType = 1;
                    }
                } else if ("Assertion".equals(string5) && "urn:oasis:names:tc:SAML:1.0:assertion".equals(string6)) {
                    element4 = (Element)node;
                    if (string != null && !string.equals(string4 = XMLUtils.getNodeAttributeValue((Node)element4, (String)"AssertionID"))) {
                        this.securityHeaders.add(node);
                    } else {
                        try {
                            this.assertion = new SecurityAssertion(element4);
                        }
                        catch (SAMLException sAMLException) {
                            string3 = Utils.bundle.getString("cannotProcessSAMLAssertion");
                            Utils.debug.error("Message.parseSecurityElement: " + string3);
                            throw new SOAPBindingException(string3);
                        }
                        if (Utils.debug.messageEnabled()) {
                            Utils.debug.message("Message.parseSecurityElement: found security assertion, isBearer = " + this.assertion.isBearer());
                        }
                        if (this.assertion.isBearer()) {
                            this.securityProfileType = 3;
                        } else {
                            this.securityProfileType = 2;
                            this.messageCertificate = (X509Certificate)SecurityUtils.getCertificate(this.assertion);
                        }
                    }
                } else {
                    this.securityHeaders.add(node);
                }
            }
            ++n2;
        }
        if (this.securityHeaders.isEmpty()) {
            this.securityHeaders = null;
        }
    }
}

