/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.soapbinding;

import com.iplanet.am.util.XMLUtils;
import com.sun.identity.common.DateUtils;
import com.sun.identity.liberty.ws.soapbinding.SOAPBindingException;
import com.sun.identity.liberty.ws.soapbinding.Utils;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import java.text.ParseException;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CorrelationHeader {
    private String messageID = null;
    private String id = null;
    private String refToMessageID = null;
    private Date timestamp = null;
    private Boolean mustUnderstand = null;
    private String actor = null;

    public CorrelationHeader() {
        this.id = this.messageID = SAMLUtilsCommon.generateID();
        this.timestamp = new Date();
        this.actor = "http://schemas.xmlsoap.org/soap/actor/next";
        this.mustUnderstand = Boolean.TRUE;
    }

    CorrelationHeader(Element element) throws SOAPBindingException {
        this.messageID = XMLUtils.getNodeAttributeValue((Node)element, (String)"messageID");
        if (this.messageID == null) {
            String string = Utils.bundle.getString("missingMessageID");
            Utils.debug.error("CorrelationHeader: " + string);
            throw new SOAPBindingException(string);
        }
        this.id = XMLUtils.getNodeAttributeValue((Node)element, (String)"id");
        this.refToMessageID = XMLUtils.getNodeAttributeValue((Node)element, (String)"refToMessageID");
        String string = XMLUtils.getNodeAttributeValueNS((Node)element, (String)"http://schemas.xmlsoap.org/soap/envelope/", (String)"mustUnderstand");
        if (string != null && string.length() > 0) {
            try {
                this.mustUnderstand = Utils.StringToBoolean(string);
            }
            catch (Exception exception) {
                String string2 = Utils.bundle.getString("invalidMustUnderstand");
                Utils.debug.error("CorrelationHeader: " + string2, (Throwable)exception);
                throw new SOAPBindingException(string2);
            }
        }
        if ((string = XMLUtils.getNodeAttributeValue((Node)element, (String)"timestamp")) == null || string.length() == 0) {
            String string3 = Utils.bundle.getString("missingCorrelationTimestamp");
            Utils.debug.error("CorrelationHeader: " + string3);
            throw new SOAPBindingException(string3);
        }
        try {
            this.timestamp = DateUtils.stringToDate((String)string);
        }
        catch (ParseException parseException) {
            String string4 = Utils.bundle.getString("invalidTimestamp");
            Utils.debug.error("CorrelationHeader: " + string4, (Throwable)parseException);
            throw new SOAPBindingException(string4);
        }
        this.actor = XMLUtils.getNodeAttributeValueNS((Node)element, (String)"http://schemas.xmlsoap.org/soap/envelope/", (String)"actor");
    }

    public String getMessageID() {
        return this.messageID;
    }

    public String getRefToMessageID() {
        return this.refToMessageID;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String getId() {
        return this.messageID;
    }

    public Boolean getMustUnderstand() {
        return this.mustUnderstand;
    }

    public String getActor() {
        return this.actor;
    }

    public void setMustUnderstand(Boolean bl) {
        this.mustUnderstand = bl;
    }

    public void setActor(String string) {
        this.actor = string;
    }

    public void setRefToMessageID(String string) {
        this.refToMessageID = string;
    }

    void addToParent(Element element) {
        Document document = element.getOwnerDocument();
        Element element2 = document.createElementNS("urn:liberty:sb:2003-08", "sb:Correlation");
        element.appendChild(element2);
        element2.setAttributeNS(null, "messageID", this.messageID);
        if (this.refToMessageID != null) {
            element2.setAttributeNS(null, "refToMessageID", this.refToMessageID);
        }
        element2.setAttributeNS(null, "timestamp", DateUtils.toUTCDateFormat((Date)this.timestamp));
        element2.setAttributeNS(null, "id", this.messageID);
        if (this.mustUnderstand != null) {
            element2.setAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "S:mustUnderstand", Utils.BooleanToString(this.mustUnderstand));
        }
        if (this.actor != null) {
            element2.setAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "S:actor", this.actor);
        }
    }
}

