/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.paos;

import com.sun.identity.liberty.ws.dst.DSTData;
import com.sun.identity.liberty.ws.dst.DSTException;
import com.sun.identity.liberty.ws.dst.DSTQueryResponse;
import com.sun.identity.liberty.ws.paos.PAOSException;
import com.sun.identity.liberty.ws.paos.PAOSRequest;
import com.sun.identity.liberty.ws.soapbinding.Message;
import com.sun.identity.liberty.ws.soapbinding.SOAPBindingException;
import com.sun.identity.liberty.ws.soapbinding.SOAPFault;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Element;

public class PAOSResponse {
    private String refToMessageID = null;
    private List bodies = null;
    private PAOSRequest paosReq = null;
    private String msgStr = null;

    public PAOSResponse(HttpServletRequest httpServletRequest) throws PAOSException, IOException {
        String string = httpServletRequest.getContentType();
        if (!string.equals("application/vnd.paos+xml")) {
            PAOSRequest.debug.error("PAOSResponse:PAOSResponse: Wrong content type: " + string);
            throw new PAOSException("Wrong content type in HTTP request: " + string);
        }
        ServletInputStream servletInputStream = null;
        try {
            servletInputStream = httpServletRequest.getInputStream();
        }
        catch (IOException iOException) {
            PAOSRequest.debug.error("Unable to get input stream from HttpServletRequest", (Throwable)iOException);
            throw iOException;
        }
        Message message = null;
        try {
            message = new Message((InputStream)servletInputStream);
        }
        catch (SOAPBindingException sOAPBindingException) {
            PAOSRequest.debug.error("PAOSResponse:PAOSResponse: SOAP binding exception in message construction from input stream.", (Throwable)sOAPBindingException);
            throw new PAOSException("Unable to parse the input stream content.");
        }
        SOAPFault sOAPFault = message.getSOAPFault();
        if (sOAPFault != null) {
            String string2 = sOAPFault.getFaultString();
            PAOSRequest.debug.error("PAOSResponse:PAOSResponse: SOAP Fault in response: " + string2);
            throw new PAOSException("Got fault in response: " + string2);
        }
        this.refToMessageID = message.getCorrelationHeader().getRefToMessageID();
        if (this.refToMessageID == null) {
            PAOSRequest.debug.error("PAOSResponse:PAOSResponse: No refToMessageID.");
            throw new PAOSException("Unrecognized PAOS response message.");
        }
        if (!PAOSRequest.reqTable.containsKey(this.refToMessageID)) {
            PAOSRequest.debug.error("PAOSResponse:PAOSResponse: refToMessageID=" + this.refToMessageID + "is not recognized.");
            throw new PAOSException("Unrecognized PAOS response message.");
        }
        if (PAOSRequest.debug.messageEnabled()) {
            PAOSRequest.debug.message("PAOSResponse:PAOSResponse: refToMessageID=" + this.refToMessageID + " is recognized.");
        }
        this.paosReq = (PAOSRequest)PAOSRequest.reqTable.remove(this.refToMessageID);
        this.bodies = message.getBodies();
        this.msgStr = message.toString();
    }

    public List getPPResponse() throws PAOSException {
        if (this.bodies == null || this.bodies.size() == 0) {
            return null;
        }
        if (PAOSRequest.debug.messageEnabled()) {
            PAOSRequest.debug.message("PAOSResponse:getPPResponse: SOAP bodies size = " + this.bodies.size());
        }
        Element element = (Element)this.bodies.get(0);
        DSTQueryResponse dSTQueryResponse = null;
        try {
            dSTQueryResponse = new DSTQueryResponse(element);
        }
        catch (DSTException dSTException) {
            PAOSRequest.debug.error("PAOSResponse:getPPResponse: Error while parsing query response.", (Throwable)dSTException);
            throw new PAOSException("Error while parsing query response: " + dSTException.getMessage());
        }
        return dSTQueryResponse.getData();
    }

    public String getPPResponseStr() throws PAOSException {
        String string = "";
        DSTData dSTData = null;
        List list = this.getPPResponse();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            dSTData = (DSTData)iterator.next();
            string = string + dSTData.toString(true, true) + "\n";
        }
        return string;
    }

    public List getResponse() {
        return this.bodies;
    }

    public PAOSRequest getOriginalPAOSRequest() {
        return this.paosReq;
    }

    public String toString() {
        return this.msgStr;
    }
}

