/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.meta;

import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSHostedProviderDescriptor;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import com.sun.identity.liberty.ws.meta.MetaException;
import com.sun.identity.liberty.ws.meta.MetaUtils;
import com.sun.identity.liberty.ws.meta.ProviderDescriptorManager;
import com.sun.identity.liberty.ws.meta.jaxb.IDPDescriptorType;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class IDPDescriptorManager
extends ProviderDescriptorManager {
    private static IDPDescriptorManager instance = new IDPDescriptorManager();

    public static IDPDescriptorManager getInstance() throws MetaException {
        if (instance == null) {
            throw new MetaException(MetaUtils.bundle.getString("failGetInstance"));
        }
        return instance;
    }

    public FSProviderDescriptor mapToFSProviderDescriptor(String string, IDPDescriptorType iDPDescriptorType, String string2, String string3) throws MetaException {
        FSProviderDescriptor fSProviderDescriptor = super.mapToFSProviderDesc(string, iDPDescriptorType, string2, string3);
        try {
            fSProviderDescriptor.setProviderRole("IDP");
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            throw new MetaException(fSAllianceManagementException.getMessage());
        }
        String string4 = iDPDescriptorType.getSingleSignOnServiceURL();
        if (string4 == null) {
            throw new MetaException("mapToFSProviderDescriptor: sso url is null");
        }
        try {
            fSProviderDescriptor.setSSOServiceURL(string4);
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            throw new MetaException(fSAllianceManagementException.getMessage());
        }
        List list = iDPDescriptorType.getSingleSignOnProtocolProfile();
        if (list == null || list.isEmpty()) {
            throw new MetaException("mapToFSProviderDescriptorsingle: sign on protocol profile is empty list");
        }
        string4 = (String)list.iterator().next();
        try {
            fSProviderDescriptor.setSingleSignOnProtocolProfile(string4);
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            throw new MetaException(fSAllianceManagementException.getMessage());
        }
        if (fSProviderDescriptor.getClass().getName().equals("com.sun.identity.federation.alliance.FSHostedProviderDescriptor")) {
            ((FSHostedProviderDescriptor)fSProviderDescriptor).getLocalConfiguration().setAuthnfedProfile(string4);
        }
        if ((string4 = iDPDescriptorType.getAuthnServiceURL()) != null) {
            try {
                fSProviderDescriptor.setAuthnServiceURL(string4);
            }
            catch (FSAllianceManagementException fSAllianceManagementException) {
                throw new MetaException(fSAllianceManagementException.getMessage());
            }
        }
        return fSProviderDescriptor;
    }

    public IDPDescriptorType mapToIDPDescriptor(FSProviderDescriptor fSProviderDescriptor) throws MetaException {
        String string = null;
        ArrayList arrayList = new ArrayList();
        IDPDescriptorType iDPDescriptorType = null;
        try {
            iDPDescriptorType = super.mapToIDPProviderDescriptor(fSProviderDescriptor);
            string = fSProviderDescriptor.getSSOServiceURL();
            if (string == null) {
                throw new MetaException("sso url is null");
            }
            iDPDescriptorType.setSingleSignOnServiceURL(string);
            Set set = fSProviderDescriptor.getSingleSignOnProtocolProfileSet();
            if (set != null && !set.isEmpty()) {
                iDPDescriptorType.getSingleSignOnProtocolProfile().addAll(set);
            }
            if ((string = fSProviderDescriptor.getAuthnServiceURL()) != null && !string.equals("")) {
                iDPDescriptorType.setAuthnServiceURL(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MetaException(exception.getMessage());
        }
        return iDPDescriptorType;
    }
}

