/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.interaction;

import com.iplanet.am.util.AMClientDetector;
import com.iplanet.am.util.Debug;
import com.iplanet.services.cdm.Client;
import com.iplanet.services.cdm.ClientException;
import com.iplanet.services.cdm.ClientsManager;
import com.iplanet.services.util.I18n;
import com.sun.identity.liberty.ws.common.LogUtil;
import com.sun.identity.liberty.ws.interaction.InteractionConfig;
import com.sun.identity.liberty.ws.interaction.InteractionManager;
import com.sun.identity.liberty.ws.interaction.JAXBObjectFactory;
import com.sun.identity.liberty.ws.interaction.jaxb.InquiryElement;
import com.sun.identity.liberty.ws.interaction.jaxb.InteractionResponseElement;
import com.sun.identity.liberty.ws.interaction.jaxb.ParameterType;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class WSPRedirectHandlerServlet
extends HttpServlet {
    private static Debug debug = Debug.getInstance((String)"amInteraction");
    private static I18n i18n = I18n.getInstance((String)"amInteraction");
    private static String PARAMETER_PREFIX = "isparam_";
    private static String ACTION = "action";
    private static String TRUE_LABEL = "trueLabel";
    private static String FALSE_LABEL = "falseLabel";
    private static String HELP_LABEL = "helpLabel";
    private static String HINT_LABEL = "hintLabel";
    private static String LINK_LABEL = "linkLabel";
    private static String MORE_LINK_LABEL = "moreLinkLabel";
    private static String DEFAULT_TRUE_LABEL = "true";
    private static String DEFAULT_FALSE_LABEL = "false";
    private static String DEFAULT_HELP_LABEL = "help";
    private static String DEFAULT_HINT_LABEL = "hint";
    private static String DEFAULT_LINK_LABEL = "link";
    private static String DEFAULT_MORE_LINK_LABEL = "moreLink";
    private DOMSource htmlStyleSource = null;
    private DOMSource wmlStyleSource = null;
    private static String WML_CLIENT = "WML";
    private AMClientDetector clientDetector;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.clientDetector = new AMClientDetector();
        String string = InteractionConfig.getInstance().getHTMLStyleSheetLocation();
        String string2 = InteractionConfig.getInstance().getWMLStyleSheetLocation();
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new File(string));
            this.htmlStyleSource = new DOMSource(document);
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(new File(string2));
            this.wmlStyleSource = new DOMSource(document);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            debug.error("WSPRedirectHandlerServlet.init()", (Throwable)parserConfigurationException);
            throw new ServletException((Throwable)parserConfigurationException);
        }
        catch (SAXException sAXException) {
            debug.error("WSPRedirectHandlerServlet.init()", (Throwable)sAXException);
            throw new ServletException((Throwable)sAXException);
        }
        catch (IOException iOException) {
            debug.error("WSPRedirectHandlerServlet.init()", (Throwable)iOException);
            throw new ServletException((Throwable)iOException);
        }
        if (debug.messageEnabled()) {
            debug.message("WSPRedirectHandlerServlet.init():initialized");
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        this.handleRequest(httpServletRequest, httpServletResponse);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        this.handleRequest(httpServletRequest, httpServletResponse);
    }

    private void handleRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String string = this.getRequestURL(httpServletRequest);
        String string2 = httpServletRequest.getParameter("TransID");
        String string3 = httpServletRequest.getParameter("ReturnToURL");
        if (debug.messageEnabled()) {
            debug.message("WSPRedirectHandlerServlet.handleRequest():entering with requestURL=" + string + ":messageID=" + string2 + ":returnToURL=" + string3);
        }
        if (string2 != null) {
            if (string3 != null) {
                if (debug.messageEnabled()) {
                    debug.message("WSPRedirecthandlerServlet.handleRequest(): entering with returnToRL=" + string3 + " :a new request");
                }
                if (string3.indexOf("ResendMessage=") != -1) {
                    debug.error("WSPRedirecthandlerServlet.handleRequest():invalid Request - illegal parameter:ResendMessage:returnToURL=" + string3);
                    this.showErrorPage(httpServletRequest, httpServletResponse, "Invalid Request - illegal parameter:ResendMessage:returnToURL=" + string3);
                    return;
                }
                if (InteractionConfig.getInstance().wspEnforcesHttpsCheck() && string3.indexOf("https") != 0) {
                    debug.error("WSPRedirecthandlerServlet.handleRequest():Invalid Request ReturnToURL not https:returnToURL=" + string3);
                    this.showErrorPage(httpServletRequest, httpServletResponse, "Invalid Request ReturnToURL not https:returnToURL=" + string3);
                    return;
                }
                if (InteractionConfig.getInstance().wspEnforcesReturnToHostEqualsRequestHost() && !this.checkReturnToHost(string2, string3)) {
                    debug.error("WSPRedirecthandlerServlet.handleRequest():Invalid Request ReturnToHost differs from  RequestHost:returnToURL=" + string3 + ":requestHost=" + InteractionManager.getInstance().getRequestHost(string2));
                    this.showErrorPage(httpServletRequest, httpServletResponse, "Invalid Request ReturnToHost differs from  RequestHost:returnToURL=" + string3 + ":requestHost=" + InteractionManager.getInstance().getRequestHost(string2));
                    return;
                }
                InteractionManager.getInstance().setReturnToURL(string2, string3);
                this.sendInteractionRequestPage(string2, httpServletRequest, httpServletResponse);
            } else {
                if (debug.messageEnabled()) {
                    debug.message("WSPRedirecthandlerServlet.handleRequest(): entering without retunrnToRL: response for query");
                }
                if ((string3 = InteractionManager.getInstance().getReturnToURL(string2)) == null) {
                    debug.error("WSPRedirecthandlerServlet.handleRequest(): returnToURL not found to redirect");
                    this.showErrorPage(httpServletRequest, httpServletResponse, " returnToURL not found in cache");
                } else {
                    this.sendInteractionResponsePage(string2, httpServletRequest, httpServletResponse, string3);
                }
            }
        } else {
            debug.error("WSPRedirecthandlerServlet.handleRequest():request without messageID:requestURL=" + string);
            this.showErrorPage(httpServletRequest, httpServletResponse, "Invalid Request - missing messageID:requestURL=" + string);
        }
        if (debug.messageEnabled()) {
            debug.message("WSPRedirecthandlerServlet.handleRequest():returning");
        }
    }

    private void sendInteractionRequestPage(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        InquiryElement inquiryElement = InteractionManager.getInstance().getInquiryElement(string);
        String string2 = httpServletRequest.getRequestURL().toString();
        string2 = string2 + "?" + "TransID" + "=" + string;
        if (debug.messageEnabled()) {
            debug.message("WSPRedirectHandlerServlet.sendInteractionRequestPage():action=" + string2);
        }
        DOMSource dOMSource = null;
        boolean bl = this.isWMLClient(httpServletRequest);
        PrintWriter printWriter = null;
        if (!bl) {
            if (debug.messageEnabled()) {
                debug.message("WSPRedirectHandlerServlet.sendInteractionRequestPage():clientType=html");
            }
            dOMSource = this.htmlStyleSource;
            httpServletResponse.setContentType("text/html");
            printWriter = httpServletResponse.getWriter();
        } else {
            if (debug.messageEnabled()) {
                debug.message("WSPRedirectHandlerServlet.sendInteractionRequestPage():clientType=wml");
            }
            dOMSource = this.wmlStyleSource;
            httpServletResponse.setContentType("text/vnd.wap.wml");
            printWriter = httpServletResponse.getWriter();
            printWriter.println("<?xml version=\"1.0\"?>");
            printWriter.println("<!DOCTYPE wml PUBLIC \"-//WAPFORUM//DTD WML 1.1//EN\"");
            printWriter.println("    \"http://www.wapforum.org/DTD/wml_1.1.xml\">");
        }
        try {
            JAXBContext jAXBContext = JAXBContext.newInstance((String)"com.sun.identity.liberty.ws.interaction.jaxb");
            Marshaller marshaller = jAXBContext.createMarshaller();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            marshaller.marshal((Object)inquiryElement, (Node)document);
            document.getDocumentElement().setAttribute("action", string2);
            String string3 = DEFAULT_TRUE_LABEL;
            String string4 = DEFAULT_FALSE_LABEL;
            String string5 = DEFAULT_HELP_LABEL;
            String string6 = DEFAULT_HINT_LABEL;
            String string7 = DEFAULT_LINK_LABEL;
            String string8 = DEFAULT_MORE_LINK_LABEL;
            String string9 = InteractionManager.getInstance().getLanguage(string);
            if (string9 == null) {
                string3 = i18n.getString(TRUE_LABEL);
                string4 = i18n.getString(FALSE_LABEL);
                string5 = i18n.getString(HELP_LABEL);
                string6 = i18n.getString(HINT_LABEL);
                string7 = i18n.getString(LINK_LABEL);
                string8 = i18n.getString(MORE_LINK_LABEL);
            } else {
                string3 = i18n.getString(TRUE_LABEL, string9);
                string4 = i18n.getString(FALSE_LABEL, string9);
                string5 = i18n.getString(HELP_LABEL, string9);
                string6 = i18n.getString(HINT_LABEL, string9);
                string7 = i18n.getString(LINK_LABEL, string9);
                string8 = i18n.getString(MORE_LINK_LABEL, string9);
            }
            Element element = document.getDocumentElement();
            element.setAttribute(TRUE_LABEL, string3);
            element.setAttribute(FALSE_LABEL, string4);
            element.setAttribute(HELP_LABEL, string5);
            element.setAttribute(HINT_LABEL, string6);
            element.setAttribute(LINK_LABEL, string7);
            element.setAttribute(MORE_LINK_LABEL, string8);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            DOMSource dOMSource2 = new DOMSource(document);
            StreamResult streamResult = new StreamResult(printWriter);
            Transformer transformer = transformerFactory.newTransformer(dOMSource);
            transformer.transform(dOMSource2, streamResult);
            if (LogUtil.isLogEnabled()) {
                String[] stringArray = new String[]{string};
                LogUtil.access(Level.INFO, "IS_Presented_Query_To_User_Agent", stringArray);
            }
        }
        catch (JAXBException jAXBException) {
            debug.error("WSPRedirectHandlerServlet.sendInteractionRequestPage():catching JAXBException =", (Throwable)jAXBException);
            this.showErrorPage(httpServletRequest, httpServletResponse, "Error creating JAXBObject:" + jAXBException.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            debug.error("WSPRedirectHandlerServlet.sendInteractionRequestPage():catching ParserConfigurationException =", (Throwable)parserConfigurationException);
            this.showErrorPage(httpServletRequest, httpServletResponse, "Error creating interaction request page:" + parserConfigurationException.getMessage());
        }
        catch (TransformerException transformerException) {
            debug.error("WSPRedirectHandlerServlet.sendInteractionRequestPage():catching TransformerException =", (Throwable)transformerException);
            this.showErrorPage(httpServletRequest, httpServletResponse, "Error creating interaction request page:" + transformerException.getMessage());
        }
    }

    private void sendInteractionResponsePage(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string2) throws IOException {
        if (debug.messageEnabled()) {
            debug.message("WSPRedirectHandlerServlet.sendInteractionResponsePage():entering");
        }
        try {
            String[] stringArray;
            InteractionResponseElement interactionResponseElement = JAXBObjectFactory.getObjectFactory().createInteractionResponseElement();
            List list = interactionResponseElement.getParameter();
            Enumeration enumeration = httpServletRequest.getParameterNames();
            while (enumeration.hasMoreElements()) {
                int n;
                stringArray = (String[])enumeration.nextElement();
                String string3 = httpServletRequest.getParameter((String)stringArray);
                if (debug.messageEnabled()) {
                    debug.message("WSPRedirectHandlerServlet.sendInteractionResponsePage():parameterName=" + (String)stringArray + "parameterValue=" + string3);
                }
                if ((n = stringArray.indexOf(PARAMETER_PREFIX)) == -1) continue;
                ParameterType parameterType = JAXBObjectFactory.getObjectFactory().createParameterType();
                stringArray = stringArray.substring(n + PARAMETER_PREFIX.length());
                parameterType.setName((String)stringArray);
                parameterType.setValue(string3);
                list.add(parameterType);
            }
            if (LogUtil.isLogEnabled()) {
                stringArray = new String[]{string};
                LogUtil.access(Level.INFO, "IS_Collected_Response_From_User_Agent", stringArray);
            }
            InteractionManager.getInstance().setInteractionResponseElement(string, interactionResponseElement);
            string2 = string2.indexOf("?") != -1 ? string2 + "&" + "ResendMessage" + "=" + InteractionManager.getInstance().getRequestMessageID(string) : string2 + "?" + "ResendMessage" + "=" + string;
            if (debug.messageEnabled()) {
                debug.message("WSPRedirectHandlerServlet. sendInteractionResponsePage():redirecting user agent to returnToURL=" + string2);
            }
            httpServletResponse.sendRedirect(string2);
            if (LogUtil.isLogEnabled()) {
                stringArray = new String[]{string};
                LogUtil.access(Level.INFO, "IS_Redirected_User_Agent_Back", stringArray);
            }
        }
        catch (JAXBException jAXBException) {
            debug.error("WSPRedirectHandlerServlet.sendInteractionResponsePage():catching JAXBException =", (Throwable)jAXBException);
            this.showErrorPage(httpServletRequest, httpServletResponse, "Error createing JAXBObject:" + jAXBException.getMessage());
        }
        catch (Exception exception) {
            debug.error("WSPRedirectHandlerServlet.sendInteractionResponsePage():catching Exception =", (Throwable)exception);
        }
    }

    private String getRequestURL(HttpServletRequest httpServletRequest) {
        return httpServletRequest.getRequestURL().append("?").append(httpServletRequest.getQueryString()).toString();
    }

    private void showErrorPage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws IOException {
        boolean bl = this.isWMLClient(httpServletRequest);
        if (!bl) {
            httpServletResponse.setContentType("text/plain");
            PrintWriter printWriter = httpServletResponse.getWriter();
            printWriter.println("<html>");
            printWriter.println("<head><title>WSPRedirectHandler</title></head>");
            printWriter.println("<body>");
            printWriter.println("WSPRedirectHandler - Interaction Error");
            printWriter.println(string);
            printWriter.println("</body>");
            printWriter.println("</html>");
        } else {
            httpServletResponse.setContentType("text/vnd.wap.wml");
            PrintWriter printWriter = httpServletResponse.getWriter();
            printWriter.println("<wml>");
            printWriter.println("<card>");
            printWriter.println("<p>");
            printWriter.println("WSPRediretHandler - encountered error");
            printWriter.println("</p>");
            printWriter.println("</card>");
            printWriter.println("</wml>");
        }
    }

    private boolean checkReturnToHost(String string, String string2) {
        String string3;
        boolean bl = false;
        String string4 = InteractionManager.getInstance().getRequestHost(string);
        URL uRL = null;
        if (string4 != null) {
            try {
                uRL = new URL(string2);
                string3 = uRL.getHost();
                if (string4.equals(string3)) {
                    bl = true;
                }
            }
            catch (MalformedURLException malformedURLException) {
                debug.error("WSPRedirecthandlerServlet.handleRequest():malformed ReturnToURL=" + string2);
            }
        }
        string3 = null;
        if (uRL != null) {
            string3 = uRL.getHost();
            bl = string4.equalsIgnoreCase(string3);
        }
        if (!bl && string3.indexOf(string4 + ".") == 0) {
            bl = true;
        }
        if (debug.messageEnabled()) {
            debug.message("WSPRedirectHandlerServlet.checkReturnToHost(): returning: :requestHost=" + string4 + ":returnToHost=" + string3 + ":returnValue=" + bl);
        }
        return bl;
    }

    private boolean isWMLClient(HttpServletRequest httpServletRequest) {
        boolean bl = false;
        try {
            String string = this.clientDetector.getClientType(httpServletRequest);
            Client client = ClientsManager.getInstance(string);
            String string2 = client.getProperty("parentId");
            if (debug.messageEnabled()) {
                debug.message("WSPRedirectHandlerServlet.isWMLClient(): clientStyle= " + string2);
            }
            if (WML_CLIENT.equalsIgnoreCase(string2)) {
                bl = true;
            }
        }
        catch (ClientException clientException) {
            debug.error("WSPRedirectHandlerServlet.isWMLClient(): catching exception ", (Throwable)clientException);
            debug.error("WSPRedirectHandlerServlet.isWMLClient(): defauting client type to non wml");
        }
        return bl;
    }
}

