/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.interaction;

import com.iplanet.am.util.AMURLEncDec;
import com.iplanet.am.util.Debug;
import com.iplanet.services.util.I18n;
import com.sun.identity.liberty.ws.common.LogUtil;
import com.sun.identity.liberty.ws.interaction.InteractionConfig;
import com.sun.identity.liberty.ws.interaction.InteractionException;
import com.sun.identity.liberty.ws.interaction.InteractionRedirectException;
import com.sun.identity.liberty.ws.interaction.InteractionSOAPFaultException;
import com.sun.identity.liberty.ws.interaction.JAXBObjectFactory;
import com.sun.identity.liberty.ws.interaction.jaxb.InquiryElement;
import com.sun.identity.liberty.ws.interaction.jaxb.InteractionResponseElement;
import com.sun.identity.liberty.ws.interaction.jaxb.ObjectFactory;
import com.sun.identity.liberty.ws.interaction.jaxb.RedirectRequestElement;
import com.sun.identity.liberty.ws.interaction.jaxb.StatusElement;
import com.sun.identity.liberty.ws.interaction.jaxb.UserInteractionElement;
import com.sun.identity.liberty.ws.soapbinding.Client;
import com.sun.identity.liberty.ws.soapbinding.CorrelationHeader;
import com.sun.identity.liberty.ws.soapbinding.Message;
import com.sun.identity.liberty.ws.soapbinding.SOAPBindingException;
import com.sun.identity.liberty.ws.soapbinding.SOAPFault;
import com.sun.identity.liberty.ws.soapbinding.SOAPFaultDetail;
import com.sun.identity.liberty.ws.soapbinding.SOAPFaultException;
import com.sun.identity.liberty.ws.soapbinding.Utils;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

public class InteractionManager {
    private static I18n i18n = I18n.getInstance((String)"amInteraction");
    public static final String RETURN_TO_URL = "ReturnToURL";
    public static final String REQUEST_ID = "RequestID";
    public static final String IDP = "IDP";
    public static final String RESEND_MESSAGE = "ResendMessage";
    public static final String INTERACTION_NAMESPACE = "urn:liberty:is:2003-08";
    public static final QName QNAME_SERVER = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server");
    public static final QName QNAME_INTERACT_IF_NEEDED = new QName("urn:liberty:is:2003-08", "interactIfNeeded", "is");
    public static final QName QNAME_DO_NOT_INTERACT = new QName("urn:liberty:is:2003-08", "doNotInteract", "is");
    public static final QName QNAME_DO_NOT_INTERACT_FOR_DATA = new QName("urn:liberty:is:2003-08", "doNotInteractForData", "is");
    public static final QName QNAME_INTERACTION_REQUIRED = new QName("urn:liberty:is:2003-08", "interactionRequired");
    public static final QName QNAME_INTERACTION_REQUIRED_FOR_DATA = new QName("urn:liberty:is:2003-08", "forData");
    public static final QName QNAME_INTERACTION_TIME_NOT_SUFFICEINT = new QName("urn:liberty:is:2003-08", "timeNotSufficient");
    public static final QName QNAME_INTERACTION_TIMED_OUT = new QName("urn:liberty:is:2003-08", "timeOut");
    public static final QName QNAME_INTERACTION_CAN_NOT_DETERMINE_REQUEST_HOST = new QName("urn:liberty:is:2003-08", "canNotDetermineRequestHostName");
    public static final String SERVER_ERROR = "Server Error";
    static final String TRANS_ID = "TransID";
    private static InteractionManager interactionManager = null;
    private static Debug debug = Debug.getInstance((String)"amInteraction");
    private static final String WSP_REDIRECT_HANDLER = "com.sun.identity.liberty.interaction.WSPRedirectHandler";
    private static final String REDIRECT_URL = "redirectURL";
    private static final String FAULT_ACTOR = "http://schemas.xmlsoap.org/soap/actor/next";
    private static final String INTERACTION_RB_NAME = "amInteraction";
    private InteractionCache cache = new InteractionCache();
    private ObjectFactory objectFactory = JAXBObjectFactory.getObjectFactory();
    private InteractionConfig interactionConfig = InteractionConfig.getInstance();

    public static synchronized InteractionManager getInstance() {
        if (interactionManager == null) {
            interactionManager = new InteractionManager();
        }
        return interactionManager;
    }

    private InteractionManager() {
        if (debug.messageEnabled()) {
            debug.message("InteractionManager():constructed singleton instance");
        }
    }

    public Message sendRequest(Message message, String string, String string2, String string3, String string4, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws InteractionException, InteractionRedirectException, SOAPBindingException, SOAPFaultException {
        String string5;
        Object object;
        String[] stringArray;
        Object object2;
        if (debug.messageEnabled()) {
            debug.message("InteractionManager.sendRequest(): entering with messageID=" + message.getCorrelationHeader().getMessageID() + ":refToMessageID=" + message.getCorrelationHeader().getRefToMessageID() + ":requestMessage=" + message);
        }
        if (this.interactionConfig.wscIncludesUserInteractionHeader()) {
            object2 = httpServletRequest.getLocales();
            stringArray = new ArrayList();
            while (object2.hasMoreElements()) {
                stringArray.add(object2.nextElement().toString());
            }
            if (debug.messageEnabled()) {
                debug.message("InteractionManager.sendRequest():Accept-Language specified by httpRequest=" + stringArray);
            }
            object = this.createUserInteractionElement((List)stringArray);
            string5 = SAMLUtilsCommon.generateID();
            object.setId(string5);
            if (object != null) {
                try {
                    Element element = Utils.convertJAXBToElement(object);
                    message.setOtherSOAPHeader(element, string5);
                }
                catch (JAXBException jAXBException) {
                    debug.error("InteractionManager.sendRequest():not setting userInteractionHeader:can not convert JAXBObject to Element", (Throwable)jAXBException);
                }
            }
        }
        object2 = null;
        try {
            if (debug.messageEnabled()) {
                debug.message("InteractionManager.sendRequest():invoking soap Client.sendRequest()::requestMessage=" + message + ":connecTo=" + string);
            }
            if (LogUtil.isLogEnabled()) {
                stringArray = new String[]{message.getCorrelationHeader().getMessageID()};
                LogUtil.access(Level.INFO, "IS_Sending_Message", stringArray);
            }
            object2 = Client.sendRequest(message, string, string2, string3);
        }
        catch (SOAPFaultException sOAPFaultException) {
            if (debug.messageEnabled()) {
                debug.message("InteractionManager.sendRequest(): catching SOAPFaultException=" + sOAPFaultException);
            }
            if ((object = this.getRedirectURL(sOAPFaultException)) == null) {
                throw sOAPFaultException;
            }
            string5 = this.getResponseID(sOAPFaultException);
            object2 = this.handleRedirectRequest(message, (String)object, string5, string, string2, string3, string4, httpServletRequest, httpServletResponse);
        }
        if (debug.messageEnabled()) {
            debug.message("InteractionManager.sendRequest(): returning response message=" + object2);
        }
        if (LogUtil.isLogEnabled()) {
            stringArray = new String[]{((Message)object2).getCorrelationHeader().getMessageID(), message.getCorrelationHeader().getMessageID()};
            LogUtil.access(Level.INFO, "IS_Returning_Response_Message", stringArray);
        }
        return object2;
    }

    public Message resendRequest(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws InteractionRedirectException, InteractionException, SOAPBindingException, SOAPFaultException {
        return this.resendRequest(string, httpServletRequest, httpServletResponse, null);
    }

    public Message resendRequest(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Message object) throws InteractionRedirectException, InteractionException, SOAPBindingException, SOAPFaultException {
        String[] stringArray;
        Object object2;
        String string2;
        if (debug.messageEnabled()) {
            debug.message("InteractionManager.resendRequest():entering ");
        }
        if ((string2 = httpServletRequest.getParameter(RESEND_MESSAGE)) == null) {
            debug.error("InteractionManager.resend(): request without ResendMessage in requestURL=" + httpServletRequest.getRequestURL().toString());
            Object[] objectArray = new String[]{RESEND_MESSAGE};
            throw new InteractionException(INTERACTION_RB_NAME, "missing_query_parameter", objectArray, null);
        }
        if (string2 == "0" || string2.equals("false")) {
            debug.error("InteractionManager.resend(): resend not allowed in requestURL=" + httpServletRequest.getRequestURL().toString());
            throw new InteractionException(INTERACTION_RB_NAME, "wsp_advised_not_to_resend", null, null);
        }
        string2 = httpServletRequest.getParameter(REQUEST_ID);
        if (string2 == null) {
            debug.error("InteractionManager.resend(): request without RequestID in requestURL=" + httpServletRequest.getRequestURL().toString());
            Object[] objectArray = new String[]{REQUEST_ID};
            throw new InteractionException(INTERACTION_RB_NAME, "request_missing_query_parameter", objectArray, null);
        }
        String string3 = this.getConnectTo(string2);
        if (string3 == null) {
            debug.error("InteractionManager.resend(): old connectTo not  found for messageID=" + string2);
            throw new InteractionException(INTERACTION_RB_NAME, "old_connectTo_not_found", null, null);
        }
        if (object == null) {
            if (debug.messageEnabled()) {
                debug.message("InteractionManager.resendRequest():invoking with null requestMessage:old cached message would be used");
            }
            if ((object2 = this.getRequestMessage(string2)) == null) {
                debug.error("InteractionManager.resend(): old message not  found for messageID=" + string2);
                throw new InteractionException(INTERACTION_RB_NAME, "old_message_not_found", null, null);
            }
            object = object2;
        } else if (debug.messageEnabled()) {
            debug.message("InteractionManager.resendRequest():invoking with non null requestMessage");
        }
        object2 = new CorrelationHeader();
        ((CorrelationHeader)object2).setRefToMessageID(InteractionManager.getInstance().getRequestMessageID(string2));
        ((Message)object).setCorrelationHeader((CorrelationHeader)object2);
        if (debug.messageEnabled()) {
            debug.message("InteractionManager.resendRequest():invoking InteractionManager.sendRequest():with requestMessage=" + object + ":returnToURL=" + string);
        }
        if (LogUtil.isLogEnabled()) {
            stringArray = new String[]{string2, ((CorrelationHeader)object2).getMessageID()};
            LogUtil.access(Level.INFO, "IS_Resending_Message", stringArray);
        }
        stringArray = this.sendRequest((Message)object, string3, this.getClientCert(string2), this.getSoapAction(string2), string, httpServletRequest, httpServletResponse);
        if (debug.messageEnabled()) {
            debug.message("InteractionManager.resendRequest(): returning responseMessage=" + stringArray);
        }
        return stringArray;
    }

    private Message handleRedirectRequest(Message message, String string, String string2, String string3, String string4, String string5, String string6, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws InteractionRedirectException, InteractionException {
        Object var10_10 = null;
        if (debug.messageEnabled()) {
            debug.message("InteractionManager.handleRedirectRequest():entering with redirectURL=" + string);
        }
        if (string.indexOf("ReturnToURL=") != -1) {
            debug.error("InteractionManager.handleRedirectRequest():Invalid redirectURL - illegal parameter ReturnToURL in redirectURL=" + string);
            Object[] objectArray = new String[]{RETURN_TO_URL, REDIRECT_URL};
            throw new InteractionException(INTERACTION_RB_NAME, "illegal_parameter_in_redirectURL", objectArray, null);
        }
        if (string.indexOf("IDP=") != -1) {
            debug.error("InteractionManager.handleRedirectRequest():Invalid redirectURL - illegal parameter:IDP in redirectURL=" + string);
            Object[] objectArray = new String[]{IDP, REDIRECT_URL};
            throw new InteractionException(INTERACTION_RB_NAME, "illegal_parameter_in_redirectURL", objectArray, null);
        }
        if (InteractionConfig.getInstance().wscEnforcesHttpsCheck() && string.indexOf("https") != 0) {
            debug.error("InteractionManager.handleRedirectRequest():Invalid Request redirectURL not https in redirectURL=" + string);
            throw new InteractionException(INTERACTION_RB_NAME, "redirectURL_not_https", null, null);
        }
        if (InteractionConfig.getInstance().wspEnforcesReturnToHostEqualsRequestHost() && !this.checkRedirectHost(string, string3)) {
            debug.error("InteractionManager.handleRedirectRequest():Invalid Request redirectToHost differs from  connectToHost: in redirectURL=" + string + ":connectTo=" + string3);
            throw new InteractionException(INTERACTION_RB_NAME, "redirectURL_differs_from_connectTo", null, null);
        }
        String string7 = message.getCorrelationHeader().getMessageID();
        this.setRequestMessage(string7, message);
        this.setConnectTo(string7, string3);
        this.setSoapAction(string7, string5);
        this.setClientCert(string7, string4);
        this.setRequestMessageID(string7, string2);
        if (debug.messageEnabled()) {
            debug.message("InteractionManager.handleRedirectRequest():cached  request message for messageID=" + string2 + ":requestID=" + string7 + ":requestMessage:" + (message == null));
        }
        string6 = string6 + "?" + REQUEST_ID + "=" + string7;
        string = string + "&" + RETURN_TO_URL + "=" + AMURLEncDec.encode((String)string6);
        if (debug.messageEnabled()) {
            debug.message("InteractionManager.handleRedirectRequest():redirecting user agent to redirectURL= " + string);
        }
        try {
            httpServletResponse.sendRedirect(string);
        }
        catch (IOException iOException) {
            debug.error("InteractionManager.handleRedirectRequest(): catching IOException", (Throwable)iOException);
            throw new InteractionException(INTERACTION_RB_NAME, "IOException_in_Interaction_Manager", null, null);
        }
        if (debug.messageEnabled()) {
            debug.message("InteractionManager.handleRedirectRequest():redirected user agent to redirectURL= " + string);
        }
        if (LogUtil.isLogEnabled()) {
            String[] stringArray = new String[]{string7};
            LogUtil.access(Level.INFO, "IS_Redirected_User_Agent", stringArray);
        }
        throw new InteractionRedirectException(string7);
    }

    public Message handleInteraction(Message message, InquiryElement inquiryElement) throws InteractionException, InteractionSOAPFaultException, SOAPFaultException {
        return this.handleInteraction(message, inquiryElement, null);
    }

    public Message handleInteraction(Message message, InquiryElement inquiryElement, String string) throws InteractionException, InteractionSOAPFaultException, SOAPFaultException {
        if (debug.messageEnabled()) {
            debug.message("InteractionManager.handleInteraction():entering");
        }
        Object var4_4 = null;
        if (!this.interactionConfig.wspSupportsRedirect()) {
            if (debug.warningEnabled()) {
                debug.warning("InteractionManager.handleInteraction(): WSP requests for interaction:wspWillRedirect=" + this.interactionConfig.wspSupportsRedirect());
                debug.warning("InteractionManager.handleInteraction():throwing InteractionException");
            }
            throw new InteractionException(INTERACTION_RB_NAME, "wsp_does_not_support_interaction", null, null);
        }
        UserInteractionElement userInteractionElement = InteractionManager.getUserInteractionElement(message);
        if (userInteractionElement == null) {
            SOAPFaultException sOAPFaultException = this.newRedirectFaultError(QNAME_INTERACTION_REQUIRED);
            if (debug.warningEnabled()) {
                debug.warning("InteractionManager.handleInteraction(): WSP requests for interaction - WSC did not  provide UserInteractionHeader");
                debug.warning("InteractionManager.handleInteraction():throwing InteractionSOAPFaultException=" + sOAPFaultException);
            }
            throw new InteractionSOAPFaultException(sOAPFaultException);
        }
        if (!userInteractionElement.isRedirect()) {
            SOAPFaultException sOAPFaultException = this.newRedirectFaultError(QNAME_INTERACTION_REQUIRED);
            if (debug.warningEnabled()) {
                debug.warning("InteractionManager.handleInteraction():WSP rquests for interaction - WSC   says redirect=false");
                debug.warning("InteractionManager.handleInteraction():throwing InteractionSOAPFaultException=" + sOAPFaultException);
            }
            throw new InteractionSOAPFaultException(sOAPFaultException);
        }
        if (userInteractionElement.getInteract().equals(QNAME_DO_NOT_INTERACT)) {
            SOAPFaultException sOAPFaultException = this.newRedirectFaultError(QNAME_INTERACTION_REQUIRED);
            if (debug.warningEnabled()) {
                debug.warning("InteractionManager.handleInteraction():WSP rquests for interaction - WSC   UserInteractionHeader says doNotInteract");
                debug.warning("InteractionManager.handleInteraction():throwing InteractionSOAPFaultException=" + sOAPFaultException);
            }
            throw new InteractionSOAPFaultException(sOAPFaultException);
        }
        if (this.interactionConfig.wspRedirectsForData() && userInteractionElement.getInteract().equals(QNAME_DO_NOT_INTERACT_FOR_DATA)) {
            SOAPFaultException sOAPFaultException = this.newRedirectFaultError(QNAME_INTERACTION_REQUIRED_FOR_DATA);
            if (debug.warningEnabled()) {
                debug.warning("InteractionManager.handleInteraction():WSP rquests interaction for data - WSC   UserInteractionHeader says doNotInteractForData");
                debug.warning("InteractionManager.handleInteraction():throwing InteractionSOAPFaultException=" + sOAPFaultException);
            }
            throw new InteractionSOAPFaultException(sOAPFaultException);
        }
        BigInteger bigInteger = userInteractionElement.getMaxInteractTime();
        if (bigInteger != null && this.interactionConfig.getWSPRedirectTime() > bigInteger.intValue()) {
            SOAPFaultException sOAPFaultException = this.newRedirectFaultError(QNAME_INTERACTION_TIME_NOT_SUFFICEINT);
            if (debug.warningEnabled()) {
                debug.warning("InteractionManager.handleInteraction():WSP inteaction time =" + this.interactionConfig.getWSPRedirectTime() + " exceeds WSC maxInteractTime= " + userInteractionElement.getMaxInteractTime());
                debug.warning("InteractionManager.handleInteraction():throwing InteractionSOAPFaultException=" + sOAPFaultException);
            }
            throw new InteractionSOAPFaultException(sOAPFaultException);
        }
        String string2 = message.getCorrelationHeader().getMessageID();
        SOAPFaultException sOAPFaultException = this.newRedirectFault(string2);
        String string3 = this.getResponseID(sOAPFaultException);
        String string4 = message.getIPAddress();
        String string5 = null;
        if (this.interactionConfig.wspEnforcesReturnToHostEqualsRequestHost()) {
            try {
                InetAddress inetAddress = InetAddress.getByName(string4);
                string5 = inetAddress.getHostName();
                if (debug.messageEnabled()) {
                    debug.message("InteractionManager.handleInteraction(): caching requestHost=" + string5 + ", for redirectResponseID= " + string3);
                }
                this.setRequestHost(string3, string5);
            }
            catch (UnknownHostException unknownHostException) {
                debug.error("InteractionManager.handleInteraction(): can not resolve host name", (Throwable)unknownHostException);
                debug.error("InteractionManager.handleInteraction(): throwing InteractionSOAPFaultException", (Throwable)sOAPFaultException);
                SOAPFaultException sOAPFaultException2 = this.newRedirectFaultError(QNAME_INTERACTION_CAN_NOT_DETERMINE_REQUEST_HOST);
                throw new InteractionSOAPFaultException(sOAPFaultException2);
            }
        }
        this.setInquiryElement(string3, inquiryElement);
        this.setRequestMessageID(string3, string2);
        this.setLanguage(string3, string);
        if (debug.messageEnabled()) {
            debug.message("InteractionManager.handleInteraction(): throwing InteractionSOAPFaultException  to redirect user agent=" + sOAPFaultException);
        }
        throw new InteractionSOAPFaultException(sOAPFaultException);
    }

    private void setInquiryElement(String string, InquiryElement inquiryElement) {
        CacheEntry cacheEntry = this.cache.getCacheEntry(string);
        if (cacheEntry == null) {
            cacheEntry = new CacheEntry(string);
            this.cache.putCacheEntry(string, cacheEntry);
        }
        cacheEntry.setInquiryElement(inquiryElement);
    }

    InquiryElement getInquiryElement(String string) {
        InquiryElement inquiryElement = null;
        CacheEntry cacheEntry = this.cache.getCacheEntry(string);
        if (cacheEntry != null) {
            inquiryElement = cacheEntry.getInquiryElement();
        }
        return inquiryElement;
    }

    void setInteractionResponseElement(String string, InteractionResponseElement interactionResponseElement) {
        CacheEntry cacheEntry = this.cache.getCacheEntry(string);
        if (cacheEntry == null) {
            cacheEntry = new CacheEntry(string);
            this.cache.putCacheEntry(string, cacheEntry);
        }
        cacheEntry.setInteractionResponseElement(interactionResponseElement);
    }

    public InteractionResponseElement getInteractionResponseElement(Message message) throws InteractionException {
        InteractionResponseElement interactionResponseElement = null;
        CorrelationHeader correlationHeader = message.getCorrelationHeader();
        String string = correlationHeader.getRefToMessageID();
        CacheEntry cacheEntry = null;
        if (string != null) {
            cacheEntry = this.cache.getCacheEntry(string);
            if (cacheEntry != null) {
                interactionResponseElement = cacheEntry.getInteractionResponseElement();
            }
            if (debug.messageEnabled()) {
                debug.message("InteractionManager.getResponseElement():for messageID=" + string + ":" + "responseElement=" + (interactionResponseElement == null));
            }
        }
        if (LogUtil.isLogEnabled()) {
            String[] stringArray = new String[]{correlationHeader.getMessageID(), correlationHeader.getRefToMessageID(), cacheEntry == null ? "NULL" : "NOT NULL"};
            LogUtil.access(Level.INFO, "IS_Returning_Response_Element", stringArray);
        }
        return interactionResponseElement;
    }

    private void setRequestMessage(String string, Message message) {
        CacheEntry cacheEntry = this.cache.getCacheEntry(string);
        if (cacheEntry == null) {
            cacheEntry = new CacheEntry(string);
            this.cache.putCacheEntry(string, cacheEntry);
        }
        cacheEntry.setRequestMessage(message);
        if (debug.messageEnabled()) {
            debug.message("InteractionManager.setRequestMessage(): cached  request message for messageID=" + string + ":requestMessage:" + (message == null));
        }
    }

    private Message getRequestMessage(String string) {
        Message message = null;
        CacheEntry cacheEntry = this.cache.getCacheEntry(string);
        if (cacheEntry != null) {
            message = cacheEntry.getRequestMessage();
        }
        if (debug.messageEnabled()) {
            debug.message("InteractionManager.getRequestMessage(): looking up request message for messageID=" + string + ":requestMessage=" + (message == null));
        }
        return message;
    }

    private void setRequestMessageID(String string, String string2) {
        CacheEntry cacheEntry = this.cache.getCacheEntry(string);
        if (cacheEntry == null) {
            cacheEntry = new CacheEntry(string);
            this.cache.putCacheEntry(string, cacheEntry);
        }
        cacheEntry.setRequestMessageID(string2);
    }

    String getRequestMessageID(String string) {
        String string2 = null;
        CacheEntry cacheEntry = this.cache.getCacheEntry(string);
        if (cacheEntry != null) {
            string2 = cacheEntry.getRequestMessageID();
        }
        return string2;
    }

    void setReturnToURL(String string, String string2) {
        CacheEntry cacheEntry = this.cache.getCacheEntry(string);
        if (cacheEntry == null) {
            cacheEntry = new CacheEntry(string);
            this.cache.putCacheEntry(string, cacheEntry);
        }
        cacheEntry.setReturnToURL(string2);
    }

    String getReturnToURL(String string) {
        String string2 = null;
        CacheEntry cacheEntry = this.cache.getCacheEntry(string);
        if (cacheEntry != null) {
            string2 = cacheEntry.getReturnToURL();
        }
        return string2;
    }

    void setRequestHost(String string, String string2) {
        CacheEntry cacheEntry = this.cache.getCacheEntry(string);
        if (cacheEntry == null) {
            cacheEntry = new CacheEntry(string);
            this.cache.putCacheEntry(string, cacheEntry);
        }
        cacheEntry.setRequestHost(string2);
    }

    String getRequestHost(String string) {
        String string2 = null;
        CacheEntry cacheEntry = this.cache.getCacheEntry(string);
        if (cacheEntry != null) {
            string2 = cacheEntry.getRequestHost();
        }
        return string2;
    }

    private void setConnectTo(String string, String string2) {
        CacheEntry cacheEntry = this.cache.getCacheEntry(string);
        if (cacheEntry == null) {
            cacheEntry = new CacheEntry(string);
            this.cache.putCacheEntry(string, cacheEntry);
        }
        cacheEntry.setConnectTo(string2);
    }

    private void setSoapAction(String string, String string2) {
        CacheEntry cacheEntry = this.cache.getCacheEntry(string);
        if (cacheEntry == null) {
            cacheEntry = new CacheEntry(string);
            this.cache.putCacheEntry(string, cacheEntry);
        }
        cacheEntry.setSoapAction(string2);
    }

    private void setClientCert(String string, String string2) {
        CacheEntry cacheEntry = this.cache.getCacheEntry(string);
        if (cacheEntry == null) {
            cacheEntry = new CacheEntry(string);
            this.cache.putCacheEntry(string, cacheEntry);
        }
        cacheEntry.setClientCert(string2);
    }

    private String getConnectTo(String string) {
        String string2 = null;
        CacheEntry cacheEntry = this.cache.getCacheEntry(string);
        if (cacheEntry != null) {
            string2 = cacheEntry.getConnectTo();
        }
        return string2;
    }

    private String getClientCert(String string) {
        String string2 = null;
        CacheEntry cacheEntry = this.cache.getCacheEntry(string);
        if (cacheEntry != null) {
            string2 = cacheEntry.getClientCert();
        }
        return string2;
    }

    private String getSoapAction(String string) {
        String string2 = null;
        CacheEntry cacheEntry = this.cache.getCacheEntry(string);
        if (cacheEntry != null) {
            string2 = cacheEntry.getSoapAction();
        }
        return string2;
    }

    private void setLanguage(String string, String string2) {
        CacheEntry cacheEntry = this.cache.getCacheEntry(string);
        if (cacheEntry == null) {
            cacheEntry = new CacheEntry(string);
            this.cache.putCacheEntry(string, cacheEntry);
        }
        cacheEntry.setLanguage(string2);
    }

    String getLanguage(String string) {
        String string2 = null;
        CacheEntry cacheEntry = this.cache.getCacheEntry(string);
        if (cacheEntry != null) {
            string2 = cacheEntry.getLanguage();
        }
        return string2;
    }

    private UserInteractionElement createUserInteractionElement(List list) {
        UserInteractionElement userInteractionElement = null;
        try {
            userInteractionElement = this.objectFactory.createUserInteractionElement();
            userInteractionElement.setInteract(this.interactionConfig.getWSCSpecifiedInteractionChoice());
            userInteractionElement.setRedirect(this.interactionConfig.wscSupportsRedirect());
            userInteractionElement.setMaxInteractTime(BigInteger.valueOf(this.interactionConfig.getWSCSpecifiedMaxInteractionTime()));
            userInteractionElement.getLanguage().addAll(list);
        }
        catch (JAXBException jAXBException) {
            debug.error("InteractionManager.createUserInteractionElement(): can not create UserInteractionElement", (Throwable)jAXBException);
        }
        return userInteractionElement;
    }

    static UserInteractionElement getUserInteractionElement(Message message) {
        UserInteractionElement userInteractionElement = null;
        List list = message.getOtherSOAPHeaders();
        try {
            list = Utils.convertElementToJAXB(list);
        }
        catch (JAXBException jAXBException) {
            debug.error("InteractionManager.getUserInteractionElement():not able to get userInteractionElement:can not convert Element to JAXBObject", (Throwable)jAXBException);
            return null;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof UserInteractionElement)) continue;
            userInteractionElement = (UserInteractionElement)e;
            break;
        }
        return userInteractionElement;
    }

    private SOAPFaultException newRedirectFault(String string) {
        RedirectRequestElement redirectRequestElement = null;
        try {
            redirectRequestElement = this.objectFactory.createRedirectRequestElement();
        }
        catch (JAXBException jAXBException) {
            debug.error("InteractionManager.newRedirectFault(): can not create RedirectRequestElement", (Throwable)jAXBException);
        }
        CorrelationHeader correlationHeader = new CorrelationHeader();
        String string2 = correlationHeader.getMessageID();
        correlationHeader.setRefToMessageID(string);
        String string3 = this.interactionConfig.getWSPRedirectHandler() + "?" + TRANS_ID + "=" + string2;
        redirectRequestElement.setRedirectURL(string3);
        ArrayList<Element> arrayList = new ArrayList<Element>();
        try {
            arrayList.add(Utils.convertJAXBToElement(redirectRequestElement));
        }
        catch (JAXBException jAXBException) {
            debug.error("InteractionManager.newRedirectFault(): can not create newRedirectFault: can not convert JAXBObject to Element", (Throwable)jAXBException);
        }
        SOAPFault sOAPFault = new SOAPFault(QNAME_SERVER, SERVER_ERROR, FAULT_ACTOR, new SOAPFaultDetail(arrayList));
        Message message = new Message(sOAPFault);
        message.setCorrelationHeader(correlationHeader);
        SOAPFaultException sOAPFaultException = new SOAPFaultException(message);
        return sOAPFaultException;
    }

    private SOAPFaultException newRedirectFaultError(QName qName) {
        StatusElement statusElement = null;
        try {
            statusElement = this.objectFactory.createStatusElement();
        }
        catch (JAXBException jAXBException) {
            debug.error("InteractionManager.newRedirectFaultError(): can not create StatusElement", (Throwable)jAXBException);
        }
        statusElement.setCode(qName);
        ArrayList<Element> arrayList = new ArrayList<Element>();
        try {
            arrayList.add(Utils.convertJAXBToElement(statusElement));
        }
        catch (JAXBException jAXBException) {
            debug.error("InteractionManager.newRedirectFaultError():can not create new RedirectFaultError:can not convert JAXBObject to Element", (Throwable)jAXBException);
        }
        SOAPFault sOAPFault = new SOAPFault(QNAME_SERVER, SERVER_ERROR, FAULT_ACTOR, new SOAPFaultDetail(arrayList));
        SOAPFaultException sOAPFaultException = new SOAPFaultException(new Message(sOAPFault));
        return sOAPFaultException;
    }

    String getRedirectURL(SOAPFaultException sOAPFaultException) throws SOAPFaultException {
        RedirectRequestElement redirectRequestElement;
        String string = null;
        List list = null;
        SOAPFaultDetail sOAPFaultDetail = sOAPFaultException.getSOAPFaultMessage().getSOAPFault().getDetail();
        if (sOAPFaultDetail != null) {
            list = sOAPFaultDetail.getOtherChildren();
        }
        try {
            list = Utils.convertElementToJAXB(list);
        }
        catch (JAXBException jAXBException) {
            debug.error("InteractionManager.getRedirectURL(): can not get Redirect URL", (Throwable)jAXBException);
        }
        if (list != null && list.size() > 0 && list.get(0) instanceof RedirectRequestElement && (redirectRequestElement = (RedirectRequestElement)list.get(0)) != null) {
            string = redirectRequestElement.getRedirectURL();
        }
        if (string == null) {
            throw sOAPFaultException;
        }
        return string;
    }

    private boolean checkRedirectHost(String string, String string2) {
        boolean bl = false;
        try {
            URL uRL = new URL(string);
            URL uRL2 = new URL(string2);
            String string3 = uRL.getHost();
            String string4 = uRL2.getHost();
            if (string3.equals(string4)) {
                bl = true;
            }
        }
        catch (MalformedURLException malformedURLException) {
            debug.error("InteractionManager.checkRedirectHost():redirectURL not a valid URL :redirectURL=" + string + " :connectTo=" + string2, (Throwable)malformedURLException);
        }
        return bl;
    }

    String getResponseID(SOAPFaultException sOAPFaultException) throws SOAPFaultException {
        String string = null;
        CorrelationHeader correlationHeader = sOAPFaultException.getSOAPFaultMessage().getCorrelationHeader();
        if (correlationHeader == null) {
            debug.error("InteractionManager.getResponseID():null CorrelationHeader in SOAPFaultException");
            throw sOAPFaultException;
        }
        string = correlationHeader.getMessageID();
        if (string == null) {
            debug.error("InteractionManager.getResponseID():null messageID in SOAPFaultException");
            throw sOAPFaultException;
        }
        return string;
    }

    static class CacheEntry {
        String messageID;
        String requestMessageID;
        Message requestMessage;
        InquiryElement inquiryElement;
        InteractionResponseElement interactionResponseElement;
        String connectTo;
        String certAlias;
        String soapAction;
        String returnToURL;
        String requestHost;
        String language;
        long createTime;
        long lastAccessTime;

        CacheEntry(String string) {
            this.messageID = string;
            this.lastAccessTime = this.createTime = System.currentTimeMillis();
        }

        CacheEntry(String string, Message message) {
            this.messageID = string;
            this.requestMessage = message;
            this.lastAccessTime = this.createTime = System.currentTimeMillis();
        }

        void setRequestMessage(Message message) {
            this.requestMessage = message;
            this.lastAccessTime = System.currentTimeMillis();
        }

        Message getRequestMessage() {
            this.lastAccessTime = System.currentTimeMillis();
            return this.requestMessage;
        }

        void setRequestMessageID(String string) {
            this.lastAccessTime = System.currentTimeMillis();
            this.requestMessageID = string;
        }

        String getRequestMessageID() {
            this.lastAccessTime = System.currentTimeMillis();
            return this.requestMessageID;
        }

        void setInquiryElement(InquiryElement inquiryElement) {
            this.lastAccessTime = System.currentTimeMillis();
            this.inquiryElement = inquiryElement;
        }

        InquiryElement getInquiryElement() {
            this.lastAccessTime = System.currentTimeMillis();
            return this.inquiryElement;
        }

        void setInteractionResponseElement(InteractionResponseElement interactionResponseElement) {
            this.lastAccessTime = System.currentTimeMillis();
            this.interactionResponseElement = interactionResponseElement;
        }

        InteractionResponseElement getInteractionResponseElement() {
            this.lastAccessTime = System.currentTimeMillis();
            return this.interactionResponseElement;
        }

        void setConnectTo(String string) {
            this.lastAccessTime = System.currentTimeMillis();
            this.connectTo = string;
        }

        String getConnectTo() {
            this.lastAccessTime = System.currentTimeMillis();
            return this.connectTo;
        }

        void setClientCert(String string) {
            this.lastAccessTime = System.currentTimeMillis();
            this.certAlias = string;
        }

        String getClientCert() {
            this.lastAccessTime = System.currentTimeMillis();
            return this.certAlias;
        }

        void setSoapAction(String string) {
            this.lastAccessTime = System.currentTimeMillis();
            this.soapAction = string;
        }

        String getSoapAction() {
            this.lastAccessTime = System.currentTimeMillis();
            return this.soapAction;
        }

        void setReturnToURL(String string) {
            this.lastAccessTime = System.currentTimeMillis();
            this.returnToURL = string;
        }

        String getReturnToURL() {
            this.lastAccessTime = System.currentTimeMillis();
            return this.returnToURL;
        }

        void setRequestHost(String string) {
            this.lastAccessTime = System.currentTimeMillis();
            this.requestHost = string;
        }

        String getRequestHost() {
            this.lastAccessTime = System.currentTimeMillis();
            return this.requestHost;
        }

        void setLanguage(String string) {
            this.lastAccessTime = System.currentTimeMillis();
            this.language = string;
        }

        String getLanguage() {
            this.lastAccessTime = System.currentTimeMillis();
            return this.language;
        }

        long getLastAccessTime() {
            return this.lastAccessTime;
        }
    }

    static class InteractionCache {
        private static final boolean VERBOSE_MESSAGE = false;
        private static final int SWEEP_INTERVAL = 60000;
        private static final int CACHE_ENTRY_MAX_IDLE_TIME = 120000;
        private boolean sweepEnabled = true;
        Map cache = Collections.synchronizedMap(new HashMap());

        InteractionCache() {
            if (debug.messageEnabled()) {
                debug.message("InteactionCache.InteractionCache()  - entering constructor");
            }
            Thread thread = new Thread(this){
                private final /* synthetic */ InteractionCache this$0;
                {
                    this.this$0 = interactionCache;
                }

                public void run() {
                    while (InteractionCache.access$100(this.this$0)) {
                        this.this$0.sweep();
                        try {
                            Thread.sleep(60000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            };
            thread.setDaemon(true);
            if (debug.messageEnabled()) {
                debug.message("InteactionCache.InteractionCache()  - starting sweeper thread");
                debug.message("InteractionCache.InteractionCache()  SWEEP_INTERVAL = 60000");
                debug.message("InteractionCache.InteractionCache()  CACHE_ENTRY_MAX_IDLE_TIME = 120000");
            }
            if (debug.messageEnabled()) {
                debug.message("InteactionCache.InteractionCache()  - returning from constructor");
            }
            thread.start();
        }

        CacheEntry getCacheEntry(String string) {
            return (CacheEntry)this.cache.get(string);
        }

        void putCacheEntry(String string, CacheEntry cacheEntry) {
            this.cache.put(string, cacheEntry);
        }

        void sweep() {
            block3: {
                try {
                    Iterator iterator = this.cache.keySet().iterator();
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        CacheEntry cacheEntry = (CacheEntry)this.cache.get(string);
                        if (cacheEntry == null || System.currentTimeMillis() - cacheEntry.getLastAccessTime() <= 120000L) continue;
                        iterator.remove();
                    }
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    if (!debug.messageEnabled()) break block3;
                    debug.message("InteractionCache.sweep() - returning due to ConcurrentModificationException:entries in cache=" + this.cache.size());
                }
            }
        }

        static /* synthetic */ boolean access$100(InteractionCache interactionCache) {
            return interactionCache.sweepEnabled;
        }
    }
}

