/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.idpp.plugin;

import com.iplanet.sso.SSOToken;
import com.sun.identity.liberty.ws.idpp.common.IDPPUtils;
import com.sun.identity.liberty.ws.interfaces.Authorizer;
import com.sun.identity.policy.ActionDecision;
import com.sun.identity.policy.PolicyDecision;
import com.sun.identity.policy.PolicyEvaluator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class IDPPAuthorizer
implements Authorizer {
    private static PolicyEvaluator evaluator = null;

    public boolean isAuthorized(Object object, String string, Object object2, Map map) {
        return false;
    }

    public Object getAuthorizationDecision(Object object, String string, Object object2, Map map) throws Exception {
        IDPPUtils.debug.message("IDPPAuthorizer.getAuthorizationDecision:Init");
        if (object == null || string == null || object2 == null) {
            IDPPUtils.debug.error("IDPPAuthorizer.isAuthorized:null input");
            throw new Exception(IDPPUtils.bundle.getString("nullInputParams"));
        }
        try {
            SSOToken sSOToken = (SSOToken)object;
            String string2 = (String)object2;
            HashSet<String> hashSet = new HashSet<String>(1);
            hashSet.add(string);
            PolicyDecision policyDecision = evaluator.getPolicyDecision(sSOToken, string2, hashSet);
            if (policyDecision == null) {
                if (IDPPUtils.debug.messageEnabled()) {
                    IDPPUtils.debug.message("IDPPAuthorizer.getAuthorizationDecision:PolicyDecision is null");
                }
                return "deny";
            }
            Map map2 = policyDecision.getActionDecisions();
            ActionDecision actionDecision = (ActionDecision)map2.get(string);
            if (actionDecision == null) {
                if (IDPPUtils.debug.messageEnabled()) {
                    IDPPUtils.debug.message("IDPPAuthorizer.getAuthorizationDecision:ActionDecision is null");
                }
                return "deny";
            }
            Set set = actionDecision.getValues();
            if (set == null || set.isEmpty()) {
                if (IDPPUtils.debug.messageEnabled()) {
                    IDPPUtils.debug.message("IDPPAuthorizer.getAuthorizationDecision:values are null");
                }
                return "deny";
            }
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("IDPPAuthorizer.getAuthorizationDecision: action values:" + set);
            }
            if (set.contains("deny")) {
                return "deny";
            }
            if (set.contains("interactForValue")) {
                return "interactForValue";
            }
            if (set.contains("interactForConsent")) {
                return "interactForConsent";
            }
            Iterator iterator = set.iterator();
            return (String)iterator.next();
        }
        catch (Exception exception) {
            IDPPUtils.debug.error("IDPPAuthorizer.getAuthorizationDecision:Exception during authorization.", (Throwable)exception);
            throw exception;
        }
    }

    static {
        try {
            evaluator = new PolicyEvaluator("sunIdentityServerLibertyPPService");
        }
        catch (Exception exception) {
            IDPPUtils.debug.error("IDPPAuthorizer:Static Init failed", (Throwable)exception);
        }
    }
}

