/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.idpp.container;

import com.iplanet.am.util.Misc;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.liberty.ws.idpp.common.IDPPException;
import com.sun.identity.liberty.ws.idpp.common.IDPPUtils;
import com.sun.identity.liberty.ws.idpp.container.IDPPBaseContainer;
import com.sun.identity.liberty.ws.idpp.jaxb.DSTString;
import com.sun.identity.liberty.ws.idpp.jaxb.DSTURI;
import com.sun.identity.liberty.ws.idpp.jaxb.MsgContactElement;
import com.sun.identity.liberty.ws.idpp.jaxb.PPElement;
import com.sun.identity.security.AdminDNAction;
import com.sun.identity.security.AdminPasswordAction;
import java.security.AccessController;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBException;

public class IDPPMsgContact
extends IDPPBaseContainer {
    private static SSOToken adminToken = null;

    public IDPPMsgContact() {
        IDPPUtils.debug.message("IDPPMsgContact:constructor:init.");
    }

    public Object getContainerObject(Map map) throws IDPPException {
        IDPPUtils.debug.message("IDPPMsgContact:getContainerObject:Init");
        try {
            PPElement pPElement = IDPPUtils.getIDPPFactory().createPPElement();
            Set set = (Set)map.get(this.getAttributeMapper().getDSAttribute("MsgContact").toLowerCase());
            if (set == null || set.isEmpty()) {
                throw new IDPPException(IDPPUtils.bundle.getString("nullValues"));
            }
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                MsgContactElement msgContactElement = this.parseEntry(string, map);
                if (msgContactElement == null) continue;
                pPElement.getMsgContact().add(msgContactElement);
            }
            return pPElement;
        }
        catch (JAXBException jAXBException) {
            IDPPUtils.debug.error("IDPPMsgContact:getContainerObject: JAXB failure", (Throwable)jAXBException);
            throw new IDPPException(IDPPUtils.bundle.getString("jaxbFailure"));
        }
    }

    private MsgContactElement parseEntry(String string, Map map) throws JAXBException {
        if (string == null || string.equals("")) {
            return null;
        }
        if (string.indexOf("|") == -1) {
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("IDPPMsgContact.parsEntry: Invalid Entry " + string);
            }
            return null;
        }
        MsgContactElement msgContactElement = IDPPUtils.getIDPPFactory().createMsgContactElement();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        while (stringTokenizer.hasMoreTokens()) {
            StringTokenizer stringTokenizer2;
            String string2 = stringTokenizer.nextToken();
            if (string2.indexOf("=") == -1 || (stringTokenizer2 = new StringTokenizer(string2, "=")).countTokens() != 2) continue;
            String string3 = stringTokenizer2.nextToken();
            String string4 = null;
            String string5 = this.getAttributeMapper().getDSAttribute(string3);
            string4 = string5 == null || string5.equals(string3) ? stringTokenizer2.nextToken() : Misc.getMapAttr((Map)map, (String)string5);
            if (string4 == null) continue;
            if (string3.equals("MsgType")) {
                msgContactElement.getMsgType().add(this.getDSTURI(string4));
                continue;
            }
            if (string3.equals("Nick")) {
                msgContactElement.setNick(this.getDSTString(string4));
                continue;
            }
            if (string3.equals("LComment")) {
                msgContactElement.setLComment(this.getDSTString(string4));
                continue;
            }
            if (string3.equals("MsgMethod")) {
                msgContactElement.getMsgMethod().add(this.getDSTURI(string4));
                continue;
            }
            if (string3.equals("MsgTechnology")) {
                msgContactElement.getMsgMethod().add(this.getDSTURI(string4));
                continue;
            }
            if (string3.equals("MsgAccount")) {
                msgContactElement.setMsgAccount(this.getDSTString(string4));
                continue;
            }
            if (string3.equals("MsgSubAccount")) {
                msgContactElement.setMsgSubaccount(this.getDSTString(string4));
                continue;
            }
            if (!string3.equals("id")) continue;
            msgContactElement.setId(string4);
        }
        return msgContactElement;
    }

    public Set getContainerAttributes() {
        IDPPUtils.debug.message("IDPPMsgContact:getContainerAttributes:Init");
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("MsgContact");
        return this.getMapperAttributeSet(hashSet);
    }

    public Set getContainerAttributesForSelect(String string) {
        return this.getContainerAttributes();
    }

    public Map getDataMapForSelect(String string, List list) throws IDPPException {
        IDPPUtils.debug.message("IDPPMsgContact:getDataMapForSelect:Init");
        String string2 = this.getMsgFilter(string);
        if (string2 == null) {
            throw new IDPPException(IDPPUtils.bundle.getString("invalidSelect"));
        }
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("IDPPMsgContact.getDataMapForSelect: MsgContact filter: " + string2);
        }
        if (list == null || list.isEmpty()) {
            return this.getDataMap(null, string2);
        }
        if (list != null && !list.isEmpty()) {
            Iterator iterator = list.iterator();
            if (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof MsgContactElement) {
                    MsgContactElement msgContactElement = (MsgContactElement)e;
                    return this.getDataMap(msgContactElement, string2);
                }
                throw new IDPPException(IDPPUtils.bundle.getString("invalidElement"));
            }
        }
        return null;
    }

    private Map getDataMap(MsgContactElement msgContactElement, String string) {
        HashMap hashMap = new HashMap();
        Set set = this.getMsgContacts();
        HashSet<String> hashSet = new HashSet<String>();
        if (set.isEmpty()) {
            hashSet.add(this.modifyEntry(null, msgContactElement));
        } else {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (string2.indexOf(string) != -1) {
                    if (msgContactElement == null) continue;
                    string2 = this.modifyEntry(string2, msgContactElement);
                    hashSet.add(string2);
                    continue;
                }
                hashSet.add(string2);
            }
        }
        hashMap.put(this.getAttributeMapper().getDSAttribute("MsgContact"), hashSet);
        return hashMap;
    }

    private Set getMsgContacts() {
        try {
            HashSet<String> hashSet = new HashSet<String>();
            String string = this.getAttributeMapper().getDSAttribute("MsgContact");
            hashSet.add(string);
            return (Set)IDPPUtils.getUserAttributes(adminToken, this.userDN, hashSet).get(string);
        }
        catch (IDPPException iDPPException) {
            IDPPUtils.debug.error("IDPPMsgContact.getMsgContacts: Exceptionwhile trying to get existing msg contacts.", (Throwable)iDPPException);
            return new HashSet();
        }
    }

    private String modifyEntry(String string, MsgContactElement msgContactElement) {
        String string2;
        DSTURI dSTURI;
        StringBuffer stringBuffer = new StringBuffer(200);
        DSTString dSTString = msgContactElement.getNick();
        if (dSTString != null) {
            stringBuffer.append("Nick").append("=").append(dSTString.getValue()).append("|");
        }
        if ((dSTString = msgContactElement.getLComment()) != null) {
            stringBuffer.append("LComment").append("=").append(dSTString.getValue()).append("|");
        }
        if ((dSTString = msgContactElement.getMsgProvider()) != null) {
            stringBuffer.append("MsgProvider").append("=").append(dSTString.getValue()).append("|");
        }
        if ((dSTString = msgContactElement.getMsgAccount()) != null) {
            stringBuffer.append("MsgAccount").append("=").append(dSTString.getValue()).append("|");
        }
        if ((dSTString = msgContactElement.getMsgSubaccount()) != null) {
            stringBuffer.append("MsgSubAccount").append("=").append(dSTString.getValue()).append("|");
        }
        if ((dSTURI = (DSTURI)msgContactElement.getMsgType().get(0)) != null) {
            stringBuffer.append("MsgType").append("=").append(dSTURI.getValue()).append("|");
        }
        if ((dSTURI = (DSTURI)msgContactElement.getMsgMethod().get(0)) != null) {
            stringBuffer.append("MsgMethod").append("=").append(dSTURI.getValue()).append("|");
        }
        if ((dSTURI = (DSTURI)msgContactElement.getMsgTechnology().get(0)) != null) {
            stringBuffer.append("MsgTechnology").append("=").append(dSTURI.getValue());
        }
        if ((string2 = msgContactElement.getId()) != null) {
            stringBuffer.append("id").append("=").append(string2);
        }
        return stringBuffer.toString();
    }

    private String getMsgFilter(String string) {
        int n;
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("IDPPMsgContact.getMsgFilter: original Expression = " + string);
        }
        if ((n = string.indexOf("\"")) == -1) {
            return null;
        }
        int n2 = (string = string.substring(n + 1, string.length())).indexOf("\"");
        if (n2 == -1) {
            return null;
        }
        return string.substring(0, n2);
    }

    public boolean hasBinaryAttributes() {
        return false;
    }

    static {
        try {
            String string = (String)AccessController.doPrivileged(new AdminDNAction());
            String string2 = (String)AccessController.doPrivileged(new AdminPasswordAction());
            adminToken = SSOTokenManager.getInstance().createSSOToken((Principal)new AuthPrincipal(string), string2);
        }
        catch (Exception exception) {
            IDPPUtils.debug.error("PersonalProfile:Initialization failed", (Throwable)exception);
        }
    }
}

