/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.idpp.container;

import com.iplanet.am.util.Misc;
import com.sun.identity.liberty.ws.idpp.IDPPServiceManager;
import com.sun.identity.liberty.ws.idpp.common.IDPPException;
import com.sun.identity.liberty.ws.idpp.common.IDPPUtils;
import com.sun.identity.liberty.ws.idpp.jaxb.AnalyzedNameType;
import com.sun.identity.liberty.ws.idpp.jaxb.DSTDate;
import com.sun.identity.liberty.ws.idpp.jaxb.DSTInteger;
import com.sun.identity.liberty.ws.idpp.jaxb.DSTMonthDay;
import com.sun.identity.liberty.ws.idpp.jaxb.DSTString;
import com.sun.identity.liberty.ws.idpp.jaxb.DSTURI;
import com.sun.identity.liberty.ws.idpp.plugin.AttributeMapper;
import com.sun.identity.liberty.ws.idpp.plugin.IDPPContainer;
import com.sun.identity.liberty.ws.idpp.plugin.IDPPExtension;
import java.math.BigInteger;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class IDPPBaseContainer
implements IDPPContainer {
    protected String userDN = null;

    public abstract Object getContainerObject(Map var1) throws IDPPException;

    public abstract Set getContainerAttributes();

    public abstract Set getContainerAttributesForSelect(String var1);

    public abstract Map getDataMapForSelect(String var1, List var2) throws IDPPException;

    protected Map getAttributeMap(String string, Object object, Map map) {
        if (string == null || map == null) {
            IDPPUtils.debug.error("IDPPBaseContainer:getAttributeMap:nullval");
            return map;
        }
        String string2 = this.getAttributeMapper().getDSAttribute(string);
        if (string2 == null) {
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("IDPPBaseContainer:getAttributeMap: There's no DS Attribute mapping for this attr:" + string);
            }
            return map;
        }
        HashSet<String> hashSet = new HashSet<String>();
        if (object != null) {
            if (object instanceof List) {
                HashSet<String> hashSet2 = new HashSet<String>();
                List list = (List)object;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string3;
                    Object object2;
                    Object e = iterator.next();
                    if (e instanceof DSTString) {
                        object2 = (DSTString)e;
                        string3 = object2.getValue();
                        hashSet2.add(string3);
                        continue;
                    }
                    if (!(object instanceof DSTURI)) continue;
                    object2 = (DSTURI)e;
                    string3 = object2.getValue();
                    hashSet2.add(string3);
                }
                map.put(string2, hashSet2);
                return map;
            }
            String string4 = null;
            if (object instanceof DSTString) {
                DSTString dSTString = (DSTString)object;
                string4 = dSTString.getValue();
            } else if (object instanceof DSTURI) {
                DSTURI dSTURI = (DSTURI)object;
                string4 = dSTURI.getValue();
            } else if (object instanceof DSTDate) {
                DSTDate dSTDate = (DSTDate)object;
                Calendar calendar = dSTDate.getValue();
                if (calendar != null) {
                    string4 = DateFormat.getDateInstance().format(calendar.getTime());
                }
            } else if (object instanceof DSTInteger) {
                DSTInteger dSTInteger = (DSTInteger)object;
                string4 = dSTInteger.getValue().toString();
            } else if (object instanceof DSTMonthDay) {
                DSTMonthDay dSTMonthDay = (DSTMonthDay)object;
                string4 = dSTMonthDay.getValue();
            }
            if (string4 != null) {
                hashSet.add(string4);
            }
        }
        map.put(string2, hashSet);
        return map;
    }

    protected Set getMapperAttributeSet(Set set) {
        if (set == null) {
            IDPPUtils.debug.error("IDPPBaseContainer:getAttributeSet:nullval");
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = this.getAttributeMapper().getDSAttribute(string);
            if (string2 == null) {
                if (!IDPPUtils.debug.messageEnabled()) continue;
                IDPPUtils.debug.message("IDPPBaseContainer:getAttributeSet:no mapping defined for this attrib:" + string);
                continue;
            }
            hashSet.add(string2);
        }
        return hashSet;
    }

    protected DSTString getDSTString(String string) {
        if (string == null) {
            IDPPUtils.debug.message("IDPPBaseContainer:getDSTString:null vals");
            return null;
        }
        try {
            DSTString dSTString = IDPPUtils.getIDPPFactory().createDSTString();
            dSTString.setValue(string);
            return dSTString;
        }
        catch (JAXBException jAXBException) {
            IDPPUtils.debug.error("IDPPBaseContainer:getDSTString:jaxbFail", (Throwable)jAXBException);
            return null;
        }
    }

    protected DSTDate getDSTDate(String string) {
        if (string == null) {
            IDPPUtils.debug.message("IDPPBaseContainer:getDSTDate:null vals");
            return null;
        }
        try {
            DSTDate dSTDate = IDPPUtils.getIDPPFactory().createDSTDate();
            Date date = DateFormat.getDateInstance(2).parse(string);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            dSTDate.setValue(calendar);
            return dSTDate;
        }
        catch (Exception exception) {
            IDPPUtils.debug.error("IDPPBaseContainer:getDSTDate: Exception", (Throwable)exception);
            return null;
        }
    }

    protected DSTMonthDay getDSTMonthDay(String string) {
        if (string == null) {
            IDPPUtils.debug.message("IDPPBaseContainer:getDSTMonthDay:nullvals");
            return null;
        }
        try {
            DSTMonthDay dSTMonthDay = IDPPUtils.getIDPPFactory().createDSTMonthDay();
            dSTMonthDay.setValue(string);
            return dSTMonthDay;
        }
        catch (Exception exception) {
            IDPPUtils.debug.error("IDPPBaseContainer:getDSTMonthDay: Exception", (Throwable)exception);
            return null;
        }
    }

    protected DSTURI getDSTURI(String string) {
        if (string == null) {
            IDPPUtils.debug.message("IDPPBaseContainer:getDSTURI:null vals");
            return null;
        }
        try {
            DSTURI dSTURI = IDPPUtils.getIDPPFactory().createDSTURI();
            dSTURI.setValue(string);
            return dSTURI;
        }
        catch (JAXBException jAXBException) {
            IDPPUtils.debug.error("IDPPBaseContainer:getDSTURI: Exception", (Throwable)jAXBException);
            return null;
        }
    }

    protected DSTInteger getDSTInteger(String string) {
        if (string == null) {
            IDPPUtils.debug.message("IDPPBaseContainer:getDSTInteger:null vals");
            return null;
        }
        try {
            DSTInteger dSTInteger = IDPPUtils.getIDPPFactory().createDSTInteger();
            dSTInteger.setValue(new BigInteger(string));
            return dSTInteger;
        }
        catch (JAXBException jAXBException) {
            IDPPUtils.debug.error("IDPPBaseContainer:getDSTInteger:Error", (Throwable)jAXBException);
            return null;
        }
        catch (NumberFormatException numberFormatException) {
            IDPPUtils.debug.error("IDPPBaseContainer:getDSTInteger: Invalid number", (Throwable)numberFormatException);
            return null;
        }
    }

    protected AnalyzedNameType getAnalyzedName(Map map) throws IDPPException {
        IDPPUtils.debug.message("IDPPContainers:getAnalyzedName:Init");
        AnalyzedNameType analyzedNameType = null;
        try {
            analyzedNameType = IDPPUtils.getIDPPFactory().createAnalyzedNameType();
            String string = Misc.getMapAttr((Map)map, (String)this.getAttributeMapper().getDSAttribute("SN").toLowerCase());
            if (string != null) {
                analyzedNameType.setSN(this.getDSTString(string));
            }
            if ((string = Misc.getMapAttr((Map)map, (String)this.getAttributeMapper().getDSAttribute("FN").toLowerCase())) != null) {
                analyzedNameType.setFN(this.getDSTString(string));
            }
            if ((string = Misc.getMapAttr((Map)map, (String)this.getAttributeMapper().getDSAttribute("PersonalTitle").toLowerCase())) != null) {
                analyzedNameType.setPersonalTitle(this.getDSTString(string));
            }
            string = Misc.getMapAttr((Map)map, (String)this.getAttributeMapper().getDSAttribute("MN").toLowerCase());
            String string2 = IDPPServiceManager.getInstance().getNameScheme();
            if (string2 != null) {
                analyzedNameType.setNameScheme(string2);
            }
            if (string2 != null && string2.equals("urn:liberty:id-sis-pp:nameScheme:firstmiddlelast") && string != null) {
                analyzedNameType.setMN(this.getDSTString(string));
            }
            return analyzedNameType;
        }
        catch (JAXBException jAXBException) {
            IDPPUtils.debug.error("IDPPContainers:getAnalyzedName: JAXB failure", (Throwable)jAXBException);
            throw new IDPPException(IDPPUtils.bundle.getString("jaxbFailure"));
        }
    }

    public Document toXMLDocument(Map map) throws IDPPException {
        IDPPUtils.debug.message("IDPPBaseContainer:toXMLDocument: Init");
        if (map == null) {
            IDPPUtils.debug.error("IDPPBaseContainer:toXMLDocument:Nodata");
            throw new IDPPException(IDPPUtils.bundle.getString("noData"));
        }
        Document document = IDPPUtils.getDocumentBuilder().newDocument();
        try {
            IDPPUtils.getMarshaller().marshal(this.getContainerObject(map), (Node)document);
            return document;
        }
        catch (JAXBException jAXBException) {
            IDPPUtils.debug.error("IDPPBaseContainer:toXMLDocument:JAXB exception while marshalling container .", (Throwable)jAXBException);
            throw new IDPPException(IDPPUtils.bundle.getString("jaxbFailure"));
        }
        catch (IDPPException iDPPException) {
            IDPPUtils.debug.error("IDPPBaseContainer:toXMLDocument:Error retrieving common name.", (Throwable)iDPPException);
            throw new IDPPException(iDPPException);
        }
    }

    protected Set getAnalyzedNameAttributes() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("FN");
        hashSet.add("SN");
        hashSet.add("PersonalTitle");
        String string = IDPPServiceManager.getInstance().getNameScheme();
        if (string != null && string.equals("urn:liberty:id-sis-pp:nameScheme:firstmiddlelast")) {
            hashSet.add("MN");
        }
        return this.getMapperAttributeSet(hashSet);
    }

    protected Map getAnalyzedNameMap(Object object, Map map) throws IDPPException {
        Object object2;
        IDPPUtils.debug.message("IDPPBaseContainer:getAnalyzedNameMap:Init");
        DSTString dSTString = null;
        DSTString dSTString2 = null;
        DSTString dSTString3 = null;
        DSTString dSTString4 = null;
        if (object != null) {
            if (object instanceof AnalyzedNameType) {
                object2 = (AnalyzedNameType)object;
                dSTString = object2.getFN();
                dSTString2 = object2.getSN();
                dSTString3 = object2.getMN();
                dSTString4 = object2.getPersonalTitle();
            } else {
                throw new IDPPException(IDPPUtils.bundle.getString("invalid Element"));
            }
        }
        this.getAttributeMap("FN", dSTString, map);
        this.getAttributeMap("SN", dSTString2, map);
        object2 = IDPPServiceManager.getInstance().getNameScheme();
        if (object2 != null && ((String)object2).equals("urn:liberty:id-sis-pp:nameScheme:firstmiddlelast")) {
            this.getAttributeMap("MN", dSTString3, map);
        }
        this.getAttributeMap("PersonalTitle", dSTString4, map);
        return map;
    }

    protected AttributeMapper getAttributeMapper() {
        return IDPPServiceManager.getInstance().getAttributeMapper();
    }

    protected Set getExtensionContainerAttributes() {
        return IDPPServiceManager.getInstance().getExtensionAttributes();
    }

    protected IDPPExtension getExtensionContainerClass() {
        return IDPPServiceManager.getInstance().getContainerExtension("Extension");
    }

    public void setUserDN(String string) {
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("IDPPBaseContainer.setUserDN: userDN" + string);
        }
        this.userDN = string;
    }

    public abstract boolean hasBinaryAttributes();
}

