/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.idpp.container;

import com.iplanet.am.util.Misc;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.liberty.ws.idpp.common.IDPPException;
import com.sun.identity.liberty.ws.idpp.common.IDPPUtils;
import com.sun.identity.liberty.ws.idpp.container.IDPPBaseContainer;
import com.sun.identity.liberty.ws.idpp.jaxb.AddressCardElement;
import com.sun.identity.liberty.ws.idpp.jaxb.AddressElement;
import com.sun.identity.liberty.ws.idpp.jaxb.AddressType;
import com.sun.identity.liberty.ws.idpp.jaxb.DSTString;
import com.sun.identity.liberty.ws.idpp.jaxb.DSTURI;
import com.sun.identity.liberty.ws.idpp.jaxb.PPElement;
import com.sun.identity.security.AdminDNAction;
import com.sun.identity.security.AdminPasswordAction;
import java.security.AccessController;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBException;

public class IDPPAddressCard
extends IDPPBaseContainer {
    private static final String REMOVE_CARD = "RemoveCard";
    private static SSOToken adminToken = null;

    public IDPPAddressCard() {
        IDPPUtils.debug.message("IDPPAddressCard:constructor:init.");
    }

    public Object getContainerObject(Map map) throws IDPPException {
        IDPPUtils.debug.message("IDPPAddressCard:getContainerObject:Init");
        try {
            PPElement pPElement = IDPPUtils.getIDPPFactory().createPPElement();
            Set set = (Set)map.get(this.getAttributeMapper().getDSAttribute("AddressCard").toLowerCase());
            if (set == null || set.isEmpty()) {
                throw new IDPPException(IDPPUtils.bundle.getString("nullValues"));
            }
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                AddressCardElement addressCardElement = this.parseEntry(string, map);
                if (addressCardElement == null) continue;
                pPElement.getAddressCard().add(addressCardElement);
            }
            return pPElement;
        }
        catch (JAXBException jAXBException) {
            IDPPUtils.debug.error("IDPPContainers:getContainerObject: JAXB failure", (Throwable)jAXBException);
            throw new IDPPException(IDPPUtils.bundle.getString("jaxbFailure"));
        }
    }

    private AddressCardElement parseEntry(String string, Map map) throws JAXBException {
        Object object;
        if (string == null || string.equals("")) {
            return null;
        }
        if (string.indexOf("|") == -1) {
            IDPPUtils.debug.error("IDPPAddressCard.parsEntry: Invalid Entry " + string);
            return null;
        }
        AddressCardElement addressCardElement = IDPPUtils.getIDPPFactory().createAddressCardElement();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        while (stringTokenizer.hasMoreTokens()) {
            StringTokenizer stringTokenizer2;
            object = stringTokenizer.nextToken();
            if (((String)object).indexOf("=") == -1 || (stringTokenizer2 = new StringTokenizer((String)object, "=")).countTokens() != 2) continue;
            String string11 = stringTokenizer2.nextToken();
            String string12 = null;
            String string13 = this.getAttributeMapper().getDSAttribute(string11);
            string12 = string13 == null || string13.equals(string11) ? stringTokenizer2.nextToken() : Misc.getMapAttr((Map)map, (String)string13);
            if (string12 == null) continue;
            if (string11.equals("AddrType")) {
                string2 = string12;
                continue;
            }
            if (string11.equals("Nick")) {
                string3 = string12;
                continue;
            }
            if (string11.equals("LComment")) {
                string4 = string12;
                continue;
            }
            if (string11.equals("PostalAddress")) {
                string5 = string12;
                continue;
            }
            if (string11.equals("PostalCode")) {
                string6 = string12;
                continue;
            }
            if (string11.equals("L")) {
                string7 = string12;
                continue;
            }
            if (string11.equals("C")) {
                string9 = string12;
                continue;
            }
            if (string11.equals("St")) {
                string8 = string12;
                continue;
            }
            if (!string11.equals("id")) continue;
            string10 = string12;
        }
        if (string2 == null) {
            IDPPUtils.debug.error("IDPPAdressCard.parseEntry: Invalid entry has no AddrType " + string);
            return null;
        }
        object = IDPPUtils.getIDPPFactory().createAddressElement();
        object.setC(this.getDSTString(string9));
        object.setSt(this.getDSTString(string8));
        object.setL(this.getDSTString(string7));
        object.setPostalAddress(this.getDSTString(string5));
        object.setPostalCode(this.getDSTString(string6));
        addressCardElement.setNick(this.getDSTString(string3));
        addressCardElement.getAddrType().add(this.getDSTURI(string2));
        addressCardElement.setAddress((AddressType)object);
        addressCardElement.setLComment(this.getDSTString(string4));
        addressCardElement.setId(string10);
        return addressCardElement;
    }

    public Set getContainerAttributes() {
        IDPPUtils.debug.message("IDPPAddressCard:getContainerAttrib:Init");
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("AddressCard");
        return this.getMapperAttributeSet(hashSet);
    }

    public Set getContainerAttributesForSelect(String string) {
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("IDPPAddressCard:getContainerAttributesForSelect:Init");
        }
        return this.getContainerAttributes();
    }

    public Map getDataMapForSelect(String string, List list) throws IDPPException {
        IDPPUtils.debug.message("IDPPAddressCard:getDataMapForSelect:Init");
        String string2 = IDPPUtils.getExpressionContext(string);
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("IDPPAddressCard:getDataMapForSelect:exp context = " + string2);
        }
        HashMap hashMap = new HashMap();
        if (string2 == null || string2.equals("")) {
            return hashMap;
        }
        if (list == null || list.isEmpty()) {
            return this.getDataMap(string2, null);
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Map map = this.getDataMap(string2, e);
            if (map == null) continue;
            hashMap.putAll(map);
        }
        return hashMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map getDataMap(String string, Object object) throws IDPPException {
        Object object2;
        String string2 = null;
        String string3 = null;
        Map map = this.getAddressMap();
        if (string.indexOf("[") != -1) {
            string2 = this.getAddressType(string);
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("IDPPAddressCard.getDataMap: AddressType=" + string2);
            }
            if (string2 != null) {
                string3 = (String)map.get(string2);
            }
        }
        if (string.startsWith("AddressCard")) {
            Object object3;
            if (object == null) {
                if (string2 == null) {
                    HashMap hashMap = new HashMap(1);
                    hashMap.put(this.getAttributeMapper().getDSAttribute("AddressCard"), new HashSet());
                    return hashMap;
                }
                HashMap<String, String> hashMap = new HashMap<String, String>(1);
                hashMap.put(string2, REMOVE_CARD);
                return this.setAddressMap(hashMap);
            }
            if (!(object instanceof AddressCardElement)) throw new IDPPException(IDPPUtils.bundle.getString("invalidElement"));
            AddressCardElement addressCardElement = (AddressCardElement)object;
            if ((string2 == null || string2.equals("")) && (object3 = addressCardElement.getAddrType()) != null && object3.size() != 0) {
                DSTURI dSTURI = (DSTURI)object3.get(0);
                string2 = dSTURI.getValue();
            }
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("IDPPAddressCard.getDataMap: AddressType= " + string2);
            }
            if ((string3 = (string3 = (String)map.get(string2)) == null ? this.createAddressCard(addressCardElement, string2) : this.modifyAddressCard(string3, addressCardElement)) == null) {
                throw new IDPPException(IDPPUtils.bundle.getString("nullValues"));
            }
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("IDPPAddressCard.getDataMap: Entry to be modified." + string3);
            }
            object3 = new HashMap(1);
            object3.put(string2, string3);
            return this.setAddressMap((Map)object3);
        }
        if (string.equals("Nick") || string.equals("PostalAddress") || string.equals("LComment") || string.equals("L") || string.equals("St") || string.equals("C") || string.equals("PostalCode")) {
            if (object == null) {
                string3 = this.modifyEntry(string3, string, null);
            } else {
                if (!(object instanceof DSTString)) throw new IDPPException(IDPPUtils.bundle.getString("invalidElement"));
                object2 = (DSTString)object;
                string3 = this.modifyEntry(string3, string, (DSTString)object2);
            }
        } else if (string.equals("Address")) {
            if (object == null) {
                string3 = this.modifyAddress(string3, null);
            } else {
                if (!(object instanceof AddressElement)) throw new IDPPException(IDPPUtils.bundle.getString("invalidElement"));
                object2 = (AddressElement)object;
                string3 = this.modifyAddress(string3, (AddressElement)object2);
            }
        }
        object2 = new HashMap(1);
        object2.put(string2, string3);
        return this.setAddressMap((Map)object2);
    }

    private String modifyEntry(String string, String string2, DSTString dSTString) {
        StringBuffer stringBuffer = new StringBuffer(100);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string3, "=");
            String string4 = stringTokenizer2.nextToken();
            if (string2.equals(string4)) {
                String string5 = null;
                if (dSTString != null) {
                    string5 = dSTString.getValue();
                }
                if (string5 == null) continue;
                stringBuffer.append(string2).append("=").append(dSTString.getValue()).append("|");
                continue;
            }
            stringBuffer.append(string3).append("|");
        }
        return stringBuffer.toString();
    }

    private String createAddressCard(AddressCardElement addressCardElement, String string) {
        DSTString dSTString;
        DSTString dSTString2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("AddrType").append("=").append(string).append("|");
        AddressType addressType = addressCardElement.getAddress();
        if (addressType == null) {
            IDPPUtils.debug.error("IDPPAddressContainer.createAddressCard:Address Element is null");
            return null;
        }
        String string2 = this.createAddress(addressType);
        if (string2 != null) {
            stringBuffer.append(string2);
        }
        if ((dSTString2 = addressCardElement.getNick()) != null) {
            stringBuffer.append("Nick=").append(dSTString2.getValue()).append("|");
        }
        if ((dSTString = addressCardElement.getLComment()) != null) {
            stringBuffer.append("LComment=").append(dSTString.getValue());
        }
        return stringBuffer.toString();
    }

    private String createAddress(AddressType addressType) {
        DSTString dSTString;
        DSTString dSTString2;
        DSTString dSTString3;
        DSTString dSTString4;
        StringBuffer stringBuffer = new StringBuffer();
        DSTString dSTString5 = addressType.getPostalAddress();
        if (dSTString5 != null) {
            stringBuffer.append("PostalAddress=").append(dSTString5.getValue()).append("|");
        }
        if ((dSTString4 = addressType.getL()) != null) {
            stringBuffer.append("L=").append(dSTString4.getValue()).append("|");
        }
        if ((dSTString3 = addressType.getSt()) != null) {
            stringBuffer.append("St=").append(dSTString3.getValue()).append("|");
        }
        if ((dSTString2 = addressType.getPostalCode()) != null) {
            stringBuffer.append("PostalCode=").append(dSTString2.getValue()).append("|");
        }
        if ((dSTString = addressType.getC()) != null) {
            stringBuffer.append("C=").append(dSTString.getValue()).append("|");
        }
        return stringBuffer.toString();
    }

    private String modifyAddress(String string, AddressElement addressElement) {
        StringBuffer stringBuffer = new StringBuffer(100);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        while (stringTokenizer.hasMoreTokens()) {
            DSTString dSTString;
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("PostalAddress")) {
                if (addressElement == null) continue;
                dSTString = addressElement.getPostalAddress();
                if (dSTString != null) {
                    stringBuffer.append("PostalAddress").append("=").append(dSTString.getValue()).append("|");
                    continue;
                }
                stringBuffer.append(string2).append("|");
                continue;
            }
            if (string2.startsWith("PostalCode")) {
                if (addressElement == null) continue;
                dSTString = addressElement.getPostalCode();
                if (dSTString != null) {
                    stringBuffer.append("PostalCode").append("=").append(dSTString.getValue()).append("|");
                    continue;
                }
                stringBuffer.append(string2).append("|");
                continue;
            }
            if (string2.startsWith("L")) {
                if (addressElement == null) continue;
                dSTString = addressElement.getL();
                if (dSTString != null) {
                    stringBuffer.append("L").append("=").append(dSTString.getValue()).append("|");
                    continue;
                }
                stringBuffer.append(string2).append("|");
                continue;
            }
            if (string2.startsWith("St")) {
                if (addressElement == null) continue;
                dSTString = addressElement.getSt();
                if (dSTString != null) {
                    stringBuffer.append("St").append("=").append(dSTString.getValue()).append("|");
                    continue;
                }
                stringBuffer.append(string2).append("|");
                continue;
            }
            if (string2.startsWith("C")) {
                if (addressElement == null) continue;
                dSTString = addressElement.getC();
                if (dSTString != null) {
                    stringBuffer.append("C").append("=").append(dSTString.getValue()).append("|");
                    continue;
                }
                stringBuffer.append(string2).append("|");
                continue;
            }
            stringBuffer.append(string2).append("|");
        }
        return stringBuffer.toString();
    }

    private String modifyAddressCard(String string, AddressCardElement addressCardElement) {
        StringBuffer stringBuffer = new StringBuffer(100);
        AddressElement addressElement = (AddressElement)addressCardElement.getAddress();
        String string2 = this.modifyAddress(string, addressElement);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            String string3 = stringTokenizer.nextToken();
            if (string3.startsWith("Nick")) {
                object = addressCardElement.getNick();
                if (object != null) {
                    stringBuffer.append("Nick").append("=").append(object.getValue()).append("|");
                    continue;
                }
                stringBuffer.append(string3).append("|");
                continue;
            }
            if (string3.startsWith("LComment")) {
                object = addressCardElement.getLComment();
                if (object != null) {
                    stringBuffer.append("LComment").append("=").append(object.getValue()).append("|");
                    continue;
                }
                stringBuffer.append(string3).append("|");
                continue;
            }
            if (string3.startsWith("id")) {
                object = addressCardElement.getId();
                if (object == null) continue;
                stringBuffer.append("id").append("=").append((String)object).append("|");
                continue;
            }
            stringBuffer.append(string3).append("|");
        }
        return stringBuffer.toString();
    }

    private Map getAddressMap() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(this.getAttributeMapper().getDSAttribute("AddressCard"));
        Map map = null;
        try {
            map = IDPPUtils.getUserAttributes(adminToken, this.userDN, hashSet);
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("IDPPAddressCard.getAddressMap: map" + map);
            }
        }
        catch (IDPPException iDPPException) {
            IDPPUtils.debug.error("IDPPAddressCard.getAddressMap: Error", (Throwable)iDPPException);
            return null;
        }
        Set set = (Set)map.get(this.getAttributeMapper().getDSAttribute("AddressCard").toLowerCase());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            hashMap.put(this.getAddressType(string), string);
        }
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("IDPPAddressCard.getAddressMap: address map " + hashMap);
        }
        return hashMap;
    }

    private Map setAddressMap(Map map) {
        Object object;
        Map map2 = this.getAddressMap();
        Set set = map2.keySet();
        HashSet<String> hashSet = new HashSet<String>();
        if (set != null && !set.isEmpty()) {
            object = set.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                if (map.containsKey(string)) {
                    String string2 = (String)map.get(string);
                    if (string2.equals(REMOVE_CARD)) {
                        map2.remove(string);
                        continue;
                    }
                    hashSet.add(string2);
                    continue;
                }
                hashSet.add((String)map2.get(string));
            }
        } else {
            hashSet.addAll(map.values());
        }
        object = new HashMap();
        object.put(this.getAttributeMapper().getDSAttribute("AddressCard"), hashSet);
        return object;
    }

    private String getAddressType(String string) {
        int n;
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("IDPPAddressCard.getAddressType:  value=" + string);
        }
        if (string.indexOf("|") != -1) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (!string2.startsWith("AddrType")) continue;
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "=");
                stringTokenizer2.nextToken();
                return stringTokenizer2.nextToken();
            }
            return null;
        }
        int n2 = string.indexOf("AddrType");
        if (n2 != -1 && (n = (string = string.substring(n2 + 9)).indexOf("\"")) != -1) {
            string = string.substring(n + 1, string.length());
            string = string.substring(0, string.indexOf("\""));
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("IDPPAddressCard.getAddressType: address type:" + string);
            }
            return string;
        }
        return null;
    }

    public boolean hasBinaryAttributes() {
        return false;
    }

    static {
        try {
            String string = (String)AccessController.doPrivileged(new AdminDNAction());
            String string2 = (String)AccessController.doPrivileged(new AdminPasswordAction());
            adminToken = SSOTokenManager.getInstance().createSSOToken((Principal)new AuthPrincipal(string), string2);
        }
        catch (Exception exception) {
            IDPPUtils.debug.error("PersonalProfile:Initialization failed", (Throwable)exception);
        }
    }
}

