/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.idpp;

import com.iplanet.am.util.Locale;
import com.sun.identity.liberty.ws.idpp.IDPPServiceManager;
import com.sun.identity.liberty.ws.idpp.common.IDPPUtils;
import com.sun.identity.liberty.ws.idpp.plugin.AttributeMapper;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;

public class PPInteractionHelper {
    private ResourceBundle props = null;
    private static final String TEXT_MIN_CHARS = "textMinChars";
    private static final String TEXT_MAX_CHARS = " textMaxChars";
    private static String defaultMinChars = null;
    private static String defaultMaxChars = null;
    private static String idppProps = "amLibertyPersonalProfile";

    public PPInteractionHelper(String string) {
        this.props = string != null ? ResourceBundle.getBundle(idppProps, Locale.getLocaleObjFromAcceptLangHeader((String)string)) : IDPPUtils.bundle;
        try {
            defaultMinChars = this.props.getString("defaultMinTextChars");
            defaultMaxChars = this.props.getString("defaultMaxTextChars");
        }
        catch (MissingResourceException missingResourceException) {
            IDPPUtils.debug.error("PPInteractHelper.Static: Could not find min or maximum text characters.", (Throwable)missingResourceException);
        }
    }

    public String getInteractForConsentQuestion(boolean bl, String string) {
        Object var3_3 = null;
        try {
            if (bl) {
                return this.props.getString(string + "_" + "Query" + "_" + "Consent" + "_" + "Question");
            }
            return this.props.getString(string + "_" + "Modify" + "_" + "Consent" + "_" + "Question");
        }
        catch (MissingResourceException missingResourceException) {
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("PPRequestHandler.getInquiryQuestion:can not find question for:" + string);
            }
            if (bl) {
                return this.props.getString("commonQueryConsentQuestion");
            }
            return this.props.getString("commonModifyConsentQuestion");
        }
    }

    public Map getInteractForValueQuestions(boolean bl, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Set set = this.getPPLeafElements(string);
        if (set == null || set.size() == 0) {
            return hashMap;
        }
        if (set.size() == 1) {
            String string2 = this.getInteractForValueQuestion(bl, string);
            if (string2 == null) {
                return hashMap;
            }
            hashMap.put(string, string2);
            return hashMap;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            String string4 = this.getInteractForValueQuestion(bl, string3);
            if (string4 == null) continue;
            hashMap.put(string3, string4);
        }
        return hashMap;
    }

    public String getPPAttribute(String string) {
        AttributeMapper attributeMapper = IDPPServiceManager.getInstance().getAttributeMapper();
        return attributeMapper.getDSAttribute(string);
    }

    public BigInteger getTextMinChars(String string) throws NumberFormatException {
        String string2 = null;
        try {
            string2 = this.props.getString(string + "_" + TEXT_MIN_CHARS);
        }
        catch (MissingResourceException missingResourceException) {
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("PPInteractionHelper.getTextMinChars:Could not find min chars for " + string);
            }
            string2 = defaultMinChars;
        }
        return new BigInteger(string2);
    }

    public BigInteger getTextMaxChars(String string) throws NumberFormatException {
        String string2 = null;
        try {
            string2 = this.props.getString(string + "_" + TEXT_MAX_CHARS);
        }
        catch (MissingResourceException missingResourceException) {
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("PPInteractionHelper.getTextMinChars:Could not find min chars for " + string);
            }
            string2 = defaultMaxChars;
        }
        return new BigInteger(string2);
    }

    private String getInteractForValueQuestion(boolean bl, String string) {
        try {
            if (bl) {
                return this.props.getString(string + "_" + "Query" + "_" + "Value" + "_" + "Question");
            }
            return this.props.getString(string + "_" + "Modify" + "_" + "Value" + "_" + "Question");
        }
        catch (MissingResourceException missingResourceException) {
            IDPPUtils.debug.error("PPInteractionHelper.getInteractForValueQuestion: No question found for " + string, (Throwable)missingResourceException);
            return null;
        }
    }

    private Set getPPLeafElements(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        if (string == null) {
            return hashSet;
        }
        if (string.equals("CommonName")) {
            return PPInteractionHelper.getCommonNameElements();
        }
        if (string.equals("InformalName")) {
            return PPInteractionHelper.getInformalNameElements();
        }
        if (string.equals("EmploymentIdentity")) {
            return PPInteractionHelper.getEmploymentIdentityElements();
        }
        if (string.equals("LegalIdentity")) {
            return PPInteractionHelper.getLegalIdentityElements();
        }
        if (string.equals("Extension")) {
            return PPInteractionHelper.getExtensionElements();
        }
        hashSet.add(string);
        return hashSet;
    }

    private static Set getCommonNameElements() {
        Set set = PPInteractionHelper.getAnalyzedNameElements();
        set.add("CN");
        set.add("AltCN");
        return set;
    }

    private static Set getAnalyzedNameElements() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("FN");
        hashSet.add("MN");
        hashSet.add("SN");
        hashSet.add("PersonalTitle");
        return hashSet;
    }

    private static Set getInformalNameElements() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("InformalName");
        return hashSet;
    }

    private static Set getEmploymentIdentityElements() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("JobTitle");
        hashSet.add("O");
        hashSet.add("AltO");
        return hashSet;
    }

    private static Set getLegalIdentityElements() {
        Set set = PPInteractionHelper.getAnalyzedNameElements();
        set.add("LegalName");
        set.add("AltIDType");
        set.add("AltIDValue");
        set.add("Gender");
        set.add("DOB");
        set.add("MaritalStatus");
        set.add("IDType");
        set.add("IDValue");
        return set;
    }

    private static Set getExtensionElements() {
        return IDPPServiceManager.getInstance().getExtensionAttributes();
    }
}

